/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.jdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlConnection;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class UnisqlStatement
implements Statement {
    private static final Logger LOG = LoggerFactory.getLogger(UnisqlStatement.class);
    private final UnisqlConnection connection;
    private Statement delegate;
    private final DbType sourceDialect;
    private final DbType targetDialect;

    public DbType getSourceDialect() {
        return this.sourceDialect;
    }

    public DbType getTargetDialect() {
        return this.targetDialect;
    }

    public UnisqlStatement(UnisqlConnection connection, Statement delegate) {
        this.connection = connection;
        this.delegate = delegate;
        this.sourceDialect = connection.getSourceDialect();
        this.targetDialect = connection.getTargetDialect();
    }

    public Statement getDelegate() {
        return this.delegate;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.execute(sql);
        return this.getResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String traceId = MultiplexContext.getCurrentTraceId();
        return this.execute(sql, traceId);
    }

    public boolean execute(String sql, String traceId) throws SQLException {
        String transformedSql;
        boolean isSendCompareService = Transformer.SEND_MQ_TO_COMPARE_SERVER;
        if (!isSendCompareService || MultiplexContext.inValidTraceId(traceId)) {
            return this.delegate.execute(this.connection.transformSql(sql));
        }
        MultiQueryResultDTO multiQueryResult = MultiplexContext.createMultiQueryResult(traceId, this.connection.getSourceDialect(), this.connection.getTargetDialect(), this.connection.getDataBase(), this.connection.getMultiDbTypes(), this.connection.getConnectionInfo());
        multiQueryResult.setBizSql(sql);
        String delegatePreparedSql = transformedSql = this.getTransformedSql(sql);
        SyncDataParamater added = this.connection.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
            if (this.sourceDialect == DbType.ORACLE) {
                PreparedStatement delegatePrepareStatment = this.connection.getDelegate().prepareStatement(delegatePreparedSql);
                if (delegatePrepareStatment != null) {
                    this.closeDelegateStatementIfNeeded();
                    this.delegate = delegatePrepareStatment;
                    UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, delegatePrepareStatment, added.getTableCols().size());
                    multiQueryResult.setTransformedBizSql(transformedSql);
                    multiQueryResult.setRawBizBindVarReplacedSql(transformedSql);
                    multiQueryResult.setBizBindVarReplacedSql(transformedSql);
                    return MultiplexContext.executePrepared(this.connection.getDelegate(), delegatePrepareStatment, multiQueryResult, new ArrayList<MultiCompletableFuture>(), false, added);
                }
                added = null;
                delegatePreparedSql = transformedSql;
            }
        }
        multiQueryResult.setTransformedBizSql(transformedSql);
        multiQueryResult.setRawBizBindVarReplacedSql(sql);
        multiQueryResult.setBizBindVarReplacedSql(transformedSql);
        return MultiplexContext.execute(this.connection.getDelegate(), this.delegate, delegatePreparedSql, multiQueryResult, new ArrayList<MultiCompletableFuture>(), false, added);
    }

    private void closeDelegateStatementIfNeeded() throws SQLException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(this.connection.transformSql(sql));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.delegate.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        String lastInsertIdSql;
        if (this.connection.getSourceDialect() == DbType.MYSQL && this.connection.getTargetDialect() == DbType.OCEAN_BASE_ORACLE && 1 == UnisqlProperties.getGenLastInsertIdAfterInsert() && Transformer.globalStaticParameter.getIsCache() == 0 && StringUtils.isNotBlank((CharSequence)(lastInsertIdSql = Transformer.getGenLastInsertIdSql()))) {
            return this.executeQuery(lastInsertIdSql);
        }
        return this.delegate.getGeneratedKeys();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.executeUpdate(this.connection.transformSql(sql), autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.executeUpdate(this.connection.transformSql(sql), columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegate.executeUpdate(this.connection.transformSql(sql), columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.execute(this.connection.transformSql(sql), autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.execute(this.connection.transformSql(sql), columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.delegate.execute(this.connection.transformSql(sql), columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.delegate.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.delegate.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.delegate.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.delegate.getLargeUpdateCount();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.delegate.setLargeMaxRows(max);
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.delegate.getLargeMaxRows();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.delegate.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.delegate.executeLargeUpdate(this.connection.transformSql(sql));
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.delegate.executeLargeUpdate(this.connection.transformSql(sql), autoGeneratedKeys);
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.delegate.executeLargeUpdate(this.connection.transformSql(sql), columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.delegate.executeLargeUpdate(this.connection.transformSql(sql), columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    protected String getTransformedSql(String sql) {
        return this.connection.transformSql(sql);
    }
}

