/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy.jdbc;

import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.Mode;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.mysql.FoundRowAdapter;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlStatement;
import com.hundsun.lightdb.unisql.proxy.multijdbc.MultiConnection;
import com.hundsun.lightdb.unisql.utils.UnisqlCommonUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL"})
public class UnisqlConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(UnisqlStatement.class);
    public static final String ORACLE_JDBC_DRIVER_ORACLE_CONNECTION = "oracle.jdbc.driver.OracleConnection";
    private final DbType sourceDialect;
    private final DbType targetDialect;
    private final String dataBase;
    private final String targetVersion;
    private final Set<DbType> multiDbTypes;
    private final ConnectionInfoDTO dataBaseInfo;
    private final Mode mode;
    private String prevSql;
    private UnisqlPreparedStatement prevPreparedStatement;
    private final Connection delegate;
    private final Long sessionId;

    public ConnectionInfoDTO getConnectionInfo() {
        return this.dataBaseInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnisqlConnection that = (UnisqlConnection)o;
        return this.sourceDialect == that.sourceDialect && this.targetDialect == that.targetDialect && Objects.equals(this.dataBase, that.dataBase) && this.mode == that.mode && Objects.equals(this.prevSql, that.prevSql) && Objects.equals(this.prevPreparedStatement, that.prevPreparedStatement) && Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceDialect, this.targetDialect, this.dataBase, this.mode, this.prevSql, this.prevPreparedStatement, this.delegate});
    }

    public String toString() {
        return "UnisqlConnection{sourceDialect=" + (Object)((Object)this.sourceDialect) + ", targetDialect=" + (Object)((Object)this.targetDialect) + ", dataBase='" + this.dataBase + '\'' + ", mode=" + (Object)((Object)this.mode) + ", prevSql='" + this.prevSql + '\'' + ", prevPreparedStatement=" + this.prevPreparedStatement + ", delegate=" + this.delegate + '}';
    }

    public DbType getSourceDialect() {
        return this.sourceDialect;
    }

    public DbType getTargetDialect() {
        return this.targetDialect;
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public Mode getMode() {
        return this.mode;
    }

    public Set<DbType> getMultiDbTypes() {
        return this.multiDbTypes;
    }

    @Override
    public UnisqlStatement createStatement() throws SQLException {
        return new UnisqlStatement(this, this.delegate.createStatement());
    }

    public SyncDataParamater addReturningClauseIfNeed(String sql) {
        boolean shouldSendToUuidService = MultiProperties.SEND_UKSYNC_SERVER;
        if (this.sourceDialect != null && this.targetDialect != null && this.sourceDialect.equals((Object)this.targetDialect) && shouldSendToUuidService && UnisqlCommonUtils.isInsertStmt(sql)) {
            String trimSql = sql.trim();
            boolean hasSemicolon = false;
            if (trimSql.endsWith(";")) {
                trimSql = trimSql.substring(0, trimSql.length() - 1);
                hasSemicolon = true;
            }
            String tableName = Transformer.getTableName(VariableParameter.builder().sourceSql(trimSql).sourceDialect(this.sourceDialect.name()).targetDialect(this.targetDialect.name()).build());
            if (log.isInfoEnabled()) {
                log.info("\u4eceSQL\u8bed\u53e5[{}]\u4e2d\u63d0\u53d6\u5230\u8868\u540d[{}]", (Object)trimSql, (Object)tableName);
            }
            if (tableName == null || tableName.contains(",")) {
                return null;
            }
            List<String> columns = MultiProperties.SEND_UKSYNC_TABLE_COLS.get(tableName);
            if (log.isInfoEnabled()) {
                log.info("\u63d2\u5165\u8868[{}],\u9700\u8981\u8865\u5145RETURING\u7684\u5217{}", (Object)tableName, columns);
            }
            if (columns == null) {
                return null;
            }
            StringBuilder returningClauseSql = new StringBuilder(trimSql).append(" ");
            if (this.sourceDialect == DbType.ORACLE) {
                returningClauseSql.append("RETURNING ");
                int i = 0;
                for (String column : columns) {
                    if (i != 0) {
                        returningClauseSql.append(", ");
                    }
                    ++i;
                    returningClauseSql.append(column);
                }
                returningClauseSql.append(" INTO ");
                i = 0;
                for (String column : columns) {
                    if (i != 0) {
                        returningClauseSql.append(", ");
                    }
                    ++i;
                    returningClauseSql.append("? ");
                }
            } else if (this.sourceDialect == DbType.MYSQL) {
                returningClauseSql.append("RETURNING ");
                int i = 0;
                for (String column : columns) {
                    if (i != 0) {
                        returningClauseSql.append(", ");
                    }
                    ++i;
                    returningClauseSql.append(column);
                }
            } else {
                return null;
            }
            if (hasSemicolon) {
                returningClauseSql.append(";");
            }
            SyncDataParamater result = new SyncDataParamater();
            result.setBizSql(sql);
            result.setTargetSql(returningClauseSql.toString());
            result.setTableName(tableName);
            result.setTableCols(columns);
            return result;
        }
        return null;
    }

    public UnisqlPreparedStatement prepareStatement(String sql, boolean needTransform) throws SQLException {
        ReturnParameter returnParameter = new ReturnParameter();
        String transformedPreparedSql = sql;
        if (needTransform) {
            transformedPreparedSql = this.transformSql(sql, true, returnParameter);
        }
        String delegatePreparedSql = transformedPreparedSql;
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedPreparedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedPreparedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = (Objects.isNull(returnParameter.getAutoIncrementColumnIndex()) || returnParameter.getAutoIncrementColumnIndex() == 0) && CollectionUtils.isEmpty(returnParameter.getBindVariableOrder()) ? new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql), transformedPreparedSql, sql, added) : new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql), transformedPreparedSql, returnParameter, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public UnisqlPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, true);
    }

    public String transformSql(String sql) {
        return this.transformSql(sql, false, null);
    }

    public String transformSql(String sql, boolean isPrecompiled) {
        return this.transformSql(sql, false, null);
    }

    private String transformSql(String sql, boolean isPrecompiled, ReturnParameter returnParameter) {
        String transform;
        sql = FoundRowAdapter.cleanFoundRows(this.mode, sql);
        if (Transformer.SEND_TO_COMPARE_SERVER) {
            if (UnisqlProperties.skipUnisqlRuntimeConvertProperty) {
                return sql;
            }
            VariableParameter variableParameter = VariableParameter.builder().dbName(this.dataBase).build();
            if (isPrecompiled) {
                variableParameter.setIsPrecompiled(1);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.targetVersion)) {
                variableParameter.setTargetDatabaseVersion(this.targetVersion);
            }
            variableParameter.setSessionId(this.sessionId);
            transform = Transformer.parse(sql, this.sourceDialect.name(), this.targetDialect.name(), variableParameter, returnParameter);
        } else {
            VariableParameter variableParameter = Transformer.VARIABLE_PARAMETER_THREAD_LOCAL.get();
            variableParameter.setSessionId(this.sessionId);
            if (FoundRowAdapter.isFoundRows(this.mode, sql)) {
                transform = FoundRowAdapter.replaceSql(this.mode, this.prevSql, this.prevPreparedStatement, this, variableParameter);
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.targetVersion)) {
                    variableParameter.setTargetDatabaseVersion(this.targetVersion);
                }
                transform = Transformer.parse(sql, this.sourceDialect.name(), this.targetDialect.name(), variableParameter, returnParameter);
            }
        }
        if (this.targetDialect == DbType.ORACLE || this.targetDialect == DbType.ORACLE_19C || this.targetDialect == DbType.OCEAN_BASE_ORACLE || this.targetDialect == DbType.LIGHTDB_ORACLE || this.targetDialect == DbType.DM) {
            transform = UnisqlConnection.trimTailSlashesForPlsqlBlock(transform);
        }
        this.prevSql = sql;
        return transform;
    }

    public static String trimTailSlashesForPlsqlBlock(String sql) {
        if (sql == null) {
            return sql;
        }
        String trimSql = sql.trim();
        if (trimSql != null && trimSql.length() > "\n/".length() && trimSql.endsWith("\n/") && (Utils.isPlsqlBlock(trimSql) || trimSql.toUpperCase().startsWith("CREATE SCHEMA"))) {
            return trimSql.substring(0, trimSql.length() - 1);
        }
        return sql;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLException("not implemented");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.delegate.nativeSQL(sql);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.delegate.setAutoCommit(autoCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.delegate.getAutoCommit();
    }

    @Override
    public void commit() throws SQLException {
        this.delegate.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.delegate.rollback();
    }

    @Override
    public void close() throws SQLException {
        Transformer.freeSession(this.sessionId);
        this.delegate.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.delegate.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.delegate.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.delegate.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.delegate.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.delegate.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.delegate.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.delegate.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    @Override
    public UnisqlStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new UnisqlStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
    }

    @Override
    public UnisqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        String transformedSql;
        String delegatePreparedSql = transformedSql = this.transformSql(sql, true);
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql, resultSetType, resultSetConcurrency), transformedSql, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("not implemented");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.delegate.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.delegate.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.delegate.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.delegate.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.delegate.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.delegate.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.delegate.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.delegate.releaseSavepoint(savepoint);
    }

    @Override
    public UnisqlStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new UnisqlStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public UnisqlPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        String transformedSql;
        String delegatePreparedSql = transformedSql = this.transformSql(sql, true);
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql, resultSetType, resultSetConcurrency, resultSetHoldability), transformedSql, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("not implemented");
    }

    @Override
    public UnisqlPreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        String transformedSql;
        String delegatePreparedSql = transformedSql = this.transformSql(sql, true);
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql, autoGeneratedKeys), transformedSql, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public UnisqlPreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        String transformedSql;
        String delegatePreparedSql = transformedSql = this.transformSql(sql, true);
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql, columnIndexes), transformedSql, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        String transformedSql;
        String delegatePreparedSql = transformedSql = this.transformSql(sql, true);
        SyncDataParamater added = this.addReturningClauseIfNeed(transformedSql);
        boolean syncData = false;
        if (added != null) {
            syncData = true;
            delegatePreparedSql = added.getTargetSql();
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u4e86\u6570\u636e\u540c\u6b65\u914d\u7f6e\uff0cSQL[{}]\u6539\u5199\u4e3a[{}]\u6267\u884c", (Object)transformedSql, (Object)delegatePreparedSql);
            }
        }
        this.prevPreparedStatement = new UnisqlPreparedStatement(this, this.delegate.prepareStatement(delegatePreparedSql, columnNames), transformedSql, sql, added);
        if (syncData) {
            UnisqlPreparedStatement.registerReturnParameter(this.sourceDialect, this.prevPreparedStatement.getDelegate(), added.getTableCols().size());
        }
        return this.prevPreparedStatement;
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.delegate.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.delegate.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.delegate.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.delegate.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.delegate.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.delegate.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.delegate.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.delegate.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.delegate.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.delegate.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.delegate.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.delegate.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.delegate.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.delegate.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.delegate.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.delegate.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (ORACLE_JDBC_DRIVER_ORACLE_CONNECTION.equals(iface.getName())) {
            return iface.isInstance(this.delegate);
        }
        return this.delegate.isWrapperFor(iface);
    }

    public UnisqlConnection(Connection delegate, DbType sourceDialect, DbType targetDialect, String dataBase, Mode mode, String targetVersion, Set<DbType> multiDbTypes, ConnectionInfoDTO dataBaseInfo) {
        this.delegate = delegate;
        this.sourceDialect = sourceDialect;
        this.targetDialect = targetDialect;
        this.dataBase = dataBase;
        this.mode = mode;
        this.targetVersion = targetVersion;
        if (Mode.MYSQL == mode) {
            Transformer.COLLECT_PARAMS = true;
        }
        this.multiDbTypes = multiDbTypes;
        this.dataBaseInfo = dataBaseInfo;
        this.sessionId = Transformer.createSession();
        Transformer.setSessionParamStr("internel.metadata.default.schema.name", dataBase, this.sessionId);
    }

    public Connection getDelegate() {
        return this.delegate;
    }

    public static Connection getRawConnection(Connection connection) {
        try {
            if (connection instanceof MultiConnection) {
                MultiConnection multiConnection = (MultiConnection)connection;
                return multiConnection.getDelegate();
            }
            if (connection instanceof UnisqlConnection) {
                UnisqlConnection unisqlConnection = (UnisqlConnection)connection;
                return unisqlConnection.getDelegate();
            }
            if (connection.isWrapperFor(MultiConnection.class)) {
                MultiConnection multiConnection = connection.unwrap(MultiConnection.class);
                return multiConnection.getDelegate();
            }
            if (connection.isWrapperFor(UnisqlConnection.class)) {
                UnisqlConnection unisqlConnection = connection.unwrap(UnisqlConnection.class);
                return unisqlConnection.getDelegate();
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u88ab\u5305\u88c5\u7684\u771f\u5b9e\u9a71\u52a8\u8fde\u63a5\u5931\u8d25", (Throwable)e);
        }
        return connection;
    }
}

