/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.proxy;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.ConnectionConfig;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.JdbcProperties;
import com.hundsun.lightdb.unisql.model.Mode;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlConnection;
import com.hundsun.lightdb.unisql.proxy.multijdbc.MultiConnection;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Driver
implements java.sql.Driver {
    public static final String UNKNOWN = "unknown";
    private static Logger log = LoggerFactory.getLogger(Driver.class);
    private static final Driver INSTANCE = new Driver();
    private static volatile Boolean mysql_driver_version_8 = null;
    public static final String ACCEPT_PREFIX = "jdbc:unisql:";
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String SOURCE_DIALECT = "sourceDialect";
    public static final String TARGET_DIALECT = "targetDialect";
    private static final String TARGET_VERSION = "targetVersion";
    private static final String JDBC_POSTGRESQL = "jdbc:postgresql:";
    private static final String JDBC_OCEANBASE = "jdbc:oceanbase:";
    private static final String JDBC_ORACLE = "jdbc:oracle:";
    private static final String JDBC_ORACLE_UPPER = "JDBC:oracle:";
    private static final String JDBC_OPENGAUSS = "jdbc:opengauss:";
    private static final String JDBC_GAUSS = "jdbc:gaussdb:";
    private static final String JDBC_DM = "jdbc:dm:";
    private static final String JDBC_MARIADB = "jdbc:mariadb:";
    private static final String JDBC_MYSQL = "jdbc:mysql:";
    private static final String JDBC_GOLDENDB = "jdbc:goldendb:";
    private static final String JDBC_LIGHTDB = "jdbc:lightdb:";
    private static final String JDBC_MYSQL_DRIVER = "com.mysql.cj.jdbc.Driver";
    public static final String JDBC_PROPERTY_URL = "url";
    public static final String JDBC_PROPERTY_USER = "user";
    private static final String JDBC_PROPERTY_USER_NAME = "username";
    public static final String JDBC_PROPERTY_PASSWORD = "password";
    public static final String MULTIPLEX_TARGET_DIALECTS = "multiplexTargetDialects";
    public static final String MULTIPLEX_MODE = "mode";
    public static final String MULTIPLEX_TARGET_SCHEMA_NAMES = "multiplexTargetSchemaNames";
    public static final String MULTIPLEX_TARGET_DIALECTS_PREFIX = "&multiplexTargetDialects=";
    private static final int MAX_PRE_CHECKED_URLS = 2048;
    private static final Map<String, Boolean> PRE_CHECKED;
    private static final Map<String, Boolean> INFO_PRINTED;
    private final UnisqlProperties properties = UnisqlProperties.getInstance();
    private static final ConcurrentHashMap<String, JdbcProperties> JDBC_PROPERTIES_MULTI;
    private static final ConcurrentHashMap<String, String> JDBC_PROPERTIES_DEFAULT_SCHEMA;

    public static boolean registerDriver(java.sql.Driver driver) {
        try {
            DriverManager.registerDriver(driver);
            return true;
        }
        catch (Exception var4) {
            if (log == null) {
                log = LoggerFactory.getLogger(Driver.class);
            }
            log.error("registerDriver error", (Throwable)var4);
            return false;
        }
    }

    private static void tryInitMetadata() {
        if (MultiProperties.AUTO_LOAD_CONFIG) {
            ConnectionConfig config = MultiProperties.getMetaDataConnectConfig();
            if (config == null) {
                log.warn("\u914d\u7f6e\u4e86\u5143\u6570\u636e\u52a0\u8f7d\u53c2\u6570\u4f46\u662f\u89e3\u6790\u5931\u8d25, \u8bf7\u6838\u5b9e\u914d\u7f6e");
                return;
            }
            try {
                Transformer.initTableColumnMetas(config);
            }
            catch (Exception e) {
                log.warn("\u52a0\u8f7d\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        HashMap<Object, Object> jdbcPropertiesMultiTmp;
        String propMultiConfigurationPath = UnisqlProperties.getPropMultiConfigurationPath();
        if (!this.acceptsURL(url)) {
            return null;
        }
        Properties urlProps = Driver.parseUrl(url);
        Mode mode = Mode.of(urlProps.getProperty(MULTIPLEX_MODE));
        if (mode != Mode.MULTIPLEX || MultiProperties.getRunWhatInteger() == 1 && !UnisqlProperties.autoTestInitMetaData) {
            return this.getUnisqlConnection(url, info, urlProps, mode);
        }
        String propMultiConfigurationPathTmp = String.format(propMultiConfigurationPath + "%s", "");
        if (!new File(propMultiConfigurationPathTmp).exists()) {
            throw new IllegalStateException("\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84 " + propMultiConfigurationPath);
        }
        if (MultiProperties.multiplex() && log.isInfoEnabled()) {
            log.info("\u591a\u53d1\u6570\u636e\u6e90\u8def\u5f84 {}", (Object)propMultiConfigurationPath);
        }
        if (JDBC_PROPERTIES_MULTI.isEmpty()) {
            Driver.jdbcMultiProperties(propMultiConfigurationPath);
        }
        String replaceUrl = url.replace(ACCEPT_PREFIX, JDBC_PREFIX);
        DbType sourceDbType = this.getSourceDbType(replaceUrl);
        java.sql.Driver driver = this.getTargetDriver(replaceUrl, null);
        String multiplexTargetDialects = urlProps.getProperty(MULTIPLEX_TARGET_DIALECTS);
        Object multiplexTargetSchemaNameObject = info.get(MULTIPLEX_TARGET_SCHEMA_NAMES);
        LinkedHashMap multiplexTargetSchemaNameMap = multiplexTargetSchemaNameObject == null ? new LinkedHashMap() : (LinkedHashMap)multiplexTargetSchemaNameObject;
        TreeSet<DbType> multiDbTypes = new TreeSet<DbType>();
        if (StringUtils.isNotBlank((CharSequence)multiplexTargetDialects)) {
            multiDbTypes.add(sourceDbType);
            multiDbTypes.addAll(Arrays.stream(multiplexTargetDialects.split(",")).map(dialect -> {
                try {
                    return DbType.of(dialect);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(ErrorMessages.format(ErrorMessages.MULTIPLEX_TARGET_DIALECTS_ERROR, replaceUrl, dialect));
                }
            }).collect(Collectors.toList()));
        }
        if (!multiDbTypes.isEmpty()) {
            jdbcPropertiesMultiTmp = new HashMap(16);
            multiDbTypes.forEach(multiplexTargetDialectDbType -> {
                JdbcProperties jdbcProperties;
                String schemaName;
                String multiplexTargetDialect;
                if (multiplexTargetDialectDbType == sourceDbType) {
                    return;
                }
                String rawDialect = multiplexTargetDialect = multiplexTargetDialectDbType.name();
                String simulateDialect = UnisqlProperties.getSimulateMapping(multiplexTargetDialect);
                if (StringUtils.isNotBlank((CharSequence)simulateDialect)) {
                    multiplexTargetDialect = simulateDialect;
                }
                if (StringUtils.isBlank((CharSequence)(schemaName = (String)multiplexTargetSchemaNameMap.get(multiplexTargetDialect))) && !MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
                    schemaName = Driver.getDefaultSchemaName(multiplexTargetDialect);
                }
                if (Driver.jdbcMultiDatasourceContainsKey(multiplexTargetDialect, schemaName)) {
                    jdbcProperties = Driver.getJdbcMultiDatasource(multiplexTargetDialect, schemaName);
                    if (StringUtils.isNotBlank((CharSequence)simulateDialect)) {
                        if (jdbcProperties.getUrl().contains(TARGET_DIALECT)) {
                            throw new IllegalArgumentException("\u6a21\u62df\u76ee\u6807\u5e93\u6a21\u5f0f\u4e0b\uff0c\u4e0d\u5141\u8bb8\u5728\u6570\u636e\u5e93\u8fde\u63a5url\u4e0a\u8bbe\u7f6etargetDialect\u5c5e\u6027\uff0c\u8be5\u5c5e\u6027\u7531\u7cfb\u7edf\u81ea\u52a8\u8bbe\u7f6e");
                        }
                        JdbcProperties copy = jdbcProperties.copy();
                        copy.setUrl(copy.getUrl() + "&targetDialect=" + rawDialect);
                        jdbcProperties = copy;
                    }
                } else {
                    if (StringUtils.isBlank((CharSequence)schemaName)) {
                        throw new NoSuchElementException(ErrorMessages.format(ErrorMessages.MULTIPLEX_SOURCE_DIALECT_NULL_ERROR, multiplexTargetDialect));
                    }
                    throw new NoSuchElementException(ErrorMessages.format(ErrorMessages.MULTIPLEX_SOURCE_DIALECT_DBNAME_NULL_ERROR, multiplexTargetDialect, schemaName));
                }
                jdbcPropertiesMultiTmp.put(rawDialect + ":" + schemaName, jdbcProperties);
            });
        } else {
            jdbcPropertiesMultiTmp = new HashMap<String, JdbcProperties>(JDBC_PROPERTIES_MULTI);
            multiDbTypes.add(sourceDbType);
            jdbcPropertiesMultiTmp.forEach((key, jdbcProperties) -> multiDbTypes.add(DbType.of(jdbcProperties.getTargetDialect())));
        }
        if (jdbcPropertiesMultiTmp.isEmpty()) {
            throw new IllegalStateException("\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u672a\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bfb\u53d6\u591a\u53d1\u6570\u636e\u6e90\u4fe1\u606f [{}]", (Object)JsonUtils.toJson(jdbcPropertiesMultiTmp));
        }
        return this.getMultiConnection(info, sourceDbType, jdbcPropertiesMultiTmp, multiDbTypes, replaceUrl, driver);
    }

    private Connection getUnisqlConnection(String url, Properties info, Properties urlProps, Mode mode) throws SQLException {
        HashSet<DbType> multiDbTypes = new HashSet<DbType>();
        String sourceDialect = urlProps.getProperty(SOURCE_DIALECT);
        String multiplexTargetDialects = urlProps.getProperty(MULTIPLEX_TARGET_DIALECTS);
        if (StringUtils.isNotBlank((CharSequence)multiplexTargetDialects)) {
            multiDbTypes.add(DbType.of(sourceDialect));
            multiDbTypes.addAll(Arrays.stream(multiplexTargetDialects.split(",")).map(dialect -> {
                try {
                    return DbType.of(dialect);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5f53\u524d\u914d\u7f6e\u7684\u6570\u636e\u5e93\u65b9\u8a00\u4e3a\uff1a{}", (Object)String.join((CharSequence)",", multiDbTypes.stream().map(d -> d.name()).collect(Collectors.toList())));
        }
        return this.unisqlConnect(url, info, mode, multiDbTypes);
    }

    private MultiConnection getMultiConnection(Properties info, DbType sourceDbType, Map<String, JdbcProperties> jdbcPropertiesMultiTmp, Set<DbType> multiDbTypes, String replaceUrl, java.sql.Driver driver) throws SQLException {
        Connection nativeConnection = null;
        ArrayList<UnisqlConnection> connections = new ArrayList<UnisqlConnection>();
        try {
            for (JdbcProperties jdbcProperties : jdbcPropertiesMultiTmp.values()) {
                try {
                    UnisqlConnection connection;
                    Properties properties = Driver.parseUrl(jdbcProperties.getUrl());
                    String sourceDialect = this.mustExists(properties, SOURCE_DIALECT, "url\u8fde\u63a5\u53c2\u6570sourceDialect\u672a\u6307\u5b9a\uff0curl\u8fde\u63a5\u4e32\uff1a" + jdbcProperties.getUrl());
                    String targetDialect = this.mustExists(properties, TARGET_DIALECT, "url\u8fde\u63a5\u53c2\u6570targetDialect\u672a\u6307\u5b9a\uff0curl\u8fde\u63a5\u4e32\uff1a" + jdbcProperties.getUrl());
                    if (DbType.ORACLE.equals((Object)DbType.of(sourceDialect)) && DbType.ORACLE.equals((Object)DbType.of(targetDialect)) || DbType.MYSQL.equals((Object)DbType.of(sourceDialect)) && DbType.MYSQL.equals((Object)DbType.of(targetDialect))) continue;
                    Mode targetSourceMode = null;
                    if (StringUtils.isNotEmpty((CharSequence)jdbcProperties.getUrl())) {
                        Properties jdbcProps = Driver.parseUrl(jdbcProperties.getUrl());
                        targetSourceMode = Mode.of(jdbcProps.getProperty(MULTIPLEX_MODE));
                    }
                    if ((connection = this.unisqlConnect(jdbcProperties.getUrl() + "&" + SOURCE_DIALECT + "=" + sourceDbType.name(), jdbcProperties.getProperties(), targetSourceMode, multiDbTypes)) != null) {
                        log.info("\u6e90\u7aef[{}]\u5230\u76ee\u6807\u7aef[{}]\u591a\u53d1\u8fde\u63a5\u5efa\u7acb\u6210\u529f\uff0cURL[{}]", new Object[]{sourceDbType, jdbcProperties.getTargetDialect(), jdbcProperties.getUrl()});
                        connections.add(connection);
                        continue;
                    }
                    log.info("\u6e90\u7aef[{}]\u5230\u76ee\u6807\u7aef[{}]\u591a\u53d1\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff0cURL[{}]", new Object[]{sourceDbType, jdbcProperties.getTargetDialect(), jdbcProperties.getUrl()});
                }
                catch (SQLException sQLException) {
                    if (log.isErrorEnabled()) {
                        log.error("\u6e90\u7aef[{}]\u5230\u76ee\u6807\u7aef[{}]\u591a\u53d1\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff0cURL[{}]", new Object[]{sourceDbType, jdbcProperties.getTargetDialect(), sQLException});
                    }
                    throw new SQLException(String.format("\u6e90\u7aef[%s]\u5230\u76ee\u6807\u7aef[%s]\u591a\u53d1\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff0cURL[%s]:%s", new Object[]{sourceDbType, jdbcProperties.getTargetDialect(), jdbcProperties.getUrl(), ExceptionUtils.getStackTrace((Throwable)sQLException)}));
                }
            }
            String sourceDbName = null;
            try {
                nativeConnection = driver.connect(this.replaceJdbcUrl(replaceUrl), info);
                sourceDbName = Driver.getSchemaName(info, replaceUrl, sourceDbType.name());
            }
            catch (SQLException e) {
                throw new SQLException(String.format("\u6e90\u7aef[%s]\u591a\u53d1\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff0cURL[%s]:%s", sourceDbType.name(), replaceUrl, ExceptionUtils.getStackTrace((Throwable)e)));
            }
            return new MultiConnection(nativeConnection, connections, sourceDbType, sourceDbName, multiDbTypes, this.buildDataBaseInfo(replaceUrl, info));
        }
        catch (Exception e) {
            try {
                for (Connection connection : connections) {
                    connection.close();
                }
                if (nativeConnection != null) {
                    nativeConnection.close();
                }
            }
            catch (Exception e2) {
                log.warn("\u5173\u95ed\u539f\u59cb\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff0c\u4ec5\u6253\u5370\u5f02\u5e38\uff0c\u7136\u540e\u4ecd\u7136\u629b\u51fa\u539f\u59cb\u5f02\u5e38\u3002", (Throwable)e);
            }
            throw e;
        }
    }

    private String replaceJdbcUrl(String input) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String result = input.replaceAll("&?(sourceDialect|targetDialect|multiplexTargetDialects|mode)=[\\w,]+", "");
        if (!result.isEmpty() && (result = result.replaceFirst("\\?&", "?")).endsWith("?")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public UnisqlConnection unisqlConnect(String url, Properties info, Mode mode, Set<DbType> multiDbTypes) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String replaceUrl = url.replace(ACCEPT_PREFIX, JDBC_PREFIX);
        Properties prop = Driver.parseUrl(url);
        String sourceDialect = this.mustExists(prop, SOURCE_DIALECT, "url param sourceDialect not specified");
        String targetDialect = this.mustExists(prop, TARGET_DIALECT, "url param targetDialect not specified");
        DbType sourceDialect1 = DbType.of(sourceDialect);
        DbType targetDialect1 = DbType.of(targetDialect);
        Connection nativeConnection = null;
        try {
            java.sql.Driver driver = this.getTargetDriver(replaceUrl, targetDialect1);
            nativeConnection = driver.connect(this.replaceJdbcUrl(replaceUrl), info);
            this.printInformation(url, replaceUrl, nativeConnection, sourceDialect1, targetDialect1);
            String dataBase = Driver.getSchemaName(info, url, targetDialect);
            return new UnisqlConnection(nativeConnection, sourceDialect1, targetDialect1, dataBase, mode, prop.getProperty(TARGET_VERSION), multiDbTypes, this.buildDataBaseInfo(replaceUrl, info));
        }
        catch (Exception e) {
            try {
                if (Optional.ofNullable(nativeConnection).isPresent()) {
                    nativeConnection.close();
                }
            }
            catch (Exception e2) {
                log.warn("An exception occurred when closing the original connection, only print the exception and still throw the original exception.", (Throwable)e);
            }
            throw new SQLException(String.format("\u6e90\u7aef[%s]\u5230\u76ee\u6807\u7aef[%s] UnisqlConnection\u8fde\u63a5\u5efa\u7acb\u5931\u8d25\uff0cURL[%s]:%s", sourceDialect1.name(), targetDialect1.name(), url, ExceptionUtils.getStackTrace((Throwable)e)));
        }
    }

    private ConnectionInfoDTO buildDataBaseInfo(String url, Properties info) {
        ConnectionInfoDTO dataBaseInfo = new ConnectionInfoDTO();
        dataBaseInfo.setUrl(url);
        dataBaseInfo.setUsername(info.get(JDBC_PROPERTY_USER).toString());
        dataBaseInfo.setPassword(info.get(JDBC_PROPERTY_PASSWORD).toString());
        return dataBaseInfo;
    }

    private void printInformation(String url, String replaceUrl, Connection con, DbType src, DbType dst) {
        if (INFO_PRINTED.containsKey(url)) {
            return;
        }
        String databaseNameAndVersion = UNKNOWN;
        try {
            if (replaceUrl.startsWith(JDBC_POSTGRESQL) || DbType.OCEAN_BASE_MYSQL.equals((Object)dst)) {
                databaseNameAndVersion = this.getVersion(url, con, "select version()");
            } else if (replaceUrl.startsWith(JDBC_OCEANBASE) || replaceUrl.startsWith(JDBC_ORACLE)) {
                databaseNameAndVersion = this.getVersion(url, con, "select BANNER from v$version");
            } else {
                DatabaseMetaData metadata = con.getMetaData();
                databaseNameAndVersion = metadata.getDatabaseProductName() + " " + metadata.getDatabaseProductVersion();
            }
        }
        catch (Exception e) {
            log.warn("Cannot detect target database type, real url: {}", (Object)replaceUrl);
        }
        if (log.isInfoEnabled()) {
            log.info("Established unisql JDBC connection. database: {}, source dialect: {}, target dialect: {}", new Object[]{databaseNameAndVersion, src, dst});
        }
        INFO_PRINTED.put(url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion(String url, Connection con, String sqlForVersion) {
        Statement stmt = null;
        ResultSet rs = null;
        String databaseNameAndVersion = UNKNOWN;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery(sqlForVersion);
            if (rs.next()) {
                databaseNameAndVersion = rs.getString(1);
            }
        }
        catch (SQLException e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5e93\u7248\u672c\u5931\u8d25,url\u4e3a({})", (Object)url, (Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95edResultSet\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error("\u5173\u95edStatement\u8d44\u6e90\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return databaseNameAndVersion;
    }

    public static String getSchemaName(Properties connectionInfo, String url, String targetDialect) {
        String user = connectionInfo.getProperty(JDBC_PROPERTY_USER);
        if (DbType.ORACLE.name().equalsIgnoreCase(targetDialect) || DbType.ORACLE_19C.name().equalsIgnoreCase(targetDialect) || DbType.DM.name().equalsIgnoreCase(targetDialect)) {
            return user;
        }
        return Driver.getDataBase(url);
    }

    public static String getDataBase(String url) {
        String dataBase = "";
        try {
            int endIndex = url.indexOf(63);
            if (endIndex != -1) {
                int beginIndex = url.substring(0, endIndex).lastIndexOf("/") + 1;
                dataBase = url.substring(beginIndex, endIndex);
            } else {
                int beginIndex = url.lastIndexOf(47) + 1;
                dataBase = url.substring(beginIndex);
            }
        }
        catch (Exception e) {
            log.error("jdbc url \u89e3\u6790\u6570\u636e\u5e93\u540d\u79f0\u5931\u8d25\uff0curl: [{}] \u5f02\u5e38\u4fe1\u606f\uff1a[{}]", (Object)url, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            dataBase = UNKNOWN;
            return dataBase;
        }
        return dataBase;
    }

    private String mustExists(Properties prop, String key, String msg) {
        String property = prop.getProperty(key);
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
        return property;
    }

    public static Properties parseUrl(String url) {
        String[] args;
        int qPos = url.indexOf(63);
        if (qPos == -1) {
            throw new IllegalArgumentException("url param sourceDialect not specified [" + url + "]");
        }
        String urlArgs = url.substring(qPos + 1);
        Properties urlProps = new Properties();
        for (String token : args = urlArgs.split("&")) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                urlProps.setProperty(token, "");
                continue;
            }
            urlProps.setProperty(token.substring(0, pos), Driver.decode(token, pos));
        }
        if (UnisqlProperties.getInstance().getUnsqlTargetForceUseGaussDb500()) {
            String sourceDialect = urlProps.getProperty(SOURCE_DIALECT);
            String targetDialect = urlProps.getProperty(TARGET_DIALECT);
            if (StringUtils.isNotBlank((CharSequence)sourceDialect) && StringUtils.isNotBlank((CharSequence)targetDialect) && StringUtils.equalsIgnoreCase((CharSequence)sourceDialect, (CharSequence)DbType.MYSQL.name()) && StringUtils.equalsIgnoreCase((CharSequence)targetDialect, (CharSequence)DbType.GAUSSDB_ORACLE.name())) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("\u5f00\u542f\u4e86\u53c2\u6570%s, \u76ee\u6807\u7c7b\u578b%s\u88ab\u5f3a\u5236\u8bbe\u7f6e\u4e3a%s", "unisql.target.dialect.forceusegaussdb500", targetDialect, DbType.GAUSSDB500_ORACLE.name()));
                }
                urlProps.setProperty(TARGET_DIALECT, DbType.GAUSSDB500_ORACLE.name());
            }
        }
        return urlProps;
    }

    private static String decode(String token, int pos) {
        try {
            return URLDecoder.decode(token.substring(pos + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to decode URL entry via UTF-8. This should not happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected java.sql.Driver getTargetDriver(String rawUrl, DbType targetDialectType) throws SQLException {
        if (rawUrl == null) {
            return null;
        }
        if (rawUrl.startsWith(JDBC_OPENGAUSS)) {
            if (DbType.GAUSSDB_ORACLE.equals((Object)targetDialectType) || DbType.GAUSSDB_MYSQL.equals((Object)targetDialectType) || DbType.GAUSSDB500_ORACLE.equals((Object)targetDialectType)) {
                return this.createDriver("com.huawei.opengauss.jdbc.Driver");
            }
            return this.createDriver("org.opengauss.Driver");
        }
        if (rawUrl.startsWith(JDBC_GAUSS)) {
            if (DbType.GAUSSDB_MYSQL_B.equals((Object)targetDialectType) || DbType.GAUSSDB_ORACLE.equals((Object)targetDialectType)) {
                return this.createDriver("com.huawei.gaussdb.jdbc.Driver");
            }
            return this.createDriver("com.huawei.gauss200.jdbc.Driver");
        }
        if (rawUrl.startsWith(JDBC_POSTGRESQL)) {
            return this.createDriver("org.postgresql.Driver");
        }
        if (rawUrl.startsWith(JDBC_DM)) {
            return this.createDriver("dm.jdbc.driver.DmDriver");
        }
        if (rawUrl.startsWith(JDBC_OCEANBASE)) {
            return this.createDriver("com.alipay.oceanbase.jdbc.Driver");
        }
        if (rawUrl.startsWith(JDBC_MARIADB)) {
            return this.createDriver("org.mariadb.jdbc.Driver");
        }
        if (rawUrl.startsWith(JDBC_ORACLE) || rawUrl.startsWith(JDBC_ORACLE_UPPER)) {
            return this.createDriver("oracle.jdbc.OracleDriver");
        }
        if (rawUrl.startsWith(JDBC_GOLDENDB)) {
            return this.createDriver("com.goldendb.jdbc.Driver");
        }
        if (rawUrl.startsWith(JDBC_MYSQL)) {
            if (mysql_driver_version_8 == null) {
                Driver driver = INSTANCE;
                synchronized (driver) {
                    if (mysql_driver_version_8 == null) {
                        mysql_driver_version_8 = Utils.loadClass(JDBC_MYSQL_DRIVER) != null;
                    }
                }
            }
            if (mysql_driver_version_8.booleanValue()) {
                return this.createDriver(JDBC_MYSQL_DRIVER);
            }
            return this.createDriver("com.mysql.jdbc.Driver");
        }
        return DriverManager.getDriver(rawUrl);
    }

    protected DbType getSourceDbType(String rawUrl) throws SQLException {
        if ((rawUrl = rawUrl.toLowerCase()).startsWith(JDBC_ORACLE)) {
            return DbType.ORACLE;
        }
        if (rawUrl.startsWith(JDBC_MYSQL)) {
            return DbType.MYSQL;
        }
        throw new SQLException("not currently support except oracle");
    }

    private java.sql.Driver createDriver(String className) throws SQLException {
        Class<?> rawDriverClass = Utils.loadClass(className);
        if (rawDriverClass == null) {
            throw new SQLException("jdbc-driver's class not found. '" + className + "'");
        }
        try {
            return (java.sql.Driver)rawDriverClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException var5) {
            throw new SQLException("create driver instance error, driver className '" + className + "'", var5);
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            return false;
        }
        return url.startsWith(ACCEPT_PREFIX);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ConcurrentHashMap<String, JdbcProperties> jdbcMultiProperties(String propMultiConfigurationPath) {
        Properties properties;
        block28: {
            if (MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
                return JDBC_PROPERTIES_MULTI;
            }
            if (!JDBC_PROPERTIES_MULTI.isEmpty()) {
                return JDBC_PROPERTIES_MULTI;
            }
            properties = new Properties();
            try {
                propMultiConfigurationPath = String.format(propMultiConfigurationPath + "%s", "");
                BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(propMultiConfigurationPath));
                properties.load(inputStream);
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block28;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Set<String> set = properties.stringPropertyNames();
        for (String key : set) {
            if (!key.startsWith("multiplex.")) continue;
            String rawUrl = properties.getProperty(key);
            JdbcProperties jdbcInfo = null;
            if (StringUtils.isBlank((CharSequence)rawUrl)) {
                throw new NoSuchElementException(ErrorMessages.MULTIPLEX_SOURCE_NULL_ERROR.getMsg());
            }
            if (rawUrl.startsWith(ACCEPT_PREFIX)) {
                rawUrl = rawUrl.replace(ACCEPT_PREFIX, JDBC_PREFIX);
            }
            if (rawUrl.startsWith(JDBC_OPENGAUSS)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.OPENGAUSS, key, properties);
            } else if (rawUrl.startsWith(JDBC_POSTGRESQL)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.POSTGRESQL, key, properties);
            } else if (rawUrl.startsWith(JDBC_LIGHTDB)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.LIGHTDB_MYSQL, key, properties);
            } else if (rawUrl.startsWith(JDBC_DM)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.DM, key, properties);
            } else if (rawUrl.startsWith(JDBC_OCEANBASE)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.OCEAN_BASE_ORACLE, key, properties);
            } else if (rawUrl.startsWith(JDBC_MARIADB)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.MYSQL, key, properties);
            } else if (rawUrl.startsWith(JDBC_ORACLE) || rawUrl.startsWith(JDBC_ORACLE_UPPER)) {
                jdbcInfo = Driver.generateJdbcProperties(DbType.ORACLE, key, properties);
            } else if (rawUrl.startsWith(JDBC_MYSQL)) {
                if (mysql_driver_version_8 == null) {
                    Driver driver = INSTANCE;
                    synchronized (driver) {
                        if (mysql_driver_version_8 == null) {
                            mysql_driver_version_8 = Utils.loadClass(JDBC_MYSQL_DRIVER) != null;
                        }
                    }
                }
                jdbcInfo = mysql_driver_version_8 != false ? Driver.generateJdbcProperties(DbType.MYSQL, key, properties) : Driver.generateJdbcProperties(DbType.MYSQL_80, key, properties);
            }
            if (jdbcInfo == null) continue;
            if (log.isDebugEnabled()) {
                log.debug("\u89e3\u6790\u5230\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e [{}]", (Object)JsonUtils.toJson(jdbcInfo));
            }
            Driver.putJdbcMultiDatasource(jdbcInfo.getTargetDialect(), jdbcInfo.getSchemaName(), jdbcInfo);
        }
        return JDBC_PROPERTIES_MULTI;
    }

    public static JdbcProperties generateJdbcProperties(DbType targetDbType, String key, Properties properties) {
        JdbcProperties jdbcProperties = new JdbcProperties();
        Properties propertiesNative = new Properties();
        String prefix = key.substring(0, key.lastIndexOf(".") + 1);
        String substringBeforeLastDot = key.substring(0, key.lastIndexOf(46));
        String targetDialect = substringBeforeLastDot.substring(substringBeforeLastDot.lastIndexOf(46) + 1).toLowerCase();
        String user = properties.getProperty(prefix + JDBC_PROPERTY_USER_NAME);
        propertiesNative.setProperty(JDBC_PROPERTY_USER, user);
        propertiesNative.setProperty(JDBC_PROPERTY_PASSWORD, properties.getProperty(prefix + JDBC_PROPERTY_PASSWORD));
        String url = properties.getProperty(prefix + JDBC_PROPERTY_URL);
        if (!url.startsWith(ACCEPT_PREFIX)) {
            url = url.replace(JDBC_PREFIX, ACCEPT_PREFIX);
        }
        Properties urlProps = Driver.parseUrl(url);
        String sourceDialect = urlProps.getProperty(SOURCE_DIALECT).toUpperCase();
        targetDialect = targetDialect.toUpperCase();
        jdbcProperties.setUrl(url);
        jdbcProperties.setProperties(propertiesNative);
        jdbcProperties.setSourceDialect(sourceDialect);
        jdbcProperties.setTargetDialect(targetDialect);
        Properties info = new Properties();
        info.setProperty(JDBC_PROPERTY_USER, user);
        String schemaName = Driver.getSchemaName(info, url, targetDialect);
        jdbcProperties.setSchemaName(schemaName);
        JDBC_PROPERTIES_DEFAULT_SCHEMA.put(targetDialect, jdbcProperties.getSchemaName());
        return jdbcProperties;
    }

    public static String getDefaultSchemaName(String targetDialect) {
        if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
            if (JDBC_PROPERTIES_DEFAULT_SCHEMA.isEmpty()) {
                Driver.jdbcMultiProperties(UnisqlProperties.getPropMultiConfigurationPath());
            }
        } else {
            throw new RuntimeException(ErrorMessages.TARGET_DIALECT_SCHEMA_NAME_NULL_ERROR.getMsg());
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)JDBC_PROPERTIES_DEFAULT_SCHEMA.get(targetDialect.toUpperCase()), (CharSequence)"");
    }

    public static void setJdbcMultiDatasource(List<JdbcProperties> jdbcProperties) throws Exception {
        jdbcProperties.forEach(jdbcPropertiesItem -> {
            String url = jdbcPropertiesItem.getUrl();
            if (!url.startsWith(ACCEPT_PREFIX)) {
                url = url.replace(JDBC_PREFIX, ACCEPT_PREFIX);
            }
            jdbcPropertiesItem.setUrl(url);
            if (!jdbcPropertiesItem.getSchemaName().equals(Driver.getSchemaName(jdbcPropertiesItem.getProperties(), url, jdbcPropertiesItem.getTargetDialect()))) {
                throw new RuntimeException(ErrorMessages.format(ErrorMessages.MULTI_DATASOURCE_SCHEMA_ERROR, jdbcPropertiesItem.getSourceDialect(), jdbcPropertiesItem.getTargetDialect()));
            }
            if (!Driver.checkJdbcMultiDatasource(jdbcPropertiesItem)) {
                throw new RuntimeException(ErrorMessages.format(ErrorMessages.MULTI_DATASOURCE_CONFIG_ERROR, jdbcPropertiesItem.getSourceDialect(), jdbcPropertiesItem.getTargetDialect()));
            }
        });
        if (log.isInfoEnabled()) {
            log.info("\u66f4\u65b0\u524d\u7684\u5386\u53f2\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a{}", JDBC_PROPERTIES_MULTI);
        }
        jdbcProperties.forEach(jdbcPropertiesItem -> {
            if (log.isInfoEnabled()) {
                if (Driver.jdbcMultiDatasourceContainsKey(jdbcPropertiesItem.getTargetDialect(), jdbcPropertiesItem.getSchemaName())) {
                    log.info("\u76ee\u6807\u5e93[{}]schemaName[{}]\u5df2\u5b58\u5728\u6570\u636e\u6e90\u914d\u7f6e\uff1a{}\uff0c\u73b0\u5728\u8fdb\u884c\u66f4\u65b0\u4e3a\uff1a{}", new Object[]{jdbcPropertiesItem.getTargetDialect().toUpperCase(), jdbcPropertiesItem.getSchemaName(), Driver.getJdbcMultiDatasource(jdbcPropertiesItem.getTargetDialect(), jdbcPropertiesItem.getSchemaName()), jdbcPropertiesItem});
                } else {
                    log.info("\u76ee\u6807\u5e93[{}]schemaName[{}]\u4e0d\u5b58\u5728\u6570\u636e\u6e90\u914d\u7f6e\uff0c\u73b0\u5728\u8fdb\u884c\u589e\u52a0\u4e3a\uff1a{}", new Object[]{jdbcPropertiesItem.getTargetDialect().toUpperCase(), jdbcPropertiesItem.getSchemaName(), jdbcPropertiesItem});
                }
            }
            Driver.putJdbcMultiDatasource(jdbcPropertiesItem.getTargetDialect(), jdbcPropertiesItem.getSchemaName(), jdbcPropertiesItem);
        });
        if (log.isInfoEnabled()) {
            log.info("\u66f4\u65b0\u540e\u76ee\u524d\u6240\u6709\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u5982\u4e0b\uff1a{}", JDBC_PROPERTIES_MULTI);
        }
    }

    public static boolean checkJdbcMultiDatasource(JdbcProperties jdbcProperties) {
        Connection connection = null;
        try {
            Driver driver = new Driver();
            connection = driver.unisqlConnect(jdbcProperties.getUrl(), jdbcProperties.getProperties(), null, null);
            boolean bl = connection.isValid(2);
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("\u6e90\u7aef[%s]\u76ee\u6807\u7aef[%s]\u6570\u636e\u6e90\u914d\u7f6e\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\uff1a%s", jdbcProperties.getSourceDialect(), jdbcProperties.getTargetDialect(), ExceptionUtils.getStackTrace((Throwable)e)));
        }
        finally {
            block10: {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    if (!log.isWarnEnabled()) break block10;
                    log.warn("\u6821\u9a8c\u6570\u636e\u6e90\u8fde\u63a5\u662f\u5426\u6709\u6548\u540e\uff0c\u5173\u95ed\u8fde\u63a5\u53d1\u751f\u5f02\u5e38\uff0c\u4ec5\u6253\u5370\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static JdbcProperties getJdbcMultiDatasource(String targetDialect, String schemaName) {
        if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue() && StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = Driver.getDefaultSchemaName(targetDialect);
        }
        String newPropertiesKey = targetDialect.toUpperCase() + ":" + schemaName;
        return JDBC_PROPERTIES_MULTI.get(newPropertiesKey);
    }

    public static void putJdbcMultiDatasource(String targetDialect, String schemaName, JdbcProperties jdbcProperties) {
        if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue() && StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = Driver.getDefaultSchemaName(targetDialect);
        }
        String newPropertiesKey = targetDialect.toUpperCase() + ":" + schemaName;
        JDBC_PROPERTIES_MULTI.put(newPropertiesKey, jdbcProperties);
    }

    public static boolean jdbcMultiDatasourceContainsKey(String targetDialect, String schemaName) {
        if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue() && StringUtils.isBlank((CharSequence)schemaName)) {
            schemaName = Driver.getDefaultSchemaName(targetDialect);
        }
        String newPropertiesKey = targetDialect.toUpperCase() + ":" + schemaName;
        return JDBC_PROPERTIES_MULTI.containsKey(newPropertiesKey);
    }

    static {
        AccessController.doPrivileged(() -> {
            Driver.registerDriver(INSTANCE);
            return null;
        });
        PRE_CHECKED = new ConcurrentHashMap<String, Boolean>();
        INFO_PRINTED = new ConcurrentHashMap<String, Boolean>();
        JDBC_PROPERTIES_MULTI = new ConcurrentHashMap();
        JDBC_PROPERTIES_DEFAULT_SCHEMA = new ConcurrentHashMap();
        Driver.tryInitMetadata();
    }
}

