/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.constant.CompareKindEnum;
import com.hundsun.lightdb.unisql.constant.CompareReportStateEnum;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.PreparedParameter;
import com.hundsun.lightdb.unisql.golang.ReturnParameter;
import com.hundsun.lightdb.unisql.golang.SqlState;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.golang.VariableParameter;
import com.hundsun.lightdb.unisql.model.ConnectionInfoDTO;
import com.hundsun.lightdb.unisql.model.Mode;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.SyncDataParamater;
import com.hundsun.lightdb.unisql.model.UuidClientRequest;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlPreparedStatement;
import com.hundsun.lightdb.unisql.proxy.jdbc.UnisqlStatement;
import com.hundsun.lightdb.unisql.utils.DbTypeSerializeUtil;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import com.hundsun.lightdb.unisql.utils.MultiJdbcUtils;
import com.hundsun.lightdb.unisql.utils.SqlInfo;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class MultiplexContext {
    private static final Logger log = LoggerFactory.getLogger(MultiplexContext.class);
    public static final String INVALID_TRACE_ID_PREFIX = "invalid-";
    private static ThreadLocal<String> realMultiplexTraceId = new ThreadLocal();
    private static ThreadLocal<String> multiUsername = new ThreadLocal();
    private static ThreadLocal<String> multiUrl = new ThreadLocal();
    private static UuidClient uuidClient = null;
    private static boolean uuidClientInitialized = false;
    private static final Set<String> VALIDATION_QUERIES = new HashSet<String>();
    private static final ConcurrentHashMap<String, ExecutorService> TARGET_THREAD_POOL_EXECUTOR_MAP = new ConcurrentHashMap();
    public static final String COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT = "com.alibaba.dubbo.rpc.RpcContext";
    public static final String GET_CONTEXT = "getContext";
    public static final String GET = "get";
    public static final String INVOKE_EVENT = "invoke.event";
    public static final String COM_HUNDSUN_JRESCLOUD_COMMON_T_2_EVENT_T_3_EVENT = "com.hundsun.jrescloud.common.t2.event.T3Event";
    public static final String GET_STRING_ATTRIBUTE_VALUE = "getStringAttributeValue";
    public static final String ATTR_INDEX_80 = "80";
    public static final String ATTR_INDEX_5 = "5";
    public static final int ATTR_LENGTH_14 = 14;
    public static final String COM_HUNDSUN_JRESCLOUD_TRACE_UTIL_TRACE_ADAPTER_UTIL = "com.hundsun.jrescloud.trace.util.TraceAdapterUtil";
    public static final String GET_CURRENT_TRACE_ID = "getCurrentTraceId";
    public static final String COM_HUNDSUN_JRESCLOUD_COMMON_UTIL_CONFIG_UTILS = "com.hundsun.jrescloud.common.util.ConfigUtils";
    public static final String GET_APP_NAME = "getAppName";
    public static final String EVENT_BODY = "eventBody";
    public static final String OPERATOR_CODE = "operator_code";
    private static boolean reflectLogPrinted;
    static EvictionListener<String, AtomicInteger> listener;
    static ConcurrentMap<String, AtomicInteger> traceId2SqlSequenceIdCache;
    static Map<String, String> TARGET_DIALECT_SERIAL_MAPPING;
    static volatile Method sendMessageMethod;
    static volatile Method sendToUuidClientMethod;

    public static boolean isValidationQuery(String query) {
        for (String validQuery : VALIDATION_QUERIES) {
            if (!validQuery.equalsIgnoreCase(query)) continue;
            return true;
        }
        return false;
    }

    public static ExecutorService getOrCreateTargetPool(String targetKey) {
        return TARGET_THREAD_POOL_EXECUTOR_MAP.computeIfAbsent(targetKey, k -> new ThreadPoolExecutor(MultiProperties.MULTI_TARGET_THREAD_POOL_SIZE, MultiProperties.MULTI_TARGET_THREAD_POOL_SIZE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(MultiProperties.MULTI_TARGET_THREAD_POOL_QUEUE_SIZE), new TargetKeyThreadFactory(targetKey), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    public static boolean inValidTraceId(String traceId) {
        return StringUtils.isNotBlank((CharSequence)traceId) && traceId.startsWith(INVALID_TRACE_ID_PREFIX);
    }

    public static String setRealMultiplexTraceId() {
        return MultiplexContext.setRealMultiplexTraceId("");
    }

    public static String setRealMultiplexTraceId(String traceId) {
        if (MultiProperties.getSendCompareService()) {
            if (StringUtils.isBlank((CharSequence)traceId)) {
                traceId = UUID.randomUUID().toString().replace("-", "");
            }
            realMultiplexTraceId.set(traceId);
            if (log.isDebugEnabled()) {
                log.debug("\u771f\u591a\u53d1\u8bbe\u7f6e traceId [{}]", (Object)traceId);
            }
            return traceId;
        }
        return traceId;
    }

    public static void removeRealMultiplexTraceId() {
        realMultiplexTraceId.remove();
    }

    public static void removeMultiUsername() {
        multiUsername.remove();
    }

    public static void setMultiUsername(String username) {
        multiUsername.set(username);
    }

    public static String getMultiUsername() {
        String username;
        block6: {
            boolean realMultiplex = MultiProperties.realMultiplex();
            if (!realMultiplex) {
                try {
                    Method getMehod;
                    Object event;
                    Class<?> clazz = Class.forName(COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT);
                    Method method = clazz.getMethod(GET_CONTEXT, new Class[0]);
                    Object invoke = method.invoke(null, new Object[0]);
                    if (COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT.equals(invoke.getClass().getName()) && (event = (getMehod = clazz.getMethod(GET, String.class)).invoke(invoke, INVOKE_EVENT)) != null && event.getClass().getName().equals(COM_HUNDSUN_JRESCLOUD_COMMON_T_2_EVENT_T_3_EVENT)) {
                        Field eventBody = event.getClass().getDeclaredField(EVENT_BODY);
                        eventBody.setAccessible(true);
                        Object str = eventBody.get(event);
                        JSONObject object = JSON.parseObject((String)str.toString());
                        String operatorCode = object.getString(OPERATOR_CODE);
                        return operatorCode;
                    }
                }
                catch (Exception e) {
                    if (reflectLogPrinted || !log.isDebugEnabled()) break block6;
                    log.debug(ErrorMessages.format(ErrorMessages.LTU0011, new Object[0]), (Object)e.getMessage());
                    reflectLogPrinted = true;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(username = multiUsername.get()))) {
            if (log.isDebugEnabled()) {
                log.debug("\u7ebf\u7a0b [{}] \u83b7\u53d6 username [{}]", (Object)Thread.currentThread().getName(), (Object)username);
            }
            return username;
        }
        return MultiProperties.getMultiUsername();
    }

    public static void removeMultiUrl() {
        multiUrl.remove();
    }

    public static void setMultiUrl(String url) {
        multiUrl.set(url);
    }

    public static String getMultiUrl() {
        return multiUrl.get();
    }

    public static MultiQueryResultDTO createMultiQueryResult(String currentTraceId, DbType sourceDbType, DbType targetDbType, String schemaName, Set<DbType> multiDbTypes, ConnectionInfoDTO dataBaseInfo) {
        MultiQueryResultDTO queryResultDTO = MultiQueryResultDTO.createForTraceId(currentTraceId);
        queryResultDTO.setRealMultiplex(MultiProperties.realMultiplex());
        queryResultDTO.setTraceId(currentTraceId);
        queryResultDTO.setAppName(MultiplexContext.getAppName());
        queryResultDTO.setAppType(MultiProperties.getMultiAppType());
        queryResultDTO.setUsername(MultiplexContext.getMultiUsername());
        queryResultDTO.setFunctionId(MultiplexContext.getFunctionId());
        queryResultDTO.setMultiAppHostIp(MultiplexContext.getMultiAppHostIp());
        queryResultDTO.setTenantName(MultiProperties.getMultiTenantName());
        queryResultDTO.setUrl(MultiplexContext.getMultiUrl());
        queryResultDTO.setSourceDialect(sourceDbType.name());
        queryResultDTO.setTargetDialect(targetDbType.name());
        queryResultDTO.setBizSqlSequence(MultiplexContext.nextSqlSequenceId(currentTraceId, queryResultDTO.getTargetDialect()));
        queryResultDTO.setSchemaName(schemaName);
        Set<String> collect = multiDbTypes.stream().map(Enum::name).collect(Collectors.toSet());
        queryResultDTO.setMultiTargetDialects(collect);
        queryResultDTO.setSyncConnectionInfo(dataBaseInfo);
        return queryResultDTO;
    }

    public static String getCurrentTraceId() {
        String realMultiplexTraceId;
        block7: {
            boolean realMultiplex = MultiProperties.realMultiplex();
            if (!realMultiplex) {
                try {
                    Class<?> traceAdapterUtil = Class.forName(COM_HUNDSUN_JRESCLOUD_TRACE_UTIL_TRACE_ADAPTER_UTIL);
                    Method method = traceAdapterUtil.getMethod(GET_CURRENT_TRACE_ID, new Class[0]);
                    String traceId = (String)method.invoke(null, new Object[0]);
                    if (StringUtils.isNotBlank((CharSequence)traceId)) {
                        return traceId;
                    }
                }
                catch (Exception e) {
                    if (reflectLogPrinted || !log.isDebugEnabled()) break block7;
                    log.debug(ErrorMessages.format(ErrorMessages.LTU0011, new Object[0]), (Throwable)e);
                    reflectLogPrinted = true;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(realMultiplexTraceId = MultiplexContext.realMultiplexTraceId.get()))) {
            if (log.isDebugEnabled()) {
                log.debug("\u7ebf\u7a0b [{}] \u83b7\u53d6 traceId [{}]", (Object)Thread.currentThread().getName(), (Object)realMultiplexTraceId);
            }
            return realMultiplexTraceId;
        }
        String uuid = INVALID_TRACE_ID_PREFIX + UUID.randomUUID().toString();
        if (log.isDebugEnabled()) {
            log.debug("\u7ebf\u7a0b [{}] \u65e0\u6cd5\u83b7\u53d6 traceId\uff0c\u4f7f\u7528\u81ea\u52a8\u751f\u6210\u7684 UUID [{}]", (Object)Thread.currentThread().getName(), (Object)uuid);
        }
        return uuid;
    }

    public static String getAppName() {
        block4: {
            boolean realMultiplex = MultiProperties.realMultiplex();
            if (!realMultiplex) {
                try {
                    Class<?> clz = Class.forName(COM_HUNDSUN_JRESCLOUD_COMMON_UTIL_CONFIG_UTILS);
                    Method getAppName = clz.getMethod(GET_APP_NAME, new Class[0]);
                    String invoke = (String)getAppName.invoke(null, new Object[0]);
                    if (StringUtils.isNotBlank((CharSequence)invoke)) {
                        return invoke;
                    }
                }
                catch (Exception e) {
                    if (reflectLogPrinted) break block4;
                    log.debug(ErrorMessages.format(ErrorMessages.LTU0011, new Object[0]), (Object)e.getMessage());
                    reflectLogPrinted = true;
                }
            }
        }
        return MultiProperties.getMultiAppName();
    }

    public static String getFunctionId() {
        block4: {
            boolean realMultiplex = MultiProperties.realMultiplex();
            if (!realMultiplex) {
                try {
                    Method getMehod;
                    Object event;
                    Class<?> clazz = Class.forName(COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT);
                    Method method = clazz.getMethod(GET_CONTEXT, new Class[0]);
                    Object invoke = method.invoke(null, new Object[0]);
                    if (COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT.equals(invoke.getClass().getName()) && (event = (getMehod = clazz.getMethod(GET, String.class)).invoke(invoke, INVOKE_EVENT)) != null && event.getClass().getName().equals(COM_HUNDSUN_JRESCLOUD_COMMON_T_2_EVENT_T_3_EVENT)) {
                        Method getStringAttributeValue = event.getClass().getMethod(GET_STRING_ATTRIBUTE_VALUE, String.class);
                        String functionId = (String)getStringAttributeValue.invoke(event, ATTR_INDEX_5);
                        return functionId;
                    }
                }
                catch (Exception e) {
                    if (reflectLogPrinted || !log.isDebugEnabled()) break block4;
                    log.debug(ErrorMessages.format(ErrorMessages.LTU0011, new Object[0]), (Object)e.getMessage());
                    reflectLogPrinted = true;
                }
            }
        }
        return "";
    }

    public static String getMultiAppHostIp() {
        block4: {
            boolean realMultiplex = MultiProperties.realMultiplex();
            if (!realMultiplex) {
                try {
                    Method getMehod;
                    Object event;
                    Class<?> clazz = Class.forName(COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT);
                    Method method = clazz.getMethod(GET_CONTEXT, new Class[0]);
                    Object invoke = method.invoke(null, new Object[0]);
                    if (COM_ALIBABA_DUBBO_RPC_RPC_CONTEXT.equals(invoke.getClass().getName()) && (event = (getMehod = clazz.getMethod(GET, String.class)).invoke(invoke, INVOKE_EVENT)) != null && event.getClass().getName().equals(COM_HUNDSUN_JRESCLOUD_COMMON_T_2_EVENT_T_3_EVENT)) {
                        Method getStringAttributeValue = event.getClass().getMethod(GET_STRING_ATTRIBUTE_VALUE, String.class);
                        String[] systemInfo = (String[])getStringAttributeValue.invoke(event, ATTR_INDEX_80);
                        return null == systemInfo || systemInfo.length < 14 ? null : systemInfo[13];
                    }
                }
                catch (Exception e) {
                    if (reflectLogPrinted || !log.isDebugEnabled()) break block4;
                    log.debug(ErrorMessages.format(ErrorMessages.LTU0011, new Object[0]), (Object)e.getMessage());
                    reflectLogPrinted = true;
                }
            }
        }
        return Utils.getFirstAvailableIp();
    }

    public static int nextSqlSequenceId(String traceId, String targetDialect) {
        return traceId2SqlSequenceIdCache.computeIfAbsent(traceId + targetDialect, k -> new AtomicInteger(1)).getAndAdd(1);
    }

    public static int rollbackSqlSequenceId(String traceId, String targetDialect) {
        return traceId2SqlSequenceIdCache.computeIfAbsent(traceId + targetDialect, k -> new AtomicInteger(1)).getAndDecrement();
    }

    public static SqlInfo doDml2Dql(MultiQueryResultDTO queryResult) {
        String sourceSql = queryResult.getBizBindVarReplacedSql();
        SqlInfo sqlInfo = new SqlInfo();
        sqlInfo.setBizSql(sourceSql);
        String firstToken = sourceSql.trim().split("\\s+")[0];
        VariableParameter variableParameter = new VariableParameter();
        variableParameter.setSourceSql(sourceSql);
        variableParameter.setSourceDialect(queryResult.getSourceDialect());
        variableParameter.setTargetDialect(queryResult.getTargetDialect());
        variableParameter.setMode(Mode.MULTIPLEX.getValue());
        variableParameter.setBizSql(queryResult.getRawBizBindVarReplacedSql());
        sqlInfo.setBizSqlOperationType(firstToken.toUpperCase());
        queryResult.setBizSqlOperationType(firstToken.toUpperCase());
        boolean needDml2Dql = false;
        if (!"SELECT".equalsIgnoreCase(firstToken)) {
            if (MultiplexContext.needDml2Dql(firstToken)) {
                needDml2Dql = true;
            } else {
                ReturnParameter returnParameter = Transformer.IdentifySqlType(variableParameter);
                if (!SqlState.SUCCESS.getState().equals(returnParameter.getState())) {
                    String msg = String.format("\u901a\u8fc7IdentifySqlType\u89e3\u6790SQL\u8bed\u53e5\u7c7b\u578b\u5931\u8d25\uff0ctraceId [%s] \u6e90SQL [%s] \u9519\u8bef\u539f\u56e0 [%s]", queryResult.getTraceId(), variableParameter.getSourceSql(), returnParameter.getMessage());
                    if (log.isInfoEnabled()) {
                        log.info(msg);
                    }
                    queryResult.setState(CompareReportStateEnum.UNISQL_PARSE_FAIL.name());
                    queryResult.addErrorReason(msg);
                    queryResult.setCompareKind(CompareKindEnum.BEFORE_QUERY.name());
                    return sqlInfo;
                }
                sqlInfo.setBizSqlOperationType(returnParameter.getSqlType());
                needDml2Dql = MultiplexContext.needDml2Dql(sqlInfo.getBizSqlOperationType());
            }
        }
        String tableName = StringUtils.lowerCase((String)Transformer.getTableName(variableParameter));
        sqlInfo.setBizSqlTableName(tableName);
        sqlInfo.setNeedDml2Dql(needDml2Dql);
        if (needDml2Dql) {
            ReturnParameter returnParameter = Transformer.getDqlByDml(variableParameter);
            if (!SqlState.SUCCESS.getState().equals(returnParameter.getState())) {
                String msg = String.format("\u901a\u8fc7getDqlByDml\u83b7\u53d6\u524d\u540e\u67e5\u8be2\u5931\u8d25\uff0ctraceId [%s] \u6e90SQL [%s] \u9519\u8bef\u539f\u56e0 [%s]", queryResult.getTraceId(), variableParameter.getSourceSql(), returnParameter.getMessage());
                if (log.isErrorEnabled()) {
                    log.error(msg);
                }
                queryResult.setState(CompareReportStateEnum.DML2DQL_PARSE_FAIL.name());
                queryResult.addErrorReason(msg);
                queryResult.setCompareKind(CompareKindEnum.BEFORE_QUERY.name());
                return sqlInfo;
            }
            queryResult.setBizSqlOperationType(sqlInfo.getBizSqlOperationType());
            sqlInfo.setBeforeSql(returnParameter.getBefore());
            sqlInfo.setAfterSql(returnParameter.getAfter());
        } else {
            queryResult.setBizSqlOperationType("SELECT");
        }
        queryResult.setBizSqlTableName(sqlInfo.getBizSqlTableName());
        return sqlInfo;
    }

    public static String getTargetDialectSerial(String targetDialect) {
        return TARGET_DIALECT_SERIAL_MAPPING.getOrDefault(targetDialect, targetDialect);
    }

    private static boolean needDml2Dql(String firstToken) {
        return "INSERT".equalsIgnoreCase(firstToken) || "UPDATE".equalsIgnoreCase(firstToken) || "DELETE".equalsIgnoreCase(firstToken) || "REPLACE".equalsIgnoreCase(firstToken) || "MERGE".equalsIgnoreCase(firstToken);
    }

    public static boolean execute(Connection connection, Statement delegate, String delegateSql, MultiQueryResultDTO multiQueryResult, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) throws SQLException {
        return MultiplexContext.execute(connection, delegate, delegateSql, multiQueryResult, multiFutures, sourceQuery, null);
    }

    public static boolean execute(Connection connection, Statement delegate, String delegateSql, MultiQueryResultDTO multiQueryResult, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery, SyncDataParamater syncData) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql) traceId [{}] currentTimeMillis [{}]", (Object)MultiplexContext.getCurrentTraceId(), (Object)System.currentTimeMillis());
        }
        long start = System.nanoTime();
        SqlInfo sqlInfo = MultiplexContext.doDml2Dql(multiQueryResult);
        boolean execute = false;
        SQLException exceptionOccur = null;
        if (MultiplexContext.isValidationQuery(multiQueryResult.getBizSql())) {
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u8fc7\u6ee4\u6389\u8fde\u63a5\u68c0\u67e5\u8bed\u53e5\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
            }
            MultiplexContext.rollbackSqlSequenceId(multiQueryResult.getTraceId(), multiQueryResult.getTargetDialect());
            return delegate.execute(delegateSql);
        }
        if (sqlInfo.isDql()) {
            try {
                multiQueryResult.setBizSqlExecutionTime(new Date());
                multiQueryResult.setCompareKind(CompareKindEnum.RAW_BIZ_QUERY.name());
                multiQueryResult.setMultiQuerySql(multiQueryResult.getBizBindVarReplacedSql());
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                execute = delegate.execute(multiQueryResult.getTransformedBizSql());
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                MultiJdbcUtils.doPreparedQuery(connection, multiQueryResult.getBizBindVarReplacedSql(), multiQueryResult, multiFutures, sourceQuery);
            }
            catch (Exception e) {
                if (e instanceof SQLException) {
                    exceptionOccur = (SQLException)e;
                }
                multiQueryResult.setState(CompareReportStateEnum.BIZ_SQL_EXECUTE_FAIL.name());
                multiQueryResult.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25,traceId [%s],\u4e1a\u52a1SQL[%s],\u5f02\u5e38\u4fe1\u606f[%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)));
                MultiplexContext.sendMessage(multiQueryResult);
            }
        } else if (sqlInfo.isDml()) {
            MultiplexContext.doMultiBeforeQuery(connection, multiQueryResult, start, sqlInfo, multiFutures, sourceQuery);
            MultiQueryResultDTO multiQueryResultAfter = MultiQueryResultDTO.deepCopyFrom(multiQueryResult);
            try {
                multiQueryResultAfter.resetForAfterQuery(sqlInfo);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                execute = delegate.execute(delegateSql);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                if (syncData != null) {
                    MultiQueryResultDTO syncResult = MultiQueryResultDTO.deepCopyFrom(multiQueryResult);
                    MultiplexContext.doReturningDataSync(syncData, delegate, syncResult);
                }
                MultiplexContext.doMultiAfterQuery(connection, delegate, multiQueryResultAfter, start, sqlInfo, multiFutures, sourceQuery);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u591a\u53d1\u6d88\u606f [{}] \u9519\u8bef\u4fe1\u606f [{}]", new Object[]{multiQueryResultAfter.getSourceDialect(), multiQueryResultAfter.getTargetDialect(), multiQueryResultAfter.getTraceId(), JsonUtils.toJson(multiQueryResultAfter), ExceptionUtils.getStackTrace((Throwable)e)});
                }
                if (e instanceof SQLException) {
                    exceptionOccur = (SQLException)e;
                    multiQueryResult.resetForAfterQuery(sqlInfo);
                }
                multiQueryResultAfter.setState(CompareReportStateEnum.BIZ_SQL_EXECUTE_FAIL.name());
                multiQueryResultAfter.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25,traceId [%s],\u4e1a\u52a1SQL[%s],\u5f02\u5e38\u4fe1\u606f[%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)));
                MultiplexContext.sendMessage(multiQueryResultAfter);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
            }
            execute = delegate.execute(multiQueryResult.getTransformedBizSql());
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
            }
        }
        if (Objects.nonNull(exceptionOccur)) {
            throw new SQLException(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0ctraceId [%s] \u591a\u53d1\u6d88\u606f [%s] \u9519\u8bef\u4fe1\u606f [%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), JsonUtils.toJson(multiQueryResult), ExceptionUtils.getStackTrace((Throwable)exceptionOccur)));
        }
        return execute;
    }

    public static boolean executeMultiplex(Connection connection, Statement delegate, List<UnisqlStatement> delegateMulti, MultiQueryResultDTO multiQueryResult) throws SQLException {
        ArrayList<MultiCompletableFuture> multiFutures = new ArrayList<MultiCompletableFuture>();
        boolean execute = MultiplexContext.execute(connection, delegate, multiQueryResult.getTransformedBizSql(), multiQueryResult, multiFutures, true);
        String traceId = multiQueryResult.getTraceId();
        for (UnisqlStatement statement : delegateMulti) {
            String targetKey = statement.getSourceDialect().name() + "2" + statement.getTargetDialect().name() + "\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c";
            ExecutorService pool = MultiplexContext.getOrCreateTargetPool(targetKey);
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5f00\u59cb\uff0ctraceId [{}] SQL [{}]", new Object[]{statement.getSourceDialect().name(), statement.getTargetDialect().name(), traceId, multiQueryResult.getBizSql()});
                    }
                    statement.execute(multiQueryResult.getBizSql(), traceId);
                    if (log.isDebugEnabled()) {
                        log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u7ed3\u675f\uff0ctraceId [{}] SQL [{}]", new Object[]{statement.getSourceDialect().name(), statement.getTargetDialect().name(), traceId, multiQueryResult.getBizSql()});
                    }
                    return String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5b8c\u6210", statement.getSourceDialect().name(), statement.getTargetDialect().name());
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5931\u8d25 traceId [{}] SQL [{}]  \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{statement.getSourceDialect().name(), statement.getTargetDialect().name(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)});
                    }
                    return String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5931\u8d25", statement.getSourceDialect().name(), statement.getTargetDialect().name());
                }
            }, pool);
            MultiCompletableFuture multiCompletableFuture = new MultiCompletableFuture(targetKey, future);
            multiFutures.add(multiCompletableFuture);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u540c\u6b65\u7b49\u5f85\u6e90\u5e93\u7684\u67e5\u8be2\u7ed3\u679c\u96c6\u5f02\u6b65\u904d\u5386\u4ee5\u53ca\u76ee\u6807\u5e93\u7684\u5f02\u6b65\u6267\u884c\u662f\u5426\u90fd\u5904\u7406\u5b8c\u6bd5,traceId [{}] SQL [{}]", (Object)multiQueryResult.getTraceId(), (Object)multiQueryResult.getBizSql());
        }
        for (MultiCompletableFuture future : multiFutures) {
            try {
                if (future.getFuture() == null) continue;
                future.getFuture().get();
            }
            catch (Exception e) {
                log.error("[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5f02\u5e38: {}", (Object)future.getTargetKey(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u591a\u53d1\u6267\u884c\u5b8c\u6210,\u7b49\u5f85\u6bd4\u5bf9\u7ed3\u679c, traceId [{}] SQL [{}]", (Object)multiQueryResult.getTraceId(), (Object)multiQueryResult.getBizSql());
        }
        return execute;
    }

    public static boolean executePrepared(Connection connection, PreparedStatement delegate, MultiQueryResultDTO multiQueryResult, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery, SyncDataParamater syncData) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u8fdb\u5165execute(String sql) traceId [{}] currentTimeMillis [{}]", (Object)multiQueryResult.getTraceId(), (Object)System.currentTimeMillis());
        }
        long start = System.nanoTime();
        SqlInfo sqlInfo = MultiplexContext.doDml2Dql(multiQueryResult);
        boolean execute = false;
        SQLException exceptionOccur = null;
        if (MultiplexContext.isValidationQuery(multiQueryResult.getBizSql())) {
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u8fc7\u6ee4\u6389\u8fde\u63a5\u68c0\u67e5\u8bed\u53e5\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
            }
            MultiplexContext.rollbackSqlSequenceId(multiQueryResult.getTraceId(), multiQueryResult.getTargetDialect());
            return delegate.execute();
        }
        if (sqlInfo.isDql()) {
            try {
                multiQueryResult.setCompareKind(CompareKindEnum.RAW_BIZ_QUERY.name());
                multiQueryResult.setBizSqlExecutionTime(new Date());
                multiQueryResult.setMultiQuerySql(multiQueryResult.getBizBindVarReplacedSql());
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                execute = delegate.execute();
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                MultiJdbcUtils.doPreparedQuery(connection, multiQueryResult.getBizBindVarReplacedSql(), multiQueryResult, multiFutures, sourceQuery);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u591a\u53d1\u6d88\u606f [{}] \u9519\u8bef\u4fe1\u606f [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), JsonUtils.toJson(multiQueryResult), ExceptionUtils.getStackTrace((Throwable)e)});
                }
                if (e instanceof SQLException) {
                    exceptionOccur = (SQLException)e;
                }
                multiQueryResult.setState(CompareReportStateEnum.BIZ_SQL_EXECUTE_FAIL.name());
                multiQueryResult.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25,traceId [%s],\u4e1a\u52a1SQL[%s],\u5f02\u5e38\u4fe1\u606f[%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)));
                MultiplexContext.sendMessage(multiQueryResult);
            }
        } else if (sqlInfo.isDml()) {
            MultiplexContext.doMultiBeforeQuery(connection, multiQueryResult, start, sqlInfo, multiFutures, sourceQuery);
            MultiQueryResultDTO multiQueryResultAfter = MultiQueryResultDTO.deepCopyFrom(multiQueryResult);
            try {
                multiQueryResultAfter.resetForAfterQuery(sqlInfo);
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                execute = delegate.execute();
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                if (syncData != null) {
                    MultiQueryResultDTO syncResult = MultiQueryResultDTO.deepCopyFrom(multiQueryResult);
                    MultiplexContext.doReturningDataSync(syncData, delegate, syncResult);
                    execute = false;
                }
                MultiplexContext.doMultiAfterQuery(connection, delegate, multiQueryResultAfter, start, sqlInfo, multiFutures, sourceQuery);
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u591a\u53d1\u6d88\u606f [{}] \u9519\u8bef\u4fe1\u606f [{}]", new Object[]{multiQueryResultAfter.getSourceDialect(), multiQueryResultAfter.getTargetDialect(), multiQueryResultAfter.getTraceId(), JsonUtils.toJson(multiQueryResultAfter), ExceptionUtils.getStackTrace((Throwable)e)});
                }
                if (e instanceof SQLException) {
                    exceptionOccur = (SQLException)e;
                    multiQueryResult.resetForAfterQuery(sqlInfo);
                }
                multiQueryResultAfter.setState(CompareReportStateEnum.BIZ_SQL_EXECUTE_FAIL.name());
                multiQueryResultAfter.addErrorReason(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25,traceId [%s],\u4e1a\u52a1SQL[%s],\u5f02\u5e38\u4fe1\u606f[%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)));
                MultiplexContext.sendMessage(multiQueryResultAfter);
            }
        } else {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5f00\u59cb\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
                execute = delegate.execute();
                if (log.isDebugEnabled()) {
                    log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u7ed3\u675f\uff0ctraceId [{}] \u4e1a\u52a1SQl [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql()});
                }
            }
            catch (SQLException e) {
                if (log.isErrorEnabled()) {
                    log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u4e1a\u52a1SQL\u6267\u884c\u5931\u8d25\uff0ctraceId [{}] \u591a\u53d1\u6d88\u606f [{}] \u9519\u8bef\u4fe1\u606f [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), JsonUtils.toJson(multiQueryResult), ExceptionUtils.getStackTrace((Throwable)e)});
                }
                exceptionOccur = e;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u591a\u53d1\u6e90\u7aef [{}] \u5230\u76ee\u6807 [{}] \u4e1a\u52a1SQL\u6267\u884c\u5b8c\u6210\uff0ctraceId [{}] \u6267\u884c\u987a\u5e8f [{}] \u4e1a\u52a1SQL [{}]", new Object[]{multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), multiQueryResult.getBizSqlSequence(), multiQueryResult.getBizBindVarReplacedSql()});
        }
        if (Objects.nonNull(exceptionOccur)) {
            throw new SQLException(String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u4e1a\u52a1SQL\u4e32\u884c\u6267\u884c\u5931\u8d25\uff0ctraceId [%s] \u591a\u53d1\u6d88\u606f [%s] \u9519\u8bef\u4fe1\u606f [%s]", multiQueryResult.getSourceDialect(), multiQueryResult.getTargetDialect(), multiQueryResult.getTraceId(), JsonUtils.toJson(multiQueryResult), ExceptionUtils.getStackTrace((Throwable)exceptionOccur)));
        }
        return execute;
    }

    private static void doReturningDataSync(SyncDataParamater syncData, Statement statement, MultiQueryResultDTO syncResult) {
        boolean gotData = MultiJdbcUtils.getReturingData(syncData, statement, syncResult.getBizSql(), syncResult);
        if (gotData) {
            MultiplexContext.sendSyncMessage(syncResult);
        }
    }

    private static void doMultiAfterQuery(Connection connection, Statement delegate, MultiQueryResultDTO multiQueryResult, long start, SqlInfo sqlInfo, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) throws SQLException {
        if (!MultiplexContext.sendMessageBeforeQuery(multiQueryResult)) {
            multiQueryResult.setBizSqlAffectedRows(delegate.getUpdateCount());
            MultiJdbcUtils.doPreparedQuery(connection, sqlInfo.getAfterSql(), multiQueryResult, multiFutures, sourceQuery);
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u540e\u67e5\u8be2\u6267\u884c\u6210\u529f traceId [{}] SQL [{}] \u8017\u65f6 [{}] \u5fae\u79d2 ", new Object[]{multiQueryResult.getTraceId(), sqlInfo.getAfterSql(), TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start)});
            }
        }
    }

    private static void doMultiBeforeQuery(Connection connection, MultiQueryResultDTO multiQueryResult, long start, SqlInfo sqlInfo, List<MultiCompletableFuture> multiFutures, Boolean sourceQuery) {
        if (!MultiplexContext.sendMessageBeforeQuery(multiQueryResult)) {
            multiQueryResult.setCompareKind(CompareKindEnum.BEFORE_QUERY.name());
            MultiJdbcUtils.doPreparedQuery(connection, sqlInfo.getBeforeSql(), multiQueryResult, multiFutures, sourceQuery);
            if (log.isDebugEnabled()) {
                log.debug("\u591a\u53d1\u524d\u67e5\u8be2\u6267\u884c\u6210\u529f traceId [{}] SQL [{}] \u8017\u65f6 [{}] \u5fae\u79d2 ", new Object[]{multiQueryResult.getTraceId(), sqlInfo.getBeforeSql(), TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start)});
            }
        }
    }

    private static boolean sendMessageBeforeQuery(MultiQueryResultDTO multiQueryResult) {
        if (StringUtils.isNotBlank((CharSequence)multiQueryResult.getErrorReason())) {
            MultiplexContext.sendMessage(multiQueryResult);
            return true;
        }
        return false;
    }

    public static boolean executePreparedMultiplex(Connection connection, PreparedStatement delegate, List<UnisqlPreparedStatement> delegateMulti, MultiQueryResultDTO multiQueryResult) throws SQLException {
        ArrayList<MultiCompletableFuture> multiFutures = new ArrayList<MultiCompletableFuture>();
        boolean execute = MultiplexContext.executePrepared(connection, delegate, multiQueryResult, multiFutures, true, null);
        String traceId = multiQueryResult.getTraceId();
        for (UnisqlPreparedStatement preparedStatement : delegateMulti) {
            String targetKey = preparedStatement.getSourceDialect().name() + "2" + preparedStatement.getTargetDialect().name() + ":\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c";
            ExecutorService pool = MultiplexContext.getOrCreateTargetPool(targetKey);
            CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5f00\u59cb\uff0ctraceId [{}] SQL [{}]", new Object[]{preparedStatement.getSourceDialect().name(), preparedStatement.getTargetDialect().name(), traceId, multiQueryResult.getBizSql()});
                    }
                    preparedStatement.execute(true, traceId);
                    if (log.isDebugEnabled()) {
                        log.debug("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u7ed3\u675f\uff0ctraceId [{}] SQL [{}]", new Object[]{preparedStatement.getSourceDialect().name(), preparedStatement.getTargetDialect().name(), traceId, multiQueryResult.getBizSql()});
                    }
                    return String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5b8c\u6210", preparedStatement.getSourceDialect().name(), preparedStatement.getTargetDialect().name());
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5931\u8d25 traceId [{}] SQL [{}]  \u5f02\u5e38\u4fe1\u606f [{}]", new Object[]{preparedStatement.getSourceDialect().name(), preparedStatement.getTargetDialect().name(), multiQueryResult.getTraceId(), multiQueryResult.getBizSql(), ExceptionUtils.getStackTrace((Throwable)e)});
                    }
                    return String.format("\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5931\u8d25", preparedStatement.getSourceDialect().name(), preparedStatement.getTargetDialect().name());
                }
            }, pool);
            MultiCompletableFuture multiCompletableFuture = new MultiCompletableFuture(targetKey, future);
            multiFutures.add(multiCompletableFuture);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb\u540c\u6b65\u7b49\u5f85\u6e90\u5e93\u7684\u67e5\u8be2\u7ed3\u679c\u96c6\u5f02\u6b65\u904d\u5386\u4ee5\u53ca\u76ee\u6807\u5e93\u7684\u5f02\u6b65\u6267\u884c\u662f\u5426\u90fd\u5904\u7406\u5b8c\u6bd5,traceId [{}] SQL [{}]", (Object)multiQueryResult.getTraceId(), (Object)multiQueryResult.getBizSql());
        }
        for (MultiCompletableFuture future : multiFutures) {
            try {
                if (future.getFuture() == null) continue;
                future.getFuture().get();
            }
            catch (Exception e) {
                log.error("[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5f02\u5e38: {}", (Object)future.getTargetKey(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u591a\u53d1\u6267\u884c\u5b8c\u6210,\u7b49\u5f85\u6bd4\u5bf9\u7ed3\u679c, traceId [{}] SQL [{}]", (Object)multiQueryResult.getTraceId(), (Object)multiQueryResult.getBizSql());
        }
        return execute;
    }

    public static void collectPreparedParameter(TreeMap<Integer, PreparedParameter> bindVariableMap, String methodName, int parameterIndex, Object paramValue, int sqlDataType) {
        if (Transformer.COLLECT_PARAMS || Transformer.SEND_MQ_TO_COMPARE_SERVER) {
            PreparedParameter preparedParameter = PreparedParameter.builder().methodName(methodName).parameterIndex(parameterIndex).x(paramValue).vendorTypeNumber(sqlDataType).build();
            bindVariableMap.put(parameterIndex, preparedParameter);
        }
    }

    public static String buildFullSql(String sql, List<PreparedParameter> preparedParameters, MultiQueryResultDTO queryResultDTO) {
        try {
            sql = MultiplexContext.dumpedSql(sql, MultiplexContext.convertToArgTrace(preparedParameters, queryResultDTO));
            log.debug("\u9884\u7f16\u8bd1SQL:[{}] \u9884\u7f16\u8bd1\u53c2\u6570:[{}] \u5177\u4f53SQL:[{}]", new Object[]{sql, JsonUtils.toJson(preparedParameters), sql});
        }
        catch (Exception e) {
            log.error("\u5c06\u9884\u7f16\u8bd1sql[{}]\u4e2d\u53c2\u6570\u66ff\u6362\u4e3a\u5177\u4f53\u53c2\u6570[{}]\u8fc7\u7a0b\u4e2d\u51fa\u9519", new Object[]{sql, JsonUtils.toJson(preparedParameters), e});
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String dumpedSql(String preCompiledSql, List<String> argTrace) {
        StringBuffer dumpSql = new StringBuffer();
        int lastPos = 0;
        int pos = preCompiledSql.indexOf(63, lastPos);
        int argIdx = 0;
        while (pos != -1) {
            String str;
            List<String> list = argTrace;
            synchronized (list) {
                try {
                    str = argTrace.get(argIdx);
                }
                catch (IndexOutOfBoundsException e) {
                    str = "?";
                }
            }
            if (str == null) {
                str = "?";
            }
            ++argIdx;
            dumpSql.append(preCompiledSql.substring(lastPos, pos));
            lastPos = pos + 1;
            pos = preCompiledSql.indexOf(63, lastPos);
            dumpSql.append(str);
        }
        if (lastPos < preCompiledSql.length()) {
            dumpSql.append(preCompiledSql.substring(lastPos, preCompiledSql.length()));
        }
        return dumpSql.toString();
    }

    private static List<String> convertToArgTrace(List<PreparedParameter> preparedParameters, MultiQueryResultDTO queryResultDTO) throws SQLException, IOException {
        ArrayList<String> argTrace = new ArrayList<String>();
        for (int i = 0; i < preparedParameters.size(); ++i) {
            argTrace.add(MultiplexContext.formatParameterObject(preparedParameters.get(i), queryResultDTO));
        }
        return argTrace;
    }

    static String formatParameterObject(PreparedParameter preparedParameter, MultiQueryResultDTO queryResultDTO) throws SQLException, IOException {
        int sqlDataType = preparedParameter.getVendorTypeNumber();
        return DbTypeSerializeUtil.serializeToString(sqlDataType, preparedParameter.getX(), queryResultDTO.getTargetDialect());
    }

    static String escapeString(String in) {
        StringBuilder out = new StringBuilder();
        int j = in.length();
        for (int i = 0; i < j; ++i) {
            char c = in.charAt(i);
            if (c == '\'') {
                out.append(c);
            }
            out.append(c);
        }
        return out.toString();
    }

    public static void sendMessage(MultiQueryResultDTO multiQueryResultDTO) {
        try {
            if (sendMessageMethod == null) {
                Class<?> clazz = Class.forName("com.hundsun.lightdb.unisql.utils.MessageUtil");
                sendMessageMethod = clazz.getMethod("sendMessage", String.class);
            }
            sendMessageMethod.invoke(null, JsonUtils.toJson(multiQueryResultDTO));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendSyncMessage(MultiQueryResultDTO multiQueryResultDTO) {
        try {
            String typeInsert = "INSERT";
            if (sendToUuidClientMethod == null) {
                Class<?> clazz = Class.forName("com.hundsun.lightdb.unisql.utils.UuidClientUtil");
                sendToUuidClientMethod = clazz.getMethod("sendMessage", String.class);
            }
            if (multiQueryResultDTO.getState() == null && "INSERT".equals(multiQueryResultDTO.getBizSqlOperationType())) {
                UuidClientRequest uuidRequest = new UuidClientRequest();
                uuidRequest.setTraceId(multiQueryResultDTO.getTraceId());
                uuidRequest.setBizSqlSequence(multiQueryResultDTO.getBizSqlSequence());
                uuidRequest.setBizSqlTableName(multiQueryResultDTO.getBizSqlTableName());
                uuidRequest.setMultiQueryResultSet(multiQueryResultDTO.getMultiQueryResultSet());
                uuidRequest.setBizSql(multiQueryResultDTO.getBizSql());
                uuidRequest.setBizBindVarReplacedSql(multiQueryResultDTO.getBizBindVarReplacedSql());
                uuidRequest.setTargetDialect(multiQueryResultDTO.getTargetDialect());
                uuidRequest.setSourceDialect(multiQueryResultDTO.getSourceDialect());
                sendToUuidClientMethod.invoke(null, JsonUtils.toJson(uuidRequest));
            }
        }
        catch (Exception e) {
            log.debug("\u5411 UUID \u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u591a\u53d1 INSERT \u573a\u666f\u4e0b\u53ef\u80fd\u4f1a\u5bfc\u81f4\u63d2\u5165\u8bb0\u5f55\u7684 ID \u4e0d\u540c\u3002\u5f02\u5e38\uff1a{}", (Object)e.toString());
        }
    }

    public static void tryInitUuidClient(String url, Properties jdbcProperties, Properties jdbcInfo) {
        String targetDialect;
        if (uuidClientInitialized) {
            return;
        }
        if (!MultiProperties.getSendCompareService()) {
            log.debug("MultiProperties.getSendCompareService \u672a\u5f00\u542f\u53d1\u9001\u6bd4\u5bf9\u670d\u52a1\uff0c\u8bf4\u660e\u4e0d\u662f\u591a\u53d1\u573a\u666f\uff0c\u4e0d\u521d\u59cb\u5316 UUID \u5ba2\u6237\u7aef\uff0c\u8bbe\u7f6e uuidClientInitialized=true \u4e0d\u518d\u521d\u59cb\u5316");
            uuidClientInitialized = true;
            return;
        }
        String sourceDialect = jdbcProperties.getProperty("sourceDialect");
        if (StringUtils.equals((CharSequence)sourceDialect, (CharSequence)(targetDialect = jdbcProperties.getProperty("targetDialect")))) {
            // empty if block
        }
        uuidClientInitialized = true;
    }

    static {
        VALIDATION_QUERIES.add("SELECT 1");
        VALIDATION_QUERIES.add("SELECT 1 FROM DUAL");
        reflectLogPrinted = false;
        listener = (key, value) -> log.info("\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664 traceId \u5bf9\u5e94\u7684SQL\u5e8f\u5217\u53f7\uff0ctraceId=" + key + ", \u5e8f\u5217\u53f7=" + value.get());
        traceId2SqlSequenceIdCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1000000L).listener(listener).build();
        TARGET_DIALECT_SERIAL_MAPPING = new HashMap<String, String>();
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.ORACLE.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.GAUSSDB_ORACLE.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.GAUSSDB500_ORACLE.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.DM.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.OCEAN_BASE_ORACLE.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.LIGHTDB_ORACLE.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.LIGHTDB_MYSQL.name(), DbType.ORACLE.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.MYSQL.name(), DbType.MYSQL.name());
        TARGET_DIALECT_SERIAL_MAPPING.put(DbType.OCEAN_BASE_MYSQL.name(), DbType.MYSQL.name());
    }

    private static class UuidClient {
        private static final Logger log = LoggerFactory.getLogger(UuidClient.class);
        private volatile Map<String, String> uuidColumnMap;
        private final DataSource sourceDatabaesDataSource;
        private final String configTableName;
        private final String configQuerySql;

        public UuidClient(DataSource sourceDatabaesDataSource, String configTableName) {
            this.sourceDatabaesDataSource = sourceDatabaesDataSource;
            this.configTableName = configTableName;
            this.configQuerySql = "select schema_name, table_name, uuid_column_name from " + configTableName;
            this.uuidColumnMap = null;
        }

        public void init() throws SQLException {
            this.updateTable();
        }

        public synchronized void updateTable() throws SQLException {
            int initialMapSize = 64;
            try (Connection connection = this.sourceDatabaesDataSource.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet resultSet = statement.executeQuery(this.configQuerySql);){
                HashMap<String, String> tempMap = new HashMap<String, String>(64);
                while (resultSet.next()) {
                    String schemaName = resultSet.getString("schema_name");
                    String tableName = resultSet.getString("table_name");
                    String uuidColumnName = resultSet.getString("uuid_column_name");
                    if (StringUtils.isEmpty((CharSequence)tableName) || StringUtils.isEmpty((CharSequence)uuidColumnName)) {
                        log.warn("Skipping record with empty tableName or uuidColumnName. schemaName: {}, tableName: {}, uuidColumnName: {}", new Object[]{schemaName, tableName, uuidColumnName});
                        continue;
                    }
                    String key = UuidClient.makeKey(schemaName, tableName);
                    tempMap.put(key, uuidColumnName);
                }
                this.uuidColumnMap = tempMap;
            }
        }

        public Optional<String> getUuidColumn(String schemaName, String tableName) {
            if (this.uuidColumnMap == null) {
                throw new IllegalStateException("UUID column map is not initialized. Please call updateTable() to update it.");
            }
            String mapKey = UuidClient.makeKey(schemaName, tableName);
            return Optional.ofNullable(this.uuidColumnMap.get(mapKey));
        }

        private static String makeKey(String schemaName, String tableName) {
            String delimiter = ":";
            if (StringUtils.isEmpty((CharSequence)schemaName)) {
                return ":" + tableName;
            }
            return schemaName + ":" + tableName;
        }
    }

    public static class TargetKeyThreadFactory
    implements ThreadFactory {
        private final String targetKey;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public TargetKeyThreadFactory(String targetKey) {
            this.targetKey = targetKey;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.targetKey + "-pool-thread-" + this.threadNumber.getAndIncrement());
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

