/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.model;

import com.hundsun.lightdb.unisql.constant.AppTypeEnum;
import com.hundsun.lightdb.unisql.model.ConnectionConfig;
import com.hundsun.lightdb.unisql.model.UnisqlProperties;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProperties {
    private static final Logger log;
    private static final MultiProperties INSTANCE;
    private static final String WORK_DIR = "user.dir";
    private static final Properties PROPERTIES;
    private static final String CONFIG = "config";
    private static final String MULTI_CONFIG_FILE_NAME = "jrescloud.properties";
    public static final String MULTI_CONFIG_PROPERTY_PREFIX = "multi.";
    private static final String UNISQL_MULTI_SENDCOMPARESERVICE = "multi.sendCompareService";
    private static final String UNISQL_MULTI_MICROSERVICES = "multi.collect.trace.info";
    private static final String UNISQL_MULTI_UPLOAD_MANUAL_URL = "multi.upload.manual.url";
    public static final String DEFAULT = "default";
    public static final int RUN_WHAT;
    public static final int AUTOTEST = 1;
    public static final int MULTIPLEX = 2;
    public static final int FOREVER_LOOP = 4;
    public static final String MULTIPLEX_RUN_WHAT = "multi.run.what";
    public static final String MULTIPLEX_AUTOTEST_SLEEP = "multi.autotest.sleep";
    public static final String MULTIPLEX_AUTOTEST_COMMANDTEMPLATE = "multi.autotest.commandtemplate";
    public static final int MULTIPLEX_AUTOTEST_SLEEP_DEFAULT = 1000;
    private static final String DEFAULT_EMPTY = "";
    private static final String MULTI_COMPARE_SERVICE_URL = "multi.compareServiceUrl";
    private static final String MULTI_PULSAR_SERVICE_URL = "multi.pulsarServiceUrl";
    private static final String MULTI_PULSAR_TOPIC_NAME = "multi.topicName";
    private static final String MULTI_PULSAR_SUBSCRIPTION_NAME = "multi.subscriptionName";
    private static final String MULTI_PULSAR_CONSUME_THREAD_COUNT = "multi.consumeThreadCount";
    private static final String MULTI_QUERY_RESULT_PUSH_URL = "multi.send.change.data.http.url";
    private static final String MULTI_DATASOURCE_SELF_MANAGE_CONFIG = "multi.datasourceSelfManage";
    public static Boolean MULTI_DATASOURCE_SELF_MANAGE;
    public static final String MULTI_APP_TYPE = "multi.appType";
    private static final String MULTI_USERNAME = "multi.username";
    private static final String MULTI_APP_NAME = "multi.appName";
    private static final String MULTI_TENANT_NAME = "multi.tenantName";
    private static final String MULTI_TARGET_THREAD_POOL_SIZE_NAME = "multi.targetThreadPoolSize";
    public static final int MULTI_TARGET_THREAD_POOL_SIZE;
    private static final String MULTI_TARGET_THREAD_POOL_QUEUE_SIZE_NAME = "multi.targetThreadPoolQueueSize";
    private static final int MULTI_TARGET_THREAD_POOL_QUEUE_SIZE_DEFAULT = 10;
    public static final int MULTI_TARGET_THREAD_POOL_QUEUE_SIZE;
    private static final String MULTI_RESULT_SET_SPILL_THRESHOLD = "multi.resultSetSpillThreshold";
    private static final String MULTI_RESULT_SET_SPILL_FILE_BASEDIR = "multi.resultSetSpillFileBasedir";
    private static final String MULTI_RESULT_SET_FETCH_LIMIT = "multi.resultSetFetchLimit";
    private static final String MULTI_UUID_SERVICE_PUSH_URL = "multi.uuidServiceUrl";
    private static final String MULTI_SYNCUUID_TABLECOLS = "multi.syncuuid.tablecols";
    public static boolean SEND_UKSYNC_SERVER;
    public static Map<String, List<String>> SEND_UKSYNC_TABLE_COLS;
    private static final String MULTI_METADATA_LOADCONFIG_KEY = "multi.metadata.loadconfig";
    private static final String MULTI_METADATA_LOADCONFIG_VALUE;
    public static final boolean AUTO_LOAD_CONFIG;
    private static final String MULTI_QUOTED_ORDER_BY_KEY_WORDS = "multi.quotedOrderByKeyWords";
    private static final String DEFAULT_KEYWORD_LIST = "select,from,where,group,having,order,limit,rownum,offset,insert,update,delete,merge,values,set,into,create,alter,drop,truncate,rename,comment,grant,revoke,flush,int,bigint,smallint,tinyint,float,double,decimal,varchar,char,date,time,timestamp,and,or,not,in,between,like,is,null,key,primary,foreign,unique,default,auto_increment,identity,begin,commit,rollback,savepoint,transaction,as,distinct,all,any,some,join,inner,left,right,full,on,using,case,when,then,else,end,engine,charset,collate,delayed,duplicate,mediumint,number,varchar2,clob,blob,sequence,trigger,sysdate,sys_guid,partition,nvarchar2,serial,bigserial,numeric,uuid,current_timestamp,tablespace,jsonb,extension,describe,explain,union,intersect,except,fetch,for,goto,if,loop,while,repeat,until,return,exception,raise,declare,cursor,open,close,lock,level,privileges,references,check,constraint,view,index,synonym,directory,profile,role,user,schema,database,instance,session,process,thread,deadlock,wait,timeout,prior,connect,by,path,node,xml,json,array,row,column,table,analyze,optimize,repair,checksum,load,infile,outfile,dumpfile,master,slave,replication,binlog,log,error,warning,note,ignore,force,use,asc,desc,natural,straight_join,sql,mode,delimiter,low_priority,high_priority,local,concurrent,locked,escape,regexp,rlike,character,names,global,variable,system,value,rows";

    private static String getProperty(String configName) {
        return PROPERTIES.getProperty(configName);
    }

    public static String getCompareServiceUrl() {
        return MultiProperties.getProperty(MULTI_COMPARE_SERVICE_URL);
    }

    public static String getQueryResultPushUrl() {
        return MultiProperties.getProperty(MULTI_QUERY_RESULT_PUSH_URL);
    }

    public static int getRunWhatInteger() {
        String runWhat = PROPERTIES.getProperty(MULTIPLEX_RUN_WHAT);
        if (StringUtils.isBlank((CharSequence)runWhat)) {
            return 0;
        }
        try {
            log.info("multi.run.what\u914d\u7f6e\u9879\u503c [{}]", (Object)runWhat);
            int runWhatInt = Integer.parseInt(runWhat);
            boolean runWhat0 = false;
            boolean runWhat1 = true;
            int runWhat2 = 2;
            int runWhat3 = 3;
            int runWhat5 = 5;
            if (runWhatInt != 0 && runWhatInt != 1 && runWhatInt != 2 && runWhatInt != 3 && runWhatInt != 5) {
                if (log.isErrorEnabled()) {
                    log.error("run_what\u7684\u53d6\u503c\u53ea\u80fd\u662f0,1,2,3,5\uff0c\u5f53\u524d\u503c\u4e3a\u3010{}\u3011\uff0c\u7a0b\u5e8f\u5373\u5c06\u9000\u51fa\uff01", (Object)runWhatInt);
                }
                Runtime.getRuntime().halt(1);
            }
            return runWhatInt;
        }
        catch (Exception e) {
            log.error("run_what\u7684\u53d6\u503c\u53ea\u80fd\u662f0,1,2,3,5\uff0c\u5f53\u524d\u503c\u4e3a\u3010{}\u3011\uff0c\u7a0b\u5e8f\u5373\u5c06\u9000\u51fa\uff01 {}", (Object)runWhat, (Object)e);
            Runtime.getRuntime().halt(1);
            return 0;
        }
    }

    public static boolean autoTest() {
        return (RUN_WHAT & 1) != 0;
    }

    public static boolean multiplex() {
        return (RUN_WHAT & 2) != 0;
    }

    public static boolean multLoop() {
        return (RUN_WHAT & 4) != 0;
    }

    public static long getMultiAutoSleepTime() {
        String autoTestSleep = PROPERTIES.getProperty(MULTIPLEX_AUTOTEST_SLEEP);
        if (StringUtils.isBlank((CharSequence)autoTestSleep)) {
            log.info("multi.autotest.sleep\u4f7f\u7528\u9ed8\u8ba4\u503c {}", (Object)1000);
            return 1000L;
        }
        try {
            log.info("multi.autotest.sleep\u914d\u7f6e\u9879\u503c [{}]", (Object)autoTestSleep);
            return Long.parseLong(autoTestSleep);
        }
        catch (NumberFormatException e) {
            log.error("multi.autotest.sleep\u914d\u7f6e\u9879\u503c\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
            log.info("multi.autotest.sleep\u4f7f\u7528\u9ed8\u8ba4\u503c {}", (Object)1000);
            return 1000L;
        }
    }

    public static boolean getSendCompareService() {
        String value = PROPERTIES.getProperty(UNISQL_MULTI_SENDCOMPARESERVICE);
        return UnisqlProperties.isOpen(value);
    }

    public static boolean realMultiplex() {
        String value = PROPERTIES.getProperty(UNISQL_MULTI_MICROSERVICES);
        return !UnisqlProperties.isOpen(value);
    }

    public static Boolean getMultiDatasourceSelfManage() {
        String multiDatasourceSelfManage = MultiProperties.getProperty(MULTI_DATASOURCE_SELF_MANAGE_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)multiDatasourceSelfManage)) {
            return Boolean.parseBoolean(multiDatasourceSelfManage);
        }
        return false;
    }

    public static String getManualUploadUrl() {
        return MultiProperties.getProperty(UNISQL_MULTI_UPLOAD_MANUAL_URL);
    }

    public static String getPulsarServiceUrl() {
        return MultiProperties.getProperty(MULTI_PULSAR_SERVICE_URL);
    }

    public static String getPulsarTopicName() {
        return MultiProperties.getProperty(MULTI_PULSAR_TOPIC_NAME);
    }

    public static int getPulsarConsumeThreadCount() {
        String consumeThreadCount = PROPERTIES.getProperty(MULTI_PULSAR_CONSUME_THREAD_COUNT);
        int count = StringUtils.isNumeric((CharSequence)consumeThreadCount) ? Integer.parseInt(consumeThreadCount) : Runtime.getRuntime().availableProcessors();
        return count;
    }

    public static int getMultiTargetThreadPoolSize() {
        String multiTargetThreadPoolSize = PROPERTIES.getProperty(MULTI_TARGET_THREAD_POOL_SIZE_NAME);
        int countDefault = Runtime.getRuntime().availableProcessors();
        if (StringUtils.isNumeric((CharSequence)multiTargetThreadPoolSize)) {
            int count = 0;
            try {
                count = Integer.parseInt(multiTargetThreadPoolSize);
            }
            catch (NumberFormatException e) {
                return countDefault;
            }
            if (count > 0) {
                return count;
            }
        }
        return countDefault;
    }

    public static int getMultiTargetThreadPoolQueueSize() {
        String multiTargetThreadPoolQueueSize = PROPERTIES.getProperty(MULTI_TARGET_THREAD_POOL_QUEUE_SIZE_NAME);
        if (StringUtils.isNumeric((CharSequence)multiTargetThreadPoolQueueSize)) {
            int count = 0;
            try {
                count = Integer.parseInt(multiTargetThreadPoolQueueSize);
            }
            catch (NumberFormatException e) {
                return 10;
            }
            if (count > 0) {
                return count;
            }
        }
        return 10;
    }

    public static String getMultiPulsarSubscriptionName() {
        return PROPERTIES.getProperty(MULTI_PULSAR_SUBSCRIPTION_NAME);
    }

    public static String getMultiAppName() {
        return PROPERTIES.getProperty(MULTI_APP_NAME, DEFAULT).trim();
    }

    public static String getMultiAppType() {
        String property = PROPERTIES.getProperty(MULTI_APP_TYPE, AppTypeEnum.OTHER.name()).trim();
        return AppTypeEnum.parse(property).name();
    }

    public static String getMultiUsername() {
        return PROPERTIES.getProperty(MULTI_USERNAME, DEFAULT).trim();
    }

    public static String getMultiTenantName() {
        return PROPERTIES.getProperty(MULTI_TENANT_NAME, DEFAULT).trim();
    }

    public static Map<String, String> getCommandTemplates() {
        HashMap<String, String> commandTemplateMap = new HashMap<String, String>(16);
        String prefix = "multi.autotest.commandtemplate.";
        Set<Object> keySet = PROPERTIES.keySet();
        for (Object keyObj : keySet) {
            String key = keyObj.toString();
            if (!key.startsWith(prefix)) continue;
            String templateKey = key.substring(prefix.length());
            String templateValue = PROPERTIES.getProperty(key);
            if (templateValue == null || templateValue.isEmpty()) continue;
            commandTemplateMap.put(templateKey, templateValue);
        }
        return commandTemplateMap;
    }

    public static int getMultiResultSetSpillThreshold() {
        return Integer.parseInt(PROPERTIES.getProperty(MULTI_RESULT_SET_SPILL_THRESHOLD, "1000"));
    }

    public static boolean isResultSetSpillThresholdEnabled() {
        return MultiProperties.getMultiResultSetSpillThreshold() > 0;
    }

    public static String getMultiResultSetSpillFileBasedir() {
        String defaultValue = System.getProperty("java.io.tmpdir");
        String value = PROPERTIES.getProperty(MULTI_RESULT_SET_SPILL_FILE_BASEDIR, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public static int getMultiResultSetFetchLimit() {
        return Integer.parseInt(PROPERTIES.getProperty(MULTI_RESULT_SET_FETCH_LIMIT, "1000"));
    }

    public static boolean isMultiResultSetFetchLimitEnabled() {
        return MultiProperties.getMultiResultSetFetchLimit() > 0;
    }

    private static void validateProperties() {
        try {
            MultiProperties.validateNumericProperty(MULTI_RESULT_SET_SPILL_THRESHOLD, "1000");
            MultiProperties.validateNumericProperty(MULTI_RESULT_SET_FETCH_LIMIT, "1000");
            MultiProperties.validateDirectoryProperty(MULTI_RESULT_SET_SPILL_FILE_BASEDIR, System.getProperty("java.io.tmpdir"));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("\u591a\u53d1 properties \u914d\u7f6e\u9879\u52a0\u8f7d\u5f02\u5e38: " + e.getMessage(), e);
        }
    }

    private static void validateNumericProperty(String propertyKey, String defaultValue) {
        String value = PROPERTIES.getProperty(propertyKey, defaultValue);
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\u914d\u7f6e\u9879 " + propertyKey + " \u7684\u503c\u4e0d\u662f\u6709\u6548\u7684\u6570\u5b57: " + value, e);
        }
    }

    private static void validateDirectoryProperty(String propertyKey, String defaultValue) {
        File dir;
        String dirPath = PROPERTIES.getProperty(propertyKey, defaultValue);
        if (StringUtils.isBlank((CharSequence)dirPath)) {
            dirPath = defaultValue;
        }
        if (!(dir = new File(dirPath)).exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55: " + dirPath + " \u914d\u7f6e\u9879: " + propertyKey);
        }
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IllegalArgumentException("\u914d\u7f6e\u9879 " + propertyKey + " \u6307\u5b9a\u7684\u76ee\u5f55\u65e0\u6cd5\u6b63\u5e38\u5199\u5165: " + dirPath);
        }
    }

    public static Set<String> getQuotedOrderByKeyWords() {
        String value = PROPERTIES.getProperty(MULTI_QUOTED_ORDER_BY_KEY_WORDS, null);
        Set<String> defaultKeywords = Arrays.stream(DEFAULT_KEYWORD_LIST.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Set append = Arrays.stream(value.split(",")).map(String::toLowerCase).collect(Collectors.toSet());
            defaultKeywords.addAll(append);
        }
        return defaultKeywords;
    }

    public static boolean isOrderByKeyWord(String columnLabel) {
        return MultiProperties.getQuotedOrderByKeyWords().contains(columnLabel);
    }

    private static String getUuidServicePushUrl() {
        String got = PROPERTIES.getProperty(MULTI_UUID_SERVICE_PUSH_URL);
        if (StringUtils.isBlank((CharSequence)got)) {
            return DEFAULT_EMPTY;
        }
        return got.trim();
    }

    private static Map<String, List<String>> getUkSyncTableCols() {
        String[] tableConfigs;
        HashMap<String, List<String>> tableColsMap = new HashMap<String, List<String>>(16);
        String propValue = PROPERTIES.getProperty(MULTI_SYNCUUID_TABLECOLS);
        if (propValue == null || propValue.trim().isEmpty()) {
            return tableColsMap;
        }
        for (String tableConfig : tableConfigs = propValue.split(";")) {
            String[] tableColumns = tableConfig.split(":");
            if (tableColumns.length != 2) continue;
            String tableName = tableColumns[0];
            List<String> columns = Arrays.asList(tableColumns[1].split(","));
            tableColsMap.put(tableName, columns);
        }
        return tableColsMap;
    }

    public static ConnectionConfig getMetaDataConnectConfig() {
        if (MULTI_METADATA_LOADCONFIG_VALUE == null || MULTI_METADATA_LOADCONFIG_VALUE.trim().isEmpty()) {
            return null;
        }
        return JsonUtils.fromJson(MULTI_METADATA_LOADCONFIG_VALUE);
    }

    static {
        block12: {
            log = LoggerFactory.getLogger(MultiProperties.class);
            INSTANCE = new MultiProperties();
            MULTI_DATASOURCE_SELF_MANAGE = false;
            String multiConfigDir = System.getProperty(WORK_DIR) + File.separator + CONFIG;
            String multiConfigPath = String.format(multiConfigDir + File.separator + "%s", MULTI_CONFIG_FILE_NAME);
            File multiConfigFile = new File(multiConfigPath);
            PROPERTIES = new Properties();
            if (multiConfigFile.exists()) {
                try (FileInputStream input = new FileInputStream(multiConfigFile);){
                    PROPERTIES.load(input);
                    if (log.isInfoEnabled()) {
                        log.info("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u52a0\u8f7d\u6210\u529f [{}]", (Object)multiConfigFile.getAbsolutePath());
                    }
                    break block12;
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u5931\u8d25 [{}]", (Object)e.getMessage());
                    }
                    break block12;
                }
            }
            if (log.isInfoEnabled()) {
                log.info("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230 [{}]", (Object)multiConfigFile.getAbsolutePath());
            }
        }
        for (Map.Entry<Object, Object> entry : PROPERTIES.entrySet()) {
            String propertyName = entry.getKey().toString();
            if (!propertyName.startsWith(MULTI_CONFIG_PROPERTY_PREFIX) || !log.isInfoEnabled()) continue;
            log.info("\u52a0\u8f7d\u591a\u53d1\u914d\u7f6e\u9879\uff0c\u914d\u7f6e\u9879\u540d\u79f0 [{}] \u914d\u7f6e\u9879\u7684\u503c [{}]", (Object)propertyName, entry.getValue());
        }
        RUN_WHAT = MultiProperties.getRunWhatInteger();
        MULTI_DATASOURCE_SELF_MANAGE = MultiProperties.getMultiDatasourceSelfManage();
        MULTI_TARGET_THREAD_POOL_SIZE = MultiProperties.getMultiTargetThreadPoolSize();
        MULTI_TARGET_THREAD_POOL_QUEUE_SIZE = MultiProperties.getMultiTargetThreadPoolQueueSize();
        SEND_UKSYNC_SERVER = StringUtils.isNotBlank((CharSequence)MultiProperties.getUuidServicePushUrl());
        SEND_UKSYNC_TABLE_COLS = MultiProperties.getUkSyncTableCols();
        MULTI_METADATA_LOADCONFIG_VALUE = MultiProperties.getProperty(MULTI_METADATA_LOADCONFIG_KEY);
        AUTO_LOAD_CONFIG = StringUtils.isNotBlank((CharSequence)MULTI_METADATA_LOADCONFIG_VALUE);
        MultiProperties.validateProperties();
    }
}

