/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import java.util.HashSet;
import java.util.Set;

public class SqlKeywordChecker {
    public static boolean isSqlHaveKeyword(String sql, Set<String> keywords) {
        boolean inSingleQuote = false;
        boolean inLineComment = false;
        StringBuilder currentToken = new StringBuilder();
        for (int i = 0; i < sql.length(); ++i) {
            char r = sql.charAt(i);
            if (inLineComment) {
                if (r != '\n') continue;
                inLineComment = false;
                continue;
            }
            if (r == '\'' && !inSingleQuote) {
                if (keywords.contains(currentToken.toString())) {
                    return true;
                }
                currentToken.setLength(0);
                inSingleQuote = true;
                continue;
            }
            if (r == '\'' && inSingleQuote) {
                inSingleQuote = false;
                continue;
            }
            if (!inSingleQuote && i + 1 < sql.length() && r == '-' && sql.charAt(i + 1) == '-') {
                if (keywords.contains(currentToken.toString())) {
                    return true;
                }
                currentToken.setLength(0);
                inLineComment = true;
                continue;
            }
            if (inSingleQuote) continue;
            if (Character.isLetterOrDigit(r) || r == '_') {
                currentToken.append(Character.toLowerCase(r));
                continue;
            }
            if (currentToken.length() > 0 && keywords.contains(currentToken.toString())) {
                return true;
            }
            currentToken.setLength(0);
        }
        return keywords.contains(currentToken.toString());
    }

    public static void main(String[] args) throws Exception {
        String sql = "SELECT * FROM wm_concat WHERE name = 'John' OR age > 30";
        HashSet<String> keywords = new HashSet<String>();
        keywords.add("wm_concat");
        if (!SqlKeywordChecker.isSqlHaveKeyword(sql, keywords)) {
            throw new Exception("\u6d4b\u8bd5\u7528\u4f8b\u5931\u8d25");
        }
        sql = "SELECT * FROM wm_concat1 WHERE name = 'John' OR age > 30";
        keywords = new HashSet();
        keywords.add("wm_concat");
        if (SqlKeywordChecker.isSqlHaveKeyword(sql, keywords)) {
            throw new Exception("\u6d4b\u8bd5\u7528\u4f8b\u5931\u8d25");
        }
        sql = "SELECT 'wm_concat' FROM t1 WHERE name = 'John' OR age > 30";
        keywords = new HashSet();
        keywords.add("wm_concat");
        if (SqlKeywordChecker.isSqlHaveKeyword(sql, keywords)) {
            throw new Exception("\u6d4b\u8bd5\u7528\u4f8b\u5931\u8d25");
        }
        sql = "-- wm_concat \nSELECT a FROM t1 WHERE name = 'John' OR age > 30";
        keywords = new HashSet();
        keywords.add("wm_concat");
        if (SqlKeywordChecker.isSqlHaveKeyword(sql, keywords)) {
            throw new Exception("\u6d4b\u8bd5\u7528\u4f8b\u5931\u8d25");
        }
        sql = "SELECT * FROM wm_concat WHERE name = 'John' OR age > 30";
        keywords = new HashSet();
        keywords.add("WM_CONCAT");
        if (!SqlKeywordChecker.isSqlHaveKeyword(sql, keywords)) {
            throw new Exception("\u6d4b\u8bd5\u7528\u4f8b\u5931\u8d25");
        }
        System.out.println("\u6d4b\u8bd5\u7528\u4f8b\u901a\u8fc7");
    }
}

