/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.golang;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.Decoder;
import com.hundsun.lightdb.unisql.golang.SqlState;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jnr.ffi.Pointer;

public class ReturnParameter
implements Serializable {
    private String sourceSql;
    private String targetSql;
    private String state;
    private String message;
    private String before;
    private String after;
    private Integer columnCountSum;
    private Integer autoIncrementColumnIndex;
    private List<Integer> bindVariableOrder;
    private String sqlType;
    private boolean dontCache;

    public static ReturnParameter decode(String utf8) {
        ReturnParameter returnParameter = new ReturnParameter();
        int currIndex = 0;
        String state = utf8.substring(currIndex, currIndex + 2);
        Integer stateLen = Integer.valueOf(state.trim());
        returnParameter.state = utf8.substring(currIndex += 2, currIndex + stateLen);
        String sql = utf8.substring(currIndex += stateLen.intValue(), currIndex + 8);
        currIndex += 8;
        Integer sqlLen = Integer.valueOf(sql.trim());
        if (sqlLen != 0) {
            returnParameter.targetSql = ReturnParameter.decodeUtf8(utf8.substring(currIndex, currIndex + sqlLen), returnParameter);
            currIndex += sqlLen.intValue();
        }
        String mesage = utf8.substring(currIndex, currIndex + 8);
        Integer messageLen = Integer.valueOf(mesage.trim());
        returnParameter.message = ReturnParameter.decodeUtf8(utf8.substring(currIndex += 8, currIndex + messageLen), returnParameter);
        String autoIncrementColumnIndex = utf8.substring(currIndex += messageLen.intValue(), currIndex + 2);
        returnParameter.autoIncrementColumnIndex = Integer.valueOf(autoIncrementColumnIndex.trim());
        String columnCountSum = utf8.substring(currIndex += 2, currIndex + 2);
        returnParameter.columnCountSum = Integer.valueOf(columnCountSum.trim());
        String before = utf8.substring(currIndex += 2, currIndex + 8);
        currIndex += 8;
        Integer beforeLen = Integer.valueOf(before.trim());
        if (beforeLen != 0) {
            returnParameter.before = ReturnParameter.decodeUtf8(utf8.substring(currIndex, currIndex + beforeLen), returnParameter);
            currIndex += beforeLen.intValue();
        }
        String after = utf8.substring(currIndex, currIndex + 8);
        currIndex += 8;
        Integer afterLen = Integer.valueOf(after.trim());
        if (afterLen != 0) {
            returnParameter.after = ReturnParameter.decodeUtf8(utf8.substring(currIndex, currIndex + afterLen), returnParameter);
            currIndex += afterLen.intValue();
        }
        String sqlTypeLen = utf8.substring(currIndex, currIndex + 2);
        currIndex += 2;
        Integer sqlTypeLenOffset = Integer.valueOf(sqlTypeLen.trim());
        if (sqlTypeLenOffset != 0) {
            returnParameter.sqlType = ReturnParameter.decodeUtf8(utf8.substring(currIndex, currIndex + sqlTypeLenOffset), returnParameter);
            currIndex += sqlTypeLenOffset.intValue();
        }
        if (currIndex < utf8.length()) {
            String bindVariableOrder = utf8.substring(currIndex, currIndex + 8);
            Integer bindVariableOrderLen = Integer.valueOf(bindVariableOrder.trim());
            String bindVariables = utf8.substring(currIndex += 8, currIndex + bindVariableOrderLen);
            ArrayList<Integer> bindVariableOrderList = new ArrayList<Integer>();
            for (String order : bindVariables.split(",")) {
                bindVariableOrderList.add(Integer.valueOf(order));
            }
            returnParameter.setBindVariableOrder(bindVariableOrderList);
        }
        return returnParameter;
    }

    private static String decodeUtf8(String text, ReturnParameter returnParameter) {
        try {
            return URLDecoder.decode(text, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            returnParameter.state = SqlState.CONVERT_ERROR.getState();
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReturnParameter that = (ReturnParameter)o;
        return Objects.equals(this.targetSql, that.targetSql) && Objects.equals(this.state, that.state) && Objects.equals(this.message, that.message) && Objects.equals(this.before, that.before) && Objects.equals(this.after, that.after) && Objects.equals(this.columnCountSum, that.columnCountSum) && Objects.equals(this.autoIncrementColumnIndex, that.autoIncrementColumnIndex) && Objects.equals(this.bindVariableOrder, that.bindVariableOrder);
    }

    public int hashCode() {
        return Objects.hash(this.targetSql, this.state, this.message, this.before, this.after, this.columnCountSum, this.autoIncrementColumnIndex, this.bindVariableOrder);
    }

    public static ReturnParameter decode(Pointer pointer) throws Exception {
        byte[] bytes = new byte[8];
        pointer.get(0L, bytes, 0, 8);
        Decoder decoder = new Decoder(bytes);
        int version = decoder.readIntValue();
        int length = decoder.readIntValue();
        if (version != 250201) {
            System.err.printf("version not match: got %d, expected %d%n", version, 250201);
            throw new IllegalStateException(ErrorMessages.format(ErrorMessages.LTU0006, version));
        }
        byte[] data = new byte[length];
        pointer.get(0L, data, 0, length);
        return ReturnParameter.decode(data);
    }

    public static ReturnParameter decode(byte[] data) throws Exception {
        Decoder decoder = new Decoder(data);
        int version = decoder.readIntValue();
        if (version != 250201) {
            throw new Exception("go runtime version is not match: got" + version + ", expected " + 250201);
        }
        int length = decoder.readIntValue();
        if (data.length != length) {
            throw new Exception("go runtime data length is not match: got" + data.length + ", expected " + length);
        }
        ReturnParameter returnParameter = new ReturnParameter();
        returnParameter.state = decoder.readString();
        returnParameter.targetSql = decoder.readString();
        returnParameter.message = decoder.readString();
        returnParameter.autoIncrementColumnIndex = decoder.readInt();
        returnParameter.columnCountSum = decoder.readInt();
        returnParameter.before = decoder.readString();
        returnParameter.after = decoder.readString();
        returnParameter.sqlType = decoder.readString();
        List<Integer> bindVariables = decoder.readIntArray();
        returnParameter.setBindVariableOrder(bindVariables);
        returnParameter.dontCache = decoder.readBool();
        return returnParameter;
    }

    public String getSourceSql() {
        return this.sourceSql;
    }

    public String getTargetSql() {
        return this.targetSql;
    }

    public String getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }

    public Integer getColumnCountSum() {
        return this.columnCountSum;
    }

    public Integer getAutoIncrementColumnIndex() {
        return this.autoIncrementColumnIndex;
    }

    public List<Integer> getBindVariableOrder() {
        return this.bindVariableOrder;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public boolean isDontCache() {
        return this.dontCache;
    }

    public void setSourceSql(String sourceSql) {
        this.sourceSql = sourceSql;
    }

    public void setTargetSql(String targetSql) {
        this.targetSql = targetSql;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public void setColumnCountSum(Integer columnCountSum) {
        this.columnCountSum = columnCountSum;
    }

    public void setAutoIncrementColumnIndex(Integer autoIncrementColumnIndex) {
        this.autoIncrementColumnIndex = autoIncrementColumnIndex;
    }

    public void setBindVariableOrder(List<Integer> bindVariableOrder) {
        this.bindVariableOrder = bindVariableOrder;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setDontCache(boolean dontCache) {
        this.dontCache = dontCache;
    }

    public String toString() {
        return "ReturnParameter(sourceSql=" + this.getSourceSql() + ", targetSql=" + this.getTargetSql() + ", state=" + this.getState() + ", message=" + this.getMessage() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + ", columnCountSum=" + this.getColumnCountSum() + ", autoIncrementColumnIndex=" + this.getAutoIncrementColumnIndex() + ", bindVariableOrder=" + this.getBindVariableOrder() + ", sqlType=" + this.getSqlType() + ", dontCache=" + this.isDontCache() + ")";
    }
}

