/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.unisql.constant;

import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import org.apache.commons.lang3.StringUtils;

public enum CompareReportStateEnum {
    SUCCESS(ErrorMessages.COMPARE_RESULT_SUCCESS.getCode(), "\u6210\u529f"),
    UNISQL_PARSE_FAIL(ErrorMessages.COMPARE_UNISQL_PARSE_FAIL.getCode(), ErrorMessages.COMPARE_UNISQL_PARSE_FAIL.getMsg()),
    DML2DQL_PARSE_FAIL(ErrorMessages.COMPARE_DML2DQL_PARSE_FAIL.getCode(), ErrorMessages.COMPARE_DML2DQL_PARSE_FAIL.getMsg()),
    BIZ_SQL_EXECUTE_FAIL(ErrorMessages.COMPARE_BIZ_SQL_EXECUTE_FAIL.getCode(), ErrorMessages.COMPARE_BIZ_SQL_EXECUTE_FAIL.getMsg()),
    MULTI_QUERY_FAIL(ErrorMessages.COMPARE_MULTI_QUERY_FAIL.getCode(), ErrorMessages.COMPARE_MULTI_QUERY_FAIL.getMsg()),
    MULTI_QUERY_RESULT_TRANSFER_FAIL(ErrorMessages.COMPARE_QUERY_RESULT_SPILL_FILE_IO_ERROR.getCode(), ErrorMessages.COMPARE_QUERY_RESULT_SPILL_FILE_IO_ERROR.getMsg()),
    COLUMN_COUNT_DIFF(ErrorMessages.COMPARE_COLUMN_COUNT_DIFF.getCode(), ErrorMessages.COMPARE_COLUMN_COUNT_DIFF.getMsg()),
    COLUMN_USE_IGNORE_RULE(ErrorMessages.COMPARE_COLUMN_USE_IGNORE_RULE.getCode(), ErrorMessages.COMPARE_COLUMN_USE_IGNORE_RULE.getMsg()),
    COMPARE_FAIL(ErrorMessages.COMPARE_RESULT_DIFF_ERROR.getCode(), "\u6bd4\u5bf9\u5931\u8d25"),
    COMPARE_FILTER(ErrorMessages.COMPARE_FILTER.getCode(), ErrorMessages.COMPARE_FILTER.getMsg()),
    COMPARE_NOTSUPPORT(ErrorMessages.COMPARE_NOTSUPPORT.getCode(), ErrorMessages.COMPARE_NOTSUPPORT.getMsg());

    private final int code;
    private final String msg;

    public int getCode() {
        return this.code;
    }

    private CompareReportStateEnum(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static boolean isSuccess(String state) {
        return SUCCESS.name().equals(state) || COLUMN_USE_IGNORE_RULE.name().equals(state);
    }

    public static boolean isFailed(String state) {
        return StringUtils.isNotBlank((CharSequence)state) && !CompareReportStateEnum.isSuccess(state);
    }

    public String getMsg() {
        return this.msg;
    }

    public String buildErrorReason(String errorMsg) {
        return this.getMsg() + " " + errorMsg;
    }

    public static CompareReportStateEnum parse(String state) {
        for (CompareReportStateEnum value : CompareReportStateEnum.values()) {
            if (!value.name().equals(state)) continue;
            return value;
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u6bd4\u5bf9\u62a5\u544a\u72b6\u6001,state: " + state);
    }
}

