#!/bin/bash

# 应用名称
APP_NAME="uk_agent"
APP_NAME_RUN="uk_agent-*.jar"

# 远程调试配置（默认不启用，如需启用将DEBUG_MODE设为true）
DEBUG_MODE=false
DEBUG_PORT=15005

# JVM参数配置
JVM_OPTS="-Xms512m -Xmx1024m -XX:+UseG1GC"

# 如果启用调试模式，添加调试参数
if [ "$DEBUG_MODE" = true ]; then
  # Java 9及以上版本使用此行
  JVM_OPTS="$JVM_OPTS -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:$DEBUG_PORT"
  
  # 如果是Java 8及以下版本，使用此行（注释上面一行，启用下面一行）
  # JVM_OPTS="$JVM_OPTS -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=$DEBUG_PORT"
  
  echo "已启用远程调试，端口: $DEBUG_PORT"
fi

# 启动命令
echo "启动 $APP_NAME ..."
nohup java $JVM_OPTS -jar $APP_NAME_RUN > /dev/null 2>&1 &

