#!/bin/bash

# 脚本名称常量定义
# ${MULTIPLEX_DEPLOY_PATH} 替换为真实绝对路径
SCRIPT_NAME=$(basename "$0")
TARGET_SCRIPT_PATH=${MULTIPLEX_DEPLOY_PATH}
SCRIPT_DIR=$(dirname "${TARGET_SCRIPT_PATH}")

# 检查 TARGET_SCRIPT_PATH 是否为空
# 提前检查的原因是为了避免未配置好造成SEE那边部署失败
if [[ -z "${TARGET_SCRIPT_PATH}" ]]; then
    exit 0
fi

# ==================== 函数定义 ====================
log_info() {
   echo -e "[INFO] $1"
}

# 帮助信息函数
show_help() {
    cat << EOF
用法: $SCRIPT_NAME <workspace>
或:   $SCRIPT_NAME -h|--help

功能: 根据当前操作系统架构，调用同级目录的对应一键部署
      自动检测架构并调用:
      - x86_64 架构 → $X86_SCRIPT
      - aarch64 架构 → $AARCH_SCRIPT

参数说明:
  <workspace>      指定服务名称（必选参数）
  -h, --help       显示帮助信息

示例:
  $SCRIPT_NAME /opt/install/my_service
EOF
}

# ==================== 参数解析 ====================
# 处理帮助参数
if [[ $# -eq 1 && ($1 == "-h" || $1 == "--help") ]]; then
    show_help
    exit 0
fi

# 校验必选参数（仅需传递 workspace，无需前缀）
if [[ $# -ne 1 ]]; then
    log_info "参数错误！正确用法：$SCRIPT_NAME <workspace>，使用 -h/--help 查看详情"
fi

workspace="$1"

# ==================== 脚本存在性校验 ====================
if [[ ! -f "$TARGET_SCRIPT_PATH" ]]; then
    log_info "目标脚本不存在: $TARGET_SCRIPT_PATH"
    exit 0
fi

if [[ ! -x "$TARGET_SCRIPT_PATH" ]]; then
    log_info "目标脚本无执行权限: $TARGET_SCRIPT_PATH，请执行 chmod +x $TARGET_SCRIPT_PATH"
    exit 0
fi

# ==================== 执行目标脚本 ====================
log_info "执行 $TARGET_SCRIPT_PATH -service_name=$workspace" --silence
cd ${SCRIPT_DIR}
log_filename="install-$(id -u)-$(date '+%Y-%m-%d-%H-%M-%S').log"
"$TARGET_SCRIPT_PATH" -service_name="$workspace" --silence > ${log_filename} 2>&1

echo 0