/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.sync;

import com.hundsun.lightdb.ukagent.config.DataSourceProperties;
import com.hundsun.lightdb.ukagent.dto.SyncDataFromSourceRequest;
import com.hundsun.lightdb.ukagent.sync.SingleTableSyncer;
import com.hundsun.lightdb.ukagent.sync.SyncContext;
import com.hundsun.lightdb.ukagent.sync.SyncSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SyncDataManager {
    private Logger log = LoggerFactory.getLogger(SyncDataManager.class);
    private final Map<SyncContext.SyncContextKey, SyncContext> syncContextMap = new ConcurrentHashMap();
    private final BlockingQueue<SyncContext> dispatchQueue = new LinkedBlockingQueue();
    private final BlockingQueue<SyncContext> cleanQueue = new LinkedBlockingQueue();
    private Executor syncExecute;
    private static final long WAIT_TIMEOUT = 10000L;
    private final List<String> targetDialectList;
    private final SyncSelector syncSelector;
    ThreadFactory daemonDataSyncDispatchThreadFactory = runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("datasync-dispatch");
        thread.setDaemon(true);
        return thread;
    };
    ThreadFactory daemonContextCleanThreadFactory = runnable -> {
        Thread thread = Executors.defaultThreadFactory().newThread(runnable);
        thread.setName("context-clean");
        thread.setDaemon(true);
        return thread;
    };
    private static boolean initFlag;
    ScheduledExecutorService dispatchScheduler = Executors.newScheduledThreadPool(1, this.daemonDataSyncDispatchThreadFactory);
    ScheduledExecutorService cleanScheduler = Executors.newScheduledThreadPool(1, this.daemonContextCleanThreadFactory);

    public SyncDataManager(DataSourceProperties dataSourceProperties, SyncSelector syncSelector) {
        this.targetDialectList = new ArrayList();
        for (DataSourceProperties.DbConfig dbConfig : dataSourceProperties.getSources()) {
            this.targetDialectList.add(StringUtils.lowerCase((String)dbConfig.getName()));
        }
        this.syncSelector = syncSelector;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (initFlag) return;
        Class<SyncDataManager> clazz = SyncDataManager.class;
        synchronized (SyncDataManager.class) {
            if (initFlag) return;
            initFlag = true;
            this.syncExecute = this.createExecutor();
            this.startDispatchScheduler();
            this.startCleanScheduler();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void handleSyncRequest(SyncDataFromSourceRequest syncDataFromSourceRequest) {
        if (StringUtils.equals((CharSequence)syncDataFromSourceRequest.getSourceDialect(), (CharSequence)syncDataFromSourceRequest.getTargetDialect())) {
            this.handleSourceSyncRequest(syncDataFromSourceRequest);
        } else {
            this.handleTargetSyncRequest(syncDataFromSourceRequest);
        }
    }

    private void handleTargetSyncRequest(SyncDataFromSourceRequest syncDataFromSourceRequest) {
        SyncContext.SyncContextKey syncContextKey = new SyncContext.SyncContextKey();
        syncContextKey.setTraceId(syncDataFromSourceRequest.getTraceId());
        syncContextKey.setBizSqlSchemaName(syncDataFromSourceRequest.getBizSqlSchemaName());
        syncContextKey.setBizSqlTableName(syncDataFromSourceRequest.getBizSqlTableName());
        syncContextKey.setSourceDialect(syncDataFromSourceRequest.getSourceDialect().toUpperCase());
        syncContextKey.setTargetDialect(syncDataFromSourceRequest.getTargetDialect().toUpperCase());
        SyncContext syncContext = this.getSyncContextKeyAndOfferTask(syncContextKey);
        SyncContext.SyncContextEntity targetEntity = new SyncContext.SyncContextEntity();
        targetEntity.setColumnNames(syncDataFromSourceRequest.getColumnNames());
        targetEntity.setColumnValues(syncDataFromSourceRequest.getColumnValues());
        syncContext.addTargetEntity(targetEntity);
    }

    private void handleSourceSyncRequest(SyncDataFromSourceRequest syncDataFromSourceRequest) {
        for (String targetDialect : this.targetDialectList) {
            SyncContext.SyncContextKey syncContextKey = new SyncContext.SyncContextKey();
            syncContextKey.setTraceId(syncDataFromSourceRequest.getTraceId());
            syncContextKey.setBizSqlSchemaName(syncDataFromSourceRequest.getBizSqlSchemaName());
            syncContextKey.setBizSqlTableName(syncDataFromSourceRequest.getBizSqlTableName());
            syncContextKey.setSourceDialect(syncDataFromSourceRequest.getSourceDialect().toUpperCase());
            syncContextKey.setTargetDialect(targetDialect.toUpperCase());
            SyncContext syncContext = this.getSyncContextKeyAndOfferTask(syncContextKey);
            SyncContext.SyncContextEntity targetEntity = new SyncContext.SyncContextEntity();
            targetEntity.setColumnNames(syncDataFromSourceRequest.getColumnNames());
            targetEntity.setColumnValues(syncDataFromSourceRequest.getColumnValues());
            syncContext.addSourceEntity(targetEntity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncContext getSyncContextKeyAndOfferTask(SyncContext.SyncContextKey syncContextKey) {
        SyncContext syncContext = (SyncContext)this.syncContextMap.get(syncContextKey);
        if (syncContext == null) {
            SyncDataManager syncDataManager = this;
            synchronized (syncDataManager) {
                syncContext = (SyncContext)this.syncContextMap.get(syncContextKey);
                if (syncContext == null) {
                    syncContext = new SyncContext(syncContextKey);
                    this.syncContextMap.put(syncContextKey, syncContext);
                    this.cleanQueue.offer(syncContext);
                    this.dispatchQueue.offer(syncContext);
                }
            }
        }
        return syncContext;
    }

    private void startDispatchScheduler() {
        Runnable task = () -> {
            try {
                this.doDispatch();
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        };
        this.dispatchScheduler.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.SECONDS);
        this.log.info("\u542f\u52a8\u540c\u6b65\u5206\u53d1\u7ebf\u7a0b\u5b8c\u6210");
    }

    private void doDispatch() {
        SyncContext syncContext;
        long currentTime = System.currentTimeMillis();
        while (!this.dispatchQueue.isEmpty() && this.isTimeOut(currentTime, syncContext = (SyncContext)this.dispatchQueue.peek())) {
            this.dispatchQueue.poll();
            this.log.info("\u5f00\u59cb\u540c\u6b65\u6e90\u6570\u636eKEY: {}", (Object)syncContext.getKey().toString());
            this.cleanContext(syncContext);
            this.doDataSync(syncContext);
        }
    }

    private void doDataSync(SyncContext syncContext) {
        this.syncExecute.execute(() -> {
            try {
                SingleTableSyncer syncer = this.syncSelector.select(syncContext);
                syncer.doSync(syncContext);
            }
            catch (Exception e) {
                this.log.error("\u540c\u6b65\u5f02\u5e38\uff0c\u4e0a\u4e0b\u6587\uff1a{}", (Object)syncContext, (Object)e);
            }
        });
    }

    private void startCleanScheduler() {
        Runnable task = () -> {
            try {
                this.doClean();
            }
            catch (Exception e) {
                Thread.currentThread().interrupt();
            }
        };
        this.cleanScheduler.scheduleAtFixedRate(task, 0L, 1L, TimeUnit.SECONDS);
        this.log.info("\u542f\u52a8\u540c\u6b65\u6e05\u7406\u7ebf\u7a0b\u5b8c\u6210");
    }

    private void doClean() {
        SyncContext syncContext;
        long currentTime = System.currentTimeMillis();
        while (!this.cleanQueue.isEmpty() && this.isTimeOut(currentTime, syncContext = (SyncContext)this.cleanQueue.peek())) {
            this.cleanQueue.poll();
            this.cleanContext(syncContext);
        }
    }

    private void cleanContext(SyncContext syncContext) {
        this.syncContextMap.remove(syncContext.getKey());
    }

    public boolean isTimeOut(long currentTime, SyncContext syncContext) {
        return currentTime - syncContext.getCreateTime() > 10000L;
    }

    public Executor createExecutor() {
        return new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    }
}

