/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.sync;

import com.hundsun.lightdb.ukagent.executor.MultiDataSourceExecutor;
import com.hundsun.lightdb.ukagent.sync.AbstractTableSyncer;
import com.hundsun.lightdb.ukagent.sync.SyncContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class OrderMatchTableSyncer
extends AbstractTableSyncer {
    public static final String ORDER_MATCH_TABLE_SYNCER = "OrderMatchTableSyncer";

    public OrderMatchTableSyncer(MultiDataSourceExecutor executor) {
        super(executor);
    }

    protected List<SyncContext.SyncExecuteInfo> getSyncExecuteInfos(SyncContext context) {
        ArrayList<SyncContext.SyncExecuteInfo> syncExecuteInfoList = new ArrayList<SyncContext.SyncExecuteInfo>();
        for (int i = 0; i < context.getSourceEntitys().size(); ++i) {
            SyncContext.SyncContextEntity sourceEntity = (SyncContext.SyncContextEntity)context.getSourceEntitys().get(i);
            SyncContext.SyncContextEntity targetEntity = (SyncContext.SyncContextEntity)context.getTargetEntitys().get(i);
            ArrayList bindParams = new ArrayList();
            String sql = this.getSyncUuidSql(context, sourceEntity, targetEntity, bindParams);
            SyncContext.SyncExecuteInfo syncExecuteInfo = new SyncContext.SyncExecuteInfo(context.getKey().getTargetDialect(), sql, bindParams, sourceEntity);
            syncExecuteInfoList.add(syncExecuteInfo);
        }
        return syncExecuteInfoList;
    }

    protected String getSyncerName() {
        return ORDER_MATCH_TABLE_SYNCER;
    }

    public Integer order(SyncContext context) {
        return 1;
    }

    public Boolean accept(SyncContext context) {
        return context.getSourceEntitys().size() == context.getTargetEntitys().size();
    }

    private String getSyncUuidSql(SyncContext context, SyncContext.SyncContextEntity sourceEntity, SyncContext.SyncContextEntity targetEntity, List<String> params) {
        List newValues = sourceEntity.getColumnValues();
        List currentValues = targetEntity.getColumnValues();
        StringBuilder sb = new StringBuilder();
        StringBuilder setBuffer = new StringBuilder();
        StringBuilder whereBuffer = new StringBuilder();
        for (String columnName : sourceEntity.getColumnNames()) {
            if (setBuffer.length() == 0) {
                setBuffer.append(String.format("%s = ? ", columnName));
            } else {
                setBuffer.append(String.format(",%s = ? ", columnName));
            }
            if (whereBuffer.length() == 0) {
                whereBuffer.append(String.format("%s = ? ", columnName));
                continue;
            }
            whereBuffer.append(String.format("and %s = ? ", columnName));
        }
        params.addAll(newValues);
        params.addAll(currentValues);
        sb.append("UPDATE ");
        sb.append(this.targetTable(context.getKey().getBizSqlSchemaName(), context.getKey().getBizSqlTableName()));
        sb.append(" SET ");
        sb.append((CharSequence)setBuffer);
        sb.append(" WHERE ");
        sb.append((CharSequence)whereBuffer);
        return sb.toString();
    }
}

