/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.sync;

import com.hundsun.lightdb.ukagent.bean.DbType;
import com.hundsun.lightdb.ukagent.executor.MultiDataSourceExecutor;
import com.hundsun.lightdb.ukagent.sync.AbstractTableSyncer;
import com.hundsun.lightdb.ukagent.sync.SyncContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.stereotype.Component;

@Component
public class BaseTableSyncer
extends AbstractTableSyncer {
    public static final String BASE_TABLE_SYNCER = "BaseTableSyncer";
    private final ReentrantLock reentrantLock = new ReentrantLock();

    public BaseTableSyncer(MultiDataSourceExecutor executor) {
        super(executor);
    }

    protected List<SyncContext.SyncExecuteInfo> getSyncExecuteInfos(SyncContext context) {
        ArrayList<SyncContext.SyncExecuteInfo> syncExecuteInfoList = new ArrayList<SyncContext.SyncExecuteInfo>();
        for (SyncContext.SyncContextEntity sourceEntity : context.getSourceEntitys()) {
            ArrayList bindParams = new ArrayList();
            String sql = this.getSyncDataSql(context, sourceEntity, bindParams);
            SyncContext.SyncExecuteInfo syncExecuteInfo = new SyncContext.SyncExecuteInfo(context.getKey().getTargetDialect(), sql, bindParams, sourceEntity);
            syncExecuteInfoList.add(syncExecuteInfo);
        }
        return syncExecuteInfoList;
    }

    protected String getSyncerName() {
        return BASE_TABLE_SYNCER;
    }

    public Integer order(SyncContext context) {
        return 0;
    }

    public Boolean accept(SyncContext context) {
        return true;
    }

    protected void lock(SyncContext context) {
        this.reentrantLock.lock();
    }

    protected void unlock(SyncContext context) {
        this.reentrantLock.unlock();
    }

    private String getSyncDataSql(SyncContext context, SyncContext.SyncContextEntity sourceEntity, List<String> params) {
        String schema = context.getKey().getBizSqlSchemaName();
        String table = context.getKey().getBizSqlTableName();
        String targetTable = this.targetTable(schema, table);
        List columns = sourceEntity.getColumnNames();
        List values = sourceEntity.getColumnValues();
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                setClause.append(", ");
            }
            setClause.append((String)columns.get(i)).append(" = ?");
            params.add((String)values.get(i));
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ").append(targetTable).append(" SET ").append((CharSequence)setClause).append(" WHERE NOT EXISTS (SELECT sync_key FROM multi_sync_data_logs WHERE");
        if (schema != null && !schema.trim().isEmpty()) {
            sqlBuilder.append(" schema_name = ").append("?").append(" AND");
            params.add(schema);
        }
        sqlBuilder.append(" table_name = ").append("?").append(" AND sync_key = ").append(this.syncKeyName(sourceEntity)).append(")");
        params.add(table);
        if (DbType.LIGHTDB_MYSQL.name().equalsIgnoreCase(context.getKey().getTargetDialect()) || DbType.OCEAN_BASE_MYSQL.name().equalsIgnoreCase(context.getKey().getTargetDialect())) {
            sqlBuilder.append("limit 1");
        }
        return sqlBuilder.toString();
    }
}

