/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.sync;

import com.hundsun.lightdb.ukagent.bean.MutilSqlResult;
import com.hundsun.lightdb.ukagent.bean.MutilSyncKey;
import com.hundsun.lightdb.ukagent.bean.SqlResult;
import com.hundsun.lightdb.ukagent.executor.MultiDataSourceExecutor;
import com.hundsun.lightdb.ukagent.sync.SingleTableSyncer;
import com.hundsun.lightdb.ukagent.sync.SyncContext;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTableSyncer
implements SingleTableSyncer {
    private final Logger log = LoggerFactory.getLogger(AbstractTableSyncer.class);
    private final MultiDataSourceExecutor executor;

    public AbstractTableSyncer(MultiDataSourceExecutor executor) {
        this.executor = executor;
    }

    public final String getTableName(SyncContext context) {
        return this.targetTable(context.getKey().getBizSqlSchemaName(), context.getKey().getBizSqlTableName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doSync(SyncContext context) throws Exception {
        if (context.getSourceEntitys().isEmpty()) {
            this.log.warn("\u6e90\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u540c\u6b65\uff0c \u4e0a\u4e0b\u6587\u5185\u5bb9\uff1a{}", (Object)context.toString());
            return;
        }
        try {
            this.lock(context);
            List syncExecuteInfos = this.getSyncExecuteInfos(context);
            int sqlNo = 0;
            ArrayList<SqlResult> sqlResultList = new ArrayList<SqlResult>();
            MutilSqlResult multiSqlResult = new MutilSqlResult(sqlResultList);
            if (syncExecuteInfos != null) {
                for (SyncContext.SyncExecuteInfo syncInfo : syncExecuteInfos) {
                    MutilSyncKey key = new MutilSyncKey(context.getKey().getTraceId(), context.getKey().getBizSqlSchemaName(), context.getKey().getBizSqlTableName(), Integer.valueOf(++sqlNo));
                    SqlResult sqlResult = this.executor.executeUpdate(key, context.getKey().getTargetDialect(), syncInfo.getSql(), syncInfo.getBindParams());
                    sqlResultList.add(sqlResult);
                    if (!sqlResult.isSuccessAndChangeData()) {
                        this.executor.continueExecuteUpdate(sqlResult, Integer.valueOf(10), Integer.valueOf(1));
                    }
                    ArrayList bindParams = new ArrayList();
                    String syncLogInsertSql = this.getSyncDataLogSql(context, syncInfo, bindParams);
                    this.executor.executeUpdate(key, sqlResult.getDataSourceName(), syncLogInsertSql, bindParams);
                }
            }
            this.printSyncSummary(context, syncExecuteInfos, multiSqlResult);
        }
        finally {
            this.unlock(context);
        }
    }

    protected void lock(SyncContext context) {
    }

    protected void unlock(SyncContext context) {
    }

    protected abstract List<SyncContext.SyncExecuteInfo> getSyncExecuteInfos(SyncContext var1);

    protected String getSyncDataLogSql(SyncContext context, SyncContext.SyncExecuteInfo syncInfo, List<String> bindParams) {
        String sql = "INSERT INTO multi_sync_data_logs (schema_name, table_name, sync_key, sync_key_desc, sync_timestamp, sync_status) VALUES (?, ?, ?, ?, ?, ?)";
        bindParams.add(context.getKey().getBizSqlSchemaName());
        bindParams.add(context.getKey().getBizSqlTableName());
        bindParams.add(this.syncKeyValue(syncInfo.getSourceEntity()));
        bindParams.add(this.syncKeyName(syncInfo.getSourceEntity()));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = now.format(formatter);
        bindParams.add(formattedDateTime);
        bindParams.add("1");
        return sql;
    }

    protected String syncKeyValue(SyncContext.SyncContextEntity entity) {
        return (String)entity.getColumnValues().get(0);
    }

    protected String syncKeyName(SyncContext.SyncContextEntity entity) {
        return (String)entity.getColumnNames().get(0);
    }

    protected String targetTable(String schema, String table) {
        return schema == null || schema.trim().isEmpty() ? table : schema + "." + table;
    }

    protected void printSyncSummary(SyncContext context, List<SyncContext.SyncExecuteInfo> syncExecuteInfos, MutilSqlResult mutilResult) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\u540c\u6b65\u6c47\u603b\u4fe1\u606f\uff1asyncer[%s] traceId[%s], \u8868\u540d[%s] \u6e90\u5e93[%s] \u76ee\u6807\u5e93[%s]", this.getSyncerName(), context.getKey().getTraceId(), this.targetTable(context.getKey().getBizSqlSchemaName(), context.getKey().getBizSqlTableName()), context.getKey().getSourceDialect(), context.getKey().getTargetDialect())).append("\n");
        for (SqlResult result : mutilResult.getSqlResultList()) {
            sb.append(String.format("\u76ee\u6807\u5e93[%s] \u540c\u6b65\u7ed3\u679c[%s] \u540c\u6b65\u6570\u636e[%s] \u91cd\u8bd5\u6b21\u6570[%d] \u540c\u6b65\u65f6\u95f4:[%dms]", result.getDataSourceName(), result.isSuccessAndChangeData(), result.getParams(), result.getReTryTimes(), result.getExecutionTime())).append("\n");
        }
        this.log.info(sb.toString());
    }

    protected abstract String getSyncerName();
}

