/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.service.impl;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.ukagent.bean.MutilSqlResult;
import com.hundsun.lightdb.ukagent.bean.MutilSyncContext;
import com.hundsun.lightdb.ukagent.bean.MutilSyncKey;
import com.hundsun.lightdb.ukagent.bean.SqlResult;
import com.hundsun.lightdb.ukagent.bean.SyncEntity;
import com.hundsun.lightdb.ukagent.config.DataSourceProperties;
import com.hundsun.lightdb.ukagent.dto.SyncDataFromSourceRequest;
import com.hundsun.lightdb.ukagent.dto.SyncTableColumnDataRequest;
import com.hundsun.lightdb.ukagent.exception.BizException;
import com.hundsun.lightdb.ukagent.executor.MultiDataSourceExecutor;
import com.hundsun.lightdb.ukagent.service.SyncService;
import com.hundsun.lightdb.ukagent.sync.SyncDataManager;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MultiSyncServiceImpl
implements SyncService {
    private static final Logger log = LoggerFactory.getLogger(MultiSyncServiceImpl.class);
    @Autowired
    private MultiDataSourceExecutor executor;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private SyncDataManager syncDataManager;
    private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(10, new ThreadPoolExecutor.DiscardOldestPolicy());
    private final Map<MutilSyncKey, MutilSyncContext> syncContextMap = new ConcurrentHashMap();

    public Boolean syncOneRecordDataByTable(SyncDataFromSourceRequest request) {
        this.syncDataManager.handleSyncRequest(request);
        return true;
    }

    private String syncKeyName(SyncDataFromSourceRequest request) {
        return (String)request.getColumnNames().get(0);
    }

    private String syncKeyValue(SyncDataFromSourceRequest request) {
        return (String)request.getColumnValues().get(0);
    }

    public String getSyncDataSql(SyncDataFromSourceRequest request, List<String> params) {
        String schema = request.getBizSqlSchemaName();
        String table = request.getBizSqlTableName();
        String targetTable = schema == null || schema.trim().isEmpty() ? table : schema + "." + table;
        List columns = request.getColumnNames();
        List values = request.getColumnValues();
        StringBuilder setClause = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                setClause.append(", ");
            }
            setClause.append((String)columns.get(i)).append(" = ?");
            params.add((String)values.get(i));
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("UPDATE ").append(targetTable).append(" SET ").append((CharSequence)setClause).append(" WHERE NOT EXISTS (SELECT sync_key FROM multi_sync_data_logs WHERE");
        if (schema != null && !schema.trim().isEmpty()) {
            sqlBuilder.append(" schema_name = ").append("?").append(" AND");
            params.add(schema);
        }
        sqlBuilder.append(" table_name = ").append("?").append(" AND sync_key = ").append(this.syncKeyName(request)).append(")");
        params.add(table);
        return sqlBuilder.toString();
    }

    public String getRegSuccSyncDataLogSql(SyncDataFromSourceRequest request, List<String> params) {
        String sql = "INSERT INTO multi_sync_data_logs (schema_name, table_name, sync_key, sync_key_desc, sync_timestamp, sync_status) VALUES (?, ?, ?, ?, ?, ?)";
        params.add(request.getBizSqlSchemaName());
        params.add(request.getBizSqlTableName());
        params.add(this.syncKeyValue(request));
        params.add(this.syncKeyName(request));
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = now.format(formatter);
        params.add(formattedDateTime);
        params.add("1");
        return sql;
    }

    public String getAllRegSyncDataLogSql(SyncDataFromSourceRequest request, List<String> params) {
        String schema = request.getBizSqlSchemaName();
        String table = request.getBizSqlTableName();
        String targetTable = schema == null || schema.trim().isEmpty() ? table : schema + "." + table;
        String syncKeyName = this.syncKeyName(request);
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("INSERT INTO multi_sync_data_logs (schema_name, table_name, sync_key, sync_key_desc, sync_timestamp, sync_status)").append(" ");
        sqlBuilder.append("SELECT ?,?,").append(syncKeyName).append(",?,?,? FROM ").append(targetTable).append(" ");
        params.add(schema);
        params.add(table);
        params.add(syncKeyName);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String formattedDateTime = now.format(formatter);
        params.add(formattedDateTime);
        params.add("0");
        sqlBuilder.append("WHERE NOT EXISTS (SELECT sync_key FROM multi_sync_data_logs WHERE ");
        if (schema != null && !schema.trim().isEmpty()) {
            sqlBuilder.append(" schema_name = ").append("?").append(" AND");
            params.add(schema);
        }
        sqlBuilder.append(" table_name = ").append("?").append(" AND sync_key = ").append(syncKeyName).append(")");
        params.add(table);
        return sqlBuilder.toString();
    }

    public Boolean syncMutilUuidByTraceId(SyncTableColumnDataRequest request) throws BizException {
        SyncEntity syncEntity;
        boolean recvFinish;
        MutilSyncKey syncKey = new MutilSyncKey(request.getTraceId(), request.getBizSqlSchemaName(), request.getBizSqlTableName(), request.getBizSqlSequence());
        MutilSyncContext syncContext = (MutilSyncContext)this.syncContextMap.get(syncKey);
        if (syncContext == null) {
            this.syncContextMap.computeIfAbsent(syncKey, key -> new MutilSyncContext(request.getTraceId(), Integer.valueOf(this.dataSourceProperties.getSources().size())));
            syncContext = (MutilSyncContext)this.syncContextMap.get(syncKey);
            if (syncContext == null) {
                return false;
            }
            this.scheduler.schedule(() -> {
                MutilSyncContext value = (MutilSyncContext)this.syncContextMap.remove(syncKey);
                if (value != null) {
                    log.info("\u540c\u6b65\u8d85\u65f6\u6e05\u7406 key:{}, \u63a5\u6536\u65f6\u95f4:{}, \u5f53\u524d\u65f6\u95f4:{}", new Object[]{JSON.toJSONString((Object)syncKey), value.getCreateTime(), LocalDateTime.now()});
                }
            }, 5L, TimeUnit.MINUTES);
        }
        int columnCount = request.getMultiQueryResultSet().getColumnNames().size();
        int rowCount = request.getMultiQueryResultSet().getDataRows().size();
        if (StringUtils.equals((CharSequence)request.getSourceDialect(), (CharSequence)request.getTargetDialect())) {
            syncContext.setTotalColumnCount(Integer.valueOf(columnCount));
            syncContext.setTotalRowCount(Integer.valueOf(rowCount));
        }
        if (recvFinish = syncContext.addSyncEntity(syncEntity = this.extractSyncEntity(request)).booleanValue()) {
            log.info("traceId:{} bizSqlSequence:{} bizSqlSchemaName:{} bizSqlTableName:{} \u540c\u6b65\u8bf7\u6c42\u63a5\u6536\u5b8c\u6bd5\uff0c\u5f00\u59cb\u540c\u6b65\u66f4\u65b0UUID", new Object[]{request.getTraceId(), request.getBizSqlSequence(), request.getBizSqlSchemaName(), request.getBizSqlTableName()});
            List syncEntities = syncContext.getSyncEntities();
            MutilSqlResult mutilSqlResult = new MutilSqlResult();
            ArrayList<SqlResult> sqlResultList = new ArrayList<SqlResult>();
            mutilSqlResult.setSqlResultList(sqlResultList);
            for (SyncEntity entity : syncEntities) {
                ArrayList params = new ArrayList();
                List sqls = this.getSyncUuidSql(entity, params);
                for (String sql : sqls) {
                    SqlResult sqlResult = this.executor.executeUpdate(syncKey, entity.getTargetDialect(), sql, params);
                    sqlResultList.add(sqlResult);
                }
            }
            if (!mutilSqlResult.isAllSuccessAndChangeData().booleanValue()) {
                this.executor.continueExecuteUpdate(mutilSqlResult, Integer.valueOf(3), Integer.valueOf(10));
            }
            log.info("traceId:{} bizSqlSequence:{} bizSqlSchemaName:{} bizSqlTableName:{} \u540c\u6b65\u8bf7\u6c42\u5904\u7406\u7ed3\u675f\uff0c\u662f\u5426\u5168\u90e8\u540c\u6b65\u5b8c\u6bd5:{}", new Object[]{request.getTraceId(), request.getBizSqlSequence(), request.getBizSqlSchemaName(), request.getBizSqlTableName(), mutilSqlResult.isAllSuccessAndChangeData()});
            if (log.isDebugEnabled()) {
                for (SqlResult sqlResult : mutilSqlResult.getSqlResultList()) {
                    log.info("traceId:{} bizSqlSequence:{} dataSouceName:{} bizSqlSchemaName:{} bizSqlTableName:{} \u540c\u6b65\u8bf7\u6c42\u5b8c\u6bd5\uff0c\u540c\u6b65\u660e\u7ec6\u7ed3\u679c\u662f\u5426\u5b8c\u6bd5:{}", new Object[]{sqlResult.getKey().getTraceId(), sqlResult.getKey().getBizSqlSequence(), sqlResult.getDataSourceName(), sqlResult.getKey().getBizSqlSchemaName(), sqlResult.getKey().getBizSqlTableName(), sqlResult.isSuccess()});
                }
            }
            this.syncContextMap.remove(syncKey);
        }
        return true;
    }

    private List<String> getSyncUuidSql(SyncEntity syncEntity, List<String> params) {
        ArrayList<String> sqls = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < syncEntity.getCurrentValues().size(); ++rowIndex) {
            List currentValues = (List)syncEntity.getCurrentValues().get(rowIndex);
            List newValues = (List)syncEntity.getNewValues().get(rowIndex);
            StringBuilder sb = new StringBuilder();
            StringBuilder setBuffer = new StringBuilder();
            StringBuilder whereBuffer = new StringBuilder();
            for (String columnName : syncEntity.getColumnName()) {
                if (setBuffer.length() == 0) {
                    setBuffer.append(String.format("%s = ? ", columnName));
                } else {
                    setBuffer.append(String.format(",%s = ? ", columnName));
                }
                if (whereBuffer.length() == 0) {
                    whereBuffer.append(String.format("%s = ? ", columnName));
                    continue;
                }
                whereBuffer.append(String.format("and %s = ? ", columnName));
            }
            params.addAll(newValues);
            params.addAll(currentValues);
            sb.append("UPDATE ");
            if (syncEntity.getBizSqlSchemaName() != null) {
                sb.append(syncEntity.getBizSqlSchemaName());
                sb.append(".");
                sb.append(syncEntity.getBizSqlTableName());
            } else {
                sb.append(syncEntity.getBizSqlTableName());
            }
            sb.append(" SET ");
            sb.append((CharSequence)setBuffer);
            sb.append(" WHERE ");
            sb.append((CharSequence)whereBuffer);
            sqls.add(sb.toString());
        }
        return sqls;
    }

    private SyncEntity extractSyncEntity(SyncTableColumnDataRequest request) {
        SyncEntity entity = new SyncEntity();
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<Integer> columnValuesPos = new ArrayList<Integer>();
        ArrayList syncDataRows = new ArrayList();
        entity.setSourceDialect(request.getSourceDialect());
        entity.setTargetDialect(request.getTargetDialect());
        entity.setBizSqlSequence(request.getBizSqlSequence());
        entity.setBizSqlTableName(request.getBizSqlTableName());
        entity.setBizSqlSchemaName(request.getBizSqlSchemaName());
        int pos = 0;
        for (String column : request.getMultiQueryResultSet().getColumnNames()) {
            columnNames.add(column);
            columnValuesPos.add(pos);
            ++pos;
        }
        for (List rowData : request.getMultiQueryResultSet().getDataRows()) {
            ArrayList<String> syncRowData = new ArrayList<String>();
            syncDataRows.add(syncRowData);
            Iterator iterator = columnValuesPos.iterator();
            while (iterator.hasNext()) {
                int syncDataPos = (Integer)iterator.next();
                syncRowData.add((String)rowData.get(syncDataPos));
            }
        }
        entity.setCurrentValues(syncDataRows);
        entity.setColumnName(columnNames);
        return entity;
    }

    public static String getConfigKey(String bizSqlSchemaName, String bizSqlTableName) {
        String key = StringUtils.isNotBlank((CharSequence)bizSqlSchemaName) ? String.format("%s.%s", bizSqlSchemaName, bizSqlTableName) : bizSqlTableName;
        return key;
    }

    public Boolean lastSyncUuidStatus() throws BizException {
        return true;
    }

    public Boolean initOneTable(String schema, String table, String columns) throws BizException {
        List<String> columnList = Arrays.asList(columns.split(","));
        columnList.replaceAll(String::trim);
        ArrayList params = new ArrayList();
        SyncDataFromSourceRequest request = new SyncDataFromSourceRequest();
        request.setBizSqlSchemaName(schema);
        request.setBizSqlTableName(table);
        request.setColumnNames(columnList);
        String ingoreSql = this.getAllRegSyncDataLogSql(request, params);
        MutilSyncKey key = new MutilSyncKey("", schema, table, Integer.valueOf(0));
        MutilSqlResult res = this.executor.executeUpdateOnAll(key, ingoreSql, params);
        if (res.isAllSuccess().booleanValue()) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        for (SqlResult result : res.getSqlResultList()) {
            if (result.isSuccess()) continue;
            sb.append(String.format("\u76ee\u6807\u5e93:%s \u6267\u884c\u5931\u8d25:%s", result.getDataSourceName(), result.getErrorMessage()));
        }
        if (log.isDebugEnabled()) {
            log.debug("\u521d\u59cb\u5316\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)res));
        }
        throw new BizException(String.format("\u521d\u59cb\u5316\u5931\u8d25\uff0c%s", sb.toString()));
    }
}

