/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.service.impl;

import com.hundsun.lightdb.ukagent.bean.DbType;
import com.hundsun.lightdb.ukagent.config.DataSourceProperties;
import com.hundsun.lightdb.ukagent.dto.DataSyncRequest;
import com.hundsun.lightdb.ukagent.dto.DataSyncResponse;
import com.hundsun.lightdb.ukagent.executor.SqlExecutor;
import com.hundsun.lightdb.ukagent.service.DataSyncService;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class DataSyncServiceImpl
implements DataSyncService {
    private static final Logger log = LoggerFactory.getLogger(DataSyncServiceImpl.class);
    private static final String SCRIPT_BASE_DIR = "config" + File.separator + "scripts";
    private static final String SCRIPT_PATH_TEMPLATE = "%s" + File.separator + "%s" + File.separator + "%s";
    private static final int TASK_TIMEOUT_MINUTES = 30;
    private static final String PASSWORD_MASK = "***";
    private static final String STATUS_SUCCESS = "success";
    private static final String STATUS_FAILED = "failed";
    private static final String STATUS_PARTIAL_SUCCESS = "partial_success";
    private static final String ERROR_REQUEST_EMPTY = "\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a";
    private static final String ERROR_SCRIPT_NAME_EMPTY = "\u811a\u672c\u540d\u79f0scriptName\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_SOURCE_DB_EMPTY = "\u6e90\u5e93sourceDb\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String ERROR_SOURCE_DB_UNSUPPORTED = "sourceDb\u4ec5\u652f\u6301oracle\u3001mysql\uff0c\u5f53\u524d\u503c\uff1a%s";
    private static final String ERROR_TARGET_DBS_EMPTY = "\u76ee\u6807\u5e93\u5217\u8868targetDbs\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u540c\u6b65";
    private static final String ERROR_SCRIPT_NOT_FOUND = "\u811a\u672c\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a%s";
    private static final String ERROR_SCRIPT_EMPTY_SQL = "\u811a\u672c\u89e3\u6790\u540e\u65e0\u6709\u6548SQL\u8bed\u53e5\uff1a%s";
    private static final String ERROR_DB_CONFIG_EMPTY = "\u76ee\u6807\u5e93\u914d\u7f6e\u4e0d\u5b58\u5728\uff1a%s";
    private static final String ERROR_DB_URL_EMPTY = "\u76ee\u6807\u5e93URL\u914d\u7f6e\u4e3a\u7a7a\uff1a%s";
    private static final String ERROR_DB_USERNAME_EMPTY = "\u76ee\u6807\u5e93\u7528\u6237\u540d\u914d\u7f6e\u4e3a\u7a7a\uff1a%s";
    private static final String ERROR_DB_DIALECT_EMPTY = "\u76ee\u6807\u5e93name\uff08\u65b9\u8a00\uff09\u914d\u7f6e\u4e3a\u7a7a\uff1a%s";
    private static final String ERROR_DB_DIALECT_INVALID = "\u76ee\u6807\u5e93\u65b9\u8a00\u65e0\u6548\uff1a%s\uff08\u76ee\u6807\u5e93\u522b\u540d\uff1a%s\uff09";
    private static final String ERROR_SOURCE_NOT_IN_TARGET = "\u6e90\u5e93sourceDb[%s]\u4e0d\u5728\u76ee\u6807\u5e93\u5217\u8868[%s]\u4e2d";
    private static final String ERROR_SQL_EXECUTE = "SQL\u6267\u884c\u5931\u8d25\uff08\u884c\u53f7\uff1a%s\uff09\uff1a%s\uff0c\u539f\u56e0\uff1a%s";
    private static final String ERROR_GLOBAL_PROCESS = "\u540c\u6b65\u6d41\u7a0b\u521d\u59cb\u5316\u5931\u8d25\uff1a%s";
    private static final String LOG_SQL_EXECUTE_START = "traceId=%s, \u76ee\u6807\u5e93=%s, \u5f00\u59cb\u6267\u884cSQL\uff08\u884c\u53f7=%s\uff09\uff1a%s";
    private static final String LOG_SQL_EXECUTE_SUCCESS = "traceId=%s, \u76ee\u6807\u5e93=%s, SQL\u6267\u884c\u6210\u529f\uff08\u884c\u53f7=%s\uff09\uff1a%s\uff0c\u8017\u65f6=%sms";
    private static final String LOG_SQL_EXECUTE_FAILED = "traceId=%s, \u76ee\u6807\u5e93=%s, SQL\u6267\u884c\u5931\u8d25\uff08\u884c\u53f7=%s\uff09\uff1a%s\uff0c\u8017\u65f6=%sms\uff0c\u539f\u56e0\uff1a%s";
    private static final String LOG_TASK_START = "traceId=%s, \u7ebf\u7a0b=%s\u5f00\u59cb\u5904\u7406\u76ee\u6807\u5e93%s\uff0c\u811a\u672c=%s";
    private static final String LOG_TASK_FINISH = "traceId=%s, \u76ee\u6807\u5e93%s\u540c\u6b65\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u603b\u8017\u65f6=%sms\uff0c\u603bSQL\u6570=%s\uff0c\u6210\u529fSQL\u6570=%s\uff0c\u5931\u8d25SQL\u6570=%s";
    private static final String LOG_SCRIPT_PARSE_FINISH = "traceId=%s, \u76ee\u6807\u5e93=%s\uff0c\u811a\u672c\u89e3\u6790\u5b8c\u6210\uff1a\u6587\u4ef6\u8def\u5f84=%s\uff0c\u603b\u884c\u6570=%s\uff0c\u6709\u6548SQL\u6570=%s";
    private static final String LOG_JDBC_URL_BUILD = "traceId=%s, \u76ee\u6807\u5e93=%s\uff0c\u6784\u5efaJDBC\u8fde\u63a5\u4fe1\u606f\uff1aurl=%s\uff0cusername=%s\uff0cpassword=%s";
    private static final String LOG_TASKS_SUBMIT = "traceId=%s\uff0c\u63d0\u4ea4\u540c\u6b65\u4efb\u52a1\u6570\uff1a%s\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a%s\u5206\u949f";
    private static final String LOG_OVERALL_STATUS = "traceId=%s\uff0c\u6570\u636e\u540c\u6b65\u6574\u4f53\u72b6\u6001\uff1a%s\uff0c\u603b\u4efb\u52a1\u6570=%s\uff0c\u6210\u529f\u4efb\u52a1\u6570=%s";
    private static final String OLD_JDBC_PREFIX = "jdbc:";
    private static final String NEW_JDBC_UNISQL_PREFIX = "jdbc:unisql:";
    private static final String PARAM_SOURCE_DIALECT = "sourceDialect";
    private static final String PARAM_TARGET_DIALECT = "targetDialect";
    private static final String PARAM_MULTIPLEX_DIALECTS = "multiplexTargetDialects";
    private String scriptBasePath;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    @Qualifier(value="dataSyncThreadPool")
    private ExecutorService dataSyncThreadPool;

    @PostConstruct
    public void afterPropertiesSet() {
        String userDir = System.getProperty("user.dir");
        this.scriptBasePath = String.format(SCRIPT_PATH_TEMPLATE, userDir, "config", "scripts");
        log.info("\u811a\u672c\u6839\u8def\u5f84\u521d\u59cb\u5316\u5b8c\u6210\uff1a{}", (Object)this.scriptBasePath);
    }

    public DataSyncResponse postSyncData(DataSyncRequest request) {
        DataSyncResponse response = new DataSyncResponse();
        ArrayList detailList = new ArrayList();
        String traceId = this.generateTraceId();
        response.setTraceId(traceId);
        try {
            log.info("\u5f00\u59cb\u6570\u636e\u540c\u6b65\u6d41\u7a0b\uff1atraceId={}, request={}", (Object)traceId, (Object)request);
            this.validateRequest(request, detailList, response);
            if (response.getStatus() != null) {
                log.warn("traceId={}, \u8bf7\u6c42\u6821\u9a8c\u5931\u8d25\uff0c\u76f4\u63a5\u8fd4\u56de\u54cd\u5e94\uff1a{}", (Object)traceId, (Object)response);
                return response;
            }
            Map aliasToDbConfigMap = this.buildAliasToDbConfigMap();
            log.debug("traceId={}, \u6784\u5efa\u522b\u540d-\u6570\u636e\u5e93\u914d\u7f6e\u6620\u5c04\uff1a{}", (Object)traceId, aliasToDbConfigMap.keySet());
            List targetDbAliases = request.getTargetDbs();
            List multiplexDialectList = this.extractTargetDbDialects(targetDbAliases, aliasToDbConfigMap, detailList);
            String multiplexDialects = String.join((CharSequence)",", multiplexDialectList);
            log.info("traceId={}, \u63d0\u53d6\u76ee\u6807\u5e93\u65b9\u8a00\u5217\u8868\uff1a{}\uff0c\u62fc\u63a5\u540e\uff1a{}", new Object[]{traceId, multiplexDialectList, multiplexDialects});
            this.validateSourceInTarget(request.getSourceDb(), multiplexDialects, detailList, response);
            if (response.getStatus() != null) {
                log.warn("traceId={}, \u6e90\u5e93\u4e0d\u5728\u76ee\u6807\u5e93\u5217\u8868\uff0c\u8fd4\u56de\u54cd\u5e94\uff1a{}", (Object)traceId, (Object)response);
                return response;
            }
            List tasks = this.createSyncTasks(targetDbAliases, traceId, request, multiplexDialects, aliasToDbConfigMap);
            log.info(String.format(LOG_TASKS_SUBMIT, traceId, tasks.size(), 30));
            List futures = this.executeTasks(tasks);
            this.processTaskFutures(futures, detailList, traceId);
            response.setDetails(detailList);
            String overallStatus = this.summaryOverallStatus(detailList);
            response.setStatus(overallStatus);
            log.info(String.format(LOG_OVERALL_STATUS, traceId, overallStatus, detailList.size(), detailList.stream().filter(d -> STATUS_SUCCESS.equals(d.getStatus())).count()));
        }
        catch (Exception e) {
            this.handleGlobalException(e, traceId, detailList, response);
        }
        log.info("\u6570\u636e\u540c\u6b65\u8bf7\u6c42\u5904\u7406\u5b8c\u6210\uff1atraceId={}, \u54cd\u5e94={}", (Object)traceId, (Object)response);
        return response;
    }

    private String generateTraceId() {
        return "uk_agent_" + UUID.randomUUID().toString().replace("-", "");
    }

    private void validateRequest(DataSyncRequest request, List<DataSyncResponse.DbExecuteDetail> detailList, DataSyncResponse response) {
        if (request == null) {
            log.error(ERROR_REQUEST_EMPTY);
            detailList.add(this.createErrorDetail("SYSTEM", ERROR_REQUEST_EMPTY));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
            return;
        }
        String scriptName = request.getScriptName();
        if (StringUtils.isBlank((CharSequence)scriptName)) {
            log.error(ERROR_SCRIPT_NAME_EMPTY);
            detailList.add(this.createErrorDetail("SYSTEM", ERROR_SCRIPT_NAME_EMPTY));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
            return;
        }
        String sourceDb = request.getSourceDb();
        if (StringUtils.isBlank((CharSequence)sourceDb)) {
            log.error(ERROR_SOURCE_DB_EMPTY);
            detailList.add(this.createErrorDetail("SYSTEM", ERROR_SOURCE_DB_EMPTY));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
            return;
        }
        if (!DbType.MYSQL.name().equalsIgnoreCase(sourceDb) && !DbType.ORACLE.name().equalsIgnoreCase(sourceDb)) {
            log.error(String.format(ERROR_SOURCE_DB_UNSUPPORTED, sourceDb));
            detailList.add(this.createErrorDetail("SYSTEM", String.format(ERROR_SOURCE_DB_UNSUPPORTED, sourceDb)));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
            return;
        }
        List targetDbAliases = request.getTargetDbs();
        if (targetDbAliases == null || targetDbAliases.isEmpty()) {
            log.error(ERROR_TARGET_DBS_EMPTY);
            detailList.add(this.createErrorDetail("SYSTEM", ERROR_TARGET_DBS_EMPTY));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
            return;
        }
        boolean hasScriptError = false;
        for (String targetDbAlias : targetDbAliases) {
            if (this.checkScriptFileExists(targetDbAlias, scriptName, detailList)) continue;
            hasScriptError = true;
        }
        if (hasScriptError) {
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
        }
    }

    private boolean checkScriptFileExists(String targetDbAlias, String scriptName, List<DataSyncResponse.DbExecuteDetail> detailList) {
        String scriptPath = String.format(SCRIPT_PATH_TEMPLATE, this.scriptBasePath, targetDbAlias, scriptName);
        String formattedScriptPath = String.format(scriptPath + "%s", "");
        File scriptFile = new File(formattedScriptPath);
        if (!scriptFile.exists() || !scriptFile.isFile()) {
            String errorMsg = String.format(ERROR_SCRIPT_NOT_FOUND, scriptPath);
            log.error(errorMsg);
            detailList.add(this.createErrorDetail(targetDbAlias, errorMsg));
            return false;
        }
        log.debug("\u811a\u672c\u6587\u4ef6\u68c0\u67e5\u901a\u8fc7\uff1atargetDbAlias={}, scriptPath={}", (Object)targetDbAlias, (Object)scriptPath);
        return true;
    }

    private void validateSourceInTarget(String sourceDb, String multiplexDialects, List<DataSyncResponse.DbExecuteDetail> detailList, DataSyncResponse response) {
        if (!multiplexDialects.contains(sourceDb.toLowerCase())) {
            String errorMsg = String.format(ERROR_SOURCE_NOT_IN_TARGET, sourceDb, multiplexDialects);
            log.error(errorMsg);
            detailList.add(this.createErrorDetail("SYSTEM", errorMsg));
            response.setStatus(STATUS_FAILED);
            response.setDetails(detailList);
        }
    }

    private Map<String, DataSourceProperties.DbConfig> buildAliasToDbConfigMap() {
        return this.dataSourceProperties.getSources().stream().filter(dbConfig -> StringUtils.isNotBlank((CharSequence)dbConfig.getAlias())).collect(Collectors.toMap(DataSourceProperties.DbConfig::getAlias, dbConfig -> dbConfig, (existing, replacement) -> {
            log.warn("\u53d1\u73b0\u91cd\u590d\u6570\u636e\u5e93\u522b\u540d\uff1a{}\uff0c\u4fdd\u7559\u539f\u6709\u914d\u7f6e\uff1a{}", (Object)existing.getAlias(), existing);
            return existing;
        }, HashMap::new));
    }

    private List<String> extractTargetDbDialects(List<String> targetDbAliases, Map<String, DataSourceProperties.DbConfig> aliasToDbConfigMap, List<DataSyncResponse.DbExecuteDetail> detailList) {
        ArrayList<String> dialects = new ArrayList<String>(targetDbAliases.size());
        for (String targetDbAlias : targetDbAliases) {
            DataSourceProperties.DbConfig dbConfig = aliasToDbConfigMap.get(targetDbAlias);
            if (dbConfig == null) {
                String errorMsg = String.format(ERROR_DB_CONFIG_EMPTY, targetDbAlias);
                log.error(errorMsg);
                detailList.add(this.createErrorDetail(targetDbAlias, errorMsg));
                continue;
            }
            String dialect = StringUtils.lowerCase((String)dbConfig.getName());
            if (StringUtils.isBlank((CharSequence)dialect)) {
                String errorMsg = String.format(ERROR_DB_DIALECT_EMPTY, targetDbAlias);
                log.error(errorMsg);
                detailList.add(this.createErrorDetail(targetDbAlias, errorMsg));
                continue;
            }
            try {
                DbType.of((String)dialect);
                dialects.add(dialect);
            }
            catch (IllegalArgumentException e) {
                String errorMsg = String.format(ERROR_DB_DIALECT_INVALID, dialect, targetDbAlias);
                log.error(errorMsg, (Throwable)e);
                detailList.add(this.createErrorDetail(targetDbAlias, errorMsg));
            }
        }
        return dialects;
    }

    private List<Callable<DataSyncResponse.DbExecuteDetail>> createSyncTasks(List<String> targetDbAliases, String traceId, DataSyncRequest request, String multiplexDialects, Map<String, DataSourceProperties.DbConfig> aliasToDbConfigMap) {
        return targetDbAliases.stream().map(targetDbAlias -> this.createSingleDbTask(targetDbAlias, traceId, request, multiplexDialects, aliasToDbConfigMap)).collect(Collectors.toCollection(() -> new ArrayList(targetDbAliases.size())));
    }

    private Callable<DataSyncResponse.DbExecuteDetail> createSingleDbTask(String targetDbAlias, String traceId, DataSyncRequest request, String multiplexDialects, Map<String, DataSourceProperties.DbConfig> aliasToDbConfigMap) {
        return () -> {
            DataSyncResponse.DbExecuteDetail dbExecuteDetail;
            DataSyncResponse.DbExecuteDetail detail = new DataSyncResponse.DbExecuteDetail();
            detail.setName(targetDbAlias);
            long taskStartTime = System.currentTimeMillis();
            ArrayList failedSqlDetails = new ArrayList();
            int totalSqlCount = 0;
            int successSqlCount = 0;
            int failedSqlCount = 0;
            try {
                MultiplexContext.setRealMultiplexTraceId((String)traceId);
                MultiplexContext.setMultiUrl((String)request.getScriptName());
                log.info(String.format(LOG_TASK_START, traceId, Thread.currentThread().getName(), targetDbAlias, request.getScriptName()));
                Map resultMap = this.processSingleTargetDbInternal(targetDbAlias, traceId, request, multiplexDialects, aliasToDbConfigMap, failedSqlDetails);
                totalSqlCount = (Integer)resultMap.get("totalSqlCount");
                successSqlCount = (Integer)resultMap.get("successSqlCount");
                failedSqlCount = (Integer)resultMap.get("failedSqlCount");
                detail.setSqlCount(totalSqlCount);
                detail.setExecuteDuration(System.currentTimeMillis() - taskStartTime);
                if (failedSqlCount == 0) {
                    detail.setStatus(STATUS_SUCCESS);
                    detail.setError(null);
                    detail.setFailedSqlDetails(null);
                } else {
                    detail.setStatus(STATUS_FAILED);
                    detail.setError(String.format("\u90e8\u5206SQL\u6267\u884c\u5931\u8d25\uff1a\u603bSQL\u6570=%d\uff0c\u6210\u529f\u6570=%d\uff0c\u5931\u8d25\u6570=%d", totalSqlCount, successSqlCount, failedSqlCount));
                    detail.setFailedSqlDetails(failedSqlDetails);
                }
                dbExecuteDetail = detail;
            }
            catch (Exception e) {
                DataSyncResponse.DbExecuteDetail dbExecuteDetail2;
                try {
                    String errorMsg = "\u540c\u6b65\u5f02\u5e38\uff1a" + e.getMessage();
                    log.error("traceId={}, \u76ee\u6807\u5e93{}\u540c\u6b65\u5931\u8d25", new Object[]{traceId, targetDbAlias, e});
                    detail.setStatus(STATUS_FAILED);
                    detail.setError(errorMsg);
                    detail.setSqlCount(totalSqlCount);
                    detail.setExecuteDuration(System.currentTimeMillis() - taskStartTime);
                    detail.setFailedSqlDetails(failedSqlDetails);
                    dbExecuteDetail2 = detail;
                }
                catch (Throwable throwable) {
                    log.info(String.format(LOG_TASK_FINISH, traceId, targetDbAlias, System.currentTimeMillis() - taskStartTime, totalSqlCount, successSqlCount, failedSqlCount));
                    MultiplexContext.removeRealMultiplexTraceId();
                    MultiplexContext.removeMultiUrl();
                    throw throwable;
                }
                log.info(String.format(LOG_TASK_FINISH, traceId, targetDbAlias, System.currentTimeMillis() - taskStartTime, totalSqlCount, successSqlCount, failedSqlCount));
                MultiplexContext.removeRealMultiplexTraceId();
                MultiplexContext.removeMultiUrl();
                return dbExecuteDetail2;
            }
            log.info(String.format(LOG_TASK_FINISH, traceId, targetDbAlias, System.currentTimeMillis() - taskStartTime, totalSqlCount, successSqlCount, failedSqlCount));
            MultiplexContext.removeRealMultiplexTraceId();
            MultiplexContext.removeMultiUrl();
            return dbExecuteDetail;
        };
    }

    private Map<String, Object> processSingleTargetDbInternal(String targetDbAlias, String traceId, DataSyncRequest request, String multiplexDialects, Map<String, DataSourceProperties.DbConfig> aliasToDbConfigMap, List<DataSyncResponse.DbExecuteDetail.FailedSqlDetail> failedSqlDetails) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        int totalSqlCount = 0;
        int successSqlCount = 0;
        int failedSqlCount = 0;
        DataSourceProperties.DbConfig dbConfig = aliasToDbConfigMap.get(targetDbAlias);
        if (dbConfig == null) {
            resultMap.put("totalSqlCount", totalSqlCount);
            resultMap.put("successSqlCount", successSqlCount);
            resultMap.put("failedSqlCount", failedSqlCount);
            throw new RuntimeException(String.format(ERROR_DB_CONFIG_EMPTY, targetDbAlias));
        }
        String originalUrl = dbConfig.getUrl();
        String username = dbConfig.getUsername();
        String password = dbConfig.getPassword();
        String targetDialect = StringUtils.lowerCase((String)dbConfig.getName());
        if (StringUtils.isBlank((CharSequence)originalUrl)) {
            String errorMsg = String.format(ERROR_DB_URL_EMPTY, targetDbAlias);
            resultMap.put("totalSqlCount", totalSqlCount);
            resultMap.put("successSqlCount", successSqlCount);
            resultMap.put("failedSqlCount", failedSqlCount);
            throw new RuntimeException(errorMsg);
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            String errorMsg = String.format(ERROR_DB_USERNAME_EMPTY, targetDbAlias);
            resultMap.put("totalSqlCount", totalSqlCount);
            resultMap.put("successSqlCount", successSqlCount);
            resultMap.put("failedSqlCount", failedSqlCount);
            throw new RuntimeException(errorMsg);
        }
        if (StringUtils.isBlank((CharSequence)targetDialect)) {
            String errorMsg = String.format(ERROR_DB_DIALECT_EMPTY, targetDbAlias);
            resultMap.put("totalSqlCount", totalSqlCount);
            resultMap.put("successSqlCount", successSqlCount);
            resultMap.put("failedSqlCount", failedSqlCount);
            throw new RuntimeException(errorMsg);
        }
        String finalJdbcUrl = this.buildFinalJdbcUrl(originalUrl, request.getSourceDb(), targetDialect, multiplexDialects);
        log.info(String.format(LOG_JDBC_URL_BUILD, traceId, targetDbAlias, finalJdbcUrl, username, PASSWORD_MASK));
        String scriptPath = String.format(SCRIPT_PATH_TEMPLATE, this.scriptBasePath, targetDbAlias, request.getScriptName());
        Map lineNumberSqlMap = SqlExecutor.parseSqlScript((String)scriptPath, (String)targetDialect);
        if (lineNumberSqlMap == null || lineNumberSqlMap.isEmpty()) {
            String errorMsg = String.format(ERROR_SCRIPT_EMPTY_SQL, scriptPath);
            resultMap.put("totalSqlCount", totalSqlCount);
            resultMap.put("successSqlCount", successSqlCount);
            resultMap.put("failedSqlCount", failedSqlCount);
            throw new RuntimeException(errorMsg);
        }
        List validSqlEntries = lineNumberSqlMap.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))).collect(Collectors.toList());
        totalSqlCount = validSqlEntries.size();
        log.info(String.format(LOG_SCRIPT_PARSE_FINISH, traceId, targetDbAlias, scriptPath, lineNumberSqlMap.size(), totalSqlCount));
        for (Map.Entry entry2 : validSqlEntries) {
            int lineNumber = (Integer)entry2.getKey();
            String sql = (String)entry2.getValue();
            long sqlStartTime = System.currentTimeMillis();
            try {
                log.info(String.format(LOG_SQL_EXECUTE_START, traceId, targetDbAlias, lineNumber, sql));
                this.executeSingleSql(finalJdbcUrl, username, password, sql, traceId, targetDbAlias);
                ++successSqlCount;
                long sqlCost = System.currentTimeMillis() - sqlStartTime;
                log.info(String.format(LOG_SQL_EXECUTE_SUCCESS, traceId, targetDbAlias, lineNumber, sql, sqlCost));
            }
            catch (Exception e) {
                ++failedSqlCount;
                String errorMsg = e.getMessage();
                long sqlCost = System.currentTimeMillis() - sqlStartTime;
                log.error(String.format(LOG_SQL_EXECUTE_FAILED, traceId, targetDbAlias, lineNumber, sql, sqlCost, errorMsg), (Throwable)e);
                DataSyncResponse.DbExecuteDetail.FailedSqlDetail failedSqlDetail = new DataSyncResponse.DbExecuteDetail.FailedSqlDetail();
                failedSqlDetail.setLineNumber(lineNumber);
                failedSqlDetail.setSql(sql);
                failedSqlDetail.setError(errorMsg);
                failedSqlDetail.setExecuteTime(sqlCost);
                failedSqlDetails.add(failedSqlDetail);
            }
        }
        resultMap.put("totalSqlCount", totalSqlCount);
        resultMap.put("successSqlCount", successSqlCount);
        resultMap.put("failedSqlCount", failedSqlCount);
        return resultMap;
    }

    private String buildFinalJdbcUrl(String originalUrl, String sourceDb, String targetDialect, String multiplexDialects) {
        String trimmedUrl = originalUrl.trim();
        String prefixReplacedUrl = trimmedUrl.replaceFirst(OLD_JDBC_PREFIX, NEW_JDBC_UNISQL_PREFIX);
        String separator = prefixReplacedUrl.contains("?") ? "&" : "?";
        String urlParams = String.format("%s=%s&%s=%s&%s=%s", PARAM_SOURCE_DIALECT, sourceDb.toLowerCase(), PARAM_TARGET_DIALECT, targetDialect, PARAM_MULTIPLEX_DIALECTS, multiplexDialects);
        return prefixReplacedUrl + separator + urlParams;
    }

    private void executeSingleSql(String jdbcUrl, String username, String password, String sql, String traceId, String targetDbAlias) throws Exception {
        try (Connection conn = DriverManager.getConnection(jdbcUrl, username, password);
             Statement stmt = conn.createStatement();){
            log.debug("traceId={}, \u76ee\u6807\u5e93={}\uff0c\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f", (Object)traceId, (Object)targetDbAlias);
            stmt.execute(sql);
        }
        catch (Exception e) {
            log.error("traceId={}, \u76ee\u6807\u5e93={}\uff0cSQL\u6267\u884c\u5f02\u5e38", new Object[]{traceId, targetDbAlias, e});
            throw e;
        }
    }

    private List<Future<DataSyncResponse.DbExecuteDetail>> executeTasks(List<Callable<DataSyncResponse.DbExecuteDetail>> tasks) throws InterruptedException {
        return this.dataSyncThreadPool.invokeAll(tasks, 30L, TimeUnit.MINUTES);
    }

    private void processTaskFutures(List<Future<DataSyncResponse.DbExecuteDetail>> futures, List<DataSyncResponse.DbExecuteDetail> detailList, String traceId) {
        for (Future<DataSyncResponse.DbExecuteDetail> future : futures) {
            try {
                if (future.isDone()) {
                    DataSyncResponse.DbExecuteDetail detail = future.get();
                    detailList.add(detail);
                    log.debug("traceId={}, \u6536\u96c6\u4efb\u52a1\u7ed3\u679c\uff1a{}", (Object)traceId, (Object)detail);
                    continue;
                }
                DataSyncResponse.DbExecuteDetail timeoutDetail = this.createErrorDetail("UNKNOWN", "\u4efb\u52a1\u6267\u884c\u8d85\u65f6");
                detailList.add(timeoutDetail);
                log.warn("traceId={}, \u4efb\u52a1\u6267\u884c\u8d85\u65f6", (Object)traceId);
            }
            catch (CancellationException e) {
                DataSyncResponse.DbExecuteDetail cancelDetail = this.createErrorDetail("UNKNOWN", "\u4efb\u52a1\u88ab\u53d6\u6d88");
                detailList.add(cancelDetail);
                log.error("traceId={}, \u4efb\u52a1\u88ab\u53d6\u6d88", (Object)traceId, (Object)e);
            }
            catch (InterruptedException e) {
                DataSyncResponse.DbExecuteDetail interruptDetail = this.createErrorDetail("UNKNOWN", "\u4efb\u52a1\u88ab\u4e2d\u65ad");
                detailList.add(interruptDetail);
                log.error("traceId={}, \u4efb\u52a1\u88ab\u4e2d\u65ad", (Object)traceId, (Object)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                DataSyncResponse.DbExecuteDetail errorDetail = this.createErrorDetail("UNKNOWN", "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a" + e.getMessage());
                detailList.add(errorDetail);
                log.error("traceId={}, \u6536\u96c6\u4efb\u52a1\u7ed3\u679c\u5931\u8d25", (Object)traceId, (Object)e);
            }
        }
    }

    private void handleGlobalException(Exception e, String traceId, List<DataSyncResponse.DbExecuteDetail> detailList, DataSyncResponse response) {
        String errorMsg = String.format(ERROR_GLOBAL_PROCESS, e.getMessage());
        DataSyncResponse.DbExecuteDetail globalDetail = this.createErrorDetail("\u5168\u5c40\u6d41\u7a0b", errorMsg);
        detailList.add(globalDetail);
        response.setDetails(detailList);
        response.setStatus(STATUS_FAILED);
        log.error("traceId={}, \u6570\u636e\u540c\u6b65\u6d41\u7a0b\u521d\u59cb\u5316\u5931\u8d25", (Object)traceId, (Object)e);
    }

    private DataSyncResponse.DbExecuteDetail createErrorDetail(String name, String errorMsg) {
        DataSyncResponse.DbExecuteDetail detail = new DataSyncResponse.DbExecuteDetail();
        detail.setName(name);
        detail.setStatus(STATUS_FAILED);
        detail.setError(errorMsg);
        detail.setSqlCount(0);
        detail.setExecuteDuration(0L);
        detail.setFailedSqlDetails(null);
        return detail;
    }

    private String summaryOverallStatus(List<DataSyncResponse.DbExecuteDetail> detailList) {
        long totalCount;
        long successCount = detailList.stream().filter(d -> STATUS_SUCCESS.equals(d.getStatus())).count();
        if (successCount == (totalCount = (long)detailList.size())) {
            return STATUS_SUCCESS;
        }
        if (successCount > 0L) {
            return STATUS_PARTIAL_SUCCESS;
        }
        return STATUS_FAILED;
    }
}

