/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.runner;

import com.hundsun.lightdb.ukagent.config.UuidSyncProperties;
import com.hundsun.lightdb.ukagent.service.SyncService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class AppInitTableIgnoreData
implements ApplicationRunner {
    private Logger log = LoggerFactory.getLogger(AppInitTableIgnoreData.class);
    @Autowired
    private SyncService syncService;
    @Autowired
    private UuidSyncProperties uuidSyncProperties;

    public void run(ApplicationArguments args) throws Exception {
        Map tableColumnsMap = this.uuidSyncProperties.getTableColumnsMap();
        if (tableColumnsMap != null) {
            for (Map.Entry entry : tableColumnsMap.entrySet()) {
                String[] schemaAndTable = ((String)entry.getKey()).split("\\.");
                String schema = "";
                String table = "";
                if (schemaAndTable.length == 1) {
                    table = schemaAndTable[0];
                } else if (schemaAndTable.length == 2) {
                    schema = schemaAndTable[0];
                    table = schemaAndTable[1];
                }
                String columns = String.join((CharSequence)",", (Iterable)entry.getValue());
                try {
                    boolean success = this.syncService.initOneTable(schema, table, columns);
                    if (success) {
                        this.log.info("\u521d\u59cb\u5316\u540c\u6b65\u8868{}\uff0c\u540c\u6b65\u5217{}\u4fe1\u606f\u6210\u529f", (Object)schemaAndTable, (Object)columns);
                        continue;
                    }
                    this.log.warn("\u521d\u59cb\u5316\u540c\u6b65\u8868{}\uff0c\u540c\u6b65\u5217{}\u4fe1\u606f\u5931\u8d25", (Object)schemaAndTable, (Object)columns);
                }
                catch (Exception e) {
                    this.log.warn("\u521d\u59cb\u5316\u540c\u6b65\u8868{}\uff0c\u540c\u6b65\u5217{}\u4fe1\u606f\u5931\u8d25", new Object[]{schemaAndTable, columns, e});
                }
            }
        }
    }
}

