/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.filter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.hundsun.lightdb.ukagent.constant.MultiplexConstants;
import com.hundsun.lightdb.ukagent.constant.MultiplexErrorEnum;
import com.hundsun.lightdb.ukagent.filter.MultiplexFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.owasp.encoder.Encode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

/*
 * Exception performing whole class analysis ignored.
 */
@WebFilter(urlPatterns={"/*"})
public class MultiplexFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(MultiplexFilter.class);
    private final ConcurrentHashMap<String, List<LoginInfo>> loginCache = new ConcurrentHashMap();
    private final RestTemplate restTemplate = new RestTemplate();
    private final ExecutorService requestExecutor = new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */, new ThreadPoolExecutor.CallerRunsPolicy());
    private final ScheduledExecutorService cacheCleanExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("login-cache-cleaner");
        thread.setDaemon(true);
        return thread;
    });
    private static final int TERMINATION_TIMEOUT = 5;

    public void initFilterBean() throws ServletException {
        super.initFilterBean();
        this.cacheCleanExecutor.scheduleAtFixedRate(() -> this.cleanExpiredCache(), 0L, 1L, TimeUnit.MINUTES);
    }

    private void cleanExpiredCache() {
        try {
            Iterator iterator = this.loginCache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String cacheKey = (String)entry.getKey();
                List loginInfoList = (List)entry.getValue();
                if (loginInfoList == null || loginInfoList.isEmpty()) {
                    log.info("\u6e05\u7406\u7a7a\u767b\u5f55\u7f13\u5b58\u5217\u8868\uff0cKey\uff1a{}", (Object)cacheKey);
                    iterator.remove();
                    continue;
                }
                Iterator listIterator = loginInfoList.iterator();
                while (listIterator.hasNext()) {
                    LoginInfo loginInfo = (LoginInfo)listIterator.next();
                    if (!loginInfo.isExpired()) continue;
                    log.info("\u6e05\u7406\u7f13\u5b58Key[{}]\u4e0b\u7684\u8fc7\u671fLoginInfo\uff08\u4e3b\u673a\uff1a{}\uff09", (Object)cacheKey, (Object)loginInfo.getHost());
                    listIterator.remove();
                }
                if (!loginInfoList.isEmpty()) continue;
                log.info("\u7f13\u5b58Key[{}]\u4e0b\u7684LoginInfo\u5df2\u5168\u90e8\u8fc7\u671f\uff0c\u79fb\u9664\u6574\u4e2a\u7f13\u5b58\u9879", (Object)cacheKey);
                iterator.remove();
            }
        }
        catch (Exception e) {
            log.error("\u6e05\u7406\u8fc7\u671f\u767b\u5f55\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String taHosts = request.getHeader("Ta-Hosts");
        if (taHosts == null || taHosts.trim().isEmpty()) {
            log.debug("\u8bf7\u6c42\u4e0d\u5305\u542bTa-Hosts\u5934\uff0c\u76f4\u63a5\u653e\u884c\uff0c\u8def\u5f84\uff1a{}", (Object)request.getRequestURI());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ContentCachingRequestWrapper wrappedRequest = this.wrapRequest(request);
        ContentCachingResponseWrapper wrappedResponse = new ContentCachingResponseWrapper(response);
        String traceId = null;
        try {
            RequestContext context = this.parseRequestContext(request, taHosts);
            traceId = context.getTraceId();
            if (context.isLoginRequest()) {
                this.handleLoginRequest(wrappedRequest, wrappedResponse, context);
            } else {
                this.handleBusinessRequest(wrappedRequest, wrappedResponse, context);
            }
        }
        catch (Exception e) {
            String finalTraceId = traceId != null ? traceId : "Trace-Id=uk_agent_" + UUID.randomUUID().toString();
            this.handleGlobalException(wrappedResponse, e, finalTraceId);
        }
        finally {
            wrappedResponse.copyBodyToResponse();
        }
    }

    private ContentCachingRequestWrapper wrapRequest(HttpServletRequest request) {
        ContentCachingRequestWrapper wrappedRequest = new ContentCachingRequestWrapper(request);
        try {
            wrappedRequest.getInputStream().readAllBytes();
        }
        catch (IOException e) {
            log.warn("\u4e3b\u52a8\u8bfb\u53d6\u8bf7\u6c42\u4f53\u8f93\u5165\u6d41\u5931\u8d25", (Throwable)e);
        }
        return wrappedRequest;
    }

    private RequestContext parseRequestContext(HttpServletRequest request, String taHosts) {
        Object multiplexUrl;
        String[] hosts;
        for (String host : hosts = taHosts.split(",")) {
            String normalizedHost = host.trim();
            if (MultiplexConstants.HOST_PATTERN.matcher(normalizedHost).matches()) continue;
            throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_TA_HOSTS_FORMAT.formatMsg(new String[]{normalizedHost}));
        }
        String taExpected = request.getHeader("Expected");
        if (taExpected != null && !taExpected.trim().isEmpty()) {
            taExpected = taExpected.trim();
            for (String condition : taExpected.split(",")) {
                String[] pathValue = condition.split("=", 2);
                if (pathValue.length == 2 && !StringUtils.isBlank((CharSequence)pathValue[0])) continue;
                throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_EXPECTED_FORMAT.formatMsg(new String[]{condition}));
            }
        } else {
            log.warn("\u8bf7\u6c42\u5934Expected\u4e3a\u7a7a");
            throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_EXPECTED_FORMAT.formatMsg(new String[]{"\u8bf7\u6c42\u5934Expected\u6ca1\u6709\u5bf9\u5e94\u5185\u5bb9"}));
        }
        int timeout = 3000;
        String timeoutHeader = request.getHeader("Ta-Timeout");
        if (timeoutHeader != null && !timeoutHeader.trim().isEmpty()) {
            try {
                timeout = Integer.parseInt(timeoutHeader.trim());
                if (timeout <= 0) {
                    throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_TIMEOUT_VALUE.getMsgTemplate());
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_TIMEOUT_FORMAT.getMsgTemplate());
            }
        }
        boolean isLoginRequest = "/tafund/submitLogin".equals(request.getRequestURI());
        String requestUri = request.getRequestURI();
        Object traceId = this.extractTraceId(request.getHeader("X-Msg-Trace"));
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = "Trace-Id=uk_agent_" + UUID.randomUUID().toString();
        }
        if (StringUtils.isBlank((CharSequence)(multiplexUrl = request.getHeader("X-MULTIPLEX-URL")))) {
            multiplexUrl = request.getMethod() + " " + request.getRequestURI();
        }
        log.info("\u5f00\u59cb\u5904\u7406\u591a\u73af\u5883\u8bf7\u6c42\uff0c\u8def\u5f84\uff1a{}\uff0c\u662f\u5426\u4e3a\u767b\u5f55\u8bf7\u6c42\uff1a{}\uff0c\u76ee\u6807\u4e3b\u673a\u6570\uff1a{}\uff0c\u9884\u671f\u6761\u4ef6\uff1a{}\uff0c\u8d85\u65f6\u65f6\u95f4\uff1a{}ms\uff0cTraceId\uff1a{}", new Object[]{requestUri, isLoginRequest, hosts.length, taExpected, timeout, traceId});
        return new RequestContext(hosts, taExpected, timeout, isLoginRequest, requestUri, (String)traceId, (String)multiplexUrl);
    }

    private String extractTraceId(String traceIdStr) {
        if (StringUtils.isNotBlank((CharSequence)traceIdStr)) {
            String[] parts;
            String spanIdDelimiter = ";";
            String traceIdPrefix = "Trace-Id=";
            for (String part : parts = traceIdStr.split(";")) {
                String[] split;
                if (!part.startsWith("Trace-Id=") || (split = part.split("=")).length != 2) continue;
                return split[1];
            }
        }
        return null;
    }

    private void handleLoginRequest(ContentCachingRequestWrapper wrappedRequest, ContentCachingResponseWrapper wrappedResponse, RequestContext context) throws IOException {
        String[] hosts = context.getHosts();
        List<String> ipHosts = Arrays.asList(hosts);
        ArrayList<String> failedHosts = new ArrayList<String>();
        MultiValueMap loginParams = this.parseRequestParams(wrappedRequest);
        String operatorCode = (String)loginParams.getFirst((Object)"operatorCode");
        String password = (String)loginParams.getFirst((Object)"password");
        if (operatorCode == null || password == null) {
            log.error(MultiplexErrorEnum.MISSING_LOGIN_PARAMS.getMsgTemplate());
            MultiplexResponse errorResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.MISSING_LOGIN_PARAMS.getMsgTemplate(), (String)context.getTraceId(), Collections.emptyList(), ipHosts, Collections.emptyList(), (String)MultiplexErrorEnum.MISSING_LOGIN_PARAMS.getErrorReason());
            this.sendResponse(wrappedResponse, HttpStatus.BAD_REQUEST.value(), (Object)errorResponse);
            return;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<LoginInfo> cacheLoginInfoList = new ArrayList<LoginInfo>();
        for (int i = 0; i < hosts.length; ++i) {
            String host = hosts[i];
            String normalizedHost = host.trim();
            try {
                LoginInfo loginInfo = this.forwardLoginRequest(normalizedHost, loginParams, context);
                if (loginInfo == null) continue;
                if (StringUtils.isBlank((CharSequence)loginInfo.getOperatorCode()) || StringUtils.isBlank((CharSequence)loginInfo.getTimeStamp())) {
                    failedHosts.add(normalizedHost);
                    results.add(loginInfo.getOriginalResponse());
                    log.info("\u8282\u70b9{}\u767b\u5f55\u5931\u8d25\uff0c\u5931\u8d25\u54cd\u5e94\u4e3a{}", (Object)normalizedHost, loginInfo.getOriginalResponse());
                    continue;
                }
                if (i == 0) {
                    String cacheKey = normalizedHost + ":" + loginInfo.getOperatorCode();
                    log.info("\u8282\u70b9{}\u767b\u5f55\u6210\u529f\uff0c\u5df2\u7f13\u5b58\uff08key\uff1a{}\uff09", (Object)normalizedHost, (Object)cacheKey);
                    this.loginCache.put(cacheKey, cacheLoginInfoList);
                    cacheLoginInfoList.add(loginInfo);
                } else {
                    cacheLoginInfoList.add(loginInfo);
                }
                results.add(loginInfo.getOriginalResponse());
                continue;
            }
            catch (Exception e) {
                failedHosts.add(normalizedHost);
                MultiplexResponse errorItem = MultiplexResponse.fail((String)MultiplexErrorEnum.LOGIN_FAILED.getMsgTemplate(), (String)context.getTraceId(), Collections.emptyList(), Collections.singletonList(normalizedHost), Collections.singletonList(normalizedHost), (String)MultiplexErrorEnum.LOGIN_FAILED.getErrorReason());
                results.add(errorItem);
                log.error("\u8282\u70b9{}\u767b\u5f55\u5931\u8d25", (Object)normalizedHost, (Object)e);
            }
        }
        boolean allSuccess = failedHosts.isEmpty();
        if (allSuccess) {
            log.info("\u672c\u6b21\u767b\u5f55\u90fd\u6210\u529f\u4e86\uff0c\u4e3b\u673a\u4fe1\u606f={}\uff0ctrace_id={}", ipHosts, (Object)context.getTraceId());
            this.sendResponse(wrappedResponse, HttpStatus.OK.value(), ((LoginInfo)cacheLoginInfoList.get(0)).getOriginalResponse());
        } else {
            MultiplexResponse finalResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.RESPONSE_NOT_EXPECTED.getMsgTemplate(), (String)context.getTraceId(), results, ipHosts, failedHosts, (String)MultiplexErrorEnum.RESPONSE_NOT_EXPECTED.getErrorReason());
            this.sendResponse(wrappedResponse, HttpStatus.BAD_REQUEST.value(), (Object)finalResponse);
        }
    }

    private boolean isLooseEqual(String str1, String str2) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{str1, str2})) {
            return true;
        }
        if (StringUtils.isBlank((CharSequence)str1) || StringUtils.isBlank((CharSequence)str2)) {
            return false;
        }
        HashSet set1 = new HashSet();
        Arrays.stream(str1.split(",")).map(String::trim).filter(StringUtils::isNotBlank).forEach(set1::add);
        HashSet set2 = new HashSet();
        Arrays.stream(str2.split(",")).map(String::trim).filter(StringUtils::isNotBlank).forEach(set2::add);
        return set1.equals(set2);
    }

    private void handleBusinessRequest(ContentCachingRequestWrapper wrappedRequest, ContentCachingResponseWrapper wrappedResponse, RequestContext context) throws IOException {
        String[] hosts = context.getHosts();
        List<String> ipHosts = Arrays.asList(hosts);
        ArrayList failedHosts = new ArrayList();
        ArrayList results = new ArrayList();
        String operatorCode = this.parseAndValidateOperatorCode(wrappedRequest, ipHosts, wrappedResponse, context);
        if (operatorCode == null) {
            return;
        }
        List loginInfoList = this.loadAndValidateLoginCache(hosts, operatorCode, ipHosts);
        Map loginInfoMap = this.convertLoginInfoListToMap(loginInfoList);
        List futures = this.submitParallelForwardTasks(hosts, wrappedRequest, context, loginInfoMap, failedHosts, results);
        if (!this.waitForTasksCompletion(futures, context, ipHosts, failedHosts, results, wrappedResponse)) {
            return;
        }
        this.buildFinalResponse(context, ipHosts, failedHosts, results, wrappedResponse);
    }

    private String parseAndValidateOperatorCode(ContentCachingRequestWrapper wrappedRequest, List<String> ipHosts, ContentCachingResponseWrapper wrappedResponse, RequestContext context) throws IOException {
        MultiValueMap params = this.parseRequestParams(wrappedRequest);
        String operatorCode = (String)params.getFirst((Object)"operator_code");
        if (operatorCode == null) {
            log.error(MultiplexErrorEnum.MISSING_OPERATOR_CODE.getMsgTemplate());
            MultiplexResponse errorResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.MISSING_OPERATOR_CODE.getMsgTemplate(), (String)context.getTraceId(), Collections.emptyList(), ipHosts, Collections.emptyList(), (String)MultiplexErrorEnum.MISSING_OPERATOR_CODE.getErrorReason());
            this.sendResponse(wrappedResponse, HttpStatus.BAD_REQUEST.value(), (Object)errorResponse);
            return null;
        }
        return operatorCode;
    }

    private List<LoginInfo> loadAndValidateLoginCache(String[] hosts, String operatorCode, List<String> ipHosts) {
        String host;
        String normalizedHost;
        String cacheKey;
        List loginInfoList = null;
        String ipHostsStr = StringUtils.join(ipHosts, (String)",");
        String[] stringArray = hosts;
        int n = stringArray.length;
        for (int i = 0; i < n && ((loginInfoList = (List)this.loginCache.get(cacheKey = (normalizedHost = (host = stringArray[i]).trim()) + ":" + operatorCode)) == null || loginInfoList.isEmpty()); ++i) {
        }
        if (loginInfoList == null || loginInfoList.isEmpty()) {
            throw new RuntimeException(MultiplexErrorEnum.NO_LOGIN_CACHE.formatMsg(new String[]{ipHostsStr}));
        }
        String loginHostsStr = loginInfoList.stream().map(LoginInfo::getHost).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        if (!this.isLooseEqual(loginHostsStr, ipHostsStr)) {
            throw new RuntimeException(MultiplexErrorEnum.HOST_MISMATCH.formatMsg(new String[]{ipHostsStr, loginHostsStr}));
        }
        boolean hasExpired = loginInfoList.stream().anyMatch(LoginInfo::isExpired);
        if (hasExpired) {
            throw new RuntimeException(MultiplexErrorEnum.LOGIN_CACHE_EXPIRED.formatMsg(new String[]{ipHostsStr}));
        }
        return loginInfoList;
    }

    private Map<String, LoginInfo> convertLoginInfoListToMap(List<LoginInfo> loginInfoList) {
        return loginInfoList.stream().filter(li -> StringUtils.isNotBlank((CharSequence)li.getHost())).collect(Collectors.toMap(LoginInfo::getHost, Function.identity(), (existing, replacement) -> existing));
    }

    private List<CompletableFuture<Void>> submitParallelForwardTasks(String[] hosts, ContentCachingRequestWrapper wrappedRequest, RequestContext context, Map<String, LoginInfo> loginInfoMap, List<String> failedHosts, List<Object> results) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (String host : hosts) {
            String normalizedHost = host.trim();
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    List list;
                    LoginInfo loginInfo = (LoginInfo)loginInfoMap.get(normalizedHost);
                    HostResponse hostResponse = this.forwardBusinessRequest(normalizedHost, wrappedRequest, loginInfo, context);
                    log.info("\u540e\u7aef\u670d\u52a1\u54cd\u5e94\u65e5\u5fd7 - \u4e3b\u673a\uff1a{}\uff0c\u72b6\u6001\u7801\uff1a{}\uff0c\u54cd\u5e94\u4f53\uff1a{}", new Object[]{normalizedHost, hostResponse.getStatusCode(), JSON.toJSONString((Object)hostResponse.getBody())});
                    boolean isExpected = this.validateResponse(hostResponse.getBody(), context.getTaExpected());
                    if (!isExpected) {
                        list = failedHosts;
                        synchronized (list) {
                            failedHosts.add(normalizedHost);
                        }
                        log.warn("\u8282\u70b9{}\u54cd\u5e94\u4e0d\u7b26\u5408\u9884\u671f{}", (Object)normalizedHost, (Object)context.getTaExpected());
                    }
                    list = results;
                    synchronized (list) {
                        results.add(hostResponse.getBody());
                    }
                }
                catch (Exception e) {
                    log.error("\u8282\u70b9{}\u4e1a\u52a1\u8bf7\u6c42\u5931\u8d25", (Object)normalizedHost, (Object)e);
                    MultiplexResponse errorItem = MultiplexResponse.fail((String)MultiplexErrorEnum.BUSINESS_REQUEST_FAILED.formatMsg(new String[]{e.getMessage()}), (String)context.getTraceId(), Collections.emptyList(), Collections.singletonList(normalizedHost), Collections.singletonList(normalizedHost), (String)MultiplexErrorEnum.BUSINESS_REQUEST_FAILED.getErrorReason());
                    List list = results;
                    synchronized (list) {
                        results.add(errorItem);
                    }
                    list = failedHosts;
                    synchronized (list) {
                        failedHosts.add(normalizedHost);
                    }
                }
            }, this.requestExecutor);
            futures.add(future);
        }
        return futures;
    }

    private boolean waitForTasksCompletion(List<CompletableFuture<Void>> futures, RequestContext context, List<String> ipHosts, List<String> failedHosts, List<Object> results, ContentCachingResponseWrapper wrappedResponse) throws IOException {
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).get(context.getTimeout(), TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException e) {
            log.error(MultiplexErrorEnum.REQUEST_TIMEOUT.getMsgTemplate());
            MultiplexResponse timeoutResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.REQUEST_TIMEOUT.getMsgTemplate(), (String)context.getTraceId(), results, ipHosts, failedHosts, (String)MultiplexErrorEnum.REQUEST_TIMEOUT.getErrorReason());
            this.sendResponse(wrappedResponse, HttpStatus.REQUEST_TIMEOUT.value(), (Object)timeoutResponse);
            return false;
        }
        catch (Exception e) {
            log.error(MultiplexErrorEnum.REQUEST_EXCEPTION.getMsgTemplate(), (Throwable)e);
            MultiplexResponse exceptionResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.REQUEST_EXCEPTION.formatMsg(new String[]{e.getMessage()}), (String)context.getTraceId(), results, ipHosts, failedHosts, (String)MultiplexErrorEnum.REQUEST_EXCEPTION.getErrorReason());
            this.sendResponse(wrappedResponse, HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)exceptionResponse);
            return false;
        }
    }

    private void buildFinalResponse(RequestContext context, List<String> ipHosts, List<String> failedHosts, List<Object> results, ContentCachingResponseWrapper wrappedResponse) throws IOException {
        boolean allExpected = failedHosts.isEmpty();
        MultiplexResponse finalResponse = allExpected ? MultiplexResponse.success((String)"\u6240\u6709\u4e3b\u673a\u54cd\u5e94\u7b26\u5408\u9884\u671f", (String)context.getTraceId(), results, ipHosts) : MultiplexResponse.fail((String)MultiplexErrorEnum.RESPONSE_NOT_EXPECTED.getMsgTemplate(), (String)context.getTraceId(), results, ipHosts, failedHosts, (String)MultiplexErrorEnum.RESPONSE_NOT_EXPECTED.getErrorReason());
        this.sendResponse(wrappedResponse, HttpStatus.OK.value(), (Object)finalResponse);
    }

    private LoginInfo forwardLoginRequest(String host, MultiValueMap<String, String> params, RequestContext context) {
        try {
            String url = "http://" + host + context.getRequestUri();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.add("X-Msg-Trace", context.getTraceId());
            headers.add("X-MULTIPLEX-URL", context.getMultiplexUrl());
            HttpEntity request = new HttpEntity(params, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                JSONObject result = JSON.parseObject((String)((String)response.getBody()));
                LoginInfo loginInfo = new LoginInfo();
                loginInfo.setHost(host);
                loginInfo.setLoginOperatorCode((String)params.getFirst((Object)"operatorCode"));
                loginInfo.setLoginPassword((String)params.getFirst((Object)"password"));
                loginInfo.setOperatorCode(result.getString("operator_code"));
                loginInfo.setTimeStamp(result.getString("timeStamp"));
                loginInfo.setSessionId(result.getString("sessionId"));
                loginInfo.setOriginalResponse((Object)result);
                loginInfo.setExpireTime(System.currentTimeMillis() + 3600000L);
                return loginInfo;
            }
            throw new RuntimeException(MultiplexErrorEnum.LOGIN_REQUEST_STATUS_ERROR.formatMsg(new String[]{String.valueOf(response.getStatusCodeValue())}));
        }
        catch (Exception e) {
            log.error("\u8f6c\u53d1\u767b\u5f55\u8bf7\u6c42\u5230{}\u5931\u8d25", (Object)host, (Object)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    private HostResponse forwardBusinessRequest(String host, ContentCachingRequestWrapper request, LoginInfo loginInfo, RequestContext context) throws Exception {
        String url = "http://" + host + request.getRequestURI();
        log.debug("\u5f00\u59cb\u8f6c\u53d1\u4e1a\u52a1\u8bf7\u6c42\uff0c\u76ee\u6807URL\uff1a{}", (Object)url);
        MultiValueMap params = this.parseRequestParams(request);
        this.replaceParams(params, loginInfo);
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if ("Ta-Hosts".equalsIgnoreCase(headerName) || "Expected".equalsIgnoreCase(headerName) || "Ta-Timeout".equalsIgnoreCase(headerName)) continue;
            headers.add(headerName, request.getHeader(headerName));
        }
        headers.add("X-Msg-Trace", context.getTraceId());
        headers.add("X-MULTIPLEX-URL", context.getMultiplexUrl());
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, String.class, new Object[0]);
        return new HostResponse(response.getStatusCodeValue(), JSON.parse((String)((String)response.getBody())));
    }

    private MultiValueMap<String, String> parseRequestParams(ContentCachingRequestWrapper request) {
        String[] pairs;
        String content;
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        byte[] contentBytes = request.getContentAsByteArray();
        if (contentBytes.length == 0) {
            log.debug("\u8bf7\u6c42\u4f53\u7f13\u5b58\u5b57\u8282\u6570\u7ec4\u4e3a\u7a7a\uff0c\u8fd4\u56de\u7a7a\u53c2\u6570");
            return params;
        }
        try {
            String charset = request.getCharacterEncoding();
            content = new String(contentBytes, charset != null ? charset : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.warn("\u4f7f\u7528\u6307\u5b9a\u7f16\u7801\u89e3\u6790\u8bf7\u6c42\u4f53\u5931\u8d25\uff0c\u9ed8\u8ba4\u4f7f\u7528UTF-8", (Throwable)e);
            content = new String(contentBytes, StandardCharsets.UTF_8);
        }
        for (String pair : pairs = content.split("&")) {
            if (pair.trim().isEmpty()) continue;
            String[] keyValue = pair.split("=", 2);
            try {
                String key = URLDecoder.decode(keyValue[0], "UTF-8");
                String value = keyValue.length == 2 ? URLDecoder.decode(keyValue[1], "UTF-8") : "";
                params.add((Object)key, (Object)value);
            }
            catch (UnsupportedEncodingException e) {
                log.warn("\u53c2\u6570\u89e3\u7801\u5931\u8d25\uff0c\u4f7f\u7528\u539f\u59cb\u503c\uff1a{}", (Object)pair, (Object)e);
                String key = keyValue[0];
                String value = keyValue.length == 2 ? keyValue[1] : "";
                params.add((Object)key, (Object)value);
            }
        }
        return params;
    }

    private void replaceParams(MultiValueMap<String, String> params, LoginInfo loginInfo) {
        if (!StringUtils.isNotBlank((CharSequence)loginInfo.getOperatorCode())) {
            throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_LOGIN_CACHE_PARAM.formatMsg(new String[]{"operator_code"}));
        }
        params.set((Object)"operator_code", (Object)loginInfo.getOperatorCode());
        if (!StringUtils.isNotBlank((CharSequence)loginInfo.getTimeStamp())) {
            throw new IllegalArgumentException(MultiplexErrorEnum.INVALID_LOGIN_CACHE_PARAM.formatMsg(new String[]{"timeStamp"}));
        }
        params.set((Object)"timeStamp", (Object)loginInfo.getTimeStamp());
    }

    private boolean validateResponse(Object responseBody, String taExpected) {
        String[] expectedConditions;
        if (taExpected == null || taExpected.trim().isEmpty()) {
            log.error("\u9884\u671f\u6761\u4ef6Expected\u4e3a\u7a7a\uff0c\u4e0d\u7b26\u5408\u6821\u9a8c\u8981\u6c42");
            return false;
        }
        JSONObject responseJson = JSON.parseObject((String)JSON.toJSONString((Object)responseBody));
        for (String condition : expectedConditions = taExpected.split(",")) {
            String expectedStr;
            String[] pathValue = condition.split("=", 2);
            if (pathValue.length != 2) {
                log.error("\u65e0\u6548\u7684\u9884\u671f\u6761\u4ef6\u683c\u5f0f\uff1a{}\uff0c\u6821\u9a8c\u5931\u8d25", (Object)condition);
                return false;
            }
            String path = pathValue[0].trim();
            String expectedValue = pathValue[1];
            Object actualValue = this.getValueByPath(responseJson, path);
            if (actualValue == null) {
                log.error("\u9884\u671f\u6761\u4ef6\u6821\u9a8c\u5931\u8d25\uff1a\u54cd\u5e94\u4e2d\u4e0d\u5b58\u5728\u8def\u5f84{}\uff0c\u65e0\u6cd5\u5339\u914d\u9884\u671f\u503c{}", (Object)path, (Object)expectedValue);
                return false;
            }
            String actualStr = actualValue.toString().trim();
            if (actualStr.equals(expectedStr = expectedValue.trim())) continue;
            log.error("\u9884\u671f\u6761\u4ef6\u4e0d\u6ee1\u8db3\uff0c\u8def\u5f84\uff1a{}\uff0c\u9884\u671f\u503c\uff1a{}\uff0c\u5b9e\u9645\u503c\uff1a{}", new Object[]{path, expectedStr.isEmpty() ? "[\u7a7a\u4e32]" : expectedStr, actualStr.isEmpty() ? "[\u7a7a\u4e32]" : actualStr});
            return false;
        }
        log.info("\u6240\u6709\u9884\u671f\u6761\u4ef6\u6821\u9a8c\u901a\u8fc7");
        return true;
    }

    private Object getValueByPath(JSONObject json, String path) {
        String[] segments = path.split("_");
        Object current = json;
        for (String segment : segments) {
            if (Character.isDigit(segment.charAt(0))) {
                try {
                    List list;
                    int index = Integer.parseInt(segment);
                    if (current instanceof List) {
                        list = (List)current;
                        if (index < 0 || index >= list.size()) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                    current = list.get(index);
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (current instanceof JSONObject) {
                current = current.get(segment);
                continue;
            }
            return null;
        }
        return current;
    }

    private int parseTimeout(String timeoutHeader) {
        if (timeoutHeader != null && !timeoutHeader.isEmpty()) {
            try {
                int timeout = Integer.parseInt(timeoutHeader);
                if (timeout > 0) {
                    return timeout;
                }
                log.warn(MultiplexErrorEnum.INVALID_TIMEOUT_VALUE.getMsgTemplate(), (Object)timeoutHeader);
            }
            catch (NumberFormatException e) {
                log.warn(MultiplexErrorEnum.INVALID_TIMEOUT_FORMAT.getMsgTemplate(), (Object)timeoutHeader, (Object)e);
            }
        }
        return 3000;
    }

    private void handleGlobalException(ContentCachingResponseWrapper wrappedResponse, Exception e, String traceId) throws IOException {
        log.error("\u591a\u73af\u5883\u8bf7\u6c42\u5904\u7406\u6d41\u7a0b\u5f02\u5e38", (Throwable)e);
        MultiplexResponse errorResponse = MultiplexResponse.fail((String)MultiplexErrorEnum.GLOBAL_PROCESS_EXCEPTION.formatMsg(new String[]{e.getMessage()}), (String)traceId, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (String)MultiplexErrorEnum.GLOBAL_PROCESS_EXCEPTION.getErrorReason());
        this.sendResponse(wrappedResponse, HttpStatus.INTERNAL_SERVER_ERROR.value(), (Object)errorResponse);
    }

    private void sendResponse(ContentCachingResponseWrapper response, int status, Object responseBody) throws IOException {
        response.setStatus(status);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        String jsonStr = JSON.toJSONString((Object)responseBody);
        response.getWriter().write(Encode.forHtml((String)jsonStr));
    }

    public void destroy() {
        this.requestExecutor.shutdown();
        this.cacheCleanExecutor.shutdown();
        try {
            if (!this.requestExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.requestExecutor.shutdownNow();
            }
            if (!this.cacheCleanExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cacheCleanExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.requestExecutor.shutdownNow();
            this.cacheCleanExecutor.shutdownNow();
        }
    }
}

