/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.executor;

import com.hundsun.lightdb.ukagent.bean.DbType;
import com.hundsun.lightdb.ukagent.executor.SqlExecutor;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"SQL_INJECTION_JDBC"})
public class SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger(SqlExecutor.class);
    private static final String UNISQL_DRIVER_CLASS = "com.hundsun.lightdb.unisql.proxy.Driver";
    private static final String TARGET_ORACLE_DB_TYPES = String.join((CharSequence)",", DbType.LIGHTDB_ORACLE.name().toLowerCase(), DbType.GAUSSDB_ORACLE.name().toLowerCase(), DbType.OCEAN_BASE_ORACLE.name().toLowerCase(), DbType.DM.name().toLowerCase(), DbType.ORACLE.name().toLowerCase());
    private static final String PROMPT_STATEMENT_REGEX = "^(?i)\\s*prompt\\s*.*";
    private static final String PL_SQL_BLOCK_REGEX = "^(?i)(declare|begin|create\\s+(or\\s+replace\\s+)?((editionable|noneditionable)\\s+)?(type|procedure|package|function|trigger))\\s.*";
    private static final String PL_SQL_END_DELIMITER = "/";
    private static final String SQL_END_DELIMITER = ";";
    private static final String SINGLE_LINE_COMMENT_PREFIX = "--";
    private static final String MULTI_LINE_COMMENT_START = "/*";
    private static final String MULTI_LINE_COMMENT_END = "*/";
    private static final Pattern PROMPT_STATEMENT_PATTERN = Pattern.compile("^(?i)\\s*prompt\\s*.*");
    private static final Pattern PL_SQL_BLOCK_PATTERN = Pattern.compile("^(?i)(declare|begin|create\\s+(or\\s+replace\\s+)?((editionable|noneditionable)\\s+)?(type|procedure|package|function|trigger))\\s.*", 32);

    public static Map<Integer, String> parseSqlScript(String filePath, String targetDialect) {
        log.info("\u5f00\u59cb\u89e3\u6790SQL\u811a\u672c\u6587\u4ef6\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c\u76ee\u6807\u6570\u636e\u5e93\u65b9\u8a00\uff1a{}", (Object)filePath, (Object)targetDialect);
        LinkedHashMap<Integer, String> lineNumToSqlMap = new LinkedHashMap<Integer, String>(32);
        SqlParseContext context = new SqlParseContext();
        StringBuilder currentSql = new StringBuilder();
        String formattedFilePath = String.format(filePath + "%s", "");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(formattedFilePath), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                ++context.currentLineNum;
                String trimmedLine = line.trim();
                SqlExecutor.processLine((String)trimmedLine, (SqlParseContext)context, lineNumToSqlMap, (StringBuilder)currentSql, (String)targetDialect);
            }
            SqlExecutor.processRemainingSql((SqlParseContext)context, (StringBuilder)currentSql, lineNumToSqlMap);
            log.info("SQL\u811a\u672c\u6587\u4ef6\u89e3\u6790\u5b8c\u6210\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}\uff0c\u5171\u89e3\u6790\u51fa{}\u6761SQL\u8bed\u53e5", (Object)filePath, (Object)lineNumToSqlMap.size());
        }
        catch (IOException e) {
            log.error("\u89e3\u6790SQL\u811a\u672c\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\uff1a{}", (Object)filePath, (Object)e);
        }
        return lineNumToSqlMap;
    }

    private static void processLine(String trimmedLine, SqlParseContext context, Map<Integer, String> lineNumToSqlMap, StringBuilder currentSql, String targetDialect) {
        if (trimmedLine.isEmpty() || SqlExecutor.skipComments((String)trimmedLine, (SqlParseContext)context)) {
            return;
        }
        if (SqlExecutor.isPromptStatement((String)trimmedLine, (String)targetDialect)) {
            log.debug("\u884c\u53f7{}\uff1a\u8bc6\u522b\u5230prompt\u8bed\u53e5\uff0c\u5185\u5bb9\uff1a{}", (Object)context.currentLineNum, (Object)trimmedLine);
            lineNumToSqlMap.put(context.currentLineNum, trimmedLine);
            return;
        }
        SqlExecutor.appendAndProcessSql((String)trimmedLine, (SqlParseContext)context, lineNumToSqlMap, (StringBuilder)currentSql, (String)targetDialect);
    }

    private static boolean skipComments(String trimmedLine, SqlParseContext context) {
        if (context.multiLineCommentCount > 0) {
            log.trace("\u884c\u53f7{}\uff1a\u5904\u4e8e\u591a\u884c\u6ce8\u91ca\u4e2d\uff0c\u5185\u5bb9\uff1a{}", (Object)context.currentLineNum, (Object)trimmedLine);
            if (trimmedLine.endsWith("*/")) {
                --context.multiLineCommentCount;
                log.trace("\u884c\u53f7{}\uff1a\u9000\u51fa\u591a\u884c\u6ce8\u91ca\uff0c\u5f53\u524d\u5d4c\u5957\u5c42\u7ea7\uff1a{}", (Object)context.currentLineNum, (Object)context.multiLineCommentCount);
            } else if (trimmedLine.startsWith("/*")) {
                ++context.multiLineCommentCount;
                log.trace("\u884c\u53f7{}\uff1a\u8fdb\u5165\u5d4c\u5957\u591a\u884c\u6ce8\u91ca\uff0c\u5f53\u524d\u5d4c\u5957\u5c42\u7ea7\uff1a{}", (Object)context.currentLineNum, (Object)context.multiLineCommentCount);
            }
            return true;
        }
        if (trimmedLine.startsWith("/*")) {
            log.trace("\u884c\u53f7{}\uff1a\u8bc6\u522b\u5230\u591a\u884c\u6ce8\u91ca\u5f00\u59cb\uff0c\u5185\u5bb9\uff1a{}", (Object)context.currentLineNum, (Object)trimmedLine);
            if (!trimmedLine.endsWith("*/")) {
                ++context.multiLineCommentCount;
                log.trace("\u884c\u53f7{}\uff1a\u8fdb\u5165\u591a\u884c\u6ce8\u91ca\uff0c\u5d4c\u5957\u5c42\u7ea7\uff1a{}", (Object)context.currentLineNum, (Object)context.multiLineCommentCount);
            }
            return true;
        }
        if (trimmedLine.startsWith("--")) {
            log.trace("\u884c\u53f7{}\uff1a\u8df3\u8fc7\u5355\u884c\u6ce8\u91ca\uff0c\u5185\u5bb9\uff1a{}", (Object)context.currentLineNum, (Object)trimmedLine);
            return true;
        }
        return false;
    }

    private static void appendAndProcessSql(String trimmedLine, SqlParseContext context, Map<Integer, String> lineNumToSqlMap, StringBuilder currentSql, String targetDialect) {
        if (context.inPlSqlBlock) {
            if ("/".equals(trimmedLine)) {
                SqlExecutor.handlePlSqlEnd((SqlParseContext)context, (String)currentSql.toString().trim(), lineNumToSqlMap, (StringBuilder)currentSql);
            } else {
                currentSql.append(trimmedLine).append("\n");
                log.trace("\u884c\u53f7{}\uff1aPL/SQL\u5757\u5185\u62fc\u63a5\uff0c\u5f53\u524d\u5185\u5bb9\uff1a{}", (Object)context.currentLineNum, (Object)currentSql.toString().trim());
            }
            return;
        }
        String sqlPart = SqlExecutor.splitSqlAndComment((String)trimmedLine, (SqlParseContext)context);
        if (sqlPart.isEmpty()) {
            log.trace("\u884c\u53f7{}\uff1a\u5206\u79bb\u6ce8\u91ca\u540e\u65e0\u6709\u6548SQL\u5185\u5bb9\uff0c\u8df3\u8fc7", (Object)context.currentLineNum);
            return;
        }
        if (currentSql.length() == 0) {
            context.sqlStartLineNum = context.currentLineNum;
            log.trace("\u884c\u53f7{}\uff1a\u5f00\u59cb\u89e3\u6790\u65b0SQL\u8bed\u53e5", (Object)context.sqlStartLineNum);
        }
        currentSql.append(sqlPart).append("\n");
        String currentSqlTrimmed = currentSql.toString().trim();
        SqlExecutor.handleNormalSql((SqlParseContext)context, (String)currentSqlTrimmed, (String)sqlPart, lineNumToSqlMap, (StringBuilder)currentSql, (String)targetDialect);
    }

    private static String splitSqlAndComment(String trimmedLine, SqlParseContext context) {
        if (!trimmedLine.contains(";")) {
            return trimmedLine;
        }
        int semicolonIndex = trimmedLine.lastIndexOf(";");
        if (semicolonIndex == -1) {
            return trimmedLine;
        }
        String afterSemicolon = trimmedLine.substring(semicolonIndex + 1).trim();
        if (afterSemicolon.startsWith("--")) {
            String sqlPart = trimmedLine.substring(0, semicolonIndex + 1).trim();
            log.trace("\u884c\u53f7{}\uff1a\u5206\u79bb\u5206\u53f7\u540e\u6ce8\u91ca\uff0c\u539f\u59cb\u884c\uff1a{}\uff0c\u5206\u79bb\u540eSQL\uff1a{}\uff0c\u6ce8\u91ca\uff1a{}", new Object[]{context.currentLineNum, trimmedLine, sqlPart, afterSemicolon});
            return sqlPart;
        }
        return trimmedLine;
    }

    private static void handlePlSqlEnd(SqlParseContext context, String plSqlBody, Map<Integer, String> lineNumToSqlMap, StringBuilder currentSql) {
        log.info("\u884c\u53f7{}\uff1a\u8bc6\u522b\u5230PL/SQL\u5757\u7ed3\u675f\u7b26\uff08\u72ec\u7acb /\uff09\uff0c\u8d77\u59cb\u884c\u53f7\uff1a{}", (Object)context.currentLineNum, (Object)context.sqlStartLineNum);
        if (StringUtils.isBlank((CharSequence)plSqlBody)) {
            log.warn("\u884c\u53f7{}\uff1aPL/SQL\u5757\u7ed3\u675f\u7b26\u540e\u65e0\u6709\u6548\u5185\u5bb9\uff0c\u8df3\u8fc7", (Object)context.currentLineNum);
            context.inPlSqlBlock = false;
            currentSql.setLength(0);
            return;
        }
        lineNumToSqlMap.put(context.sqlStartLineNum, plSqlBody);
        log.info("\u884c\u53f7{}\uff1aPL/SQL\u5757\u5904\u7406\u5b8c\u6210\uff0c\u5df2\u79fb\u9664\u7ed3\u5c3e /\uff0c\u6700\u7ec8SQL\uff1a{}", (Object)context.sqlStartLineNum, (Object)plSqlBody);
        context.inPlSqlBlock = false;
        currentSql.setLength(0);
    }

    private static void handleNormalSql(SqlParseContext context, String currentSqlTrimmed, String sqlPart, Map<Integer, String> lineNumToSqlMap, StringBuilder currentSql, String targetDialect) {
        if (SqlExecutor.isPlSqlBlock((String)currentSqlTrimmed, (String)targetDialect)) {
            context.inPlSqlBlock = true;
            log.debug("\u884c\u53f7{}\uff1a\u8bc6\u522b\u5230PL/SQL\u5757\u5f00\u59cb\uff0c\u8d77\u59cb\u884c\u53f7\uff1a{}", (Object)context.currentLineNum, (Object)context.sqlStartLineNum);
        } else if (sqlPart.endsWith(";")) {
            lineNumToSqlMap.put(context.sqlStartLineNum, currentSqlTrimmed);
            log.trace("\u884c\u53f7{}\uff1a\u666e\u901aSQL\u5904\u7406\u5b8c\u6210\uff0c\u5185\u5bb9\uff1a{}", (Object)context.sqlStartLineNum, (Object)currentSqlTrimmed);
            currentSql.setLength(0);
        } else if ("/".equals(sqlPart)) {
            log.debug("\u884c\u53f7{}\uff1a\u7279\u6b8aSQL\u7ed3\u675f\uff08/\u5206\u9694\uff09\uff0c\u8d77\u59cb\u884c\u53f7\uff1a{}", (Object)context.currentLineNum, (Object)context.sqlStartLineNum);
            SqlExecutor.handleSpecialSql((int)context.sqlStartLineNum, (String)currentSqlTrimmed, lineNumToSqlMap);
            currentSql.setLength(0);
        }
    }

    private static void handleSpecialSql(int sqlStartLineNum, String currentSqlTrimmed, Map<Integer, String> lineNumToSqlMap) {
        if (currentSqlTrimmed.isEmpty()) {
            log.trace("\u884c\u53f7{}\uff1a\u7279\u6b8aSQL\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8df3\u8fc7", (Object)sqlStartLineNum);
            return;
        }
        String sql = currentSqlTrimmed.substring(0, currentSqlTrimmed.length() - 1).trim();
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            lineNumToSqlMap.put(sqlStartLineNum, sql);
            log.trace("\u884c\u53f7{}\uff1a\u7279\u6b8aSQL\u5904\u7406\u5b8c\u6210\uff0c\u5df2\u79fb\u9664\u7ed3\u5c3e /\uff0c\u5185\u5bb9\uff1a{}", (Object)sqlStartLineNum, (Object)sql);
        }
    }

    private static void processRemainingSql(SqlParseContext context, StringBuilder currentSql, Map<Integer, String> lineNumToSqlMap) {
        String remainingSql = currentSql.toString().trim();
        if (StringUtils.isNotBlank((CharSequence)remainingSql)) {
            log.debug("\u6587\u4ef6\u89e3\u6790\u5b8c\u6bd5\uff0c\u5b58\u5728\u672a\u7ed3\u675f\u7684SQL\u8bed\u53e5\uff0c\u8d77\u59cb\u884c\u53f7\uff1a{}", (Object)context.sqlStartLineNum);
            lineNumToSqlMap.put(context.sqlStartLineNum, remainingSql);
            log.trace("\u672a\u7ed3\u675fSQL\u5904\u7406\u5b8c\u6210\uff0c\u5185\u5bb9\uff1a{}", (Object)remainingSql);
            currentSql.setLength(0);
        }
    }

    public static boolean isPromptStatement(String sql, String targetDialect) {
        if (targetDialect == null || !TARGET_ORACLE_DB_TYPES.contains(targetDialect.toLowerCase())) {
            log.trace("\u76ee\u6807\u6570\u636e\u5e93\u65b9\u8a00{}\u4e0d\u5c5e\u4e8eOracle\u7cfb\uff0c\u4e0d\u652f\u6301prompt\u8bed\u53e5,sql={}", (Object)targetDialect, (Object)sql);
            return false;
        }
        Matcher matcher = PROMPT_STATEMENT_PATTERN.matcher(sql);
        boolean isPrompt = matcher.matches();
        log.trace("\u5224\u65ad\u662f\u5426\u4e3aprompt\u8bed\u53e5\uff0cSQL\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)sql, (Object)isPrompt);
        return isPrompt;
    }

    public static boolean isPlSqlBlock(String sql, String targetDialect) {
        if (targetDialect == null || !TARGET_ORACLE_DB_TYPES.contains(targetDialect.toLowerCase())) {
            log.trace("\u76ee\u6807\u6570\u636e\u5e93\u65b9\u8a00{}\u4e0d\u5c5e\u4e8eOracle\u7cfb\uff0c\u4e0d\u652f\u6301PL/SQL\u5757", (Object)targetDialect);
            return false;
        }
        Matcher matcher = PL_SQL_BLOCK_PATTERN.matcher(sql);
        boolean isPlSql = matcher.find();
        log.trace("\u5224\u65ad\u662f\u5426\u4e3aPL/SQL\u5757\uff0cSQL\uff1a{}\uff0c\u7ed3\u679c\uff1a{}", (Object)sql, (Object)isPlSql);
        return isPlSql;
    }

    public static void executeSql(String jdbcUrl, String username, String password, ArrayList<String> sqlList, String traceId, String targetDb) throws Exception {
        log.info("traceId={}\uff0c\u5f00\u59cb\u6267\u884c\u76ee\u6807\u5e93{}\u7684SQL\uff0c\u5171{}\u6761\u8bed\u53e5\uff0cJDBC URL\uff1a{}", new Object[]{traceId, targetDb, sqlList.size(), jdbcUrl});
        try {
            Class.forName("com.hundsun.lightdb.unisql.proxy.Driver");
            log.debug("traceId={}\uff0c\u6210\u529f\u52a0\u8f7dUnisql\u9a71\u52a8\uff1a{}", (Object)traceId, (Object)"com.hundsun.lightdb.unisql.proxy.Driver");
        }
        catch (ClassNotFoundException e) {
            String errorMsg = String.format("\u76ee\u6807\u5e93%s\uff1a\u52a0\u8f7dUnisql\u9a71\u52a8\u5931\u8d25\uff0c\u9a71\u52a8\u7c7b\uff1a%s", targetDb, "com.hundsun.lightdb.unisql.proxy.Driver");
            log.error("traceId={}\uff0c{}", new Object[]{traceId, errorMsg, e});
            throw new Exception(errorMsg, e);
        }
        try (Connection conn = DriverManager.getConnection(jdbcUrl, username, password);
             Statement stmt = conn.createStatement();){
            log.info("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u6570\u636e\u5e93\u8fde\u63a5\u6210\u529f\uff0c\u7528\u6237\u540d\uff1a{}", new Object[]{traceId, targetDb, username});
            for (int i = 0; i < sqlList.size(); ++i) {
                String sql = sqlList.get(i);
                if (SqlExecutor.isPromptStatement((String)sql, (String)targetDb)) {
                    log.info("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u7b2c{}\u6761\u4e3aprompt\u8bed\u53e5\uff0c\u8df3\u8fc7\u6267\u884c\uff0c\u5185\u5bb9\uff1a{}", new Object[]{traceId, targetDb, i + 1, sql});
                    continue;
                }
                log.debug("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u6267\u884c\u7b2c{}\u6761SQL\uff0c\u5185\u5bb9\uff1a{}", new Object[]{traceId, targetDb, i + 1, sql});
                try {
                    boolean isResultSet = stmt.execute(sql);
                    if (isResultSet) {
                        log.info("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u7b2c{}\u6761SQL\u6267\u884c\u6210\u529f\uff08\u67e5\u8be2\u8bed\u53e5\uff09", new Object[]{traceId, targetDb, i + 1});
                        continue;
                    }
                    int updateCount = stmt.getUpdateCount();
                    log.info("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u7b2c{}\u6761SQL\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u884c\u6570\uff1a{}", new Object[]{traceId, targetDb, i + 1, updateCount});
                    continue;
                }
                catch (Exception e) {
                    String errorMsg = String.format("\u76ee\u6807\u5e93%s\uff1a\u7b2c%d\u6761SQL\u6267\u884c\u5931\u8d25\uff0cSQL\u5185\u5bb9\uff1a%s", targetDb, i + 1, sql);
                    log.error("traceId={}\uff0c{}", new Object[]{traceId, errorMsg, e});
                    throw new Exception(errorMsg, e);
                }
            }
            log.info("traceId={}\uff0c\u76ee\u6807\u5e93{}\uff1a\u6240\u6709{}\u6761SQL\u6267\u884c\u5b8c\u6bd5", new Object[]{traceId, targetDb, sqlList.size()});
        }
        catch (Exception e) {
            String errorMsg = String.format("\u76ee\u6807\u5e93%s\uff1a\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25\uff08\u8fde\u63a5/Statement\u521b\u5efa\uff09", targetDb);
            log.error("traceId={}\uff0c{}\uff0cJDBC URL\uff1a{}\uff0c\u7528\u6237\u540d\uff1a{}", new Object[]{traceId, errorMsg, jdbcUrl, username, e});
            throw new Exception(errorMsg, e);
        }
    }
}

