/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.hundsun.lightdb.ukagent.config.DataSourceProperties;
import com.hundsun.lightdb.ukagent.config.UuidSyncProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AgentInitConfig {
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private UuidSyncProperties uuidSyncProperties;

    @Bean(name={"syncdatasources"})
    public Map<String, DataSource> dataSources() {
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>(16);
        List dbConfigs = this.dataSourceProperties.getSources();
        if (dbConfigs != null && !dbConfigs.isEmpty()) {
            for (DataSourceProperties.DbConfig config : dbConfigs) {
                DruidDataSource dataSource = new DruidDataSource();
                dataSource.setUrl(config.getUrl());
                dataSource.setUsername(config.getUsername());
                dataSource.setPassword(config.getPassword());
                dataSource.setDriverClassName(config.getDriverClassName());
                dataSource.setInitialSize(config.getInitialSize());
                dataSource.setMaxActive(config.getMaxActive());
                dataSource.setMinIdle(config.getMinIdle());
                dataSource.setMaxWait(config.getMaxWait());
                dataSource.setValidationQuery(config.getValidationQuery());
                dataSources.put(config.getName().toLowerCase(), (DataSource)dataSource);
            }
        }
        return dataSources;
    }
}

