/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex;

import com.hundsun.lightdb.unisql.model.MultiplexContext;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/*"})
public class MultiplexFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MultiplexFilter.class);
    public static final String X_MSG_TRACE = "X-Msg-Trace";
    public static final String X_MULTIPLEX_USERNAME = "X-MULTIPLEX-USERNAME";
    public static final String X_MULTIPLEX_URL = "X-MULTIPLEX-URL";
    private static final String EQUAL = "=";
    public static final int INT_2 = 2;
    public static final int INT_1 = 1;

    public MultiplexFilter() {
        log.info("MultiplexFilter \u5b9e\u4f8b\u5316\u5b8c\u6210");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String traceIdHeader = httpRequest.getHeader(X_MSG_TRACE);
        String traceId = this.extractTraceId(traceIdHeader);
        if (StringUtils.isNotBlank((CharSequence)traceId)) {
            MultiplexContext.setRealMultiplexTraceId((String)traceId);
        } else if (log.isWarnEnabled()) {
            log.warn("\u7ebf\u7a0b [{}] \u4ece\u8bf7\u6c42\u5934\u83b7\u53d6\u7684 traceId \u65e0\u6548 [{}]\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a [{}]", new Object[]{Thread.currentThread().getName(), traceIdHeader, httpRequest.getRequestURI()});
        }
        String username = httpRequest.getHeader(X_MULTIPLEX_USERNAME);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            MultiplexContext.setMultiUsername((String)username);
        } else if (log.isWarnEnabled()) {
            log.warn("\u7ebf\u7a0b [{}] \u672a\u83b7\u53d6\u5230 username\uff0c\u8bf7\u6c42\u5730\u5740\u4e3a [{}]", (Object)Thread.currentThread().getName(), (Object)httpRequest.getRequestURI());
        }
        String url = httpRequest.getHeader(X_MULTIPLEX_URL);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            MultiplexContext.setMultiUrl((String)url);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("\u7ebf\u7a0b [{}] \u672a\u83b7\u53d6\u5230 {}\uff0c\u4f7f\u7528\u8bf7\u6c42\u5730\u5740 URI [{}]", new Object[]{Thread.currentThread().getName(), X_MULTIPLEX_URL, httpRequest.getRequestURI()});
            }
            MultiplexContext.setMultiUrl((String)(httpRequest.getMethod() + " " + httpRequest.getRequestURI()));
        }
        filterChain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        MultiplexContext.removeRealMultiplexTraceId();
        MultiplexContext.removeMultiUsername();
    }

    private String extractTraceId(String traceIdStr) {
        if (StringUtils.isNotBlank((CharSequence)traceIdStr)) {
            String[] parts;
            String spanIdDelimiter = ";";
            String traceIdPrefix = "Trace-Id=";
            for (String part : parts = traceIdStr.split(";")) {
                String[] split;
                if (!part.startsWith("Trace-Id=") || (split = part.split(EQUAL)).length != 2) continue;
                return split[1];
            }
        }
        return null;
    }
}

