/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.utils;

import com.hundsun.lightdb.dbabrun.bean.CompareMessageEntity;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.dbabrun.util.SpringContextUtils;
import com.hundsun.lightdb.multiplex.service.dbactuator.CommonActuatorStrategy;
import com.hundsun.lightdb.unisql.annotation.SuppressFBWarnings;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonUtils {
    private static final Logger log = LoggerFactory.getLogger(CommonUtils.class);
    private static final Logger consoleLogger = LoggerFactory.getLogger((String)"ConsoleLogger");
    private static final String DEFAULT_EMPTY = "";
    public static final List<DbType> LOAD_METADATA_LIST = new ArrayList();

    public static String getTestCasesDirectory() {
        String dir = System.getProperty("unisql.testcases.path");
        if (StringUtils.isBlank((CharSequence)dir)) {
            dir = "";
        }
        return dir;
    }

    public static String getTestCasesSource() {
        String source = System.getProperty("unisql.testcases.src");
        if (StringUtils.isBlank((CharSequence)source)) {
            return "";
        }
        return source;
    }

    public static Boolean needRunCase(String targetDbCaseSrc) {
        String caseSource = CommonUtils.getTestCasesSource();
        if (StringUtils.isBlank((CharSequence)caseSource) || StringUtils.equalsIgnoreCase((CharSequence)caseSource, (CharSequence)targetDbCaseSrc)) {
            return true;
        }
        return false;
    }

    public static void parseExcludeRuleFile() {
        String excludePath = SpringContextUtils.getConfigProperty((String)"unisql.exclude.directory");
        String formatExcludePath = String.format(excludePath + "%s", FilenameUtils.getName((String)""));
        if (StringUtils.isBlank((CharSequence)formatExcludePath)) {
            log.info("unisql.exclude.directory \u672a\u914d\u7f6e\uff0c\u5ffd\u7565\u6392\u9664\u89c4\u5219\u521d\u59cb\u5316");
            return;
        }
        File directory = new File(formatExcludePath = String.format(formatExcludePath + "%s", FilenameUtils.getName((String)"")));
        if (!directory.exists() || !directory.isDirectory()) {
            log.info("unisql.exclude.directory \u914d\u7f6e\u7684\u76ee\u5f55\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u76ee\u5f55 [{}]", (Object)directory.getAbsolutePath());
            return;
        }
        Object[] files = directory.listFiles();
        if (ArrayUtils.isEmpty((Object[])files)) {
            log.info("unisql.exclude.directory \u914d\u7f6e\u7684\u76ee\u5f55\u4e3a\u7a7a [{}]", (Object)directory.getAbsolutePath());
            return;
        }
        for (Object file : files) {
            if (!((File)file).isFile()) {
                log.warn("\u5ffd\u7565\u975e\u6587\u4ef6\u8def\u5f84 [{}]", (Object)((File)file).getAbsolutePath());
                continue;
            }
            try (BufferedReader reader = Files.newBufferedReader(((File)file).toPath());){
                String lineContent;
                if (reader == null) continue;
                while ((lineContent = reader.readLine()) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u8bfb\u53d6\u89c4\u5219\u884c\u5185\u5bb9 [{}]", (Object)lineContent);
                    }
                    try {
                        Transformer.initTableMetas((String)lineContent);
                    }
                    catch (Exception e) {
                        log.warn("\u5ffd\u7565\u9519\u8bef\u7684\u884c\u5185\u5bb9 [{}] [{}]", (Object)lineContent, (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) continue;
                String msg = e.getMessage();
                String errorMsg = String.format("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25 %s %s", formatExcludePath, msg);
                log.error(errorMsg);
            }
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT", "COMMAND_INJECTION"})
    public static String getLogPath() {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        String logPath = context.getConfiguration().getStrSubstitutor().getVariableResolver().lookup("log-path");
        File logDir = new File(logPath);
        return logDir.getAbsolutePath();
    }

    public static void parserCommentInfo(CompareMessageEntity compareMessage) {
        if (StringUtils.isBlank((CharSequence)compareMessage.getSourceSql())) {
            log.error("\u8bfb\u53d6sql\u6587\u4ef6{}\u5931\u8d25\uff0c\u65e0\u6cd5\u8bfb\u53d6\u5230\u6267\u884csql", (Object)compareMessage.getFilename());
            return;
        }
        String execSqlId = compareMessage.getExecSqlId();
        StringBuffer commentInfo = new StringBuffer();
        StringBuffer newSql = new StringBuffer();
        String[] sourceSql = compareMessage.getSourceSql().split("\n");
        if (StringUtils.isBlank((CharSequence)execSqlId)) {
            String firstSourceSql = compareMessage.isNewTestFile() ? sourceSql[0].trim() : sourceSql[0];
            if (firstSourceSql.startsWith("-- ")) {
                compareMessage.setExecSqlId(firstSourceSql.replaceFirst("-- ", ""));
            } else {
                compareMessage.setExecSqlId(firstSourceSql);
            }
        }
        boolean isComment = true;
        for (int i = 0; i < sourceSql.length; ++i) {
            String rowString = sourceSql[i];
            if (isComment = isComment && rowString.startsWith("-- ")) {
                commentInfo.append(rowString);
                commentInfo.append("\n");
                continue;
            }
            newSql.append(rowString);
            newSql.append("\n");
        }
        if (StringUtils.isNotBlank((CharSequence)newSql)) {
            compareMessage.setSourceSql(newSql.substring(0, newSql.length() - 1));
        }
        if (StringUtils.isNotBlank((CharSequence)commentInfo)) {
            compareMessage.setCommentInfo(commentInfo.substring(0, commentInfo.length() - 1));
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT", "COMMAND_INJECTION"})
    public static boolean existExpectedPreparedFile(DbType sourceDb, DbType targetDb, String filename) {
        String localUnisqlSentencePath = CommonUtils.getTestCasesDirectory();
        String prepareFilePath = com.hundsun.lightdb.dbabrun.util.CommonUtils.getFullFilePath((String)localUnisqlSentencePath, (DbType)sourceDb, (DbType)targetDb, (String)"expected", (String)("prepared-" + filename), (String)"out");
        File prepareFile = new File(prepareFilePath);
        return prepareFile.exists();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "PATH_TRAVERSAL_OUT", "COMMAND_INJECTION"})
    public static boolean needExecSqlFile(DbType sourceDb, DbType targetDb, String filename) {
        if (StringUtils.isBlank((CharSequence)filename)) {
            return false;
        }
        if (!filename.endsWith(".sql")) {
            return false;
        }
        String localUnisqlSentencePath = CommonUtils.getTestCasesDirectory();
        String expectedFilePath = com.hundsun.lightdb.dbabrun.util.CommonUtils.getFullFilePath((String)localUnisqlSentencePath, (DbType)sourceDb, (DbType)targetDb, (String)"expected", (String)filename, (String)"out");
        File expectedFile = new File(expectedFilePath);
        return expectedFile.exists();
    }

    public static void executeInit(File rootCaseDir) {
        String mysqlInit = String.join((CharSequence)File.separator, rootCaseDir.getAbsolutePath(), "init", "mysql_init.sql");
        String oracleInit = String.join((CharSequence)File.separator, rootCaseDir.getAbsolutePath(), "init", "oracle_init.sql");
        AbstractActuator oracleActuator = CommonActuatorStrategy.getInstance().getActuator(DbType.ORACLE);
        AbstractActuator mysqlActuator = CommonActuatorStrategy.getInstance().getActuator(DbType.MYSQL);
        CommonUtils.executeScript((String)mysqlInit, (AbstractActuator)mysqlActuator);
        CommonUtils.executeScript((String)oracleInit, (AbstractActuator)oracleActuator);
    }

    public static void executeDestroy(File rootCaseDir) {
        String mysqlDestroy = String.join((CharSequence)File.separator, rootCaseDir.getAbsolutePath(), "init", "mysql_destroy.sql");
        String oracleDestroy = String.join((CharSequence)File.separator, rootCaseDir.getAbsolutePath(), "init", "oracle_destroy.sql");
        AbstractActuator oracleActuator = CommonActuatorStrategy.getInstance().getActuator(DbType.ORACLE);
        AbstractActuator mysqlActuator = CommonActuatorStrategy.getInstance().getActuator(DbType.MYSQL);
        CommonUtils.executeScript((String)mysqlDestroy, (AbstractActuator)mysqlActuator);
        CommonUtils.executeScript((String)oracleDestroy, (AbstractActuator)oracleActuator);
    }

    public static void executeScript(String sqlPath, AbstractActuator actuator) {
        String sqlFilePath = String.format(sqlPath + "%s", FilenameUtils.getName((String)""));
        File sqlFile = new File(sqlFilePath);
        if (!sqlFile.exists()) {
            log.info("\u6267\u884c\u6587\u4ef6\u4e0d\u5b58\u5728{}", (Object)sqlPath);
            return;
        }
        List sqlQueries = CommonUtils.readSqlQueriesFromFile((File)sqlFile);
        for (String sql : sqlQueries) {
            log.info("\u51c6\u5907\u6267\u884c SQL: {}", (Object)sql);
            try {
                actuator.doMultiplexUpdate(actuator.getTargetDB(), sql);
                if (!log.isDebugEnabled()) continue;
                log.debug("[{}]{}SQL\u6267\u884c\u6210\u529f [{}]", (Object)sqlPath, (Object)sql);
            }
            catch (Exception e) {
                log.error("[{}]SQL\u5728\u6570\u636e\u5e93\u6267\u884c\u5931\u8d25\uff0cSQL\u4e3a{} \u62a5\u9519\u4e3a{}", new Object[]{sqlPath, sql, e});
            }
        }
    }

    public static List<String> readSqlQueriesFromFile(File sqlFile) {
        ArrayList<String> sqlQueries = new ArrayList<String>();
        if (!sqlFile.exists()) {
            log.error("{}\u811a\u672c\u4e0d\u5b58\u5728\uff0c\u8df3\u8fc7\u64cd\u4f5c [{}]", (Object)sqlFile.getName(), (Object)sqlFile.getAbsolutePath());
            return sqlQueries;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(sqlFile));){
            String line;
            StringBuilder query = new StringBuilder();
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("--")) {
                    query.append(line.trim());
                }
                if (!query.toString().endsWith(";")) continue;
                sqlQueries.add(query.substring(0, query.length() - 1));
                query.setLength(0);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6{}\u6587\u4ef6({})\u4e2dsql\u51fa\u73b0\u5f02\u5e38", new Object[]{sqlFile.getName(), sqlFile.getAbsolutePath(), e});
        }
        return sqlQueries;
    }

    public static void loadMetadata() {
        for (DbType targetDbType : LOAD_METADATA_LIST) {
            try {
                AbstractActuator.loadUnisqlTableColumnMetadata((DbType)targetDbType, null);
            }
            catch (Exception e) {
                log.error("{}\u52a0\u8f7d\u52a0\u8f7d\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0{}", (Object)targetDbType, (Object)e);
            }
        }
    }

    public static void determineSqlIdSpec(String sqlId) {
        String[] validSqlTypes;
        boolean sqlType = false;
        for (String validSqlType : validSqlTypes = new String[]{"DQL", "DML", "DCL", "DDL", "SET", "DML2DQL"}) {
            if (!sqlId.contains(validSqlType)) continue;
            sqlType = true;
            break;
        }
        if (!sqlType) {
            consoleLogger.info("\u7528\u4f8b\u540d{}\u7f16\u5199\u4e0d\u89c4\u8303\uff0c\u4e0d\u5305\u542bsql\u7c7b\u578b\uff0c\u8bf7\u53c2\u8003\u7528\u4f8b\u6a21\u7248", (Object)sqlId);
            System.exit(1);
        }
        if (!sqlId.matches(".*\u9884\u671f\u8f93\u51fa\\d+\u884c.*")) {
            consoleLogger.info("\u7528\u4f8b\u540d{}\u7f16\u5199\u4e0d\u89c4\u8303\uff0c\u4e0d\u5305\u542b\u9884\u671f\u8f93\u51fa\u884c\u6570\uff0c\u8bf7\u53c2\u8003\u7528\u4f8b\u6a21\u7248", (Object)sqlId);
            System.exit(1);
        }
        if (!sqlId.contains("\u6210\u529f") && !sqlId.contains("\u5931\u8d25")) {
            consoleLogger.info("\u7528\u4f8b\u540d{}\u7f16\u5199\u4e0d\u89c4\u8303\uff0c\u4e0d\u5305\u542b\u6267\u884c\u7ed3\u679c\u6210\u529f\u8fd8\u662f\u5931\u8d25\uff0c\u8bf7\u53c2\u8003\u7528\u4f8b\u6a21\u7248", (Object)sqlId);
            System.exit(1);
        }
        if (!sqlId.contains("\u6709\u5e8f") && !sqlId.contains("\u65e0\u5e8f")) {
            consoleLogger.info("\u7528\u4f8b\u540d{}\u7f16\u5199\u4e0d\u89c4\u8303\uff0c\u4e0d\u5305\u542b\u6267\u884c\u7ed3\u679c\u6709\u5e8f\u8fd8\u662f\u65e0\u5e8f\uff0c\u8bf7\u53c2\u8003\u7528\u4f8b\u6a21\u7248", (Object)sqlId);
            System.exit(1);
        }
    }

    public static String getAutoTestIdentBlack() {
        String autoTestBlacklist = System.getProperty("multi.autotest.ident.blacklist");
        if (StringUtils.isBlank((CharSequence)autoTestBlacklist)) {
            autoTestBlacklist = "";
        }
        return autoTestBlacklist;
    }

    public static void determineIdentCompliance(String sql) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return;
        }
        String autoTestBlacklist = CommonUtils.getAutoTestIdentBlack();
        if (StringUtils.isBlank((CharSequence)autoTestBlacklist)) {
            log.warn("\u5f53\u524d\u672a\u914d\u7f6e\u6807\u8bc6\u7b26\u9ed1\u540d\u5355\u6216\u6807\u8bc6\u7b26\u9ed1\u540d\u5355\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        List<String> blacklistIdentifiers = Arrays.asList(autoTestBlacklist.split(","));
        for (String ident : blacklistIdentifiers) {
            String regexPattern = "\\b" + ident.trim() + "\\b";
            Pattern pattern = Pattern.compile(regexPattern, 2);
            Matcher matcher = pattern.matcher(sql);
            if (!matcher.find()) continue;
            consoleLogger.info("\u5f53\u524d\u7528\u4f8b{}\u6709\u6807\u8bc6\u7b26{}\uff0c\u8bf7\u52a0\u4e0a\u7528\u6237\u540d\u6216\u65e5\u671f\uff0c\u907f\u514d\u548c\u5176\u4ed6\u6d4b\u8bd5\u7528\u4f8b\u51b2\u7a81", (Object)sql, (Object)ident);
            System.exit(1);
        }
    }

    static {
        LOAD_METADATA_LIST.add(DbType.GOLDENDB_MYSQL);
        LOAD_METADATA_LIST.add(DbType.GAUSSDB500_ORACLE);
        LOAD_METADATA_LIST.add(DbType.LIGHTDB_MYSQL);
        LOAD_METADATA_LIST.add(DbType.OCEAN_BASE_MYSQL);
        LOAD_METADATA_LIST.add(DbType.MYSQL);
        LOAD_METADATA_LIST.add(DbType.ORACLE_19C);
        LOAD_METADATA_LIST.add(DbType.OCEAN_BASE_ORACLE);
        LOAD_METADATA_LIST.add(DbType.GAUSSDB_MYSQL);
        LOAD_METADATA_LIST.add(DbType.GAUSSDB_ORACLE);
        LOAD_METADATA_LIST.add(DbType.GAUSSDB_MYSQL_B);
        LOAD_METADATA_LIST.add(DbType.TDSQL_PG);
        LOAD_METADATA_LIST.add(DbType.DM);
    }
}

