/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.dbactuator;

import com.hundsun.lightdb.dbabrun.config.MultiplexJdbcConfig;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.dm.DmOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.Gaussdb500OracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbMysqlBmodeActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.OpengaussMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.goldendb.GoldendbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.lightdb.LightdbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.lightdb.LightdbOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.mysql.MysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.ob.ObMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.ob.ObOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.oracle.Oracle19Actuator;
import com.hundsun.lightdb.dbabrun.dbactuator.oracle.OracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.postgres.PgActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlPgActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlPgOracleActuator;
import com.hundsun.lightdb.unisql.proxy.Driver;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.utils.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommonActuatorStrategy {
    private static final Logger log = LoggerFactory.getLogger(CommonActuatorStrategy.class);
    private static volatile CommonActuatorStrategy instance;
    private static final String WORK_DIR = "user.dir";
    private static final Properties PROPERTIES;
    private static final String CONFIG = "config";
    private static final String MULTI_CONFIG_FILE_NAME = "jrescloud.properties";
    private static Path fileWatcherPath;
    private static WatchService watchService;
    private static MultiplexJdbcConfig multiplexJdbcConfig;
    private static Map<DbType, AbstractActuator> actuatorMap;
    public static List<String> allActuatorTypes;
    private static final int CORE_POOL_SIZE = 1;
    private static final int MAX_POOL_SIZE = 1;
    private static final long KEEP_ALIVE_TIME = 0L;
    private static final TimeUnit TIME_UNIT;
    private static final BlockingQueue<Runnable> WORK_QUEUE;
    private static final ThreadFactory DAEMON_THREAD_FACTORY;
    private static final ExecutorService EXECUTOR;

    private static void setFileWatcher() {
        block4: {
            if (fileWatcherPath == null) {
                if (log.isWarnEnabled()) {
                    log.warn("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230\uff0c\u591a\u53d1\u6570\u636e\u6e90\u672a\u542f\u7528\u70ed\u66f4\u65b0");
                }
                return;
            }
            try {
                watchService = FileSystems.getDefault().newWatchService();
                fileWatcherPath.getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                EXECUTOR.submit(() -> CommonActuatorStrategy.processEvents());
            }
            catch (IOException ex) {
                if (!log.isErrorEnabled()) break block4;
                log.error("\u8bbe\u7f6e\u914d\u7f6e\u6587\u4ef6\u76d1\u542c\u5f02\u5e38\uff1a{} ", (Throwable)ex);
            }
        }
    }

    private static void processEvents() {
        block6: {
            try {
                WatchKey key;
                boolean valid;
                do {
                    key = watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent<?> ev;
                        Path fileName;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !(fileName = (Path)(ev = event).context()).equals(fileWatcherPath.getFileName())) continue;
                        try {
                            CommonActuatorStrategy.rebuildActuators((File)fileWatcherPath.toFile().getAbsoluteFile());
                        }
                        catch (Exception e) {
                            log.warn("\u81f3\u5c11\u9700\u8981\u914d\u7f6e\u4e00\u4e2a\u6570\u636e\u6e90\u8fde\u63a5\u4fe1\u606f\uff0c\u5ffd\u7565\u6b64\u6b21\u9519\u8bef\u7684\u914d\u7f6e\u6587\u4ef6\u4fee\u6539", (Throwable)e);
                        }
                    }
                } while (valid = key.reset());
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block6;
                log.error("\u914d\u7f6e\u6587\u4ef6\u76d1\u542c\u5904\u7406\u5f02\u5e38\uff1a{} ", (Throwable)e);
            }
        }
    }

    private static void rebuildActuators(File multiConfigFile) throws IOException {
        if (log.isInfoEnabled()) {
            log.info("\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u53d8\u66f4\uff0c\u5f00\u59cb\u91cd\u65b0\u6784\u5efaActuator\u6267\u884c\u5668");
        }
        Properties properties = new Properties();
        try (FileInputStream stream = new FileInputStream(multiConfigFile);){
            properties.load(stream);
        }
        if (properties.isEmpty()) {
            return;
        }
        PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource("multiplex", properties);
        StandardEnvironment environment = new StandardEnvironment();
        environment.getPropertySources().addLast((PropertySource)propertiesPropertySource);
        MultiplexJdbcConfig tempJdbcConfig = (MultiplexJdbcConfig)Binder.get((Environment)environment).bind("multiplex", MultiplexJdbcConfig.class).get();
        tempJdbcConfig.check();
        AbstractActuator.cleanConnectionPool();
        Driver.reloadJdbcMultiDatasource();
        if (log.isInfoEnabled()) {
            log.info("\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u53d8\u66f4\uff0c\u65b0\u7684\u914d\u7f6e\u9879\u5185\u5bb9 [{}]", (Object)JsonUtils.toJson((Object)tempJdbcConfig));
        }
        HashMap<DbType, Object> tempMap = new HashMap<DbType, Object>();
        tempMap.put(DbType.MYSQL, new MysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.GOLDENDB_MYSQL, new GoldendbMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.ORACLE, new OracleActuator(tempJdbcConfig));
        tempMap.put(DbType.LIGHTDB_ORACLE, new LightdbOracleActuator(tempJdbcConfig));
        tempMap.put(DbType.LIGHTDB_MYSQL, new LightdbMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.OCEAN_BASE_ORACLE, new ObOracleActuator(tempJdbcConfig));
        tempMap.put(DbType.GAUSSDB_ORACLE, new GaussdbOracleActuator(tempJdbcConfig));
        tempMap.put(DbType.DM, new DmOracleActuator(tempJdbcConfig));
        tempMap.put(DbType.POSTGRESQL, new PgActuator(tempJdbcConfig));
        tempMap.put(DbType.TDSQL_PG_ORACLE, new TdsqlPgOracleActuator(tempJdbcConfig));
        tempMap.put(DbType.TDSQL_MYSQL, new TdsqlMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.OCEAN_BASE_MYSQL, new ObMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.GAUSSDB500_ORACLE, new Gaussdb500OracleActuator(tempJdbcConfig));
        tempMap.put(DbType.ORACLE_19C, new Oracle19Actuator(tempJdbcConfig));
        tempMap.put(DbType.GAUSSDB_MYSQL, new GaussdbMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.GAUSSDB_MYSQL_B, new GaussdbMysqlBmodeActuator(tempJdbcConfig));
        tempMap.put(DbType.OPENGAUSS_MYSQL, new OpengaussMysqlActuator(tempJdbcConfig));
        tempMap.put(DbType.TDSQL_PG, new TdsqlPgActuator(tempJdbcConfig));
        multiplexJdbcConfig = tempJdbcConfig;
        actuatorMap = tempMap;
        allActuatorTypes = actuatorMap.keySet().stream().map(dbType -> dbType.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        if (log.isInfoEnabled()) {
            log.info("\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u6587\u4ef6\u53d8\u66f4\uff0cActuator\u6267\u884c\u5668\u6784\u5efa\u5b8c\u6210");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonActuatorStrategy getInstance() {
        if (instance != null) return instance;
        Class<CommonActuatorStrategy> clazz = CommonActuatorStrategy.class;
        synchronized (CommonActuatorStrategy.class) {
            if (instance != null) return instance;
            instance = new CommonActuatorStrategy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AbstractActuator getActuator(DbType dbType) {
        AbstractActuator actuator = (AbstractActuator)actuatorMap.get(dbType);
        if (Objects.nonNull(actuator)) {
            return actuator;
        }
        throw new IllegalArgumentException("Unsupported database type: " + dbType.name());
    }

    public static MultiplexJdbcConfig getMultiplexJdbcConfig() {
        return multiplexJdbcConfig;
    }

    static {
        actuatorMap = new HashMap();
        allActuatorTypes = new ArrayList();
        TIME_UNIT = TimeUnit.MILLISECONDS;
        WORK_QUEUE = new LinkedBlockingQueue();
        DAEMON_THREAD_FACTORY = runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setName("multi-datasource-monitor");
            thread.setDaemon(true);
            return thread;
        };
        EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TIME_UNIT, WORK_QUEUE, DAEMON_THREAD_FACTORY, new ThreadPoolExecutor.AbortPolicy());
        String multiConfigDir = System.getProperty("user.dir") + File.separator + "config";
        String multiConfigPath = String.format(multiConfigDir + File.separator + "%s", "jrescloud.properties");
        File multiConfigFile = new File(multiConfigPath);
        PROPERTIES = new Properties();
        if (multiConfigFile.exists()) {
            try {
                fileWatcherPath = multiConfigFile.toPath();
                CommonActuatorStrategy.rebuildActuators((File)multiConfigFile);
                CommonActuatorStrategy.setFileWatcher();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (log.isInfoEnabled()) {
            log.info("\u591a\u53d1\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230 [{}]", (Object)multiConfigFile.getAbsolutePath());
        }
    }
}

