/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.controller;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.multiplex.common.apicount.ApiAccessCounter;
import com.hundsun.lightdb.multiplex.service.bean.MultiplexDataSourceInPutDTO;
import com.hundsun.lightdb.multiplex.service.bean.MultiplexInPutDTO;
import com.hundsun.lightdb.multiplex.service.bean.MultiplexOutPutDTO;
import com.hundsun.lightdb.multiplex.service.impl.MultiplexServiceImpl;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.model.JdbcProperties;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.Result;
import com.hundsun.lightdb.unisql.proxy.Driver;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MultiplexController {
    private static final Logger log = LoggerFactory.getLogger(MultiplexController.class);
    @Autowired
    private ApiAccessCounter apiAccessCounter;

    @PostMapping(value={"/transformSql"})
    public Result<MultiplexOutPutDTO> transformSql(@RequestBody MultiplexInPutDTO multiplexInPut) {
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u7edf\u4e00SQL http\u8f6c\u6362\u63a5\u53e3 transformSql \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)multiplexInPut));
        }
        Result output = MultiplexServiceImpl.transformSql((MultiplexInPutDTO)multiplexInPut);
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u7edf\u4e00SQL http\u8f6c\u6362\u63a5\u53e3 transformSql \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)output));
        }
        try {
            this.apiAccessCounter.increment(multiplexInPut.getSourceDialect(), multiplexInPut.getTargetDialectInfos());
        }
        catch (Throwable e) {
            log.error("\u7edf\u8ba1API\u63a5\u53e3\u51fa\u9519", (Object)ExceptionUtils.getMessage((Throwable)e));
        }
        return output;
    }

    @PostMapping(value={"/multiplex"})
    public Result<MultiplexOutPutDTO> multiplex(@RequestBody MultiplexInPutDTO multiplexInPutDTO) {
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u7edf\u4e00SQL http\u591a\u53d1\u63a5\u53e3 multiplex \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)multiplexInPutDTO));
        }
        Result output = MultiplexServiceImpl.multiplex((MultiplexInPutDTO)multiplexInPutDTO);
        if (log.isInfoEnabled()) {
            log.info("\u8c03\u7528\u7edf\u4e00SQL http\u591a\u53d1\u63a5\u53e3 multiplex \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)output));
        }
        return output;
    }

    @PostMapping(value={"/initDataSourceConfig"})
    public Result<MultiplexOutPutDTO> initDataSourceConfig(@RequestBody MultiplexDataSourceInPutDTO multiplexDataSourceInPut) {
        try {
            if (log.isInfoEnabled()) {
                log.info("\u8c03\u7528\u7edf\u4e00SQL http\u591a\u53d1\u6570\u636e\u6e90\u914d\u7f6e\u52a0\u8f7d\u63a5\u53e3 initDataSourceConfig \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)multiplexDataSourceInPut));
            }
            if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
                return Result.fail((ErrorMessages)ErrorMessages.MULTI_DATASOURCE_SELF_MANAGE_ERROR);
            }
            if (Objects.isNull(multiplexDataSourceInPut)) {
                return Result.fail((ErrorMessages)ErrorMessages.PARAM_NOT_NULL_ERROR);
            }
            if (!DbType.MYSQL.name().equalsIgnoreCase(multiplexDataSourceInPut.getSourceDialect()) && !DbType.ORACLE.name().equalsIgnoreCase(multiplexDataSourceInPut.getSourceDialect())) {
                return Result.failFormat((ErrorMessages)ErrorMessages.SOURCE_DIALECT_TYPE_ERROR, (String[])new String[]{multiplexDataSourceInPut.getSourceDialect()});
            }
            if (CollectionUtils.isEmpty((Collection)multiplexDataSourceInPut.getTargetDataSourceProperties())) {
                return Result.fail((ErrorMessages)ErrorMessages.TARGET_DATASOURCE_PROPERTIES_NULL_ERROR);
            }
            ArrayList<JdbcProperties> jdbcPropertieList = new ArrayList<JdbcProperties>();
            for (MultiplexDataSourceInPutDTO.MultiJdbcProperties targetDataSourceProperties : multiplexDataSourceInPut.getTargetDataSourceProperties()) {
                if (Objects.isNull(targetDataSourceProperties)) {
                    return Result.fail((ErrorMessages)ErrorMessages.SOURCE_DATABASE_NULL_ERROR);
                }
                if (StringUtils.isBlank((CharSequence)targetDataSourceProperties.getTargetDialect())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_NULL_ERROR);
                }
                try {
                    DbType.of((String)targetDataSourceProperties.getTargetDialect());
                }
                catch (Exception e) {
                    return Result.failFormat((ErrorMessages)ErrorMessages.TARGET_DIALECT_TYPE_ERROR, (String[])new String[]{targetDataSourceProperties.getTargetDialect()});
                }
                if (StringUtils.isBlank((CharSequence)targetDataSourceProperties.getUrl())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DATABASE_URL_NULL_ERROR);
                }
                if (StringUtils.isBlank((CharSequence)targetDataSourceProperties.getSchemaName())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_SCHEMA_NAME_NULL_ERROR);
                }
                if (StringUtils.isBlank((CharSequence)targetDataSourceProperties.getUser())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DATABASE_USER_NULL_ERROR);
                }
                if (StringUtils.isBlank((CharSequence)targetDataSourceProperties.getPassword())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DATABASE_PASSWORD_NULL_ERROR);
                }
                JdbcProperties jdbcProperties2 = new JdbcProperties();
                BeanUtils.copyProperties((Object)targetDataSourceProperties, (Object)jdbcProperties2);
                jdbcProperties2.setSourceDialect(multiplexDataSourceInPut.getSourceDialect().toUpperCase());
                jdbcProperties2.setTargetDialect(targetDataSourceProperties.getTargetDialect().toUpperCase());
                Properties properties = new Properties();
                properties.setProperty("user", targetDataSourceProperties.getUser());
                properties.setProperty("password", targetDataSourceProperties.getPassword());
                jdbcProperties2.setProperties(properties);
                jdbcPropertieList.add(jdbcProperties2);
            }
            Driver.setJdbcMultiDatasource(jdbcPropertieList);
            jdbcPropertieList.forEach(jdbcProperties -> {
                try {
                    DbType targetDbType = DbType.of((String)jdbcProperties.getTargetDialect().toUpperCase());
                    AbstractActuator.loadUnisqlTableColumnMetadata((DbType)targetDbType, (String)jdbcProperties.getSchemaName());
                }
                catch (Exception e) {
                    if (log.isErrorEnabled()) {
                        log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTI_DATASOURCE_UNISQL_METADATA_ERROR, (Object[])new Object[]{jdbcProperties.getTargetDialect(), ExceptionUtils.getMessage((Throwable)e)}));
                    }
                    throw new RuntimeException(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTI_DATASOURCE_UNISQL_METADATA_ERROR, (Object[])new Object[]{jdbcProperties.getTargetDialect(), ExceptionUtils.getMessage((Throwable)e)}));
                }
            });
            AbstractActuator.clearDataSourceCache();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_SOURCE_INIT_ERROR, (String)ExceptionUtils.getMessage((Throwable)e)));
            }
            return Result.failFormat((ErrorMessages)ErrorMessages.MULTIPLEX_SOURCE_INIT_ERROR, (String[])new String[]{ExceptionUtils.getMessage((Throwable)e)});
        }
        if (log.isInfoEnabled()) {
            log.info(ErrorMessages.MULTIPLEX_SOURCE_INIT_SUCCESS.getMsg());
        }
        return Result.successWithoutData((String)ErrorMessages.MULTIPLEX_SOURCE_INIT_SUCCESS.getMsg());
    }

    @GetMapping(value={"/countshow"})
    public Map<String, Map<String, Map<String, Integer>>> getJsonStats() {
        try {
            Map data = this.apiAccessCounter.getHistoryData();
            return data;
        }
        catch (Exception e) {
            return Map.of();
        }
    }
}

