#!/bin/bash

# 应用名称
APP_NAME="ukagent"
# PID文件路径
PID_FILE="application.pid"
# 最大等待时间（秒）
MAX_WAIT=30
# 每次检测间隔（秒）
CHECK_INTERVAL=1

# 循环检测进程是否已终止的函数
# 参数1: 进程ID
# 参数2: 操作描述（用于日志输出）
wait_for_process_stop() {
    local description=$1
    local elapsed=0

    while [ $elapsed -lt $MAX_WAIT ]; do
        if [ ! -f "$PID_FILE" ]; then
            echo "$description 已成功停止"
            return 0
        fi
        echo "等待 $description 停止... (已等待 $elapsed 秒)"
        sleep $CHECK_INTERVAL
        elapsed=$((elapsed + CHECK_INTERVAL))
    done

    # 超过最大等待时间仍未停止
    return 1
}

# 检查PID文件是否存在
if [ ! -f "$PID_FILE" ]; then
    echo "错误：找不到PID文件 $PID_FILE"
    exit 1
fi

# 从PID文件读取进程ID
PID=$(cat "$PID_FILE")

if [ -z "$PID" ]; then
    echo "错误：PID文件 $PID_FILE 中没有有效的进程ID"
    exit 1
fi

echo "正在停止 $APP_NAME (PID: $PID)..."
# 先尝试优雅终止
kill "$PID"

# 调用函数等待进程停止
if wait_for_process_stop "$APP_NAME"; then
    exit 0
fi

# 如果最终仍未停止
echo "错误：$APP_NAME 无法停止，请手动检查"
exit 1
