#!/bin/bash

# 获取当前脚本所在目录的绝对路径
SCRIPT_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd) || exit

# 进入当前脚本所在目录
cd "$SCRIPT_DIR" || exit

PID_FILE="multiplex.pid"

# 检查 pid 文件是否存在
if [ ! -f "$PID_FILE" ]; then
    echo "未找到 PID 文件，应用可能未运行"
    exit 1
fi

PID=$(cat "$PID_FILE")

if ps -p $PID > /dev/null 2>&1; then
    echo "正在停止应用 (PID: $PID)..."
    kill $PID
    sleep 2
    if ps -p $PID > /dev/null 2>&1; then
        echo "进程未能成功停止，尝试强制杀死..."
        kill -9 $PID
    fi
    echo "应用已停止"
    rm -f "$PID_FILE"
else
    echo "未找到正在运行的进程，删除 PID 文件"
    rm -f "$PID_FILE"
fi
