#!/bin/bash

# 获取当前脚本所在目录的绝对路径
SCRIPT_DIR=$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd) || exit

# 进入当前脚本所在目录
cd "$SCRIPT_DIR" || exit

# 输出当前目录路径
#echo "当前目录：$SCRIPT_DIR"
PID_FILE="multiplex.pid"


# 判断 pid 文件是否存在
if [ -f "$PID_FILE" ]; then
    PID=$(cat "$PID_FILE")
    if ps -p $PID > /dev/null 2>&1; then
        echo "应用已经在运行 (PID: $PID)"
        exit 1
    else
        rm -f "$PID_FILE"
    fi
fi
if [ ! -f "$SCRIPT_DIR/config/jrescloud.properties" ]; then
    echo "错误: 配置文件不存在: $SCRIPT_DIR/config/jrescloud.properties "
    echo "请参考安装手册，以$SCRIPT_DIR/config/jrescloud.properties.example为模板创建配置文件 "
    exit 1
fi
# 创建日志目录
log_path=$SCRIPT_DIR/logs
mkdir -p "$log_path"
#echo "日志路径: $(readlink -f "$log_path")"

# 设置Java选项和端口
JAVA_OPTS="-Xmx4096M -Xms128M -XX:+UseG1GC "

# 启动服务
nohup java $JAVA_OPTS -Dspring.config.location=$SCRIPT_DIR/config/jrescloud.properties \
    -Dlog4j2.configurationFile=$SCRIPT_DIR/config/log4j2.properties \
    -jar $SCRIPT_DIR/multiplex-*.jar >"${log_path}/multiplex.log" 2>&1 &

pid=$!
echo "Service starting with PID $pid"
echo $! > "$PID_FILE"  # 记录 PID

# 等待3秒再看下进程还在不在
sleep 3
# 检查服务是否正常启动
if ps -p $pid > /dev/null 2>&1; then
    echo "Service started successfully with PID $pid"
else
    echo "Service failed to start"
    rm -f "$PID_FILE"
    if [ -f "logs/lightdb-multiplex/lightdb-multiplex.log" ]; then
        tail -n 500  "logs/lightdb-multiplex/lightdb-multiplex.log"
    fi
    exit 1
fi

echo "Service started with PID $(cat $PID_FILE)"
exit 0
