/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.impl;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.multiplex.service.bean.BindVariableDTO;
import com.hundsun.lightdb.multiplex.service.bean.MultiplexInPutDTO;
import com.hundsun.lightdb.multiplex.service.bean.MultiplexOutPutDTO;
import com.hundsun.lightdb.multiplex.service.bean.TargetDialectInfo;
import com.hundsun.lightdb.multiplex.service.dbactuator.CommonActuatorStrategy;
import com.hundsun.lightdb.unisql.constant.ErrorMessages;
import com.hundsun.lightdb.unisql.golang.Transformer;
import com.hundsun.lightdb.unisql.model.MultiCompletableFuture;
import com.hundsun.lightdb.unisql.model.MultiProperties;
import com.hundsun.lightdb.unisql.model.MultiQueryResultDTO;
import com.hundsun.lightdb.unisql.model.MultiplexContext;
import com.hundsun.lightdb.unisql.model.Result;
import com.hundsun.lightdb.unisql.proxy.Driver;
import com.hundsun.lightdb.unisql.proxy.jdbc.DbType;
import com.hundsun.lightdb.unisql.proxy.jdbc.UniSqlType;
import com.hundsun.lightdb.unisql.utils.HttpClientUtils;
import com.hundsun.lightdb.unisql.utils.ThreadPoolUtils;
import com.hundsun.lightdb.unisql.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MultiplexServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(MultiplexServiceImpl.class);
    private static final String GET_COMPARE_REPORT_BY_TRACE_ID_URL = "/compare/getCompareReportByTraceId";
    private static final int BULK_MODE_ONE = 1;
    private static final int BULK_MODE_TWO = 2;

    public static Result<MultiplexOutPutDTO> transformSql(MultiplexInPutDTO multiplexInPut) {
        MultiplexOutPutDTO output = null;
        try {
            if (Objects.isNull(multiplexInPut)) {
                return Result.fail((ErrorMessages)ErrorMessages.PARAM_NOT_NULL_ERROR);
            }
            if (!DbType.MYSQL.name().equalsIgnoreCase(multiplexInPut.getSourceDialect()) && !DbType.ORACLE.name().equalsIgnoreCase(multiplexInPut.getSourceDialect())) {
                return Result.failFormat((ErrorMessages)ErrorMessages.SOURCE_DIALECT_TYPE_ERROR, (String[])new String[]{multiplexInPut.getSourceDialect()});
            }
            if (CollectionUtils.isEmpty((Collection)multiplexInPut.getTargetDialectInfos())) {
                return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_INFOS_NULL_ERROR);
            }
            String sourceSql = multiplexInPut.getSql();
            if (StringUtils.isBlank((CharSequence)sourceSql)) {
                return Result.fail((ErrorMessages)ErrorMessages.SOURCE_SQL_NULL_ERROR);
            }
            output = new MultiplexOutPutDTO();
            output.setSourceDialect(multiplexInPut.getSourceDialect());
            output.setTargetDialectInfos(new ArrayList());
            MultiplexInPutDTO multiplexIn = new MultiplexInPutDTO();
            multiplexIn.setSourceDialect(multiplexInPut.getSourceDialect());
            ArrayList<TargetDialectInfo> targetDialects = new ArrayList<TargetDialectInfo>();
            multiplexIn.setTargetDialectInfos(targetDialects);
            for (TargetDialectInfo targetDialectInPut : multiplexInPut.getTargetDialectInfos()) {
                if (StringUtils.isBlank((CharSequence)targetDialectInPut.getTargetDialect())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_NULL_ERROR);
                }
                try {
                    DbType.of((String)targetDialectInPut.getTargetDialect());
                }
                catch (Exception e) {
                    return Result.failFormat((ErrorMessages)ErrorMessages.TARGET_DIALECT_TYPE_ERROR, (String[])new String[]{targetDialectInPut.getTargetDialect()});
                }
                TargetDialectInfo targetDialectOutPutInfo = new TargetDialectInfo();
                BeanUtils.copyProperties((Object)targetDialectInPut, (Object)targetDialectOutPutInfo);
                if (Objects.equals(multiplexInPut.getSourceDialect(), targetDialectInPut.getTargetDialect())) {
                    targetDialectOutPutInfo.setSql(sourceSql);
                } else {
                    try {
                        String exceptSql = Transformer.parse((String)sourceSql, (String)multiplexInPut.getSourceDialect(), (String)targetDialectInPut.getTargetDialect());
                        targetDialectOutPutInfo.setSql(exceptSql);
                    }
                    catch (Exception e) {
                        return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.SOURCE_SQL_TRANSFORM_ERROR, (String[])new String[]{multiplexInPut.getSourceDialect(), targetDialectInPut.getTargetDialect(), e.getMessage()});
                    }
                }
                output.getTargetDialectInfos().add(targetDialectOutPutInfo);
                if (Objects.isNull(targetDialectInPut.getMultiCompare()) || !targetDialectInPut.getMultiCompare().booleanValue()) continue;
                targetDialects.add(targetDialectOutPutInfo);
            }
            if (CollectionUtils.isNotEmpty(targetDialects)) {
                TargetDialectInfo targetDialectOutPutInfo = new TargetDialectInfo();
                targetDialectOutPutInfo.setTargetDialect(multiplexInPut.getSourceDialect());
                targetDialectOutPutInfo.setSql(multiplexInPut.getSql());
                targetDialectOutPutInfo.setSqlParameters(multiplexInPut.getSqlParameters());
                targetDialects.add(targetDialectOutPutInfo);
                String traceId = UUID.randomUUID().toString();
                multiplexIn.setTraceId(traceId);
                output.setTraceId(traceId);
                multiplexIn.setNeedTransform(Boolean.valueOf(true));
                multiplexIn.setBulkMode(Integer.valueOf(1));
                ThreadPoolUtils.submit(() -> {
                    block4: {
                        try {
                            if (log.isInfoEnabled()) {
                                log.info("\u7edf\u4e00SQL\u8f6c\u6362\u540e\uff0c\u83b7\u53d6\u5230\u9700\u8981\u591a\u53d1\u6bd4\u5bf9\u7684\u76ee\u6807\u6570\u636e\u5e93\u4fe1\u606f\uff1a{}\uff0c\u5f00\u59cb\u6267\u884c\u591a\u53d1\u3002", (Object)targetDialects);
                            }
                            Result result = MultiplexServiceImpl.multiplex((MultiplexInPutDTO)multiplexIn);
                            if (log.isInfoEnabled()) {
                                log.info("\u591a\u53d1\u6267\u884c\u7ed3\u675f\uff0c{}", (Object)JSON.toJSONString((Object)result));
                            }
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block4;
                            log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_SEND_ERROR, (String)ExceptionUtils.getStackTrace((Throwable)e)));
                        }
                    }
                });
                return Result.successWithDataAndMessage((Object)output, (String)ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_SEND_SUCCESS, (String)targetDialects.stream().map(TargetDialectInfo::getTargetDialect).collect(Collectors.joining(","))));
            }
        }
        catch (BeansException e) {
            if (log.isErrorEnabled()) {
                log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.TRANSFORM_ERROR, (String)ExceptionUtils.getStackTrace((Throwable)e)));
            }
            return Result.failFormat(output, (ErrorMessages)ErrorMessages.TRANSFORM_ERROR, (String[])new String[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
        return Result.successWithDataAndMessage((Object)output, (String)ErrorMessages.NO_COMPARE_TRANSFORM_SUCCESS.getMsg());
    }

    public static Result<MultiplexOutPutDTO> multiplex(MultiplexInPutDTO multiplexInPut) {
        MultiplexOutPutDTO output = null;
        try {
            Result result;
            Result checkResult = MultiplexServiceImpl.check((MultiplexInPutDTO)multiplexInPut);
            if (checkResult != null && checkResult.getCode() != 0) {
                return checkResult;
            }
            output = new MultiplexOutPutDTO();
            multiplexInPut.setSourceDialect(multiplexInPut.getSourceDialect().toUpperCase());
            for (TargetDialectInfo targetDialectInPutInfo : multiplexInPut.getTargetDialectInfos()) {
                if (StringUtils.isBlank((CharSequence)targetDialectInPutInfo.getTargetDialect())) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_NULL_ERROR);
                }
                try {
                    DbType.of((String)targetDialectInPutInfo.getTargetDialect());
                }
                catch (Exception e) {
                    return Result.failFormat((ErrorMessages)ErrorMessages.TARGET_DIALECT_TYPE_ERROR, (String[])new String[]{targetDialectInPutInfo.getTargetDialect()});
                }
                if (StringUtils.isBlank((CharSequence)targetDialectInPutInfo.getSchemaName())) {
                    if (!MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
                        targetDialectInPutInfo.setSchemaName(Driver.getDefaultSchemaName((String)targetDialectInPutInfo.getTargetDialect()));
                    } else {
                        return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_SCHEMA_NAME_NULL_ERROR);
                    }
                }
                targetDialectInPutInfo.setTargetDialect(targetDialectInPutInfo.getTargetDialect().toUpperCase());
                if (multiplexInPut.getNeedTransform().booleanValue() && !Objects.equals(multiplexInPut.getSourceDialect(), targetDialectInPutInfo.getTargetDialect())) continue;
                String sql = targetDialectInPutInfo.getSql();
                if (CollectionUtils.isNotEmpty((Collection)targetDialectInPutInfo.getSqlParameters())) {
                    for (BindVariableDTO sqlParameter : targetDialectInPutInfo.getSqlParameters()) {
                        if (StringUtils.isBlank((CharSequence)sqlParameter.getName())) {
                            return Result.fail((ErrorMessages)ErrorMessages.BIND_VARIABLE_NAME_NULL_ERROR);
                        }
                        sql = sql.replaceFirst("@" + sqlParameter.getName(), "?");
                        if (!Objects.equals(UniSqlType.UNKNOWN, UniSqlType.getByJdbcType((int)sqlParameter.getType()))) continue;
                        return Result.failFormat((ErrorMessages)ErrorMessages.BIND_VARIABLE_TYPE_ERROR, (String[])new String[]{"" + sqlParameter.getType()});
                    }
                }
                targetDialectInPutInfo.setSql(sql);
            }
            if (multiplexInPut.getNeedTransform().booleanValue()) {
                result = MultiplexServiceImpl.doExecuteMultiplex((MultiplexInPutDTO)multiplexInPut, (MultiplexOutPutDTO)output);
                if (result != null && result.getCode() != 0) {
                    return result;
                }
            } else {
                result = MultiplexServiceImpl.doExecuteFakeMultiplex((MultiplexInPutDTO)multiplexInPut, (MultiplexOutPutDTO)output);
                if (result != null && result.getCode() != 0) {
                    return result;
                }
                if (multiplexInPut.getBulkMode() == 2) {
                    return Result.successWithDataAndMessage((Object)output, (String)ErrorMessages.COMPARE_SEND_SUCCESS.getMsg());
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_EXECUTE_ERROR, (String)ExceptionUtils.getStackTrace((Throwable)e)));
            }
            return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.MULTIPLEX_EXECUTE_ERROR, (String[])new String[]{ExceptionUtils.getStackTrace((Throwable)e)});
        }
        return Result.successWithDataAndMessage((Object)output, (String)ErrorMessages.COMPARE_RESULT_SUCCESS.getMsg());
    }

    private static Result<MultiplexOutPutDTO> check(MultiplexInPutDTO multiplexInPut) {
        if (Objects.isNull(multiplexInPut)) {
            return Result.fail((ErrorMessages)ErrorMessages.PARAM_NOT_NULL_ERROR);
        }
        if (Objects.isNull(multiplexInPut.getNeedTransform())) {
            return Result.fail((ErrorMessages)ErrorMessages.NEED_TRANSFORM_NULL_ERROR);
        }
        if (!Objects.equals(multiplexInPut.getBulkMode(), 1) && !Objects.equals(multiplexInPut.getBulkMode(), 2)) {
            return Result.fail((ErrorMessages)ErrorMessages.BULK_MODE_ERROR);
        }
        if (multiplexInPut.getNeedTransform().booleanValue() && !Objects.equals(multiplexInPut.getBulkMode(), 1)) {
            return Result.fail((ErrorMessages)ErrorMessages.BULK_MODE_ONE_ERROR);
        }
        if (!multiplexInPut.getNeedTransform().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)multiplexInPut.getTraceId())) {
                return Result.fail((ErrorMessages)ErrorMessages.TRACE_ID_NULL_ERROR);
            }
            if (multiplexInPut.getBulkMode() == 2 && CollectionUtils.isEmpty((Collection)multiplexInPut.getTargetDialects())) {
                return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECTS_NULL_ERROR);
            }
        }
        if (!DbType.MYSQL.name().equalsIgnoreCase(multiplexInPut.getSourceDialect()) && !DbType.ORACLE.name().equalsIgnoreCase(multiplexInPut.getSourceDialect())) {
            return Result.failFormat((ErrorMessages)ErrorMessages.SOURCE_DIALECT_TYPE_ERROR, (String[])new String[]{multiplexInPut.getSourceDialect()});
        }
        if (CollectionUtils.isEmpty((Collection)multiplexInPut.getTargetDialectInfos())) {
            return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_INFOS_NULL_ERROR);
        }
        return null;
    }

    private static Result<MultiplexOutPutDTO> doExecuteMultiplex(MultiplexInPutDTO multiplexInPutDTO, MultiplexOutPutDTO output) {
        try {
            Optional<TargetDialectInfo> first = multiplexInPutDTO.getTargetDialectInfos().stream().filter(targetDialectInPut -> Objects.equals(multiplexInPutDTO.getSourceDialect().toUpperCase(), targetDialectInPut.getTargetDialect().toUpperCase())).findFirst();
            if (!first.isPresent()) {
                return Result.failFormat((ErrorMessages)ErrorMessages.SOURCE_INFO_NULL_ERROR, (String[])new String[]{multiplexInPutDTO.getSourceDialect()});
            }
            TargetDialectInfo sourceDialectsInPutInfo = first.get();
            String sourceSql = sourceDialectsInPutInfo.getSql();
            if (StringUtils.isBlank((CharSequence)sourceSql)) {
                return Result.fail((ErrorMessages)ErrorMessages.SOURCE_SQL_NULL_ERROR);
            }
            AbstractActuator actuator = CommonActuatorStrategy.getInstance().getActuator(multiplexInPutDTO.getSourceDialect());
            List sqlParameters = sourceDialectsInPutInfo.getSqlParameters();
            Object[] parameters = new Object[]{};
            Map<Integer, Integer> parameterTypes = null;
            if (!CollectionUtils.isEmpty((Collection)sqlParameters)) {
                parameters = sqlParameters.stream().map(BindVariableDTO::getValue).toArray();
                parameterTypes = IntStream.range(0, sqlParameters.size()).boxed().collect(Collectors.toMap(index -> index, index -> UniSqlType.getByJdbcType((int)((BindVariableDTO)sqlParameters.get((int)index)).getType()).getJdbcType()));
            }
            LinkedHashMap targetDialectSchemaNameMap = multiplexInPutDTO.getTargetDialectInfos().stream().collect(Collectors.toMap(TargetDialectInfo::getTargetDialect, TargetDialectInfo::getSchemaName, (existing, replacement) -> existing, LinkedHashMap::new));
            if (CollectionUtils.isEmpty((Collection)multiplexInPutDTO.getTargetDialects()) && multiplexInPutDTO.getTargetDialectInfos().size() == 1) {
                if (MultiProperties.MULTI_DATASOURCE_SELF_MANAGE.booleanValue()) {
                    return Result.fail((ErrorMessages)ErrorMessages.TARGET_DIALECT_INFOS_ONLY_SOURCE_INFO_ERROR);
                }
                String sourceUrl = actuator.getTargetDbConfig().getUrl();
                String multiplexTargetDialects = Driver.parseUrl((String)sourceUrl).getProperty("multiplexTargetDialects");
                if (StringUtils.isBlank((CharSequence)multiplexTargetDialects)) {
                    throw new IllegalArgumentException(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_TARGET_DIALECTS_NULL_ERROR, (String)sourceUrl));
                }
                multiplexTargetDialects = multiplexTargetDialects.toUpperCase();
                Arrays.stream(multiplexTargetDialects.split(",")).forEach(targetDialect -> {
                    String target = "";
                    try {
                        target = DbType.of((String)targetDialect).name();
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(ErrorMessages.format((ErrorMessages)ErrorMessages.MULTIPLEX_TARGET_DIALECTS_ERROR, (Object[])new Object[]{sourceUrl, targetDialect}));
                    }
                    if (!targetDialectSchemaNameMap.containsKey(target)) {
                        targetDialectSchemaNameMap.put(target, Driver.getDefaultSchemaName((String)target));
                    }
                });
                if (log.isInfoEnabled()) {
                    log.info("\u771f\u591a\u53d1\u5916\u90e8\u63a5\u53e3\u672a\u6307\u5b9a\u591a\u53d1\u54ea\u51e0\u4e2a\u76ee\u6807\u5e93\uff0c\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e\u9879\u4e2d\u6307\u5b9a\u7684\u591a\u53d1\u54ea\u51e0\u4e2a\u76ee\u6807\u5e93[{}]", (Object)multiplexTargetDialects);
                }
            } else if (log.isInfoEnabled()) {
                log.info("\u771f\u591a\u53d1\u5916\u90e8\u63a5\u53e3\u6307\u5b9a\u4e86\u9700\u8981\u591a\u53d1\u54ea\u51e0\u4e2a\u76ee\u6807\u5e93\uff0c\u4f7f\u7528\u5916\u90e8\u63a5\u53e3\u6307\u5b9a\u7684\u54ea\u51e0\u4e2a\u76ee\u6807\u5e93[{}]", (Object)String.join((CharSequence)",", targetDialectSchemaNameMap.keySet()));
            }
            String multiplexTargetDialects = "&multiplexTargetDialects=" + String.join((CharSequence)",", targetDialectSchemaNameMap.keySet());
            if (log.isDebugEnabled()) {
                log.debug("\u5f00\u59cb\u6267\u884c\u771f\u591a\u53d1\uff1a\u6e90\u65b9\u8a00[{}],\u8981\u591a\u53d1\u7684\u6570\u636e\u5e93[{}],\u539f\u59cbSQL[{}],\u7ed1\u5b9a\u53d8\u91cf\u7c7b\u578b[{}],\u7ed1\u5b9a\u53d8\u91cf\u503c[{}]", new Object[]{multiplexInPutDTO.getSourceDialect(), multiplexTargetDialects, sourceSql, parameterTypes, parameters});
            }
            String traceId = MultiplexContext.setRealMultiplexTraceId((String)multiplexInPutDTO.getTraceId());
            output.setTraceId(traceId);
            actuator.doMultiplexExecutePrepared(multiplexTargetDialects, targetDialectSchemaNameMap, sourceSql, parameters, parameterTypes, traceId);
            Result fail3 = MultiplexServiceImpl.getCompareReportByTraceId((String)sourceSql, (MultiplexOutPutDTO)output);
            if (fail3 != null && fail3.getCode() != 0) {
                return fail3;
            }
        }
        catch (NoSuchElementException e) {
            if (log.isErrorEnabled()) {
                log.error(ExceptionUtils.getMessage((Throwable)e), (Throwable)e);
            }
            return Result.fail((Object)output, (int)ErrorMessages.MULTIPLEX_SOURCE_DIALECT_DBNAME_NULL_ERROR.getCode(), (String)ExceptionUtils.getMessage((Throwable)e));
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(ExceptionUtils.getMessage((Throwable)e), (Throwable)e);
            }
            return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.MULTIPLEX_EXECUTE_ERROR, (String[])new String[]{ExceptionUtils.getMessage((Throwable)e)});
        }
        return null;
    }

    private static Result<MultiplexOutPutDTO> doExecuteFakeMultiplex(MultiplexInPutDTO multiplexInPutDTO, MultiplexOutPutDTO output) {
        try {
            String traceId = multiplexInPutDTO.getTraceId();
            output.setTraceId(traceId);
            log.debug("needTransform=false\u65f6,bulkMode=[{}], \u4f2a\u591a\u53d1\u8bbe\u7f6etraceId\u4e3a [{}]", (Object)multiplexInPutDTO.getBulkMode(), (Object)traceId);
            String multiplexTargetDialects = multiplexInPutDTO.getBulkMode() == 2 ? "&multiplexTargetDialects=" + String.join((CharSequence)",", multiplexInPutDTO.getTargetDialects()).toUpperCase() : "&multiplexTargetDialects=" + multiplexInPutDTO.getTargetDialectInfos().stream().map(e -> e.getTargetDialect().toUpperCase()).collect(Collectors.joining(","));
            String sql = "";
            ArrayList<MultiCompletableFuture> futures = new ArrayList<MultiCompletableFuture>();
            for (Object targetDialectInfo : multiplexInPutDTO.getTargetDialectInfos()) {
                Map<Integer, Integer> parameterTypes;
                String sourceSql;
                if (Objects.equals(multiplexInPutDTO.getSourceDialect().toUpperCase(), targetDialectInfo.getTargetDialect().toUpperCase())) {
                    sql = targetDialectInfo.getSql();
                }
                if (StringUtils.isBlank((CharSequence)(sourceSql = targetDialectInfo.getSql()))) {
                    return Result.fail((ErrorMessages)ErrorMessages.SOURCE_SQL_NULL_ERROR);
                }
                AbstractActuator actuator = CommonActuatorStrategy.getInstance().getActuator(targetDialectInfo.getTargetDialect());
                List sqlParameters = targetDialectInfo.getSqlParameters();
                Object[] parameters = new Object[]{};
                if (!CollectionUtils.isEmpty((Collection)sqlParameters)) {
                    parameters = sqlParameters.stream().map(BindVariableDTO::getValue).toArray();
                    parameterTypes = IntStream.range(0, sqlParameters.size()).boxed().collect(Collectors.toMap(index -> index, index -> UniSqlType.getByJdbcType((int)((BindVariableDTO)sqlParameters.get((int)index)).getType()).getJdbcType()));
                } else {
                    parameterTypes = null;
                }
                if (log.isDebugEnabled()) {
                    log.debug("\u5f00\u59cb\u6267\u884c\u4f2a\u591a\u53d1\uff1a\u6e90\u65b9\u8a00[{}],\u8981\u591a\u53d1\u7684\u6570\u636e\u5e93\u65b9\u8a00[{}],\u5f53\u524d\u6267\u884c\u6570\u636e\u5e93[{}],\u6267\u884cSQL[{}],\u7ed1\u5b9a\u53d8\u91cf\u7c7b\u578b[{}],\u7ed1\u5b9a\u53d8\u91cf\u503c[{}]", new Object[]{multiplexInPutDTO.getSourceDialect(), multiplexTargetDialects, targetDialectInfo.getTargetDialect(), sourceSql, parameterTypes, parameters});
                }
                String targetKey = multiplexInPutDTO.getSourceDialect().toUpperCase() + "2" + targetDialectInfo.getTargetDialect().toUpperCase() + ":\u76ee\u6807\u5e93\u4f2a\u591a\u53d1\u5f02\u6b65\u6267\u884c";
                ExecutorService pool = MultiplexContext.getOrCreateTargetPool((String)targetKey);
                Object[] finalParameters = parameters;
                CompletableFuture<String> future = CompletableFuture.supplyAsync(() -> MultiplexServiceImpl.lambda$doExecuteFakeMultiplex$9(multiplexInPutDTO, (TargetDialectInfo)targetDialectInfo, traceId, sourceSql, actuator, multiplexTargetDialects, finalParameters, parameterTypes), pool);
                String errKey = String.format("\u4f2a\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5931\u8d25traceId [%s] SQL [%s]", multiplexInPutDTO.getSourceDialect(), targetDialectInfo.getTargetDialect(), traceId, sourceSql);
                MultiCompletableFuture multiCompletableFuture = new MultiCompletableFuture(errKey, future);
                futures.add(multiCompletableFuture);
            }
            if (log.isDebugEnabled()) {
                log.debug("\u4f2a\u591a\u53d1\u5f00\u59cb\u540c\u6b65\u7b49\u5f85\u6e90\u5e93\u4ee5\u53ca\u76ee\u6807\u5e93\u7684\u5f02\u6b65\u6267\u884c\u662f\u5426\u90fd\u5904\u7406\u5b8c\u6bd5,traceId [{}] ", (Object)traceId);
            }
            StringBuilder executeErrorReason = new StringBuilder();
            for (MultiCompletableFuture future : futures) {
                try {
                    if (future.getFuture() == null) continue;
                    future.getFuture().get();
                }
                catch (ExecutionException e2) {
                    if (log.isErrorEnabled()) {
                        log.error("[{}],\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)future.getTargetKey(), (Object)ExceptionUtils.getStackTrace((Throwable)e2));
                    }
                    executeErrorReason.append(String.format("[%s],\u5f02\u5e38\u4fe1\u606f\uff1a[%s]\n", future.getTargetKey(), ExceptionUtils.getMessage((Throwable)e2)));
                }
            }
            if (executeErrorReason.length() > 0) {
                return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.MULTIPLEX_EXECUTE_ERROR, (String[])new String[]{executeErrorReason.toString()});
            }
            if (multiplexInPutDTO.getBulkMode() == 2) {
                return Result.successWithDataAndMessage((Object)output, (String)ErrorMessages.COMPARE_SEND_SUCCESS.getMsg());
            }
            Result result = MultiplexServiceImpl.getCompareReportByTraceId((String)sql, (MultiplexOutPutDTO)output);
            if (result != null && result.getCode() != 0) {
                return result;
            }
        }
        catch (Exception e3) {
            if (log.isErrorEnabled()) {
                log.error(ExceptionUtils.getMessage((Throwable)e3), (Throwable)e3);
            }
            return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.MULTIPLEX_EXECUTE_ERROR, (String[])new String[]{ExceptionUtils.getMessage((Throwable)e3)});
        }
        return null;
    }

    private static Result<MultiplexOutPutDTO> getCompareReportByTraceId(String sql, MultiplexOutPutDTO output) {
        if (!Utils.isDDL((String)sql)) {
            if (StringUtils.isBlank((CharSequence)MultiProperties.getCompareServiceUrl())) {
                return Result.fail((Object)output, (ErrorMessages)ErrorMessages.COMPARE_SERVICE_URL_NULL_ERROR);
            }
            try {
                String compareReportUrl = MultiProperties.getCompareServiceUrl() + "/compare/getCompareReportByTraceId";
                String message = JSON.toJSONString((Object)MultiQueryResultDTO.createForTraceId((String)output.getTraceId()));
                String json = HttpClientUtils.postJson((String)compareReportUrl, (String)message, new HashMap(0));
                if (StringUtils.isBlank((CharSequence)json)) {
                    return Result.fail((Object)output, (String)ErrorMessages.format((ErrorMessages)ErrorMessages.COMPARE_RESULT_FAIL, (String)compareReportUrl));
                }
                Result result = (Result)JSON.parseObject((String)json, Result.class);
                if (ErrorMessages.LTU0020.getMsg().equals(result.getMessage())) {
                    return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.COMPARE_SERVER_UNAUTHORIZED, (String[])new String[]{compareReportUrl});
                }
                if (ErrorMessages.COMPARE_RESULT_DIFF_ERROR.getCode() == result.getCode()) {
                    return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.COMPARE_RESULT_DIFF_ERROR, (String[])new String[]{MultiProperties.getCompareServiceUrl()});
                }
                if (result.getCode() != 0) {
                    return Result.fail((Object)output, (int)result.getCode(), (String)result.getMessage());
                }
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error(ErrorMessages.format((ErrorMessages)ErrorMessages.COMPARE_RESULT_QUERY_ERROR, (String)ExceptionUtils.getStackTrace((Throwable)e)));
                }
                return Result.failFormat((Object)output, (ErrorMessages)ErrorMessages.COMPARE_RESULT_QUERY_ERROR, (String[])new String[]{ExceptionUtils.getStackTrace((Throwable)e)});
            }
        }
        return null;
    }

    private static /* synthetic */ String lambda$doExecuteFakeMultiplex$9(MultiplexInPutDTO multiplexInPutDTO, TargetDialectInfo targetDialectInfo, String traceId, String sourceSql, AbstractActuator actuator, String multiplexTargetDialects, Object[] finalParameters, Map parameterTypes) {
        if (log.isDebugEnabled()) {
            log.debug("\u4f2a\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5f00\u59cb\uff0ctraceId [{}] SQL [{}]", new Object[]{multiplexInPutDTO.getSourceDialect(), targetDialectInfo.getTargetDialect(), traceId, sourceSql});
        }
        actuator.doExecutePreparedNoTransForm(multiplexTargetDialects, targetDialectInfo.getSchemaName(), sourceSql, finalParameters, parameterTypes, multiplexInPutDTO.getNeedTransform().booleanValue(), traceId);
        if (log.isDebugEnabled()) {
            log.debug("\u4f2a\u591a\u53d1\u6e90\u7aef[{}]\u5230\u76ee\u6807[{}]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u7ed3\u675f\uff0ctraceId [{}] SQL [{}]", new Object[]{multiplexInPutDTO.getSourceDialect(), targetDialectInfo.getTargetDialect(), traceId, sourceSql});
        }
        return String.format("\u4f2a\u591a\u53d1\u6e90\u7aef[%s]\u5230\u76ee\u6807[%s]\u76ee\u6807\u5e93\u5f02\u6b65\u6267\u884c\u5904\u7406\u5b8c\u6210", multiplexInPutDTO.getSourceDialect(), targetDialectInfo.getTargetDialect());
    }
}

