/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.service.dbactuator;

import com.hundsun.lightdb.dbabrun.dbactuator.AbstractActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.dm.DmOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.Gaussdb500OracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbMysqlBmodeActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.gaussdb.GaussdbOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.goldendb.GoldendbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.lightdb.LightdbMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.lightdb.LightdbOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.mysql.MysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.ob.ObMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.ob.ObOracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.oracle.Oracle19Actuator;
import com.hundsun.lightdb.dbabrun.dbactuator.oracle.OracleActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.postgres.PgActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlMysqlActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlPgActuator;
import com.hundsun.lightdb.dbabrun.dbactuator.tdsql.TdsqlPgOracleActuator;
import com.hundsun.lightdb.dbabrun.util.SpringContextUtils;

public class CommonActuatorStrategy {
    private static volatile CommonActuatorStrategy instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CommonActuatorStrategy getInstance() {
        if (instance != null) return instance;
        Class<CommonActuatorStrategy> clazz = CommonActuatorStrategy.class;
        synchronized (CommonActuatorStrategy.class) {
            if (instance != null) return instance;
            instance = new CommonActuatorStrategy();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AbstractActuator getActuator(String databaseType) {
        switch (databaseType.toLowerCase()) {
            case "oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"oracleCommonDbExecutor", OracleActuator.class);
            }
            case "mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"mysqlCommonDbExecutor", MysqlActuator.class);
            }
            case "ocean_base_mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"obMysqlCommonDbExecutor", ObMysqlActuator.class);
            }
            case "lightdb_oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"lightdbOracleCommonDbExecutor", LightdbOracleActuator.class);
            }
            case "ocean_base_oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"obOracleCommonDbExecutor", ObOracleActuator.class);
            }
            case "gaussdb_oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"gaussdbOracleCommonDbExecutor", GaussdbOracleActuator.class);
            }
            case "gaussdb500_oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"gaussdb500OracleCommonDbExecutor", Gaussdb500OracleActuator.class);
            }
            case "dm": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"dmOracleCommonDbExecutor", DmOracleActuator.class);
            }
            case "postgresql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"pgCommonDbExecutor", PgActuator.class);
            }
            case "tdsql_pg_oracle": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"tdsqlPgOracleCommonDbExecutor", TdsqlPgOracleActuator.class);
            }
            case "tdsql_mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"tdsqlMysqlCommonDbExecutor", TdsqlMysqlActuator.class);
            }
            case "goldendb_mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"goldendbMysqlCommonDbExecutor", GoldendbMysqlActuator.class);
            }
            case "lightdb_mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"lightdbMysqlCommonDbExecutor", LightdbMysqlActuator.class);
            }
            case "oracle_19c": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"oracle19CommonDbExecutor", Oracle19Actuator.class);
            }
            case "gaussdb_mysql": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"gaussdbMysqlCommonDbExecutor", GaussdbMysqlActuator.class);
            }
            case "gaussdb_mysql_b": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"gaussdbMysqlBCommonDbExecutor", GaussdbMysqlBmodeActuator.class);
            }
            case "tdsql_pg": {
                return (AbstractActuator)SpringContextUtils.getBean((String)"tdsqlPgCommonDbExecutor", TdsqlPgActuator.class);
            }
        }
        throw new IllegalArgumentException("Unsupported database type: " + databaseType);
    }
}

