/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.multiplex.common.apicount;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hundsun.lightdb.multiplex.service.bean.TargetDialectInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ApiAccessCounter {
    private static final Logger logger = LoggerFactory.getLogger(ApiAccessCounter.class);
    private static final String WORK_DIR = "user.dir";
    private static final String CONFIG = "config";
    private Map<String, Map<String, Integer>> todayData = new ConcurrentHashMap();
    private Map<String, Map<String, Map<String, Integer>>> historyData = new ConcurrentHashMap();
    private final String fileName = "api_count.json";
    private String countConfigPath;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private String currentDate;

    @PostConstruct
    public void init() {
        this.currentDate = this.dateFormat.format(new Date());
        this.loadHistoryData();
        if (this.historyData.containsKey(this.currentDate)) {
            this.todayData = new ConcurrentHashMap((Map)this.historyData.get(this.currentDate));
        }
    }

    private void loadHistoryData() {
        try {
            String countConfigDir = System.getProperty(WORK_DIR) + File.separator + CONFIG;
            this.countConfigPath = String.format(countConfigDir + File.separator + "%s", "api_count.json");
            File file = new File(this.countConfigPath);
            if (!file.exists()) {
                file.createNewFile();
                this.historyData = new ConcurrentHashMap();
                return;
            }
            String jsonContent = new String(Files.readAllBytes(Paths.get(this.countConfigPath, new String[0])));
            if (!jsonContent.isEmpty()) {
                this.historyData = (Map)this.objectMapper.readValue(jsonContent, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (IOException e) {
            logger.error("\u52a0\u8f7d\u5386\u53f2\u6570\u636e\u5931\u8d25: " + ExceptionUtils.getStackTrace((Throwable)e));
            this.historyData = new ConcurrentHashMap();
        }
    }

    private void saveHistoryData() {
        try {
            this.objectMapper.writeValue(new File(this.countConfigPath), (Object)this.historyData);
        }
        catch (IOException e) {
            logger.error("\u4fdd\u5b58\u5386\u53f2\u6570\u636e\u5931\u8d25: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void increment(String source, List<TargetDialectInfo> targetDialectInfoList) {
        try {
            if (Strings.isBlank((String)source) || CollectionUtils.isEmpty(targetDialectInfoList)) {
                return;
            }
            for (TargetDialectInfo targetDialectInfo : targetDialectInfoList) {
                if (StringUtils.isBlank((CharSequence)targetDialectInfo.getTargetDialect())) continue;
                this.todayData.computeIfAbsent(source, k -> new ConcurrentHashMap()).merge(targetDialectInfo.getTargetDialect(), 1, Integer::sum);
            }
            logger.debug("\u589e\u52a0\u63a5\u53e3\u8bbf\u95ee\u8ba1\u6570\u4fe1\u606f\u5b8c\u6210");
        }
        catch (Throwable e) {
            logger.error("\u589e\u52a0\u63a5\u53e3\u8bbf\u95ee\u8ba1\u6570\u4fe1\u606f\u51fa\u9519: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @PreDestroy
    public void preDestroy() {
        this.archiveTodayData();
    }

    @Scheduled(fixedRate=30000L)
    public void archiveTodayData() {
        try {
            String today = this.dateFormat.format(new Date());
            if (!today.equals(this.currentDate)) {
                this.currentDate = today;
                this.todayData = new ConcurrentHashMap();
            }
            this.historyData.put(today, new HashMap(this.todayData));
            this.saveHistoryData();
            logger.debug("\u5b9a\u671f\u4fdd\u5b58\u8ba1\u6570\u4fe1\u606f\u5b8c\u6210.");
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5386\u53f2\u6570\u636e\u5931\u8d25: " + ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public Map<String, Map<String, Map<String, Integer>>> getHistoryData() {
        return this.historyData;
    }
}

