/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.listener;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class PidGenerator
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(PidGenerator.class);
    private static final String PID_FILE_PATH = "application.pid";

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.generatePidFile();
    }

    public void generatePidFile() {
        try {
            String pid = this.getProcessId();
            File pidFile = new File(PID_FILE_PATH);
            try (FileWriter writer = new FileWriter(pidFile);){
                writer.write(pid);
                LOG.info("PID\u6587\u4ef6\u5df2\u751f\u6210: " + pidFile.getAbsolutePath() + ", PID: " + pid);
            }
            this.registerShutdownHook(pidFile);
        }
        catch (IOException e) {
            LOG.info("\u751f\u6210PID\u6587\u4ef6\u5931\u8d25: " + e.getMessage());
        }
    }

    public String getProcessId() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return processName.split("@")[0];
    }

    private void registerShutdownHook(File pidFile) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (pidFile != null && pidFile.exists() && pidFile.delete()) {
                LOG.info("PID\u6587\u4ef6\u5df2\u5220\u9664: " + pidFile.getAbsolutePath());
            }
        }));
    }
}

