/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.executor;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.ukagent.bean.DbType;
import com.hundsun.lightdb.ukagent.bean.MutilSqlResult;
import com.hundsun.lightdb.ukagent.bean.MutilSyncKey;
import com.hundsun.lightdb.ukagent.bean.SqlResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@SuppressFBWarnings(value={"SQL_INJECTION_JDBC", "SQL_INJECTION_JDBC"})
public class MultiDataSourceExecutor {
    private static final Logger log = LoggerFactory.getLogger(MultiDataSourceExecutor.class);
    @Autowired
    @Qualifier(value="syncdatasources")
    private Map<String, DataSource> dataSources;

    public MutilSqlResult executeUpdateOnAll(MutilSyncKey syncKey, String sql, List<String> params) {
        return this.executeUpdateOnAll(syncKey, sql, params, false);
    }

    public MutilSqlResult executeUpdateOnAll(MutilSyncKey syncKey, String sql, List<String> params, boolean limit) {
        MutilSqlResult mutilSqlResult = new MutilSqlResult();
        ArrayList<SqlResult> results = new ArrayList<SqlResult>(this.dataSources.size());
        mutilSqlResult.setSqlResultList(results);
        for (Map.Entry entry : this.dataSources.entrySet()) {
            String execSql = sql;
            if (limit && (DbType.LIGHTDB_MYSQL.name().equalsIgnoreCase((String)entry.getKey()) || DbType.OCEAN_BASE_MYSQL.name().equalsIgnoreCase((String)entry.getKey()))) {
                execSql = sql + " limit 1";
            }
            SqlResult result = this.executeUpdate(syncKey, (String)entry.getKey(), execSql, params);
            results.add(result);
        }
        return mutilSqlResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlResult executeUpdate(MutilSyncKey syncKey, String dataSourceName, String sql, List<String> params) {
        SqlResult result = new SqlResult();
        result.setKey(syncKey);
        result.setSql(sql);
        result.setParams(params);
        result.setDataSourceName(dataSourceName);
        Instant start = Instant.now();
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = ((DataSource)this.dataSources.get(dataSourceName.toLowerCase())).getConnection();
            pstmt = conn.prepareStatement(sql);
            if (log.isInfoEnabled()) {
                log.info("\u5f00\u59cb\u6267\u884c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sql:{}, params:{}", new Object[]{dataSourceName, syncKey.getTraceId(), syncKey.getBizSqlSequence(), syncKey.getBizSqlTableName(), dataSourceName, sql, JSON.toJSONString(params)});
            }
            this.setParameters(pstmt, params);
            int res = pstmt.executeUpdate();
            result.setSuccess(true);
            result.setUpdateCount(res);
        }
        catch (Exception e) {
            try {
                result.setSuccess(false);
                result.setErrorMessage(e.getMessage());
            }
            catch (Throwable throwable) {
                this.closeResources(null, pstmt, conn);
                result.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
                if (log.isInfoEnabled()) {
                    log.info("\u6267\u884c\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, syncKey.getTraceId(), syncKey.getBizSqlSequence(), syncKey.getBizSqlTableName(), dataSourceName, JSON.toJSONString((Object)result)});
                }
                throw throwable;
            }
            this.closeResources(null, (Statement)pstmt, conn);
            result.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
            if (log.isInfoEnabled()) {
                log.info("\u6267\u884c\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, syncKey.getTraceId(), syncKey.getBizSqlSequence(), syncKey.getBizSqlTableName(), dataSourceName, JSON.toJSONString((Object)result)});
            }
        }
        this.closeResources(null, (Statement)pstmt, conn);
        result.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
        if (log.isInfoEnabled()) {
            log.info("\u6267\u884c\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, syncKey.getTraceId(), syncKey.getBizSqlSequence(), syncKey.getBizSqlTableName(), dataSourceName, JSON.toJSONString((Object)result)});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doContinueExecuteUpdate(SqlResult sqlResult) {
        String dataSourceName;
        PreparedStatement pstmt;
        Connection conn;
        Instant start;
        block9: {
            start = Instant.now();
            conn = null;
            pstmt = null;
            dataSourceName = sqlResult.getDataSourceName().toLowerCase();
            try {
                conn = ((DataSource)this.dataSources.get(sqlResult.getDataSourceName().toLowerCase())).getConnection();
                pstmt = conn.prepareStatement(sqlResult.getSql());
                if (log.isInfoEnabled()) {
                    log.info("\u91cd\u8bd5\u6267\u884c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sql:{}, params:{}", new Object[]{dataSourceName, sqlResult.getKey().getTraceId(), sqlResult.getKey().getBizSqlSequence(), sqlResult.getKey().getBizSqlTableName(), sqlResult.getDataSourceName(), sqlResult.getSql(), JSON.toJSONString((Object)sqlResult.getParams())});
                }
                this.setParameters(pstmt, sqlResult.getParams());
                int res = pstmt.executeUpdate();
                if (res > 0) {
                    sqlResult.setSuccess(true);
                    sqlResult.setUpdateCount(res);
                    break block9;
                }
                sqlResult.setSuccess(false);
                sqlResult.setUpdateCount(res);
            }
            catch (Exception e) {
                try {
                    sqlResult.setSuccess(false);
                    sqlResult.setErrorMessage(e.getMessage());
                }
                catch (Throwable throwable) {
                    this.closeResources(null, pstmt, conn);
                    sqlResult.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
                    sqlResult.setReTryTimes(sqlResult.getReTryTimes() + 1);
                    if (log.isInfoEnabled()) {
                        log.info("\u91cd\u8bd5\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, sqlResult.getKey().getTraceId(), sqlResult.getKey().getBizSqlSequence(), sqlResult.getKey().getBizSqlTableName(), sqlResult.getDataSourceName(), JSON.toJSONString((Object)sqlResult)});
                    }
                    throw throwable;
                }
                this.closeResources(null, (Statement)pstmt, conn);
                sqlResult.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
                sqlResult.setReTryTimes(sqlResult.getReTryTimes() + 1);
                if (log.isInfoEnabled()) {
                    log.info("\u91cd\u8bd5\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, sqlResult.getKey().getTraceId(), sqlResult.getKey().getBizSqlSequence(), sqlResult.getKey().getBizSqlTableName(), sqlResult.getDataSourceName(), JSON.toJSONString((Object)sqlResult)});
                }
            }
        }
        this.closeResources(null, (Statement)pstmt, conn);
        sqlResult.setExecutionTime(Duration.between(start, Instant.now()).toMillis());
        sqlResult.setReTryTimes(sqlResult.getReTryTimes() + 1);
        if (log.isInfoEnabled()) {
            log.info("\u91cd\u8bd5\u7ed3\u679c dataSourceName:{} traceId:{}, bizSqlSequence:{} bizSqlTableName:{} dataSourceName:{} sqlResult:{}", new Object[]{dataSourceName, sqlResult.getKey().getTraceId(), sqlResult.getKey().getBizSqlSequence(), sqlResult.getKey().getBizSqlTableName(), sqlResult.getDataSourceName(), JSON.toJSONString((Object)sqlResult)});
        }
    }

    public void continueExecuteUpdate(SqlResult result, Integer maxTimes, Integer onceWaitTime) {
        for (int i = 0; i < maxTimes && !result.isSuccess() && result.getReTryTimes() < maxTimes; ++i) {
            this.doContinueExecuteUpdate(result);
            try {
                Thread.sleep(1000L * (long)onceWaitTime.intValue());
                continue;
            }
            catch (InterruptedException e) {
                log.info("sleep\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public void continueExecuteUpdate(MutilSqlResult multiSqlResult, Integer maxTimes, Integer onceWaitTime) {
        for (int i = 0; i < maxTimes; ++i) {
            for (SqlResult result : multiSqlResult.getSqlResultList()) {
                if (result.isSuccessAndChangeData() || result.getReTryTimes() >= maxTimes) continue;
                this.doContinueExecuteUpdate(result);
                try {
                    Thread.sleep(1000L * (long)onceWaitTime.intValue());
                }
                catch (InterruptedException e) {
                    log.info("sleep\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private void setParameters(PreparedStatement pstmt, List<String> params) throws SQLException {
        if (params != null && !params.isEmpty()) {
            for (int i = 0; i < params.size(); ++i) {
                String param = params.get(i);
                pstmt.setObject(i + 1, param);
            }
        }
    }

    private void closeResources(ResultSet rs, Statement stmt, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            log.error("\u5173\u95ed\u6570\u636e\u5e93\u8d44\u6e90\u5931\u8d25", (Throwable)e);
        }
    }
}

