/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.controller;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.ukagent.config.DataSourceProperties;
import com.hundsun.lightdb.ukagent.dto.BaseResponse;
import com.hundsun.lightdb.ukagent.dto.LastSyncUuidStatusRequset;
import com.hundsun.lightdb.ukagent.dto.LastSyncUuidStatusResposne;
import com.hundsun.lightdb.ukagent.dto.SyncDataFromSourceRequest;
import com.hundsun.lightdb.ukagent.dto.SyncTableColumnDataRequest;
import com.hundsun.lightdb.ukagent.dto.SyncTableColumnDataResposne;
import com.hundsun.lightdb.ukagent.exception.BizException;
import com.hundsun.lightdb.ukagent.service.SyncService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AgentController {
    private static final Logger log = LoggerFactory.getLogger(AgentController.class);
    private static final ExecutorService executorService = new ThreadPoolExecutor(50, 50, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private SyncService syncService;
    @Autowired
    private DataSourceProperties config;

    @GetMapping(value={"/ukagent/initTable"})
    public BaseResponse initTable(@RequestParam(value="schema", required=false) String schema, @RequestParam(value="table", required=false) String table, @RequestParam(value="columns", required=false) String columns) {
        if (log.isInfoEnabled()) {
            log.info("initTable \u5165\u53c2:schema {} table {} columns {}", new Object[]{schema, table, columns});
        }
        BaseResponse response = new BaseResponse();
        response.setCode(0);
        response.setMessage("success");
        if (StringUtils.isBlank((CharSequence)table) || StringUtils.isBlank((CharSequence)columns)) {
            response.setCode(1);
            response.setMessage("\u53c2\u6570\u9519\u8bef\uff1atable\u548ccolumns\u4e0d\u80fd\u4e3a\u7a7a");
            if (log.isInfoEnabled()) {
                log.info("initTables \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
            }
            return response;
        }
        try {
            this.syncService.initOneTable(schema, table, columns);
        }
        catch (BizException e) {
            response.setCode(1);
            response.setMessage(e.getMessage());
            if (log.isInfoEnabled()) {
                log.info("initTables \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
            }
            return response;
        }
        if (log.isInfoEnabled()) {
            log.info("initTable \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)response));
        }
        return response;
    }

    @PostMapping(value={"/ukagent/putSyncUuid"})
    public SyncTableColumnDataResposne putSyncDataFromSource(@Valid @RequestBody SyncTableColumnDataRequest request) {
        if (log.isInfoEnabled()) {
            log.info("putSyncUuid \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
        }
        try {
            this.checkRequest(request);
        }
        catch (BizException e) {
            SyncTableColumnDataResposne resposne = new SyncTableColumnDataResposne();
            resposne.setCode(1);
            resposne.setMessage(e.getMessage());
            return resposne;
        }
        executorService.submit(() -> {
            try {
                Thread.sleep(1000L);
                for (List rowData : request.getMultiQueryResultSet().getDataRows()) {
                    SyncDataFromSourceRequest requestOneRow = new SyncDataFromSourceRequest();
                    requestOneRow.setTraceId(request.getTraceId());
                    requestOneRow.setBizSqlSequence(request.getBizSqlSequence());
                    requestOneRow.setBizSqlSchemaName(request.getBizSqlSchemaName());
                    requestOneRow.setBizSqlTableName(request.getBizSqlTableName());
                    requestOneRow.setColumnNames(request.getMultiQueryResultSet().getColumnNames());
                    requestOneRow.setColumnValues(rowData);
                    this.syncService.syncOneRecordDataByTable(requestOneRow);
                }
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u5904\u7406putSyncDataFromSrouce\u53d1\u751f\u5f02\u5e38, traceId:{}, BizSqlSchemaName:{}, BizSqlTableName:{}", new Object[]{request.getTraceId(), request.getBizSqlSchemaName(), request.getBizSqlTableName(), e});
            }
        });
        SyncTableColumnDataResposne resposne = new SyncTableColumnDataResposne();
        resposne.setCode(0);
        resposne.setMessage("success");
        if (log.isInfoEnabled()) {
            log.info("putSyncUuid \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resposne));
        }
        return resposne;
    }

    @PostMapping(value={"/ukagent/putSyncUuidByTraceId"})
    public SyncTableColumnDataResposne putSyncUuid(@Valid @RequestBody SyncTableColumnDataRequest request) {
        if (log.isInfoEnabled()) {
            log.info("putSyncUuidByTraceId \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
        }
        try {
            this.checkRequest(request);
        }
        catch (BizException e) {
            SyncTableColumnDataResposne resposne = new SyncTableColumnDataResposne();
            resposne.setCode(1);
            resposne.setMessage(e.getMessage());
            return resposne;
        }
        executorService.submit(() -> {
            try {
                Thread.sleep(1000L);
                this.syncService.syncMutilUuidByTraceId(request);
            }
            catch (Exception e) {
                log.error("\u5f02\u6b65\u5904\u7406putSyncUuid\u53d1\u751f\u5f02\u5e38, traceId:{}, BizSqlSequence:{}, BizSqlSchemaName:{}, BizSqlTableName:{}", new Object[]{request.getTraceId(), request.getBizSqlSequence(), request.getBizSqlSchemaName(), request.getBizSqlTableName(), e});
            }
        });
        SyncTableColumnDataResposne resposne = new SyncTableColumnDataResposne();
        resposne.setCode(0);
        resposne.setMessage("success");
        if (log.isInfoEnabled()) {
            log.info("putSyncUuidByTraceId \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resposne));
        }
        return resposne;
    }

    private void checkRequest(SyncTableColumnDataRequest request) throws BizException {
        int columnCount = request.getMultiQueryResultSet().getColumnNames().size();
        if (columnCount == 0) {
            throw new BizException("\u540c\u6b65\u7ed3\u679c\u96c6\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (request.getMultiQueryResultSet().getDataRows().isEmpty()) {
            throw new BizException("\u540c\u6b65\u7ed3\u679c\u96c6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (List datarow : request.getMultiQueryResultSet().getDataRows()) {
            if (datarow.size() == columnCount) continue;
            throw new BizException("\u540c\u6b65\u7ed3\u679c\u96c6\u6570\u636e\u5217\u4e0e\u5217\u540d\u4e2a\u6570\u4e0d\u5339\u914d");
        }
    }

    @PostMapping(value={"/ukagent/getLastSyncUuidStatus"})
    public LastSyncUuidStatusResposne getLastSyncUuidStatus(@RequestBody LastSyncUuidStatusRequset request) {
        boolean status;
        if (log.isInfoEnabled()) {
            log.info("getLastSyncUuidStatus \u5165\u53c2:{}", (Object)JSON.toJSONString((Object)request));
        }
        LastSyncUuidStatusResposne resposne = new LastSyncUuidStatusResposne();
        try {
            status = this.syncService.lastSyncUuidStatus();
        }
        catch (BizException e) {
            resposne.setCode(0);
            resposne.setMessage(e.getMessage());
            return resposne;
        }
        if (status) {
            resposne.setSyncStatus(1);
        } else {
            resposne.setSyncStatus(0);
        }
        resposne.setCode(0);
        resposne.setMessage("success");
        if (log.isInfoEnabled()) {
            log.info("getLastSyncUuidStatus \u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)resposne));
        }
        return resposne;
    }
}

