/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.ukagent.bean;

import com.alibaba.fastjson2.JSON;
import com.hundsun.lightdb.ukagent.bean.SyncEntity;
import com.hundsun.lightdb.ukagent.exception.BizException;
import com.hundsun.lightdb.ukagent.service.impl.MultiSyncServiceImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutilSyncContext {
    private static final Logger log = LoggerFactory.getLogger(MultiSyncServiceImpl.class);
    private LocalDateTime createTime = LocalDateTime.now();
    private String traceId;
    private Boolean recvFinish;
    private Integer syncNodeCount;
    private SyncEntity primarySyncEntity;
    private List<SyncEntity> syncEntities;
    private Integer totalColumnCount;
    private Integer totalRowCount;

    public MutilSyncContext(String traceId, Integer syncNodeCount) {
        this.traceId = traceId;
        this.syncNodeCount = syncNodeCount;
        this.syncEntities = new ArrayList();
        this.recvFinish = false;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public Boolean getRecvFinish() {
        return this.recvFinish;
    }

    public void setRecvFinish(Boolean recvFinish) {
        this.recvFinish = recvFinish;
    }

    public synchronized Boolean addSyncEntity(SyncEntity syncEntity) throws BizException {
        if (this.recvFinish.booleanValue()) {
            if (log.isWarnEnabled()) {
                log.warn("\u540c\u6b65\u4fe1\u606f\u5df2\u6536\u96c6\u5b8c\u6bd5\uff0c \u4ecd\u65e7\u83b7\u53d6\u5230\u540c\u6b65\u8bf7\u6c42\uff0c traceId {}, bizSqlSequence {}, syncEntity {}", new Object[]{this.traceId, syncEntity.getBizSqlSequence(), JSON.toJSONString((Object)syncEntity)});
            }
            return false;
        }
        if (syncEntity.getSourceDialect().equals(syncEntity.getTargetDialect())) {
            this.primarySyncEntity = syncEntity;
            for (SyncEntity entity : this.syncEntities) {
                entity.setNewValues(this.primarySyncEntity.getCurrentValues());
                this.checkDataConsistency(this.primarySyncEntity, entity);
            }
        } else {
            if (this.primarySyncEntity != null) {
                syncEntity.setNewValues(this.primarySyncEntity.getCurrentValues());
                this.checkDataConsistency(this.primarySyncEntity, syncEntity);
            }
            this.syncEntities.add(syncEntity);
        }
        if (this.syncEntities.size() >= this.syncNodeCount && this.primarySyncEntity != null) {
            this.recvFinish = true;
        }
        return this.recvFinish;
    }

    public Boolean isRecvFinish() {
        return this.recvFinish;
    }

    public List<SyncEntity> getSyncEntities() {
        if (this.recvFinish.booleanValue()) {
            return this.syncEntities;
        }
        return null;
    }

    public Integer getTotalColumnCount() {
        return this.totalColumnCount;
    }

    public void setTotalColumnCount(Integer totalColumnCount) {
        this.totalColumnCount = totalColumnCount;
    }

    public Integer getTotalRowCount() {
        return this.totalRowCount;
    }

    public void setTotalRowCount(Integer totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    private void checkDataConsistency(SyncEntity primarySyncEntity, SyncEntity syncEntity) throws BizException {
        if (primarySyncEntity.getColumnName().size() != syncEntity.getColumnName().size()) {
            log.info("primarySyncEntity:{} syncEntity:{}", (Object)JSON.toJSONString((Object)primarySyncEntity), (Object)JSON.toJSONString((Object)syncEntity));
            throw new BizException("\u4e3b\u8282\u70b9\u548c\u540c\u6b65\u8282\u70b9\u63a5\u6536\u5230\u7684\u5217\u6570\u4e0d\u4e00\u81f4\uff0c\u653e\u5f03\u672c\u6b21\u540c\u6b65");
        }
        if (primarySyncEntity.getCurrentValues().size() != syncEntity.getCurrentValues().size()) {
            log.info("primarySyncEntity:{} syncEntity:{}", (Object)JSON.toJSONString((Object)primarySyncEntity), (Object)JSON.toJSONString((Object)syncEntity));
            throw new BizException("\u4e3b\u8282\u70b9\u548c\u540c\u6b65\u8282\u70b9\u63a5\u6536\u5230\u7684\u6570\u636e\u884c\u4e0d\u4e00\u81f4\uff0c\u653e\u5f03\u672c\u6b21\u540c\u6b65");
        }
    }
}

