/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb;

import com.hundsun.lightdb.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@SuppressFBWarnings(value={"PATH_TRAVERSAL_OUT", "PATH_TRAVERSAL_IN", "SQL_INJECTION_JDBC", "EXTERNAL_CONFIG_CONTROL", "DMI_HARDCODED_EXEC_COMMAND"})
public class DataCompare {
    private static final Logger log = LoggerFactory.getLogger(DataCompare.class);
    static ConcurrentSkipListMap<String, Long> oracleRows = new ConcurrentSkipListMap();
    static ConcurrentSkipListMap<String, Long> lightdbRows = new ConcurrentSkipListMap();
    static final AtomicInteger SUCCESS = new AtomicInteger(0);
    static final AtomicInteger FAILED = new AtomicInteger(0);
    static final AtomicInteger TOTAL = new AtomicInteger(0);
    static final AtomicInteger SUCCESS_LIGHTDB = new AtomicInteger(0);
    static final AtomicInteger FAILED_LIGHTDB = new AtomicInteger(0);
    static final AtomicInteger TOTAL_LIGHTDB = new AtomicInteger(0);

    public static void printTime(long currentTimeMillis, String prefix) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedTime = dateFormat.format(new Date(currentTimeMillis));
        log.info(prefix + formattedTime);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        String confDir;
        try {
            Class.forName("oracle.jdbc.driver.OracleDriver");
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        DataCompare.printTime((long)currentTimeMillis, (String)"\u5f00\u59cb\u65f6\u95f4\uff1a");
        int threadCount = 4;
        String s = System.getProperty("threadCount");
        if (s != null) {
            threadCount = Integer.parseInt(s);
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount);
        String userInfo = System.getProperty("userInfo");
        String username = System.getProperty("username");
        String password = System.getProperty("password");
        String lightdbUrl = System.getProperty("lightdbUrl");
        String usernameLightDB = System.getProperty("usernameLightDB");
        String passwordLightDB = System.getProperty("passwordLightDB");
        if (userInfo == null) {
            log.info("usage: java -DuserInfo=host:port/database -DlightdbUrl=host:port/database -Dusername=xxx -Dpassword=xxx-DusernameLightDB=xxx -DpasswordLightDB=xxx -Dconf.dir=xxx -DthreadCount=xxx -jar datacompare.jar\nuserInfo \u5230oracle\u7684\u8fde\u63a5\u4e32\nusername \u5230oracle\u7684\u7528\u6237\u540d\npassword \u5230oracle\u7684\u5bc6\u7801\nlightdbUrl \u5230lightdb\u7684jdbc url\nusernameLightDB \u5230lightdb\u7684\u7528\u6237\u540d\npasswordLightDB \u5230lightdb\u7684\u5bc6\u7801\nthreadCount \u7ebf\u7a0b\u6570,\u9ed8\u8ba48\nconfDir \u8868\u7684schema\u6e05\u5355,\u9017\u53f7\u5206\u5272\u3001\u5e26\u5355\u5f15\u53f7\u3002\u9ed8\u8ba4\u503c\u5f53\u524d\u8def\u5f84data_compare.txt\n");
            System.exit(-1);
        }
        if ((confDir = System.getProperty("conf.dir")) == null) {
            confDir = "data_compare.txt";
        }
        BufferedReader reader = new BufferedReader(new FileReader(confDir));
        String owners = "";
        while ((owners = reader.readLine()) != null && ("".equals(owners = owners.trim()) || owners.startsWith("#"))) {
        }
        String sqlOracle = String.format("with indx_t as (SELECT\n\tDISTINCT owner || '.' || table_name x1, 'select /*+ PARALLEL_INDEX(t,' || first_value(index_name) OVER(PARTITION BY owner, table_name ORDER BY uniqueness DESC) || ',3) */count(1) from ' || owner || '.' || table_name || ' t'\nFROM\n\tdba_indexes\nWHERE\n\ttable_type = 'TABLE'\n\tAND owner IN (%s)) \nselect * from indx_t union select owner || '.' || table_name, 'select /*+ parallel(t 2) */ count(1) from ' || owner || '.' || table_name || ' t'\nfrom dba_tables WHERE owner || '.' || table_name NOT IN (select x1 from indx_t) AND owner IN (%s)", owners == null ? "" : owners.toUpperCase(), owners.toUpperCase());
        try {
            String connectionString = "jdbc:oracle:thin:@" + userInfo;
            Connection connection = null;
            try {
                connection = DriverManager.getConnection(connectionString, username, password);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Statement stmt = connection.createStatement();
            log.info("\u751f\u6210\u7edf\u8ba1\u8bed\u53e5\uff1a" + sqlOracle);
            ResultSet resultSet = stmt.executeQuery(sqlOracle);
            HashMap<String, String> getRowsStmt = new HashMap<String, String>(16);
            while (resultSet.next()) {
                getRowsStmt.put(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
            stmt.close();
            connection.close();
            for (Map.Entry ddl : getRowsStmt.entrySet()) {
                executor.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                TOTAL.addAndGet(1);
            }
            reader.close();
            log.info("\u5f85\u5bf9\u6bd4oracle\u8868\u603b\u6570:" + TOTAL.get());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ExecutorService executorLightDB = Executors.newFixedThreadPool(threadCount);
        String sqlLightDB = "with indx_t as (select distinct schemaname || '.' || tablename x1,'select /*+ index(t '|| first_value(indexname) over(partition by schemaname,tablename order by substr(indexdef,8,1) desc) ||') */count(1) from ' || schemaname || '.' || tablename || ' t' from pg_indexes where schemaname in (" + owners.toLowerCase() + ")and schemaname || '.' || tablename in    (select (select nspname from pg_namespace d where d.oid=relnamespace) || '.' ||  relname       from pg_class where relkind in ('p','r') and relispartition='f'))\nselect * from indx_t union \nselect schemaname || '.' || tablename,'select count(1) from ' || schemaname || '.' || tablename || ' t' from pg_tables where schemaname || '.' || tablename not in (select x1 from indx_t)  and schemaname || '.' || tablename in    (select (select nspname from pg_namespace d where d.oid=relnamespace) || '.' ||  relname \n                      from pg_class where relkind in ('p','r') and relispartition='f')\n  and schemaname in (" + owners.toLowerCase() + ") and tablename not like 'BIN$%%$0'";
        try {
            String connectionString = "jdbc:postgresql://" + lightdbUrl;
            Connection connection = null;
            try {
                connection = DriverManager.getConnection(connectionString, usernameLightDB, passwordLightDB);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            Statement stmt = connection.createStatement();
            log.info("\u751f\u6210\u7edf\u8ba1\u8bed\u53e5\uff1a" + sqlLightDB);
            ResultSet resultSet = stmt.executeQuery(sqlLightDB);
            HashMap<String, String> getRowsStmt = new HashMap<String, String>(16);
            while (resultSet.next()) {
                getRowsStmt.put(resultSet.getString(1), resultSet.getString(2));
            }
            resultSet.close();
            stmt.close();
            connection.close();
            for (Map.Entry ddl : getRowsStmt.entrySet()) {
                executorLightDB.submit((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                TOTAL_LIGHTDB.addAndGet(1);
            }
            reader.close();
            log.info("\u5f85\u5bf9\u6bd4lightdb\u8868\u603b\u6570:" + TOTAL_LIGHTDB.get());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        log.info("\u6240\u6709lightdb\u8868\u7edf\u8ba1\u4efb\u52a1\u5df2\u63d0\u4ea4\uff0c\u5171" + TOTAL_LIGHTDB.get() + "\uff0c\u7b49\u5f85\u6240\u6709lightdb\u8868\u7edf\u8ba1\u5b8c\u6210\u3002");
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.DAYS);
        log.info("\u6240\u6709oracle\u8868\u5df2\u7edf\u8ba1\u5b8c\u6210\uff0c\u5171:" + TOTAL.get() + ",\u6210\u529f:" + SUCCESS.get() + ",\u5931\u8d25:" + FAILED.get() + "\n\n\n\n");
        executorLightDB.shutdown();
        executorLightDB.awaitTermination(1L, TimeUnit.DAYS);
        log.info("\u6240\u6709lightdb\u8868\u5df2\u7edf\u8ba1\u5b8c\u6210:" + TOTAL_LIGHTDB.get() + ",\u6210\u529f:" + SUCCESS_LIGHTDB.get() + ",\u5931\u8d25:" + FAILED_LIGHTDB.get());
        String html = "<html>\n\n<head>\n\t<title>lightdb\u4e0eoracle\u6570\u636e\u5bf9\u6bd4\u62a5\u544a</title>\n</head>\n<body>\n";
        String summary = "\t<h1>\u6bd4\u5bf9\u6c47\u603b</h1>\n";
        String compreHead = "\t<h1>\u6570\u636e\u6bd4\u5bf9\u660e\u7ec6</h1>\n\t<table border=\"1\" cellspacing=\"0\" cellpadding=\"10\"><thead><tr><th>\u8868\u540d</th><th>oracle\u884c\u6570</th><th>lightdb\u884c\u6570</th><th>\u662f\u5426\u4e00\u81f4</th></tr></thead><tbody>\n";
        String foot = "</tbody></table></body>\n\n</html>";
        String body = "";
        boolean debug = System.getProperty("debug") != null;
        int incorrect = 0;
        int oraclehas = 0;
        int correct = 0;
        if (debug) {
            log.info("oracle: " + oracleRows.size() + "," + oracleRows.keySet());
            log.info("lightdb: " + lightdbRows.size() + "," + lightdbRows.keySet());
        }
        for (Map.Entry oracleTable : oracleRows.entrySet()) {
            try {
                long oracleRows = (Long)oracleTable.getValue();
                long lightdbRows = DataCompare.lightdbRows.getOrDefault(oracleTable.getKey(), -1L);
                String info = "\u4e0d\u4e00\u81f4";
                String bg = "bgcolor=\"#FF0000\"";
                if (oracleRows == lightdbRows) {
                    bg = "";
                    info = "\u4e00\u81f4";
                    ++correct;
                } else if (lightdbRows == -1L) {
                    info = "oracle\u4e2d\u5b58\u5728\u8be5\u8868\uff0c\u4f46\u662flightdb\u4e2d\u4e0d\u5b58\u5728\uff0c\u8fc1\u79fb\u7f3a\u5931!";
                    ++incorrect;
                    ++oraclehas;
                } else {
                    ++incorrect;
                }
                body = body + "<tr><td>" + (String)oracleTable.getKey() + "</td><td>" + oracleRows + "</td><td>" + lightdbRows + "</td><td " + bg + ">" + info + "</td></tr>\n";
            }
            catch (Exception e) {
                log.error("\u751f\u6210\u62a5\u544a\u62a5\u9519, oracleTable.getKey()=" + (String)oracleTable.getKey());
                e.printStackTrace();
            }
        }
        summary = summary + MessageFormat.format("<h2>oracle\u5171:{0}\u5f20\u8868\uff0clightdb\u5171:{1}\u5f20\u8868\u3002\u5176\u4e2d\u5b8c\u5168\u4e00\u81f4:{2}\u5f20\u3002\u4e0d\u4e00\u81f4:{3}\u5f20\uff0c\u4e0d\u4e00\u81f4\u4e2dlightdb\u7f3a\u5c11\u7684\u8868:{4}\u5f20</h2>", oracleRows.size(), lightdbRows.size(), correct, incorrect, oraclehas);
        try {
            FileWriter writer = new FileWriter("data_compare.html");
            writer.write(html);
            writer.write(summary);
            writer.write(compreHead);
            writer.write(body);
            writer.write(foot);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        currentTimeMillis = System.currentTimeMillis();
        DataCompare.printTime((long)currentTimeMillis, (String)"\u7ed3\u675f\u65f6\u95f4\uff1a");
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

