/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.util;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.core.v3.ConnectionFactoryImpl;
import com.tencentcloud.tdsql.pg.jdbc.Driver;
import com.tencentcloud.tdsql.pg.jdbc.PgArray;
import com.tencentcloud.tdsql.pg.jdbc.PgClob;
import com.tencentcloud.tdsql.pg.jdbc.PgResultSet;
import com.tencentcloud.tdsql.pg.jdbc.PgSQLXML;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.HStoreConverter;
import com.tencentcloud.tdsql.pg.util.PGOrclBlob;
import com.tencentcloud.tdsql.pg.util.PGOrclStringClob;
import com.tencentcloud.tdsql.pg.util.PGobject;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PGStruct
extends PGobject
implements Struct {
    protected BaseConnection connection;
    protected int oid;
    protected Object[] attributes = null;
    private static final int[] HEX_VALS;

    public PGStruct(BaseConnection connection, int oid, Object[] attributes) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.type = connection.getTypeInfo().getPGType(oid);
        this.attributes = attributes;
        this.value = this.ConvertToString();
    }

    public PGStruct(BaseConnection connection, int oid, String value) throws SQLException {
        this.connection = connection;
        this.oid = oid;
        this.type = connection.getTypeInfo().getPGType(oid);
        this.value = value;
        this.attributes = this.convertToObjArr(value);
    }

    public int getOid() {
        return this.oid;
    }

    @Override
    public String getSQLTypeName() {
        return this.type;
    }

    @Override
    public Object[] getAttributes() {
        return this.attributes;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "NULL";
        }
        return this.value;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw Driver.notImplemented(this.getClass(), "getAttributes(Map)");
    }

    private String ConvertToString() throws SQLException {
        if (this.attributes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            if (this.attributes[i] == null) continue;
            String objStr = null;
            objStr = this.attributes[i] instanceof Clob ? ((Clob)this.attributes[i]).getSubString(1L, (int)((Clob)this.attributes[i]).length()) : (this.attributes[i] instanceof byte[] ? new String((byte[])this.attributes[i]) : (this.attributes[i] instanceof Blob ? new String(((Blob)this.attributes[i]).getBytes(1L, (int)((Blob)this.attributes[i]).length())) : this.attributes[i].toString()));
            this.processStr(objStr, sb);
        }
        sb.append(")");
        return sb.toString();
    }

    private void processStr(String str, StringBuilder sb) {
        sb.append('\"');
        if (str.indexOf(34) == -1 && str.indexOf(92) == -1) {
            sb.append(str);
        } else {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch == '\"') {
                    sb.append('\"');
                } else if (ch == '\\') {
                    sb.append('\\');
                }
                sb.append(ch);
            }
        }
        sb.append('\"');
    }

    private Object[] convertToObjArr(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        List<Integer> attributesOidList = this.connection.getTypeInfo().getPGStructAttributes(this.oid);
        if (value.startsWith("(") && value.endsWith(")")) {
            value = value.substring(1, value.length() - 1);
        }
        String[] valueArr = this.splitStr(value);
        ArrayList<Object> ObjList = new ArrayList<Object>();
        for (int i = 0; i < valueArr.length; ++i) {
            int attOid = attributesOidList.get(i);
            int sqlType = this.connection.getTypeInfo().getSQLType(attOid);
            String objStr = valueArr[i];
            ObjList.add(this.getObject(objStr, attOid, sqlType));
        }
        this.attributes = ObjList.toArray();
        return this.attributes;
    }

    private Object getObject(String objStr, int attOid, int sqlType) throws SQLException {
        if (objStr == null) {
            return null;
        }
        if (sqlType != 2002 && sqlType != 2003 && objStr.startsWith("\"") && objStr.endsWith("\"")) {
            objStr = objStr.substring(1, objStr.length() - 1);
        }
        switch (sqlType) {
            case -7: 
            case 16: {
                return PGStruct.convertStringToBoolean(objStr);
            }
            case 2009: {
                return new PgSQLXML(this.connection, objStr);
            }
            case -6: 
            case 4: 
            case 5: {
                if (ConnectionFactoryImpl.ORACLE_COMPILE) {
                    return PgResultSet.toBigDecimal(objStr);
                }
                return PgResultSet.toInt(objStr);
            }
            case -5: {
                if (ConnectionFactoryImpl.ORACLE_COMPILE && attOid == 20) {
                    return PgResultSet.toBigDecimal(objStr);
                }
                return PgResultSet.toLong(objStr);
            }
            case 2: 
            case 3: {
                return PgResultSet.toBigDecimal(objStr);
            }
            case 7: {
                return Float.valueOf(PgResultSet.toFloat(objStr));
            }
            case 6: 
            case 8: {
                return PgResultSet.toDouble(objStr);
            }
            case -1: 
            case 1: 
            case 12: {
                return objStr;
            }
            case 91: {
                return this.connection.getTimestampUtils().toDate(null, objStr);
            }
            case 92: {
                return this.connection.getTimestampUtils().toTime(null, objStr);
            }
            case 93: {
                if (attOid == 1083 || attOid == 1266) {
                    Timestamp tsWithMicros = this.connection.getTimestampUtils().toTimestamp(null, objStr);
                    Timestamp tsUnixEpochDate = new Timestamp(this.connection.getTimestampUtils().toTime(null, objStr).getTime());
                    tsUnixEpochDate.setNanos(tsWithMicros.getNanos());
                    return tsUnixEpochDate;
                }
                return this.connection.getTimestampUtils().toTimestamp(null, objStr);
            }
            case -4: 
            case -3: 
            case -2: {
                return PGStruct.toBytesHexEscaped(objStr.toCharArray());
            }
            case 2003: {
                return new PgArray(this.connection, attOid, objStr);
            }
            case 2002: {
                return new PGStruct(this.connection, attOid, objStr);
            }
            case 2005: {
                if (ConnectionFactoryImpl.ORACLE_COMPILE) {
                    if (ConnectionFactoryImpl.CLOB_AS_STRING) {
                        return objStr;
                    }
                    return new PGOrclStringClob(this.connection, objStr);
                }
                return new PgClob(this.connection, PgResultSet.toLong(objStr));
            }
            case 2004: {
                return new PGOrclBlob(this.connection, PGStruct.toBytesHexEscaped(objStr.toCharArray()));
            }
        }
        String type = this.connection.getTypeInfo().getPGType(attOid);
        if (type.equals("uuid")) {
            UUID uuid;
            try {
                uuid = UUID.fromString(objStr);
            }
            catch (IllegalArgumentException iae) {
                throw new PSQLException(GT.tr("Invalid UUID data.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE, (Throwable)iae);
            }
            return uuid;
        }
        if ("hstore".equals(type)) {
            return HStoreConverter.fromString(objStr);
        }
        return objStr;
    }

    private static Boolean convertStringToBoolean(String objStr) throws SQLException {
        String val = objStr.trim();
        if ("1".equals(val) || "true".equalsIgnoreCase(val) || "t".equalsIgnoreCase(val) || "yes".equalsIgnoreCase(val) || "y".equalsIgnoreCase(val) || "on".equalsIgnoreCase(val)) {
            return true;
        }
        if ("0".equals(val) || "false".equalsIgnoreCase(val) || "f".equalsIgnoreCase(val) || "no".equalsIgnoreCase(val) || "n".equalsIgnoreCase(val) || "off".equalsIgnoreCase(val)) {
            return false;
        }
        try {
            return PGStruct.fromNumberInOracleCompile(Double.parseDouble(val));
        }
        catch (NumberFormatException e) {
            throw new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(objStr)), PSQLState.CANNOT_COERCE);
        }
    }

    private static boolean fromNumberInOracleCompile(Number numval) throws SQLException {
        double value = numval.doubleValue();
        if (value == 0.0) {
            return false;
        }
        if (!Double.isNaN(value)) {
            return true;
        }
        throw new PSQLException(GT.tr("Cannot cast to boolean: \"{0}\"", String.valueOf(numval)), PSQLState.CANNOT_COERCE);
    }

    private static byte[] toBytesHexEscaped(char[] s) {
        int realLength = s.length - 2;
        byte[] output = new byte[realLength >>> 1];
        for (int i = 0; i < realLength; i += 2) {
            int val = PGStruct.getHex(s[2 + i]) << 4;
            output[i >>> 1] = (byte)(val |= PGStruct.getHex(s[3 + i]));
        }
        return output;
    }

    private static int getHex(char b) {
        return HEX_VALS[b - 48];
    }

    private String[] splitStr(String value) {
        int i;
        if (value.isEmpty()) {
            return new String[0];
        }
        char[] aChars = value.toCharArray();
        int valueLen = aChars.length;
        ArrayList<String> res = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Index index = new Index();
        boolean inQuotes = false;
        boolean isNullString = true;
        block5: for (i = 0; i < valueLen; ++i) {
            char aChar = aChars[i];
            switch (aChar) {
                case '\"': {
                    if (inQuotes && i + 1 < valueLen && aChars[i + 1] == '\"') {
                        this.moveIndex(++i, index, sb, value);
                        continue block5;
                    }
                    boolean bl = inQuotes = !inQuotes;
                    if (index.start >= index.end && sb.length() == 0) {
                        isNullString = false;
                    }
                    this.processQuote(i, index, sb, value);
                    continue block5;
                }
                case '\\': {
                    if (i + 1 >= valueLen || aChars[i + 1] != '\"' && aChars[i + 1] != '\\' && aChars[i + 1] != ',') continue block5;
                    this.moveIndex(++i, index, sb, value);
                    continue block5;
                }
                case ',': {
                    if (!inQuotes) {
                        String tmp = this.getStrByIndex(i, index, sb, value);
                        if (isNullString && tmp.isEmpty()) {
                            res.add(null);
                        } else {
                            res.add(tmp);
                        }
                        sb.setLength(0);
                        index.start = index.end = i + 1;
                        isNullString = true;
                        continue block5;
                    }
                }
                default: {
                    this.moveIndex(i, index, sb, value);
                    isNullString = false;
                }
            }
        }
        if (!inQuotes) {
            String tmp = this.getStrByIndex(i, index, sb, value);
            if (isNullString && tmp.isEmpty()) {
                res.add(null);
            } else {
                res.add(tmp);
            }
        }
        return res.toArray(new String[0]);
    }

    private void moveIndex(int pos, Index index, StringBuilder sb, String value) {
        if (index.start == index.end) {
            index.start = pos;
            index.end = pos + 1;
        } else if (index.end == pos) {
            ++index.end;
        } else {
            if (index.start < index.end) {
                sb.append(value, index.start, index.end);
                index.start = index.end = pos + 1;
            }
            sb.append(value.charAt(pos));
        }
    }

    private String getStrByIndex(int pos, Index index, StringBuilder sb, String value) {
        if (sb.length() == 0) {
            return value.substring(index.start, index.end);
        }
        if (index.start < index.end) {
            sb.append(value, index.start, index.end);
            index.start = index.end = pos + 1;
        }
        return sb.toString();
    }

    private void processQuote(int pos, Index index, StringBuilder sb, String value) {
        if (pos > 2 && value.charAt(pos - 1) != ',' && value.length() - 1 > pos && value.charAt(pos + 1) != ',') {
            String str;
            if ((index.start < index.end || sb.length() != 0) && PGStruct.onlyContainWhitespace(str = this.getStrByIndex(pos, index, sb, value))) {
                sb.setLength(0);
                index.start = index.end = pos + 1;
                return;
            }
            this.moveIndex(pos, index, sb, value);
        }
    }

    private static boolean onlyContainWhitespace(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        int i;
        HEX_VALS = new int[55];
        for (i = 0; i < 10; ++i) {
            PGStruct.HEX_VALS[i] = (byte)i;
        }
        for (i = 0; i < 6; ++i) {
            PGStruct.HEX_VALS[65 + i - 48] = (byte)(10 + i);
            PGStruct.HEX_VALS[97 + i - 48] = (byte)(10 + i);
        }
    }

    private class Index {
        int start = 0;
        int end = 0;

        Index() {
        }
    }
}

