/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.replication.fluent;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.core.ReplicationProtocol;
import com.tencentcloud.tdsql.pg.replication.PGReplicationStream;
import com.tencentcloud.tdsql.pg.replication.fluent.ChainedStreamBuilder;
import com.tencentcloud.tdsql.pg.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.tencentcloud.tdsql.pg.replication.fluent.logical.LogicalReplicationOptions;
import com.tencentcloud.tdsql.pg.replication.fluent.logical.LogicalStreamBuilder;
import com.tencentcloud.tdsql.pg.replication.fluent.logical.StartLogicalReplicationCallback;
import com.tencentcloud.tdsql.pg.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.tencentcloud.tdsql.pg.replication.fluent.physical.PhysicalReplicationOptions;
import com.tencentcloud.tdsql.pg.replication.fluent.physical.PhysicalStreamBuilder;
import com.tencentcloud.tdsql.pg.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

