/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.largeobject;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class PGBlobOutputStream
extends OutputStream {
    private Blob blob;
    private long lobOffset;

    public PGBlobOutputStream(Blob blob) {
        this(blob, 1L);
    }

    public PGBlobOutputStream(Blob blob, long pos) {
        if (blob == null || pos < 1L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        this.blob = blob;
        this.lobOffset = pos;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        byte[] bytes = new byte[]{(byte)b};
        try {
            this.lobOffset += (long)this.blob.setBytes(this.lobOffset, bytes);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (b == null) {
            throw new NullPointerException();
        }
        try {
            this.lobOffset += (long)this.blob.setBytes(this.lobOffset, b, off, len);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.blob != null) {
            this.blob = null;
        }
    }

    private void checkClosed() throws IOException {
        if (this.blob == null) {
            throw new IOException("PGBlobOutputStream is closed.");
        }
    }
}

