/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.jdbc;

import com.tencentcloud.tdsql.pg.core.BaseConnection;
import com.tencentcloud.tdsql.pg.largeobject.BytesObject;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public abstract class AbstractOrclBlobClob {
    protected BaseConnection conn;
    private BytesObject bytesObject;
    private boolean support64bit;

    public AbstractOrclBlobClob(BaseConnection conn, byte[] bytes) throws SQLException {
        this.conn = conn;
        this.bytesObject = new BytesObject();
        try {
            this.bytesObject.write(bytes);
        }
        catch (IOException e) {
            throw new SQLException("failed write bytes");
        }
        this.support64bit = conn.haveMinimumServerVersion(90300);
    }

    public synchronized void free() throws SQLException {
        try {
            this.bytesObject.close();
        }
        catch (IOException e) {
            throw new SQLException("failed write bytes");
        }
        this.bytesObject = null;
    }

    public synchronized void truncate(long len) throws SQLException {
        this.checkFreed();
        if (len >= (long)this.bytesObject.size()) {
            this.bytesObject.reset();
            return;
        }
        this.bytesObject.truncate((int)len);
    }

    public synchronized long length() throws SQLException {
        this.checkFreed();
        return this.bytesObject.toByteArray().length;
    }

    public synchronized byte[] getBytes(long pos, int length) throws SQLException {
        this.assertPosition(pos);
        return this.bytesObject.getBytes((int)(pos - 1L), (int)(pos - 1L + (long)length));
    }

    public synchronized InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.bytesObject.toByteArray());
    }

    public synchronized OutputStream setBinaryStream(long pos) throws SQLException {
        this.bytesObject.setPos((int)(pos - 1L));
        return this.bytesObject;
    }

    public synchronized long position(byte[] pattern, long start) throws SQLException {
        this.assertPosition(start, pattern.length);
        int patternIdx = 0;
        long result = -1L;
        int tmpPosition = 1;
        byte[] bytes = this.bytesObject.toByteArray();
        for (int position = (int)(start - 1L); position < bytes.length; ++position) {
            byte b = bytes[position];
            if (b == pattern[patternIdx]) {
                if (patternIdx == 0) {
                    tmpPosition = position;
                }
                if (++patternIdx != pattern.length) continue;
                result = tmpPosition;
                break;
            }
            patternIdx = 0;
        }
        return result + 1L;
    }

    public synchronized long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    protected void assertPosition(long pos) throws SQLException {
        this.assertPosition(pos, 0L);
    }

    protected void assertPosition(long pos, long len) throws SQLException {
        this.checkFreed();
        if (pos < 1L) {
            throw new PSQLException(GT.tr("LOB positioning offsets start at 1.", new Object[0]), PSQLState.INVALID_PARAMETER_VALUE);
        }
        if (pos + len - 1L > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("PostgreSQL LOBs can only index to: {0}", Integer.MAX_VALUE), PSQLState.INVALID_PARAMETER_VALUE);
        }
    }

    protected void checkFreed() throws SQLException {
        if (this.bytesObject == null) {
            throw new PSQLException(GT.tr("free() was called on this LOB previously", new Object[0]), PSQLState.OBJECT_NOT_IN_STATE);
        }
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.assertPosition(pos);
        this.bytesObject.setPos((int)pos - 1);
        this.bytesObject.write(bytes, offset, len);
        return len;
    }
}

