/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloud.tdsql.pg.gss;

import com.tencentcloud.tdsql.pg.PGProperty;
import com.tencentcloud.tdsql.pg.core.PGStream;
import com.tencentcloud.tdsql.pg.gss.GSSCallbackHandler;
import com.tencentcloud.tdsql.pg.gss.GssAction;
import com.tencentcloud.tdsql.pg.gss.GssEncAction;
import com.tencentcloud.tdsql.pg.util.GT;
import com.tencentcloud.tdsql.pg.util.PSQLException;
import com.tencentcloud.tdsql.pg.util.PSQLState;
import com.tencentcloud.tdsql.pg.util.internal.Nullness;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MakeGSS {
    private static final Logger LOGGER = Logger.getLogger(MakeGSS.class.getName());

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void authenticate(boolean encrypted, PGStream pgStream, String host, String user, char @Nullable [] password, @Nullable String jaasApplicationName, @Nullable String kerberosServerName, boolean useSpnego, boolean jaasLogin, boolean logServerErrorDetail) throws IOException, PSQLException {
        Exception result;
        LOGGER.log(Level.FINEST, " <=BE AuthenticationReqGSS");
        if (jaasApplicationName == null) {
            jaasApplicationName = PGProperty.JAAS_APPLICATION_NAME.getDefaultValue();
        }
        if (kerberosServerName == null) {
            kerberosServerName = "postgres";
        }
        try {
            boolean performAuthentication = jaasLogin;
            LoginContext lc = new LoginContext(Nullness.castNonNull(jaasApplicationName), new GSSCallbackHandler(user, password));
            lc.login();
            Subject sub = lc.getSubject();
            if (encrypted) {
                @Nullable GssEncAction action = new GssEncAction(pgStream, sub, host, user, kerberosServerName, useSpnego, logServerErrorDetail);
                result = Subject.doAs(sub, action);
            } else {
                @Nullable GssAction action = new GssAction(pgStream, sub, host, kerberosServerName, useSpnego, logServerErrorDetail);
                result = Subject.doAs(sub, action);
            }
        }
        catch (Exception e) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)e);
        }
        if (result instanceof IOException) {
            throw (IOException)result;
        }
        if (result instanceof PSQLException) {
            throw (PSQLException)result;
        }
        if (result != null) {
            throw new PSQLException(GT.tr("GSS Authentication failed", new Object[0]), PSQLState.CONNECTION_FAILURE, (Throwable)result);
        }
    }
}

