/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.quartzscheduler;

import com.hundsun.lightdb.motion.quartzscheduler.JobService;
import com.hundsun.lightdb.motion.service.TaskConfigService;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class DynamicQuartzScheduler {
    private static final Logger log = LoggerFactory.getLogger(DynamicQuartzScheduler.class);
    @Autowired
    private TaskConfigService taskConfigService;

    @PostConstruct
    public void restDynamicQuartzScheduler() {
        StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = schedulerFactory.getScheduler();
        scheduler.clear();
        scheduler.start();
        List taskConfigEntities = this.taskConfigService.getSchedule();
        taskConfigEntities.forEach(t -> {
            try {
                String taskMainId = t.getTaskMainId();
                JobDetailImpl jobDetail = new JobDetailImpl(taskMainId, taskMainId, JobService.class);
                jobDetail.getJobDataMap().put("taskMainId", taskMainId);
                CronTriggerImpl trigger = new CronTriggerImpl(taskMainId, taskMainId, t.getTaskConfigValue());
                scheduler.scheduleJob((JobDetail)jobDetail, (Trigger)trigger);
            }
            catch (SchedulerException e) {
                log.error("\u4efb\u52a1\u53f7:{} \u7684\u4efb\u52a1\u52a0\u8f7d\u5f02\u5e38 schedulerException:{}", (Object)t.getTaskMainId(), (Object)e);
            }
            catch (ParseException e) {
                log.error("\u4efb\u52a1\u53f7:{} \u7684\u8c03\u5ea6\u65f6\u95f4\u914d\u7f6e\u4fe1\u606f\uff1a{} \u9519\u8bef\uff1a{} parseException:{}", new Object[]{t.getTaskMainId(), t.getTaskConfigValue(), e});
            }
        });
    }
}

