/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.controller;

import com.github.pagehelper.PageInfo;
import com.hundsun.lightdb.motion.base.Result;
import com.hundsun.lightdb.motion.enums.NoticeEnum;
import com.hundsun.lightdb.motion.service.TaskMainService;
import com.hundsun.lightdb.motion.vo.request.TaskMainAddReqVo;
import com.hundsun.lightdb.motion.vo.request.TaskMainQueryReqVo;
import com.hundsun.lightdb.motion.vo.request.TaskMainUpdateReqVo;
import com.hundsun.lightdb.motion.vo.response.TaskMainAddRespVo;
import com.hundsun.lightdb.motion.vo.response.TaskMainDetailRespVo;
import com.hundsun.lightdb.motion.vo.response.TaskMainRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taskmain"})
@Api(tags={"\u4efb\u52a1"})
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class TaskMainController {
    @Autowired
    private TaskMainService taskMainService;

    @RequestMapping(value={"/selectbyid"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f")
    public Result<TaskMainDetailRespVo> selectById(String taskMainId) {
        TaskMainDetailRespVo taskMainDetailRespVo = this.taskMainService.getTaskDetail(taskMainId);
        return Result.success((Object)taskMainDetailRespVo);
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    @ApiOperation(value="\u65b0\u589e\u4efb\u52a1\u4fe1\u606f")
    public Result<TaskMainAddRespVo> add(@RequestBody @Valid TaskMainAddReqVo taskMainAddReqVo) {
        String result = this.taskMainService.postTask(taskMainAddReqVo);
        TaskMainAddRespVo taskMainAddRespVo = new TaskMainAddRespVo();
        taskMainAddRespVo.setTaskMainId(result);
        return Result.successWithDataAndMessage((Object)taskMainAddRespVo, (String)NoticeEnum.HANDLER_SUCCESS.getMessage());
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ApiOperation(value="\u66f4\u65b0\u4efb\u52a1\u4fe1\u606f")
    public Result update(@RequestBody @Valid TaskMainUpdateReqVo taskMainUpdateReqVo) {
        int result = this.taskMainService.putTask(taskMainUpdateReqVo);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5220\u9664\u4efb\u52a1\u4fe1\u606f")
    public Result delete(String taskMainId) {
        int result = this.taskMainService.delete(taskMainId);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }

    @RequestMapping(value={"/selectlist"}, method={RequestMethod.POST})
    @ApiOperation(value="\u67e5\u8be2\u4efb\u52a1\u4fe1\u606f\u5217\u8868")
    public Result<PageInfo<TaskMainRespVo>> selectList(@RequestBody TaskMainQueryReqVo taskMainQueryReqVo) {
        PageInfo pageInfo = this.taskMainService.getList(taskMainQueryReqVo);
        return Result.success((Object)pageInfo);
    }

    @RequestMapping(value={"/starttask"}, method={RequestMethod.POST})
    @ApiOperation(value="\u542f\u52a8\u4efb\u52a1")
    public Result startTask(String taskMainId) {
        int result = this.taskMainService.postStartTask(taskMainId);
        if (result > 0) {
            return Result.success((Object)NoticeEnum.HANDLER_SUCCESS.getMessage());
        }
        return Result.fail((String)NoticeEnum.HANDLER_FAILED.getMessage());
    }
}

