/*
 * Decompiled with CFR 0.152.
 */
package com.hundsun.lightdb.motion.config;

import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@MapperScan(basePackages={"com.hundsun.lightdb.motion.dao"})
@ConditionalOnProperty(value={"etl.global.runModel"}, havingValue="1")
public class MyBatisConfig {
    @Autowired
    private Environment env;

    @Bean
    public DataSource getDataSource() throws Exception {
        Properties props = new Properties();
        props.put("driverClassName", this.env.getProperty("spring.datasource.driver"));
        props.put("url", this.env.getProperty("spring.datasource.url"));
        props.put("username", this.env.getProperty("spring.datasource.username"));
        props.put("password", this.env.getProperty("spring.datasource.password"));
        return DruidDataSourceFactory.createDataSource((Properties)props);
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource ds) throws Exception {
        SqlSessionFactoryBean sqlSessionFactoryBean = new SqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource(ds);
        sqlSessionFactoryBean.setTypeAliasesPackage("com.hundsun.lightdb.motion.entity");
        sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath:/mybatis/mapper/**/*.xml"));
        return sqlSessionFactoryBean.getObject();
    }
}

