/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.jdbc2.optional;

import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.jdbc2.optional.GoldendbPooledConnection;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Map;

abstract class WrapperBase {
    protected GoldendbPooledConnection pooledConnection;
    protected Map<Class<?>, Object> unwrappedInterfaces = null;
    protected ExceptionInterceptor exceptionInterceptor;

    protected void checkAndFireConnectionError(SQLException sqlEx) throws SQLException {
        if (this.pooledConnection != null && "08S01".equals(sqlEx.getSQLState())) {
            this.pooledConnection.callConnectionEventListeners(1, sqlEx);
        }
        throw sqlEx;
    }

    protected WrapperBase(GoldendbPooledConnection pooledConnection) {
        this.pooledConnection = pooledConnection;
        this.exceptionInterceptor = this.pooledConnection.getExceptionInterceptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConnectionErrorFiringInvocationHandler
    implements InvocationHandler {
        Object invokeOn = null;

        public ConnectionErrorFiringInvocationHandler(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("equals".equals(method.getName())) {
                return args[0].equals(this);
            }
            Object result = null;
            try {
                result = method.invoke(this.invokeOn, args);
                if (result != null) {
                    result = this.proxyIfInterfaceIsJdbc(result, result.getClass());
                }
            }
            catch (InvocationTargetException var6) {
                if (!(var6.getTargetException() instanceof SQLException)) {
                    throw var6;
                }
                WrapperBase.this.checkAndFireConnectionError((SQLException)var6.getTargetException());
            }
            return result;
        }

        private Object proxyIfInterfaceIsJdbc(Object toProxy, Class<?> clazz) {
            int i$ = 0;
            Class<?>[] interfaces = clazz.getInterfaces();
            int len$ = interfaces.length;
            if (i$ < len$) {
                Object object;
                Class<?> iclass = interfaces[i$];
                String packageName = Util.getPackageName(iclass);
                if (!"java.sql".equals(packageName) && !"javax.sql".equals(packageName)) {
                    object = this.proxyIfInterfaceIsJdbc(toProxy, iclass);
                } else {
                    ClassLoader classLoader = toProxy.getClass().getClassLoader();
                    WrapperBase wrapperBase = WrapperBase.this;
                    wrapperBase.getClass();
                    object = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)wrapperBase.new ConnectionErrorFiringInvocationHandler(toProxy));
                }
                return object;
            }
            return toProxy;
        }
    }
}

