/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.jdbc2;

import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.jdbc2.optional.ConnectionWrapper;
import com.goldendb.jdbc.jdbc2.optional.GoldendbPooledConnection;
import com.goldendb.jdbc.jdbc2.optional.StatementWrapper;
import com.goldendb.jdbc.jdbc2.optional.WrapperBase;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

public class JDBC4StatementWrapper
extends StatementWrapper {
    public JDBC4StatementWrapper(ConnectionWrapper c, GoldendbPooledConnection conn, Statement toWrap) {
        super(c, conn, toWrap);
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
        }
        finally {
            this.unwrappedInterfaces = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.isClosed();
            }
            throw SQLError.createSQLException("Statement already closed", "S1009", this.exceptionInterceptor);
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return false;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            if (this.wrappedStmt == null) {
                throw SQLError.createSQLException("Statement already closed", "S1009", this.exceptionInterceptor);
            }
            this.wrappedStmt.setPoolable(poolable);
        }
        catch (SQLException var3) {
            this.checkAndFireConnectionError(var3);
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            if (this.wrappedStmt != null) {
                return this.wrappedStmt.isPoolable();
            }
            throw SQLError.createSQLException("Statement already closed", "S1009", this.exceptionInterceptor);
        }
        catch (SQLException var2) {
            this.checkAndFireConnectionError(var2);
            return false;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        boolean isInstance = iface.isInstance(this);
        if (isInstance) {
            return true;
        }
        String interfaceClassName = iface.getName();
        return interfaceClassName.equals("com.goldendb.jdbc.internal.core.io.Statement") || interfaceClassName.equals("java.sql.Statement") || interfaceClassName.equals("java.sql.Wrapper");
    }

    @Override
    public synchronized <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (!"java.sql.Statement".equals(iface.getName()) && !"java.sql.Wrapper.class".equals(iface.getName())) {
                Object cachedUnwrapped;
                if (this.unwrappedInterfaces == null) {
                    this.unwrappedInterfaces = new HashMap();
                }
                if ((cachedUnwrapped = this.unwrappedInterfaces.get(iface)) == null) {
                    cachedUnwrapped = Proxy.newProxyInstance(this.wrappedStmt.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new WrapperBase.ConnectionErrorFiringInvocationHandler(this, this.wrappedStmt));
                    this.unwrappedInterfaces.put(iface, cachedUnwrapped);
                }
                return iface.cast(cachedUnwrapped);
            }
            return iface.cast(this);
        }
        catch (ClassCastException var3) {
            throw SQLError.createSQLException("Unable to unwrap to " + iface.toString(), "S1009", this.exceptionInterceptor);
        }
    }
}

