/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.exceptions.jdbc4;

import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.StreamingNotifiable;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.sql.SQLRecoverableException;

public class CommunicationsException
extends SQLRecoverableException
implements StreamingNotifiable {
    static final long serialVersionUID = 4317904269797988677L;
    private String exceptionMessage;

    public CommunicationsException(MySQLConnection conn, long lastPacketSentTimeMs, long lastPacketReceivedTimeMs, Exception underlyingException) {
        String linkInfo = "";
        linkInfo = conn.getLinkInfo();
        this.exceptionMessage = linkInfo + SQLError.createLinkFailureMessageBasedOnHeuristics(conn, lastPacketSentTimeMs, lastPacketReceivedTimeMs, underlyingException);
        if (underlyingException != null) {
            this.initCause(underlyingException);
        }
    }

    @Override
    public String getMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getSQLState() {
        return "08S01";
    }

    @Override
    public void setWasStreamingResults() {
        this.exceptionMessage = Messages.getString("CommunicationsException.ClientWasStreaming");
    }
}

