/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.escape;

import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.internal.escape.EscapeProcessorResult;
import com.goldendb.jdbc.internal.escape.EscapeTokenizer;
import com.goldendb.jdbc.internal.util.SQLError;
import com.goldendb.jdbc.internal.util.StringUtils;
import com.goldendb.jdbc.internal.util.TimeUtil;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class EscapeProcessor {
    private static Map<String, String> JDBC_CONVERT_TO_MYSQL_TYPE_MAP;
    private static Map<String, String> JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP;

    EscapeProcessor() {
    }

    public static final Object escapeSQL(String sql, boolean serverSupportsConvertFn, MySQLConnection conn) throws SQLException {
        int nextEndBrace;
        boolean replaceEscapeSequence = false;
        String escapeSequence = null;
        if (sql == null) {
            return null;
        }
        int beginBrace = sql.indexOf(123);
        int n = nextEndBrace = beginBrace == -1 ? -1 : sql.indexOf(125, beginBrace);
        if (nextEndBrace == -1) {
            return sql;
        }
        StringBuilder newSql = new StringBuilder();
        EscapeTokenizer escapeTokenizer = new EscapeTokenizer(sql);
        byte usesVariables = 0;
        boolean callingStoredFunction = false;
        block4: while (true) {
            String argument;
            int startPos;
            String collapsedToken;
            String token;
            if (!escapeTokenizer.hasMoreTokens()) {
                token = newSql.toString();
                if (replaceEscapeSequence) {
                    collapsedToken = token;
                    while (collapsedToken.contains(escapeSequence)) {
                        startPos = collapsedToken.indexOf(escapeSequence);
                        String lhs = collapsedToken.substring(0, startPos);
                        argument = collapsedToken.substring(startPos + 1, collapsedToken.length());
                        collapsedToken = lhs + "\\" + argument;
                    }
                    token = collapsedToken;
                }
                EscapeProcessorResult epr = new EscapeProcessorResult();
                epr.escapedSql = token;
                epr.callingStoredFunction = callingStoredFunction;
                if (usesVariables != 1) {
                    epr.usesVariables = escapeTokenizer.sawVariableUse() ? (byte)1 : 0;
                }
                return epr;
            }
            token = escapeTokenizer.nextToken();
            if (token.length() == 0) continue;
            if (token.charAt(0) == '{') {
                StringTokenizer st;
                int endPos;
                if (!token.endsWith("}")) {
                    throw SQLError.createSQLException("Not a valid escape sequence: " + token, conn.getExceptionInterceptor());
                }
                if (token.length() > 2 && (endPos = token.indexOf(123, 2)) != -1) {
                    StringBuilder buf = new StringBuilder(token.substring(0, 1));
                    Object remainingResults = EscapeProcessor.escapeSQL(token.substring(1, token.length() - 1), serverSupportsConvertFn, conn);
                    argument = null;
                    if (remainingResults instanceof String) {
                        argument = (String)remainingResults;
                    } else {
                        argument = ((EscapeProcessorResult)remainingResults).escapedSql;
                        if (usesVariables != 1) {
                            usesVariables = ((EscapeProcessorResult)remainingResults).usesVariables;
                        }
                    }
                    buf.append(argument);
                    buf.append('}');
                    token = buf.toString();
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken = EscapeProcessor.removeWhitespace(token), "{escape")) {
                    try {
                        st = new StringTokenizer(token, " '");
                        st.nextToken();
                        escapeSequence = st.nextToken();
                        if (escapeSequence.length() < 3) {
                            newSql.append(token);
                            continue;
                        }
                        escapeSequence = escapeSequence.substring(1, escapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                    }
                    catch (NoSuchElementException var22) {
                        newSql.append(token);
                    }
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{fn")) {
                    startPos = token.toLowerCase().indexOf("fn ") + 3;
                    argument = token.substring(startPos, endPos = token.length() - 1);
                    if (StringUtils.startsWithIgnoreCaseAndWs(argument, "convert")) {
                        newSql.append(EscapeProcessor.processConvertToken(argument, serverSupportsConvertFn, conn));
                        continue;
                    }
                    newSql.append(argument);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{d")) {
                    startPos = token.indexOf(39) + 1;
                    endPos = token.lastIndexOf(39);
                    if (startPos != -1 && endPos != -1) {
                        argument = token.substring(startPos, endPos);
                        try {
                            st = new StringTokenizer(argument, " -");
                            String year4 = st.nextToken();
                            String month2 = st.nextToken();
                            String day2 = st.nextToken();
                            String dateString = "'" + year4 + "-" + month2 + "-" + day2 + "'";
                            newSql.append(dateString);
                        }
                        catch (NoSuchElementException var21) {
                            throw SQLError.createSQLException("Syntax error for DATE escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                        }
                    }
                    newSql.append(token);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{ts")) {
                    EscapeProcessor.processTimestampToken(conn, newSql, token);
                    continue;
                }
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{t")) {
                    EscapeProcessor.processTimeToken(conn, newSql, token);
                    continue;
                }
                if (!StringUtils.startsWithIgnoreCase(collapsedToken, "{call") && !StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                    if (StringUtils.startsWithIgnoreCase(collapsedToken, "{oj")) {
                        newSql.append(token);
                        continue;
                    }
                    newSql.append(token);
                    continue;
                }
                startPos = StringUtils.indexOfIgnoreCase(token, "CALL") + 5;
                endPos = token.length() - 1;
                if (StringUtils.startsWithIgnoreCase(collapsedToken, "{?=call")) {
                    callingStoredFunction = true;
                    newSql.append("SELECT ");
                    newSql.append(token.substring(startPos, endPos));
                } else {
                    callingStoredFunction = false;
                    newSql.append("CALL ");
                    newSql.append(token.substring(startPos, endPos));
                }
                int i = endPos - 1;
                while (true) {
                    if (i < startPos) continue block4;
                    char c = token.charAt(i);
                    if (!Character.isWhitespace(c)) {
                        if (c == ')') continue block4;
                        newSql.append("()");
                        continue block4;
                    }
                    --i;
                }
            }
            newSql.append(token);
        }
    }

    private static void processTimeToken(MySQLConnection conn, StringBuilder newSql, String token) throws SQLException {
        int startPos = token.indexOf(39) + 1;
        int endPos = token.lastIndexOf(39);
        if (startPos != -1 && endPos != -1) {
            String argument = token.substring(startPos, endPos);
            try {
                StringTokenizer st = new StringTokenizer(argument, " :.");
                String hour = st.nextToken();
                String minute = st.nextToken();
                String second = st.nextToken();
                boolean serverSupportsFractionalSecond = false;
                String fractionalSecond = "";
                if (st.hasMoreTokens() && conn.versionMeetsMinimum(5, 6, 4)) {
                    serverSupportsFractionalSecond = true;
                    fractionalSecond = "." + st.nextToken();
                }
                if (conn.getUseTimezone() && conn.getUseLegacyDatetimeCode()) {
                    Calendar sessionCalendar = conn.getCalendarInstanceForSessionOrNew();
                    try {
                        int hourInt = Integer.parseInt(hour);
                        int minuteInt = Integer.parseInt(minute);
                        int secondInt = Integer.parseInt(second);
                        Time toBeAdjusted = TimeUtil.fastTimeCreate(sessionCalendar, hourInt, minuteInt, secondInt, conn.getExceptionInterceptor());
                        Time inServerTimezone = TimeUtil.changeTimezone(conn, sessionCalendar, (Calendar)null, toBeAdjusted, sessionCalendar.getTimeZone(), conn.getServerTimezoneTZ(), false);
                        newSql.append("'");
                        newSql.append(inServerTimezone.toString());
                        if (serverSupportsFractionalSecond) {
                            newSql.append(fractionalSecond);
                        }
                        newSql.append("'");
                    }
                    catch (NumberFormatException var18) {
                        throw SQLError.createSQLException("Syntax error in TIMESTAMP escape sequence '" + token + "'.", "S1009", conn.getExceptionInterceptor());
                    }
                }
                newSql.append("'");
                newSql.append(hour);
                newSql.append(":");
                newSql.append(minute);
                newSql.append(":");
                newSql.append(second);
                newSql.append(fractionalSecond);
                newSql.append("'");
            }
            catch (NoSuchElementException var19) {
                throw SQLError.createSQLException("Syntax error for escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
            }
        } else {
            newSql.append(token);
        }
    }

    private static void processTimestampToken(MySQLConnection conn, StringBuilder newSql, String token) throws SQLException {
        int startPos = token.indexOf(39) + 1;
        int endPos = token.lastIndexOf(39);
        if (startPos != -1 && endPos != -1) {
            String argument = token.substring(startPos, endPos);
            try {
                if (!conn.getUseLegacyDatetimeCode()) {
                    Timestamp ts = Timestamp.valueOf(argument);
                    SimpleDateFormat tsdf = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss", Locale.US);
                    tsdf.setTimeZone(conn.getServerTimezoneTZ());
                    newSql.append(tsdf.format(ts));
                    if (ts.getNanos() > 0 && conn.versionMeetsMinimum(5, 6, 4)) {
                        newSql.append('.');
                        newSql.append(TimeUtil.formatNanos(ts.getNanos(), true, true));
                    }
                    newSql.append('\'');
                }
                StringTokenizer st = new StringTokenizer(argument, " .-:");
                try {
                    String year4 = st.nextToken();
                    String month2 = st.nextToken();
                    String day2 = st.nextToken();
                    String hour = st.nextToken();
                    String minute = st.nextToken();
                    String second = st.nextToken();
                    boolean serverSupportsFractionalSecond = false;
                    String fractionalSecond = "";
                    if (st.hasMoreTokens() && conn.versionMeetsMinimum(5, 6, 4)) {
                        serverSupportsFractionalSecond = true;
                        fractionalSecond = "." + st.nextToken();
                    }
                    if (!conn.getUseTimezone() && !conn.getUseJDBCCompliantTimezoneShift()) {
                        newSql.append("'").append(year4).append("-").append(month2).append("-").append(day2).append(" ").append(hour).append(":").append(minute).append(":").append(second).append(fractionalSecond).append("'");
                    }
                    Calendar sessionCalendar = conn.getCalendarInstanceForSessionOrNew();
                    try {
                        int year4Int = Integer.parseInt(year4);
                        int month2Int = Integer.parseInt(month2);
                        int day2Int = Integer.parseInt(day2);
                        int hourInt = Integer.parseInt(hour);
                        int minuteInt = Integer.parseInt(minute);
                        int secondInt = Integer.parseInt(second);
                        boolean useGmtMillis = conn.getUseGmtMillisForDatetimes();
                        Timestamp toBeAdjusted = TimeUtil.fastTimestampCreate(useGmtMillis, useGmtMillis ? Calendar.getInstance(TimeZone.getTimeZone("GMT")) : null, sessionCalendar, year4Int, month2Int, day2Int, hourInt, minuteInt, secondInt, 0);
                        Timestamp inServerTimezone = TimeUtil.changeTimezone(conn, sessionCalendar, (Calendar)null, toBeAdjusted, sessionCalendar.getTimeZone(), conn.getServerTimezoneTZ(), false);
                        newSql.append("'");
                        String timezoneLiteral = inServerTimezone.toString();
                        int indexOfDot = timezoneLiteral.indexOf(".");
                        if (indexOfDot != -1) {
                            timezoneLiteral = timezoneLiteral.substring(0, indexOfDot);
                        }
                        newSql.append(timezoneLiteral);
                        if (serverSupportsFractionalSecond) {
                            newSql.append(fractionalSecond);
                        }
                        newSql.append("'");
                    }
                    catch (NumberFormatException var27) {
                        throw SQLError.createSQLException("Syntax error in TIMESTAMP escape sequence '" + token + "'.", "S1009", conn.getExceptionInterceptor());
                    }
                }
                catch (NoSuchElementException var28) {
                    throw SQLError.createSQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                }
            }
            catch (IllegalArgumentException var29) {
                SQLException sqlEx = SQLError.createSQLException("Syntax error for TIMESTAMP escape sequence '" + argument + "'", "42000", conn.getExceptionInterceptor());
                sqlEx.initCause(var29);
                throw sqlEx;
            }
        } else {
            newSql.append(token);
        }
    }

    private static String processConvertToken(String functionToken, boolean serverSupportsConvertFn, MySQLConnection conn) throws SQLException {
        int firstIndexOfParen = functionToken.indexOf("(");
        if (firstIndexOfParen == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing opening parenthesis in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        int indexOfComma = functionToken.lastIndexOf(",");
        if (indexOfComma == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing comma in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        int indexOfCloseParen = functionToken.indexOf(41, indexOfComma);
        if (indexOfCloseParen == -1) {
            throw SQLError.createSQLException("Syntax error while processing {fn convert (... , ...)} token, missing closing parenthesis in token '" + functionToken + "'.", "42000", conn.getExceptionInterceptor());
        }
        String expression = functionToken.substring(firstIndexOfParen + 1, indexOfComma);
        String type = functionToken.substring(indexOfComma + 1, indexOfCloseParen);
        String newType = null;
        String trimmedType = type.trim();
        if (StringUtils.startsWithIgnoreCase(trimmedType, "SQL_")) {
            trimmedType = trimmedType.substring(4, trimmedType.length());
        }
        if (serverSupportsConvertFn) {
            newType = JDBC_CONVERT_TO_MYSQL_TYPE_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
        } else {
            newType = JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP.get(trimmedType.toUpperCase(Locale.ENGLISH));
            if (newType == null) {
                throw SQLError.createSQLException("Can't find conversion re-write for type '" + type + "' that is applicable for this server version while processing escape tokens.", "S1000", conn.getExceptionInterceptor());
            }
        }
        if (newType == null) {
            throw SQLError.createSQLException("Unsupported conversion type '" + type.trim() + "' found while processing escape token.", "S1000", conn.getExceptionInterceptor());
        }
        int replaceIndex = newType.indexOf("?");
        if (replaceIndex != -1) {
            StringBuilder castRewrite = new StringBuilder(newType.substring(0, replaceIndex));
            castRewrite.append(expression);
            castRewrite.append(newType.substring(replaceIndex + 1, newType.length()));
            return castRewrite.toString();
        }
        StringBuilder castRewrite = new StringBuilder("CAST(");
        castRewrite.append(expression);
        castRewrite.append(" AS ");
        castRewrite.append(newType);
        castRewrite.append(")");
        return castRewrite.toString();
    }

    private static String removeWhitespace(String toCollapse) {
        if (toCollapse == null) {
            return null;
        }
        int length = toCollapse.length();
        StringBuilder collapsed = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = toCollapse.charAt(i);
            if (Character.isWhitespace(c)) continue;
            collapsed.append(c);
        }
        return collapsed.toString();
    }

    static {
        HashMap<Object, Object> tempMap = new HashMap<String, String>();
        tempMap.put("BIGINT", "0 + ?");
        tempMap.put("BINARY", "BINARY");
        tempMap.put("BIT", "0 + ?");
        tempMap.put("CHAR", "CHAR");
        tempMap.put("DATE", "DATE");
        tempMap.put("DECIMAL", "0.0 + ?");
        tempMap.put("DOUBLE", "0.0 + ?");
        tempMap.put("FLOAT", "0.0 + ?");
        tempMap.put("INTEGER", "0 + ?");
        tempMap.put("LONGVARBINARY", "BINARY");
        tempMap.put("LONGVARCHAR", "CONCAT(?)");
        tempMap.put("REAL", "0.0 + ?");
        tempMap.put("SMALLINT", "CONCAT(?)");
        tempMap.put("TIME", "TIME");
        tempMap.put("TIMESTAMP", "DATETIME");
        tempMap.put("TINYINT", "CONCAT(?)");
        tempMap.put("VARBINARY", "BINARY");
        tempMap.put("VARCHAR", "CONCAT(?)");
        JDBC_CONVERT_TO_MYSQL_TYPE_MAP = Collections.unmodifiableMap(tempMap);
        tempMap = new HashMap<String, String>(JDBC_CONVERT_TO_MYSQL_TYPE_MAP);
        tempMap.put("BINARY", "CONCAT(?)");
        tempMap.put("CHAR", "CONCAT(?)");
        tempMap.remove("DATE");
        tempMap.put("LONGVARBINARY", "CONCAT(?)");
        tempMap.remove("TIME");
        tempMap.remove("TIMESTAMP");
        tempMap.put("VARBINARY", "CONCAT(?)");
        JDBC_NO_CONVERT_TO_MYSQL_EXPRESSION_MAP = Collections.unmodifiableMap(tempMap);
    }
}

