/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.loadbalance;

import com.goldendb.jdbc.BalanceStrategy;
import com.goldendb.jdbc.BestResponseTimeBalanceStrategy;
import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.ConnectionGroup;
import com.goldendb.jdbc.ConnectionGroupManager;
import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.RandomBalanceStrategy;
import com.goldendb.jdbc.ServerAffinityStrategy;
import com.goldendb.jdbc.Util;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.PingTarget;
import com.goldendb.jdbc.internal.core.io.Statement;
import com.goldendb.jdbc.internal.core.io.StatementInterceptorV2;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedAutoCommitInterceptor;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnection;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedMySQLConnection;
import com.goldendb.jdbc.internal.core.loadbalance.MultiHostConnectionProxy;
import com.goldendb.jdbc.internal.custom.LoadBalanceExceptionChecker;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancedConnectionProxy
extends MultiHostConnectionProxy
implements PingTarget {
    private ConnectionGroup connectionGroup = null;
    private long connectionGroupProxyID = 0L;
    protected Map<String, ConnectionImpl> liveConnections;
    private Map<String, Integer> hostsToListIndexMap;
    private Map<ConnectionImpl, String> connectionsToHostsMap;
    private long totalPhysicalConnections = 0L;
    private long[] responseTimes;
    private int retriesAllDown;
    private BalanceStrategy balancer;
    private int autoCommitSwapThreshold = 0;
    public static final String BLACKLIST_TIMEOUT_PROPERTY_KEY = "loadBalanceBlacklistTimeout";
    private int globalBlacklistTimeout = 0;
    private static Map<String, Long> globalBlacklist = new HashMap<String, Long>();
    public static final String HOST_REMOVAL_GRACE_PERIOD_PROPERTY_KEY = "loadBalanceHostRemovalGracePeriod";
    private int hostRemovalGracePeriod = 0;
    private Set<String> hostsToRemove = new HashSet<String>();
    private boolean inTransaction = false;
    private long transactionStartTime = 0L;
    private long transactionCount = 0L;
    private LoadBalanceExceptionChecker exceptionChecker;
    private static Constructor<?> JDBC_4_LB_CONNECTION_CTOR;
    private static Class<?>[] INTERFACES_TO_PROXY;
    private static LoadBalancedConnection nullLBConnectionInstance;

    public static LoadBalancedConnection createProxyInstance(List<String> hosts, Properties props) throws SQLException {
        LoadBalancedConnectionProxy connProxy = new LoadBalancedConnectionProxy(hosts, props);
        return (LoadBalancedConnection)Proxy.newProxyInstance(LoadBalancedConnection.class.getClassLoader(), INTERFACES_TO_PROXY, (InvocationHandler)connProxy);
    }

    private LoadBalancedConnectionProxy(List<String> hosts, Properties props) throws SQLException {
        String statementInterceptors;
        String group = props.getProperty("loadBalanceConnectionGroup", null);
        boolean enableJMX = false;
        String enableJMXAsString = props.getProperty("loadBalanceEnableJMX", "false");
        try {
            enableJMX = Boolean.parseBoolean(enableJMXAsString);
        }
        catch (Exception var19) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForLoadBalanceEnableJMX", new Object[]{enableJMXAsString}), "S1009", (ExceptionInterceptor)null);
        }
        if (group != null) {
            this.connectionGroup = ConnectionGroupManager.getConnectionGroupInstance(group);
            if (enableJMX) {
                ConnectionGroupManager.registerJmx();
            }
            this.connectionGroupProxyID = this.connectionGroup.registerConnectionProxy(this, hosts);
            hosts = new ArrayList<String>(this.connectionGroup.getInitialHosts());
        }
        int numHosts = this.initializeHostsSpecs(hosts, props);
        this.liveConnections = new HashMap<String, ConnectionImpl>(numHosts);
        this.hostsToListIndexMap = new HashMap<String, Integer>(numHosts);
        for (int i = 0; i < numHosts; ++i) {
            this.hostsToListIndexMap.put((String)this.hostList.get(i), i);
        }
        this.connectionsToHostsMap = new HashMap<ConnectionImpl, String>(numHosts);
        this.responseTimes = new long[numHosts];
        String retriesAllDownAsString = this.localProps.getProperty("retriesAllDown", "120");
        try {
            this.retriesAllDown = Integer.parseInt(retriesAllDownAsString);
        }
        catch (NumberFormatException var18) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForRetriesAllDown", new Object[]{retriesAllDownAsString}), "S1009", (ExceptionInterceptor)null);
        }
        String blacklistTimeoutAsString = this.localProps.getProperty(BLACKLIST_TIMEOUT_PROPERTY_KEY, "0");
        try {
            this.globalBlacklistTimeout = Integer.parseInt(blacklistTimeoutAsString);
        }
        catch (NumberFormatException var17) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForLoadBalanceBlacklistTimeout", new Object[]{blacklistTimeoutAsString}), "S1009", (ExceptionInterceptor)null);
        }
        String hostRemovalGracePeriodAsString = this.localProps.getProperty(HOST_REMOVAL_GRACE_PERIOD_PROPERTY_KEY, "15000");
        try {
            this.hostRemovalGracePeriod = Integer.parseInt(hostRemovalGracePeriodAsString);
        }
        catch (NumberFormatException var16) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForLoadBalanceHostRemovalGracePeriod", new Object[]{hostRemovalGracePeriodAsString}), "S1009", (ExceptionInterceptor)null);
        }
        String strategy = this.localProps.getProperty("loadBalanceStrategy", "random");
        this.balancer = "random".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, RandomBalanceStrategy.class.getName(), "InvalidLoadBalanceStrategy", null).get(0) : ("bestResponseTime".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, BestResponseTimeBalanceStrategy.class.getName(), "InvalidLoadBalanceStrategy", null).get(0) : ("serverAffinity".equals(strategy) ? (BalanceStrategy)Util.loadExtensions(null, props, ServerAffinityStrategy.class.getName(), "InvalidLoadBalanceStrategy", null).get(0) : (BalanceStrategy)Util.loadExtensions(null, props, strategy, "InvalidLoadBalanceStrategy", null).get(0)));
        String autoCommitSwapThresholdAsString = props.getProperty("loadBalanceAutoCommitStatementThreshold", "0");
        try {
            this.autoCommitSwapThreshold = Integer.parseInt(autoCommitSwapThresholdAsString);
        }
        catch (NumberFormatException var15) {
            throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForLoadBalanceAutoCommitStatementThreshold", new Object[]{autoCommitSwapThresholdAsString}), "S1009", (ExceptionInterceptor)null);
        }
        String autoCommitSwapRegex = props.getProperty("loadBalanceAutoCommitStatementRegex", "");
        if (!"".equals(autoCommitSwapRegex)) {
            try {
                "".matches(autoCommitSwapRegex);
            }
            catch (Exception var14) {
                throw SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.badValueForLoadBalanceAutoCommitStatementRegex", new Object[]{autoCommitSwapRegex}), "S1009", (ExceptionInterceptor)null);
            }
        }
        if (this.autoCommitSwapThreshold > 0) {
            statementInterceptors = this.localProps.getProperty("statementInterceptors");
            if (statementInterceptors == null) {
                this.localProps.setProperty("statementInterceptors", "com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedAutoCommitInterceptor");
            } else if (statementInterceptors.length() > 0) {
                this.localProps.setProperty("statementInterceptors", statementInterceptors + ",com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedAutoCommitInterceptor");
            }
            props.setProperty("statementInterceptors", this.localProps.getProperty("statementInterceptors"));
        }
        this.balancer.init(null, props);
        statementInterceptors = this.localProps.getProperty("loadBalanceExceptionChecker", "com.goldendb.jdbc.StandardLoadBalanceExceptionChecker");
        this.exceptionChecker = (LoadBalanceExceptionChecker)Util.loadExtensions(null, props, statementInterceptors, "InvalidLoadBalanceExceptionChecker", null).get(0);
        this.pickNewConnection();
    }

    @Override
    MySQLConnection getNewWrapperForThisAsConnection() throws SQLException {
        return !Util.isJdbc4() && JDBC_4_LB_CONNECTION_CTOR == null ? new LoadBalancedMySQLConnection(this) : (MySQLConnection)Util.handleNewInstance(JDBC_4_LB_CONNECTION_CTOR, new Object[]{this}, null);
    }

    @Override
    protected void propagateProxyDown(MySQLConnection proxyConn) {
        for (MySQLConnection mySQLConnection : this.liveConnections.values()) {
            mySQLConnection.setProxy(proxyConn);
        }
    }

    @Override
    public boolean shouldExceptionTriggerConnectionSwitch(Throwable t) {
        return t instanceof SQLException && this.exceptionChecker.shouldExceptionTriggerFailover((SQLException)t);
    }

    @Override
    boolean isMasterConnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    synchronized void invalidateConnection(MySQLConnection conn) throws SQLException {
        super.invalidateConnection(conn);
        if (this.isGlobalBlacklistEnabled()) {
            this.addToGlobalBlacklist(this.connectionsToHostsMap.get(conn));
        }
        this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
        String mappedHost = this.connectionsToHostsMap.remove(conn);
        if (mappedHost == null || !this.hostsToListIndexMap.containsKey(mappedHost)) return;
        int hostIndex = this.hostsToListIndexMap.get(mappedHost);
        long[] lArray = this.responseTimes;
        synchronized (this.responseTimes) {
            this.responseTimes[hostIndex] = 0L;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    @Override
    synchronized void pickNewConnection() throws SQLException {
        if (!this.isClosed || !this.closedExplicitly) {
            if (this.currentConnection == null) {
                this.currentConnection = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
            } else {
                if (this.currentConnection.isClosed()) {
                    this.invalidateCurrentConnection();
                }
                int pingTimeout = this.currentConnection.getLoadBalancePingTimeout();
                boolean pingBeforeReturn = this.currentConnection.getLoadBalanceValidateConnectionOnSwapServer();
                int hostsTried = 0;
                int hostsToTry = this.hostList.size();
                while (true) {
                    if (hostsTried >= hostsToTry) {
                        this.isClosed = true;
                        this.closedReason = "Connection closed after inability to pick valid new connection during load-balance.";
                        break;
                    }
                    ConnectionImpl newConn = null;
                    try {
                        newConn = this.balancer.pickConnection(this, Collections.unmodifiableList(this.hostList), Collections.unmodifiableMap(this.liveConnections), (long[])this.responseTimes.clone(), this.retriesAllDown);
                        if (this.currentConnection != null) {
                            if (pingBeforeReturn) {
                                if (pingTimeout == 0) {
                                    newConn.ping();
                                } else {
                                    newConn.pingInternal(true, pingTimeout);
                                }
                            }
                            this.syncSessionState(this.currentConnection, newConn);
                        }
                        this.currentConnection = newConn;
                        return;
                    }
                    catch (SQLException var7) {
                        if (this.shouldExceptionTriggerConnectionSwitch(var7) && newConn != null) {
                            this.invalidateConnection(newConn);
                        }
                        ++hostsTried;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public synchronized ConnectionImpl createConnectionForHost(String hostPortSpec) throws SQLException {
        ConnectionImpl conn = super.createConnectionForHost(hostPortSpec);
        this.liveConnections.put(hostPortSpec, conn);
        this.connectionsToHostsMap.put(conn, hostPortSpec);
        ++this.totalPhysicalConnections;
        for (StatementInterceptorV2 stmtInterceptor : conn.getStatementInterceptorsInstances()) {
            if (!(stmtInterceptor instanceof LoadBalancedAutoCommitInterceptor)) continue;
            ((LoadBalancedAutoCommitInterceptor)stmtInterceptor).resumeCounters();
            break;
        }
        return conn;
    }

    @Override
    void syncSessionState(Connection source, Connection target, boolean readOnly) throws SQLException {
        LoadBalancedAutoCommitInterceptor lbAutoCommitStmtInterceptor = null;
        for (StatementInterceptorV2 stmtInterceptor : ((MySQLConnection)target).getStatementInterceptorsInstances()) {
            if (!(stmtInterceptor instanceof LoadBalancedAutoCommitInterceptor)) continue;
            lbAutoCommitStmtInterceptor = (LoadBalancedAutoCommitInterceptor)stmtInterceptor;
            lbAutoCommitStmtInterceptor.pauseCounters();
            break;
        }
        super.syncSessionState(source, target, readOnly);
        if (lbAutoCommitStmtInterceptor != null) {
            lbAutoCommitStmtInterceptor.resumeCounters();
        }
    }

    private synchronized void closeAllConnections() {
        for (ConnectionImpl c : this.liveConnections.values()) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    @Override
    public synchronized void doClose() {
        this.closeAllConnections();
    }

    @Override
    public synchronized void doAbortInternal() {
        for (ConnectionImpl c : this.liveConnections.values()) {
            try {
                c.abortInternal();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    @Override
    public synchronized void doAbort(Executor executor) {
        for (ConnectionImpl c : this.liveConnections.values()) {
            try {
                c.abort(executor);
            }
            catch (SQLException var5) {}
        }
        if (!this.isClosed) {
            this.balancer.destroy();
            if (this.connectionGroup != null) {
                this.connectionGroup.closeConnectionProxy(this);
            }
        }
        this.liveConnections.clear();
        this.connectionsToHostsMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public synchronized Object invokeMore(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (this.isClosed && !this.allowedOnClosedConnection(method) && method.getExceptionTypes().length > 0) {
            if (!this.autoReconnect || this.closedExplicitly) {
                String reason = "No operations allowed after connection closed.";
                if (this.closedReason == null) throw SQLError.createSQLException(reason, "08003", (ExceptionInterceptor)null);
                reason = reason + " " + this.closedReason;
                throw SQLError.createSQLException(reason, "08003", (ExceptionInterceptor)null);
            }
            this.currentConnection = null;
            this.pickNewConnection();
            this.isClosed = false;
            this.closedReason = null;
        }
        if (!this.inTransaction) {
            this.inTransaction = true;
            this.transactionStartTime = System.nanoTime();
            ++this.transactionCount;
        }
        Object result = null;
        try {
            block18: {
                try {
                    result = method.invoke((Object)this.thisAsConnection, args);
                    if (result == null) break block18;
                    if (result instanceof Statement) {
                        ((Statement)result).setPingTarget(this);
                    }
                    result = this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
                }
                catch (InvocationTargetException var19) {
                    this.dealWithInvocationException(var19);
                    Object var8_8 = null;
                    if (!"commit".equals(methodName)) return result;
                    this.inTransaction = false;
                    String host = this.connectionsToHostsMap.get(this.currentConnection);
                    if (host != null) {
                        long[] lArray = this.responseTimes;
                        // MONITORENTER : this.responseTimes
                        Integer hostIndex = this.hostsToListIndexMap.get(host);
                        if (hostIndex != null && hostIndex < this.responseTimes.length) {
                            this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                        }
                        // MONITOREXIT : lArray
                    }
                    this.pickNewConnection();
                    return result;
                }
            }
            Object var8_7 = null;
            if (!"commit".equals(methodName)) return result;
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConnection);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                Integer hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            return result;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!"commit".equals(methodName)) throw throwable;
            this.inTransaction = false;
            String host = this.connectionsToHostsMap.get(this.currentConnection);
            if (host != null) {
                long[] lArray = this.responseTimes;
                // MONITORENTER : this.responseTimes
                Integer hostIndex = this.hostsToListIndexMap.get(host);
                if (hostIndex != null && hostIndex < this.responseTimes.length) {
                    this.responseTimes[hostIndex.intValue()] = System.nanoTime() - this.transactionStartTime;
                }
                // MONITOREXIT : lArray
            }
            this.pickNewConnection();
            throw throwable;
        }
    }

    @Override
    public synchronized void doPing() throws SQLException {
        SQLException se = null;
        boolean foundHost = false;
        int pingTimeout = this.currentConnection.getLoadBalancePingTimeout();
        Iterator i = this.hostList.iterator();
        while (true) {
            if (!i.hasNext()) {
                if (!foundHost) {
                    this.closeAllConnections();
                    this.isClosed = true;
                    this.closedReason = "Connection closed due to inability to ping any active connections.";
                    if (se != null) {
                        throw se;
                    }
                    ((ConnectionImpl)this.currentConnection).throwConnectionClosedException();
                }
                return;
            }
            String host = (String)i.next();
            ConnectionImpl conn = this.liveConnections.get(host);
            if (conn == null) continue;
            try {
                if (pingTimeout == 0) {
                    conn.ping();
                } else {
                    conn.pingInternal(true, pingTimeout);
                }
                foundHost = true;
                continue;
            }
            catch (SQLException var8) {
                if (host.equals(this.connectionsToHostsMap.get(this.currentConnection))) {
                    this.closeAllConnections();
                    this.isClosed = true;
                    this.closedReason = "Connection closed because ping of current connection failed.";
                    throw var8;
                }
                if (var8.getMessage().equals(Messages.getString("Connection.exceededConnectionLifetime"))) {
                    if (se == null) {
                        se = var8;
                    }
                } else {
                    se = var8;
                    if (this.isGlobalBlacklistEnabled()) {
                        this.addToGlobalBlacklist(host);
                    }
                }
                this.liveConnections.remove(this.connectionsToHostsMap.get(conn));
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToGlobalBlacklist(String host, long timeout) {
        if (this.isGlobalBlacklistEnabled()) {
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                globalBlacklist.put(host, timeout);
            }
        }
    }

    public void addToGlobalBlacklist(String host) {
        this.addToGlobalBlacklist(host, System.currentTimeMillis() + (long)this.globalBlacklistTimeout);
    }

    public boolean isGlobalBlacklistEnabled() {
        return this.globalBlacklistTimeout > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Map<String, Long> getGlobalBlacklist() {
        if (this.isGlobalBlacklistEnabled()) {
            HashMap<String, Long> blacklistClone = new HashMap<String, Long>(globalBlacklist.size());
            Map<String, Long> map = globalBlacklist;
            synchronized (map) {
                blacklistClone.putAll(globalBlacklist);
            }
            Set keys = blacklistClone.keySet();
            keys.retainAll(this.hostList);
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String host = (String)i.next();
                Long timeout = globalBlacklist.get(host);
                if (timeout == null || timeout >= System.currentTimeMillis()) continue;
                Map<String, Long> map2 = globalBlacklist;
                synchronized (map2) {
                    globalBlacklist.remove(host);
                }
                i.remove();
            }
            if (keys.size() == this.hostList.size()) {
                return new HashMap<String, Long>(1);
            }
            return blacklistClone;
        }
        if (this.hostsToRemove.isEmpty()) {
            return new HashMap<String, Long>(1);
        }
        HashMap<String, Long> blacklistClone = new HashMap<String, Long>();
        for (String h : this.hostsToRemove) {
            blacklistClone.put(h, System.currentTimeMillis() + 5000L);
        }
        return blacklistClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHostWhenNotInUse(String hostPortPair) throws SQLException {
        if (this.hostRemovalGracePeriod <= 0) {
            this.removeHost(hostPortPair);
        } else {
            int timeBetweenChecks = this.hostRemovalGracePeriod > 1000 ? 1000 : this.hostRemovalGracePeriod;
            LoadBalancedConnectionProxy loadBalancedConnectionProxy = this;
            synchronized (loadBalancedConnectionProxy) {
                this.addToGlobalBlacklist(hostPortPair, System.currentTimeMillis() + (long)this.hostRemovalGracePeriod + (long)timeBetweenChecks);
                long cur = System.currentTimeMillis();
                while (System.currentTimeMillis() < cur + (long)this.hostRemovalGracePeriod) {
                    this.hostsToRemove.add(hostPortPair);
                    if (!hostPortPair.equals(this.currentConnection.getHostPortPair())) {
                        this.removeHost(hostPortPair);
                        return;
                    }
                    try {
                        Thread.sleep(timeBetweenChecks);
                    }
                    catch (InterruptedException var8) {}
                }
            }
            this.removeHost(hostPortPair);
        }
    }

    public synchronized void removeHost(String hostPortPair) throws SQLException {
        if (this.connectionGroup != null && this.connectionGroup.getInitialHosts().size() == 1 && this.connectionGroup.getInitialHosts().contains(hostPortPair)) {
            throw SQLError.createSQLException("Cannot remove only configured host.", null);
        }
        this.hostsToRemove.add(hostPortPair);
        this.connectionsToHostsMap.remove(this.liveConnections.remove(hostPortPair));
        if (this.hostsToListIndexMap.remove(hostPortPair) != null) {
            long[] newResponseTimes = new long[this.responseTimes.length - 1];
            int newIdx = 0;
            for (String h : this.hostList) {
                if (this.hostsToRemove.contains(h)) continue;
                Integer idx = this.hostsToListIndexMap.get(h);
                if (idx != null && idx < this.responseTimes.length) {
                    newResponseTimes[newIdx] = this.responseTimes[idx];
                }
                this.hostsToListIndexMap.put(h, newIdx++);
            }
            this.responseTimes = newResponseTimes;
        }
        if (hostPortPair.equals(this.currentConnection.getHostPortPair())) {
            this.invalidateConnection(this.currentConnection);
            this.pickNewConnection();
        }
    }

    public synchronized boolean addHost(String hostPortPair) {
        if (this.hostsToListIndexMap.containsKey(hostPortPair)) {
            return false;
        }
        long[] newResponseTimes = new long[this.responseTimes.length + 1];
        System.arraycopy(this.responseTimes, 0, newResponseTimes, 0, this.responseTimes.length);
        this.responseTimes = newResponseTimes;
        if (!this.hostList.contains(hostPortPair)) {
            this.hostList.add(hostPortPair);
        }
        this.hostsToListIndexMap.put(hostPortPair, this.responseTimes.length - 1);
        this.hostsToRemove.remove(hostPortPair);
        return true;
    }

    public synchronized boolean inTransaction() {
        return this.inTransaction;
    }

    public synchronized long getTransactionCount() {
        return this.transactionCount;
    }

    public synchronized long getActivePhysicalConnectionCount() {
        return this.liveConnections.size();
    }

    public synchronized long getTotalPhysicalConnectionCount() {
        return this.totalPhysicalConnections;
    }

    public synchronized long getConnectionGroupProxyID() {
        return this.connectionGroupProxyID;
    }

    public synchronized String getCurrentActiveHost() {
        String o;
        MySQLConnection c = this.currentConnection;
        if (c != null && (o = this.connectionsToHostsMap.get(c)) != null) {
            return o.toString();
        }
        return null;
    }

    public synchronized long getCurrentTransactionDuration() {
        return this.inTransaction && this.transactionStartTime > 0L ? System.nanoTime() - this.transactionStartTime : 0L;
    }

    public static synchronized LoadBalancedConnection getNullLoadBalancedConnectionInstance() {
        if (nullLBConnectionInstance == null) {
            nullLBConnectionInstance = (LoadBalancedConnection)Proxy.newProxyInstance(LoadBalancedConnection.class.getClassLoader(), INTERFACES_TO_PROXY, (InvocationHandler)new NullLoadBalancedConnectionProxy());
        }
        return nullLBConnectionInstance;
    }

    static {
        if (Util.isJdbc4()) {
            try {
                JDBC_4_LB_CONNECTION_CTOR = Class.forName("com.goldendb.jdbc.internal.core.JDBC4LoadBalancedMySQLConnection").getConstructor(LoadBalancedConnectionProxy.class);
                INTERFACES_TO_PROXY = new Class[]{LoadBalancedConnection.class, Class.forName("com.goldendb.jdbc.internal.core.JDBC4MySQLConnection")};
            }
            catch (SecurityException var1) {
                throw new RuntimeException(var1);
            }
            catch (NoSuchMethodException var2) {
                throw new RuntimeException(var2);
            }
            catch (ClassNotFoundException var3) {
                throw new RuntimeException(var3);
            }
        } else {
            INTERFACES_TO_PROXY = new Class[]{LoadBalancedConnection.class};
        }
        nullLBConnectionInstance = null;
    }

    private static class NullLoadBalancedConnectionProxy
    implements InvocationHandler {
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?>[] declaredException;
            SQLException exceptionToThrow = SQLError.createSQLException(Messages.getString("LoadBalancedConnectionProxy.unusableConnection"), "25000", 1000001, true, (ExceptionInterceptor)null);
            Class<?>[] arr$ = declaredException = method.getExceptionTypes();
            int len$ = declaredException.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<?> declEx = arr$[i$];
                if (!declEx.isAssignableFrom(exceptionToThrow.getClass())) continue;
                throw exceptionToThrow;
            }
            throw new IllegalStateException(exceptionToThrow.getMessage(), exceptionToThrow);
        }
    }
}

