/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.loadbalance;

import com.goldendb.jdbc.Connection;
import com.goldendb.jdbc.MySQLConnection;
import com.goldendb.jdbc.internal.core.io.ConnectionImpl;
import com.goldendb.jdbc.internal.core.io.ResultSetInternalMethods;
import com.goldendb.jdbc.internal.core.io.Statement;
import com.goldendb.jdbc.internal.core.io.StatementInterceptorV2;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedConnectionProxy;
import com.goldendb.jdbc.internal.core.loadbalance.LoadBalancedMySQLConnection;
import com.goldendb.jdbc.internal.util.StringUtils;
import java.sql.SQLException;
import java.util.Properties;

public class LoadBalancedAutoCommitInterceptor
implements StatementInterceptorV2 {
    private int matchingAfterStatementCount = 0;
    private int matchingAfterStatementThreshold = 0;
    private String matchingAfterStatementRegex;
    private ConnectionImpl conn;
    private LoadBalancedConnectionProxy proxy = null;
    private boolean countStatements = false;

    public void destroy() {
    }

    public boolean executeTopLevelOnly() {
        return false;
    }

    public void init(Connection connection, Properties props) throws SQLException {
        this.conn = (ConnectionImpl)connection;
        String autoCommitSwapThresholdAsString = props.getProperty("loadBalanceAutoCommitStatementThreshold", "0");
        try {
            this.matchingAfterStatementThreshold = Integer.parseInt(autoCommitSwapThresholdAsString);
        }
        catch (NumberFormatException var5) {
            // empty catch block
        }
        String autoCommitSwapRegex = props.getProperty("loadBalanceAutoCommitStatementRegex", "");
        if (!"".equals(autoCommitSwapRegex)) {
            this.matchingAfterStatementRegex = autoCommitSwapRegex;
        }
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, SQLException statementException) throws SQLException {
        if (this.countStatements && !StringUtils.startsWithIgnoreCase(sql, "SET") && !StringUtils.startsWithIgnoreCase(sql, "SHOW")) {
            if (!this.conn.getAutoCommit()) {
                this.matchingAfterStatementCount = 0;
                return originalResultSet;
            }
            if (this.proxy == null && this.conn.isProxySet()) {
                MySQLConnection lcl_proxy;
                for (lcl_proxy = this.conn.getMultiHostSafeProxy(); lcl_proxy != null && !(lcl_proxy instanceof LoadBalancedMySQLConnection); lcl_proxy = lcl_proxy.getMultiHostSafeProxy()) {
                }
                if (lcl_proxy != null) {
                    this.proxy = ((LoadBalancedMySQLConnection)lcl_proxy).getThisAsProxy();
                }
            }
            if (this.proxy == null) {
                return originalResultSet;
            }
            if (this.matchingAfterStatementRegex == null || sql.matches(this.matchingAfterStatementRegex)) {
                ++this.matchingAfterStatementCount;
            }
            if (this.matchingAfterStatementCount >= this.matchingAfterStatementThreshold) {
                this.matchingAfterStatementCount = 0;
                try {
                    this.proxy.pickNewConnection();
                }
                catch (SQLException var10) {
                    // empty catch block
                }
            }
            return originalResultSet;
        }
        return originalResultSet;
    }

    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) throws SQLException {
        return null;
    }

    void pauseCounters() {
        this.countStatements = false;
    }

    void resumeCounters() {
        this.countStatements = true;
    }
}

