/*
 * Decompiled with CFR 0.152.
 */
package com.goldendb.jdbc.internal.core.jdbc4;

import com.goldendb.jdbc.ExceptionInterceptor;
import com.goldendb.jdbc.internal.util.Messages;
import com.goldendb.jdbc.internal.util.SQLError;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class JDBC42Helper {
    private static volatile Method castOffsetDateTimeToTimestampMethod = null;

    static Object convertJavaTimeToJavaSql(Object x) {
        if (x instanceof LocalDate) {
            return Date.valueOf((LocalDate)x);
        }
        if (x instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)x);
        }
        if (x != null && "java.time.OffsetDateTime".equalsIgnoreCase(x.getClass().getName())) {
            try {
                Method[] declaredMethods;
                if (castOffsetDateTimeToTimestampMethod != null) {
                    return castOffsetDateTimeToTimestampMethod.invoke(null, x);
                }
                Class<?> clz = Class.forName("com.goldendb.jdbc.JDK8Util");
                for (Method method : declaredMethods = clz.getDeclaredMethods()) {
                    if (!"castOffsetDateTimeToTimestamp".equals(method.getName())) continue;
                    castOffsetDateTimeToTimestampMethod = method;
                    return method.invoke(null, x);
                }
            }
            catch (Exception e) {
                System.out.println("cast OffsetDateTime to Timestamp exception, input: " + x);
            }
            return x;
        }
        return x instanceof LocalTime ? Time.valueOf((LocalTime)x) : x;
    }

    static boolean isSqlTypeSupported(int sqlType) {
        return sqlType != 2012 && sqlType != 2013 && sqlType != 2014;
    }

    static int checkSqlType(int sqlType, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        if (JDBC42Helper.isSqlTypeSupported(sqlType)) {
            return sqlType;
        }
        throw SQLError.createSQLFeatureNotSupportedException(Messages.getString("UnsupportedSQLType.0") + JDBCType.valueOf(sqlType), "S1C00", exceptionInterceptor);
    }

    static int translateAndCheckSqlType(SQLType sqlType, ExceptionInterceptor exceptionInterceptor) throws SQLException {
        return JDBC42Helper.checkSqlType(sqlType.getVendorTypeNumber(), exceptionInterceptor);
    }
}

